/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.bill.HSAmountSplitHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.bill.billsplit.SplitAmountDTO;
import kd.imc.sim.formplugin.bill.splitMerge.split.dto.SplitOriginBillItemDTO;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;

public class BillSplitAmountHelper {
    private static final Log log = LogFactory.getLog(BillSplitAmountHelper.class);
    private static final int PROPORTION_NUMBER_DIGIT = 16;

    public String getMergeBillNoFirst(String billNo) {
        try {
            String[] billNos = billNo.split(",");
            return billNos[0];
        }
        catch (Exception e) {
            return billNo;
        }
    }

    public List<SplitOriginBillItemDTO> buildOriginBillItemDTO(SplitRequestDTO requestDTO) {
        ArrayList<SplitOriginBillItemDTO> splitOriginBillItemDTOList = new ArrayList<SplitOriginBillItemDTO>();
        BigDecimal totalBillNum = BigDecimal.ZERO;
        for (DynamicObject originBillItem : requestDTO.getBill().getDynamicObjectCollection("sim_original_bill_item")) {
            SplitOriginBillItemDTO splitOriginBillItemDTO = new SplitOriginBillItemDTO();
            splitOriginBillItemDTO.setId(originBillItem.getPkValue());
            splitOriginBillItemDTO.setSurplusSplitTotalAmount(originBillItem.getBigDecimal("remainvalidamount"));
            splitOriginBillItemDTO.setTotalAmount(originBillItem.getBigDecimal("remainvalidamount"));
            splitOriginBillItemDTO.setRowType(originBillItem.getString("rowtype"));
            if ("1".equals(originBillItem.getString("rowtype"))) {
                SplitOriginBillItemDTO bzkItem = (SplitOriginBillItemDTO)splitOriginBillItemDTOList.get(splitOriginBillItemDTOList.size() - 1);
                bzkItem.setZkItem(splitOriginBillItemDTO);
                bzkItem.setRowType("2");
                bzkItem.setTotalAmount(bzkItem.getTotalAmount().add(splitOriginBillItemDTO.getSurplusSplitTotalAmount()));
                bzkItem.setSurplusSplitTotalAmount(bzkItem.getSurplusSplitTotalAmount().add(splitOriginBillItemDTO.getSurplusSplitTotalAmount()));
            } else {
                splitOriginBillItemDTO.setRowType("0");
                splitOriginBillItemDTOList.add(splitOriginBillItemDTO);
            }
            totalBillNum = totalBillNum.add(originBillItem.getBigDecimal("num"));
        }
        requestDTO.setTotalBillNum(totalBillNum);
        return splitOriginBillItemDTOList;
    }

    public List<BillRelationDTO> splitUserInputInvoiceAmount(SplitRequestDTO requestDTO, List<SplitOriginBillItemDTO> splitOriginBillItemDTOList, List<SplitAmountDTO> splitAmountDTOList) {
        ArrayList<BillRelationDTO> relations = new ArrayList<BillRelationDTO>();
        Collections.sort(splitAmountDTOList);
        DynamicObject originBill = requestDTO.getBill();
        DynamicObject hsConfigDO = HSAmountSplitHelper.getHSAmountSplitConfigDynamicObject((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)originBill.get("orgid")));
        for (SplitAmountDTO splitAmountDTO : splitAmountDTOList) {
            DynamicObject invoiceDynamicObject = this.buildInvoiceMain(requestDTO, originBill);
            splitAmountDTO.setInvoiceDynamicObject(invoiceDynamicObject);
            this.splitBillItem(originBill, invoiceDynamicObject, splitAmountDTO.getAmount(), relations, splitOriginBillItemDTOList, hsConfigDO);
        }
        return relations;
    }

    private DynamicObject buildInvoiceMain(SplitRequestDTO requestDTO, DynamicObject originBill) {
        DynamicObject waitInvoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)originBill, (DynamicObject)waitInvoiceDynamicObject);
        String invoiceBillNo = (String)requestDTO.getBillNoMap().get(originBill.getString("billno"));
        waitInvoiceDynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        waitInvoiceDynamicObject.set("billno", (Object)invoiceBillNo);
        waitInvoiceDynamicObject.set("batchbelong", (Object)this.getMergeBillNoFirst(originBill.getString("billno")));
        waitInvoiceDynamicObject.set("invoiceamount", (Object)BigDecimal.ZERO);
        waitInvoiceDynamicObject.set("totaltax", (Object)BigDecimal.ZERO);
        waitInvoiceDynamicObject.set("totalamount", (Object)BigDecimal.ZERO);
        waitInvoiceDynamicObject.set("totalamount", (Object)BigDecimal.ZERO);
        waitInvoiceDynamicObject.set("taxedtype", (Object)"0");
        if (ReducedHelper.isReduced((Object)originBill.getString("taxationstyle"))) {
            waitInvoiceDynamicObject.set("taxedtype", (Object)"1");
        }
        waitInvoiceDynamicObject.set("remark", (Object)originBill.getString("invoiceremark"));
        InvoiceUtils.setSpecialItemToInvoiceByBill((DynamicObject)originBill, (DynamicObject)waitInvoiceDynamicObject);
        AbstractBillSplitServiceImpl.buildMainInvoiceData(waitInvoiceDynamicObject);
        return waitInvoiceDynamicObject;
    }

    private void splitBillItem(DynamicObject originBill, DynamicObject invoiceDynamicObject, BigDecimal maxUserInputSplitAmount, List<BillRelationDTO> relations, List<SplitOriginBillItemDTO> splitOriginBillItemDTOList, DynamicObject hsConfigDO) {
        Iterator<SplitOriginBillItemDTO> iterator = splitOriginBillItemDTOList.iterator();
        while (iterator.hasNext() && splitOriginBillItemDTOList.size() != 0) {
            SplitOriginBillItemDTO billItemDTO = iterator.next();
            BigDecimal surplusSplitTotalAmount = billItemDTO.getSurplusSplitTotalAmount();
            SplitOriginBillItemDTO zkItem = billItemDTO.getZkItem();
            BigDecimal proportion = BigDecimal.ONE;
            if (maxUserInputSplitAmount.compareTo(surplusSplitTotalAmount) < 0) {
                BigDecimal zkAmount;
                proportion = maxUserInputSplitAmount.divide(billItemDTO.getTotalAmount(), 16, RoundingMode.HALF_UP);
                BigDecimal realItemTotalAmount = billItemDTO.getSurplusSplitTotalAmount();
                if (zkItem != null) {
                    zkAmount = zkItem.getTotalAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                    maxUserInputSplitAmount = maxUserInputSplitAmount.subtract(zkAmount);
                    realItemTotalAmount = realItemTotalAmount.subtract(zkAmount);
                    surplusSplitTotalAmount = realItemTotalAmount.subtract(maxUserInputSplitAmount);
                } else {
                    surplusSplitTotalAmount = surplusSplitTotalAmount.subtract(maxUserInputSplitAmount);
                }
                this.buildItem(billItemDTO, maxUserInputSplitAmount, relations, proportion, invoiceDynamicObject, originBill, hsConfigDO);
                if (zkItem != null) {
                    zkAmount = zkItem.getTotalAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                    this.buildZKItem(originBill, invoiceDynamicObject, relations, billItemDTO, zkAmount, hsConfigDO);
                }
                billItemDTO.setSurplusSplitTotalAmount(surplusSplitTotalAmount);
                break;
            }
            if (maxUserInputSplitAmount.compareTo(surplusSplitTotalAmount) == 0) {
                BigDecimal zkAmount;
                if (billItemDTO.getTotalAmount().compareTo(surplusSplitTotalAmount) != 0) {
                    proportion = surplusSplitTotalAmount.divide(billItemDTO.getTotalAmount(), 16, RoundingMode.HALF_UP);
                }
                if (zkItem != null) {
                    zkAmount = proportion.compareTo(BigDecimal.ONE) == 0 ? zkItem.getSurplusSplitTotalAmount().setScale(2, RoundingMode.HALF_UP) : zkItem.getTotalAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                    maxUserInputSplitAmount = maxUserInputSplitAmount.subtract(zkAmount);
                }
                this.buildItem(billItemDTO, maxUserInputSplitAmount, relations, proportion, invoiceDynamicObject, originBill, hsConfigDO);
                if (zkItem != null) {
                    zkAmount = proportion.compareTo(BigDecimal.ONE) == 0 ? zkItem.getSurplusSplitTotalAmount().setScale(2, RoundingMode.HALF_UP) : zkItem.getTotalAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                    this.buildZKItem(originBill, invoiceDynamicObject, relations, billItemDTO, zkAmount, hsConfigDO);
                }
                iterator.remove();
                break;
            }
            if (maxUserInputSplitAmount.compareTo(surplusSplitTotalAmount) <= 0) continue;
            if (billItemDTO.getTotalAmount().compareTo(surplusSplitTotalAmount) != 0) {
                proportion = surplusSplitTotalAmount.divide(billItemDTO.getTotalAmount(), 16, RoundingMode.HALF_UP);
            }
            if (zkItem != null) {
                surplusSplitTotalAmount = surplusSplitTotalAmount.subtract(zkItem.getSurplusSplitTotalAmount());
            }
            this.buildItem(billItemDTO, surplusSplitTotalAmount, relations, proportion, invoiceDynamicObject, originBill, hsConfigDO);
            maxUserInputSplitAmount = maxUserInputSplitAmount.subtract(billItemDTO.getSurplusSplitTotalAmount());
            if (zkItem != null) {
                BigDecimal zkAmount = zkItem.getTotalAmount().multiply(proportion).setScale(2, RoundingMode.HALF_UP);
                this.buildZKItem(originBill, invoiceDynamicObject, relations, billItemDTO, zkAmount, hsConfigDO);
            }
            iterator.remove();
            this.splitBillItem(originBill, invoiceDynamicObject, maxUserInputSplitAmount, relations, splitOriginBillItemDTOList, hsConfigDO);
            break;
        }
    }

    private void buildItem(SplitOriginBillItemDTO billItemDTO, BigDecimal itemSplitJSHJ, List<BillRelationDTO> relations, BigDecimal proportion, DynamicObject invoiceDynamicObject, DynamicObject originBill, DynamicObject hsConfigDO) {
        DynamicObjectCollection billItems = originBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject billItem : billItems) {
            if (billItem.getPkValue() != billItemDTO.getId()) continue;
            if (billItemDTO.getTotalAmount().compareTo(BigDecimal.ZERO) < 0) {
                this.handleZKItem(itemSplitJSHJ, relations, billItemDTO, invoiceDynamicObject, originBill, billItem);
                break;
            }
            this.handleItem(billItemDTO, relations, proportion, billItem, invoiceDynamicObject, originBill, hsConfigDO);
            break;
        }
        invoiceDynamicObject.set("totalamount", (Object)invoiceDynamicObject.getBigDecimal("invoiceamount").add(invoiceDynamicObject.getBigDecimal("totaltax")));
    }

    private void buildZKItem(DynamicObject originBill, DynamicObject waitInvoiceDynamicObject, List<BillRelationDTO> relations, SplitOriginBillItemDTO maxItem, BigDecimal zkAmount, DynamicObject hsConfigDO) {
        SplitOriginBillItemDTO zkItem = maxItem.getZkItem();
        if (zkItem != null) {
            this.buildItem(zkItem, zkAmount, relations, null, waitInvoiceDynamicObject, originBill, hsConfigDO);
            zkItem.setSurplusSplitTotalAmount(zkItem.getSurplusSplitTotalAmount().subtract(zkAmount));
        }
    }

    private void handleZKItem(BigDecimal needSplitAmount, List<BillRelationDTO> relations, SplitOriginBillItemDTO maxItem, DynamicObject waitInvoiceDynamicObject, DynamicObject originBill, DynamicObject billItem) {
        BigDecimal newBHSAmount = needSplitAmount.divide(BigDecimal.ONE.add(new BigDecimal(billItem.getString("taxrate"))), 2, RoundingMode.HALF_UP);
        BigDecimal newTax = needSplitAmount.subtract(newBHSAmount);
        this.buildItemAndRelation(maxItem, relations, billItem, waitInvoiceDynamicObject, originBill, BigDecimal.ZERO, billItem.getBigDecimal("unitprice"), billItem.getBigDecimal("taxunitprice"), needSplitAmount, newBHSAmount, newTax);
    }

    private void handleItem(SplitOriginBillItemDTO billItemDTO, List<BillRelationDTO> relations, BigDecimal proportion, DynamicObject billItem, DynamicObject waitInvoiceDynamicObject, DynamicObject originBill, DynamicObject hsConfigDO) {
        ImmutableSet splitRuleByNum = ImmutableSet.of((Object)"1", (Object)"2");
        if (hsConfigDO == null || splitRuleByNum.contains((Object)hsConfigDO.getString("splitrule"))) {
            this.splitByNum(billItemDTO, relations, proportion, billItem, waitInvoiceDynamicObject, originBill);
        } else {
            this.splitByPrice(billItemDTO, relations, proportion, billItem, waitInvoiceDynamicObject, originBill, hsConfigDO);
        }
    }

    private void splitByNum(SplitOriginBillItemDTO billItemDTO, List<BillRelationDTO> relations, BigDecimal proportion, DynamicObject billItem, DynamicObject waitInvoiceDynamicObject, DynamicObject originBill) {
        BigDecimal newNum = billItem.getBigDecimal("remainvalidnum");
        BigDecimal billItemRemainAmount = billItem.getBigDecimal("remainvalidamount");
        BigDecimal billItemUnitPrice = billItem.getBigDecimal("unitprice");
        BigDecimal billItemTaxUnitPrice = billItem.getBigDecimal("taxunitprice");
        BigDecimal billItemTaxRate = new BigDecimal(billItem.getString("taxrate"));
        BigDecimal newHSAmount = billItemRemainAmount.multiply(proportion).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newBHSAmount = newHSAmount.divide(BigDecimal.ONE.add(billItemTaxRate), 2, RoundingMode.HALF_UP);
        if (!MathUtils.isZero((BigDecimal)billItemUnitPrice) && !MathUtils.isZero((BigDecimal)newNum)) {
            newNum = UnitPriceHelper.calcNum((BigDecimal)newBHSAmount, (BigDecimal)billItemUnitPrice);
        }
        BigDecimal newTax = newHSAmount.subtract(newBHSAmount);
        this.buildItemAndRelation(billItemDTO, relations, billItem, waitInvoiceDynamicObject, originBill, newNum, billItemUnitPrice, billItemTaxUnitPrice, newHSAmount, newBHSAmount, newTax);
    }

    private void splitByPrice(SplitOriginBillItemDTO billItemDTO, List<BillRelationDTO> relations, BigDecimal proportion, DynamicObject billItem, DynamicObject waitInvoiceDynamicObject, DynamicObject originBill, DynamicObject hsConfigDO) {
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)originBill.getString("invoicetype")) || "1".equals(originBill.getString("iselepaper"));
        BigDecimal newUintPrice = billItem.getBigDecimal("unitprice");
        BigDecimal newTaxUintPrice = billItem.getBigDecimal("taxunitprice");
        BigDecimal billItemNum = billItem.getBigDecimal("remainvalidnum");
        if ("4".equals(hsConfigDO.getString("splitrule"))) {
            billItemNum = hsConfigDO.getBigDecimal("splitpricefixednum");
        }
        BigDecimal billItemRemainAmount = billItem.getBigDecimal("remainvalidamount");
        BigDecimal billItemTaxRate = new BigDecimal(billItem.getString("taxrate"));
        BigDecimal newHSAmount = billItemRemainAmount.multiply(proportion).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newBHSAmount = newHSAmount.divide(BigDecimal.ONE.add(billItemTaxRate), 2, RoundingMode.HALF_UP);
        if (!MathUtils.isZero((BigDecimal)billItemNum) && !MathUtils.isZero((BigDecimal)newUintPrice)) {
            newUintPrice = PriceHelper.calcPriceOrNum((BigDecimal)newBHSAmount, (BigDecimal)billItemNum, (boolean)isAllEle);
            newTaxUintPrice = PriceHelper.calcPriceOrNum((BigDecimal)newHSAmount, (BigDecimal)billItemNum, (boolean)isAllEle);
        }
        BigDecimal newTax = newHSAmount.subtract(newBHSAmount);
        this.buildItemAndRelation(billItemDTO, relations, billItem, waitInvoiceDynamicObject, originBill, billItemNum, newUintPrice, newTaxUintPrice, newHSAmount, newBHSAmount, newTax);
    }

    private void buildItemAndRelation(SplitOriginBillItemDTO billItemDTO, List<BillRelationDTO> relations, DynamicObject billItem, DynamicObject waitInvoice, DynamicObject originBill, BigDecimal newNum, BigDecimal newUnitPrice, BigDecimal newTaxUnitPrice, BigDecimal newHSAmount, BigDecimal newBHSAmount, BigDecimal newTax) {
        DynamicObjectCollection items = waitInvoice.getDynamicObjectCollection("items");
        DynamicObject invoiceItem = items.addNew();
        DynamicObjectUtil.copyDynamicObject((DynamicObject)billItem, (DynamicObject)invoiceItem);
        Long targetDetailId = DBServiceHelper.genGlobalLongId();
        invoiceItem.set("id", (Object)targetDetailId);
        invoiceItem.set("seq", (Object)(items.size() - 1));
        invoiceItem.set("simplegoodsname", (Object)billItem.getString("goodssimplename"));
        if (!invoiceItem.getString("simplegoodsname").startsWith("*")) {
            invoiceItem.set("simplegoodsname", (Object)("*" + invoiceItem.getString("simplegoodsname") + "*"));
        }
        SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)invoiceItem);
        invoiceItem.set("num", (Object)newNum);
        invoiceItem.set("unitprice", (Object)newUnitPrice);
        invoiceItem.set("taxunitprice", (Object)newTaxUnitPrice);
        invoiceItem.set("amount", (Object)newBHSAmount);
        invoiceItem.set("taxamount", (Object)newHSAmount);
        invoiceItem.set("tax", (Object)newTax);
        invoiceItem.set("taxpremark", (Object)billItem.getString("policylogo"));
        invoiceItem.set("zzstsgl", (Object)billItem.getString("policycontants"));
        ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)invoiceItem);
        if (newBHSAmount.compareTo(BigDecimal.ZERO) < 0) {
            invoiceItem.set("rowtype", billItem.get("rowtype"));
        } else {
            invoiceItem.set("rowtype", (Object)billItemDTO.getRowType());
        }
        BillRelationDTO billRelationDTO = new BillRelationDTO();
        billRelationDTO.setAmount(newBHSAmount);
        billRelationDTO.setTax(newTax);
        billRelationDTO.setsBillNo("");
        if (newNum != null) {
            billRelationDTO.setNum(newNum.setScale(10, RoundingMode.HALF_UP));
        }
        billRelationDTO.setPrice(billItem.getBigDecimal("unitprice"));
        billRelationDTO.setsBillId(Long.valueOf(originBill.getLong("id")));
        billRelationDTO.setsDetailId(Long.valueOf(billItem.getLong("id")));
        billRelationDTO.settBillId((Long)waitInvoice.getPkValue());
        billRelationDTO.settBillNo(waitInvoice.getString("billno"));
        billRelationDTO.settDetailId(targetDetailId);
        billRelationDTO.settTable("sim_vatinvoice");
        billRelationDTO.setPushType("1");
        billRelationDTO.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)originBill.get("orgid"))));
        relations.add(billRelationDTO);
        waitInvoice.set("inventorymark", (Object)(items.size() > 8 ? "1" : "0"));
        waitInvoice.set("invoiceamount", (Object)waitInvoice.getBigDecimal("invoiceamount").add(newBHSAmount));
        waitInvoice.set("totaltax", (Object)waitInvoice.getBigDecimal("totaltax").add(newTax));
    }
}

