/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.formplugin.bill.splitMerge.split.IBillSplitService;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.DeductionSplitServiceImpl;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.NoSplitServiceImpl;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByAmountServiceImpl;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByInvoiceQuantityServiceImpl;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByRuleServiceImpl;

public class BillSplitHelper {
    private static final Log LOGGER = LogFactory.getLog(BillSplitHelper.class);
    private static List<IBillSplitService> splitServices = new ArrayList<IBillSplitService>(4);

    public static List<IBillSplitService> getSplitServices() {
        return splitServices;
    }

    public static SplitResponseDTO splitBill(SplitRequestDTO splitRequest, String jqbh) {
        if (InvoiceUtils.isAllEInvoice((Object)splitRequest.getBill().getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)splitRequest.getBill().getString("iselepaper"))) {
            LimitAmountsDTO limitAmountsDTO = new LimitAmountsDTO(true);
            splitRequest.setLimitAmounts(limitAmountsDTO);
        } else {
            DynamicObject devObj = EquipmentUtil.getDevByCode((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)splitRequest.getBill().get("orgid")), (String)jqbh);
            LimitAmountsDTO limitAmountsDTO = new LimitAmountsDTO(devObj);
            splitRequest.setLimitAmounts(limitAmountsDTO);
        }
        SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill(splitRequest);
        splitRequest.setRuleObj(null);
        return splitResponseDTO;
    }

    public static SplitResponseDTO splitBill(SplitRequestDTO splitRequest) {
        try {
            for (int i = splitServices.size() - 1; i >= 0; --i) {
                IBillSplitService splitService = splitServices.get(i);
                splitRequest.setRuleCode(splitRequest.getBill().getString("splitrule"));
                if (!splitService.support(splitRequest)) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\u6267\u884c\u7684\u62c6\u5206\u89c4\u5219\u7f16\u7801\u662f[%s]", splitRequest.getBill().getString("billno"), splitRequest.getRuleCode()));
                }
                return splitService.split(splitRequest);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u62c6\u5206\u5355\u636e\u5f02\u5e38", (Throwable)e);
            if (e instanceof MsgException) {
                throw new KDBizException(((MsgException)((Object)e)).getErrorMsg());
            }
            throw new KDBizException(e.getMessage());
        }
        return new SplitResponseDTO();
    }

    static {
        splitServices.add(new NoSplitServiceImpl());
        splitServices.add(new SplitByRuleServiceImpl());
        splitServices.add(new SplitByAmountServiceImpl());
        splitServices.add(new SplitByInvoiceQuantityServiceImpl());
        splitServices.add(new DeductionSplitServiceImpl());
    }
}

