/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.dto;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.dto.SmsRequestDto;

public class SplitAisinoDTO {
    private SmsRequestDto smsRequestDto = new SmsRequestDto();

    public SplitAisinoDTO(Builder builder) {
        this.smsRequestDto.setSmr(builder.smruleConfigDto);
        this.smsRequestDto.setIsOil(builder.isOil ? "1" : "0");
        this.smsRequestDto.setAllEReducedTax(builder.isAllEReducedTax);
        this.smsRequestDto.setBillSubject(builder.billSList);
        this.smsRequestDto.setCiAmt(builder.pcLimitAmt);
        this.smsRequestDto.setSiAmt(builder.psLimitAmt);
        this.smsRequestDto.setEiAmt(builder.ecLimitAmt);
        this.smsRequestDto.setEsiAmt(builder.esLimitAmt);
        this.smsRequestDto.setVlAmt(new BigDecimal("9999999999.99"));
        this.smsRequestDto.setAllecAmt(builder.allecLimitAmt);
        this.smsRequestDto.setAllesAmt(builder.allesLimitAmt);
    }

    private static BigDecimal min(BigDecimal a, BigDecimal b) {
        if (a.compareTo(BigDecimal.ZERO) <= 0) {
            a = BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ZERO) <= 0) {
            b = BigDecimal.ZERO;
        }
        return a.compareTo(b) > 0 ? b : a;
    }

    public SmsRequestDto getSmsRequestDto() {
        return this.smsRequestDto;
    }

    public static class Builder {
        private SmruleConfigDto smruleConfigDto;
        private boolean isOil = false;
        private boolean isAllEReducedTax = false;
        private BigDecimal pcLimitAmt;
        private BigDecimal psLimitAmt;
        private BigDecimal ecLimitAmt;
        private BigDecimal esLimitAmt;
        private BigDecimal allecLimitAmt;
        private BigDecimal allesLimitAmt;
        private BillSubjectDto billSList;

        public Builder(SplitRequestDTO request) {
            DynamicObject ruleObj = request.getRuleObj();
            LimitAmountsDTO limitAmount = request.getLimitAmounts();
            SmruleConfigDto configDto = new SmruleConfigDto();
            configDto.setAmtNumber(ruleObj.getInt("quantitydecimallimit"));
            configDto.setPriceNumber(ruleObj.getInt("pricedecimallimit"));
            configDto.setSplitGoodsLine(ruleObj.getInt("detailsplitrule"));
            configDto.setSplitGoodsWithNumber(ruleObj.getInt("detailquantitysplitrule") + 1);
            configDto.setOneUnchange(ruleObj.getBoolean("oneunchange"));
            configDto.setInvNoteUseLineNote(ruleObj.getInt("invoiceremarkrule"));
            if (configDto.getInvNoteUseLineNote() == 2 || configDto.getInvNoteUseLineNote() == 3) {
                configDto.setInvNoteUseLineNote(0);
            }
            configDto.setMccNoteStr("\\n".equals(ruleObj.getString("remarksplitregex")) ? System.lineSeparator() : ruleObj.getString("remarksplitregex"));
            configDto.setMccRepeat(!ruleObj.getBoolean("remarkautodistinct"));
            configDto.setListType(ruleObj.getInt("listrule"));
            configDto.setMaxSLine(ruleObj.getInt("listlimitspecial"));
            configDto.setMaxCLine(ruleObj.getInt("listlimitcommon"));
            configDto.setMaxELine(ruleObj.getInt("listlimitelecomm"));
            configDto.setMaxEsiLine(ruleObj.getInt("listlimitelespec"));
            configDto.setMaxAllELine(ruleObj.getInt("listlimitallelecomm"));
            configDto.setMaxAllEsiLine(ruleObj.getInt("listlimitallelespec"));
            this.smruleConfigDto = configDto;
            if (!ruleObj.getBoolean("splitwithamount")) {
                ruleObj.set("paperspeciallimitamount", (Object)new BigDecimal("9999999999999999"));
                ruleObj.set("papercommonlimitamount", (Object)new BigDecimal("9999999999999999"));
                ruleObj.set("elecommonlimitamount", (Object)new BigDecimal("9999999999999999"));
                ruleObj.set("elespeciallimitamount", (Object)new BigDecimal("9999999999999999"));
            }
            this.pcLimitAmt = SplitAisinoDTO.min(this.getRuleLimitAmt(ruleObj, "papercommonlimitamount"), limitAmount.getPcLimitAmt());
            this.psLimitAmt = SplitAisinoDTO.min(this.getRuleLimitAmt(ruleObj, "paperspeciallimitamount"), limitAmount.getPsLimitAmt());
            this.ecLimitAmt = SplitAisinoDTO.min(this.getRuleLimitAmt(ruleObj, "elecommonlimitamount"), limitAmount.getEcLimitAmt());
            this.esLimitAmt = SplitAisinoDTO.min(this.getRuleLimitAmt(ruleObj, "elespeciallimitamount"), limitAmount.getEsLimitAmt());
            this.allecLimitAmt = this.getRuleLimitAmt(ruleObj, "allelecommonlimitamount");
            this.allesLimitAmt = this.getRuleLimitAmt(ruleObj, "allelespeciallimitamount");
        }

        private BigDecimal getRuleLimitAmt(DynamicObject ruleObj, String key) {
            BigDecimal amt = ruleObj.getBigDecimal(key);
            return amt == null ? BigDecimal.ZERO : amt;
        }

        public Builder isOil(boolean isOil) {
            this.isOil = isOil;
            return this;
        }

        public Builder isAllEReducedTax(boolean isAllEReducedTax) {
            this.isAllEReducedTax = isAllEReducedTax;
            return this;
        }

        public Builder billSList(BillSubjectDto billSubjectDto) {
            this.billSList = billSubjectDto;
            return this;
        }

        public SplitAisinoDTO builder() {
            return new SplitAisinoDTO(this);
        }
    }
}

