/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ExtraInfoHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class NoSplitServiceImpl
extends AbstractBillSplitServiceImpl {
    @Override
    public boolean support(SplitRequestDTO splitRequest) {
        return true;
    }

    @Override
    public SplitResponseDTO split(SplitRequestDTO request) {
        ArrayList<DynamicObject> invoices = new ArrayList<DynamicObject>(1);
        List<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(1);
        DynamicObject bill = request.getBill();
        String newBillNo = (String)request.getBillNoMap().get(bill.getString("billno"));
        if (this.isRedInvoice(bill)) {
            if (this.isRedInfo(bill)) {
                invoices.addAll(this.createRedInfo(bill, relationList, newBillNo, request));
            } else if (this.isRedConfirm(bill)) {
                DynamicObject waitInv = this.createVatInvoice(bill, relationList, newBillNo);
                if (StringUtils.isNotBlank((CharSequence)bill.getString("buyeremail")) || StringUtils.isNotBlank((CharSequence)bill.getString("buyerphone"))) {
                    waitInv.set("buyeremail", (Object)bill.getString("buyeremail"));
                    waitInv.set("buyerphone", (Object)bill.getString("buyerphone"));
                }
                invoices.add(waitInv);
                this.changeFromRedConfirm(invoices);
                waitInv.set("remark", (Object)bill.getString("invoiceremark"));
                relationList = this.dealRedConfirmRelation(bill, relationList, newBillNo);
            } else {
                invoices.add(this.createVatInvoice(bill, relationList, newBillNo));
            }
        } else {
            invoices.addAll(this.createBlueInvoice(bill, request.getLimitAmounts(), relationList, newBillNo));
        }
        ExtraInfoHelper.copyExtraInfo(invoices, (SplitRequestDTO)request);
        return new SplitResponseDTO(invoices, relationList);
    }

    private void changeFromRedConfirm(List<DynamicObject> invoices) {
        for (DynamicObject invoice : invoices) {
            String redConfirmBillNo = invoice.getString("infocode");
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
            if (StringUtils.isBlank((CharSequence)redConfirmBillNo)) continue;
            DynamicObject confirmBill = RedConfirmHelper.loadConfirmBill((String)redConfirmBillNo, (Long)orgId);
            if (null == confirmBill) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u636e\u7f16\u53f7\u4e3a:%s\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"NoSplitServiceImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmBillNo));
            }
            RedConfirmHelper.replaceItems((DynamicObject)confirmBill, (DynamicObject)invoice);
        }
    }

    private List<BillRelationDTO> dealRedConfirmRelation(DynamicObject bill, List<BillRelationDTO> relationList, String newBillNo) {
        String redConfirmBillNo = bill.getString("infocode");
        if (StringUtils.isBlank((CharSequence)redConfirmBillNo)) {
            return this.dealRedConfirmByBlueInvoice(bill, relationList, newBillNo);
        }
        Object org = bill.get("orgid");
        Long orgPk = org instanceof DynamicObject ? Long.valueOf(((DynamicObject)org).getLong("id")) : (Long)org;
        DynamicObject redConfirm = RedConfirmHelper.loadConfirmBill((String)redConfirmBillNo, (Long)orgPk);
        if (null == redConfirm) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230:%s\u5bf9\u5e94\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"NoSplitServiceImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmBillNo));
        }
        long confirmPk = redConfirm.getLong("id");
        HashSet<Long> sBillIdSet = new HashSet<Long>();
        ArrayList<BillRelationDTO> result = new ArrayList<BillRelationDTO>();
        for (BillRelationDTO billRelationDTO : relationList) {
            if (sBillIdSet.contains(billRelationDTO.getsBillId())) continue;
            billRelationDTO.setPushType("-1");
            billRelationDTO.settTable("sim_red_confirm_bill");
            billRelationDTO.settBillId(Long.valueOf(confirmPk));
            billRelationDTO.settBillNo(newBillNo);
            result.add(billRelationDTO);
            sBillIdSet.add(billRelationDTO.getsBillId());
        }
        return result;
    }

    private List<BillRelationDTO> dealRedConfirmByBlueInvoice(DynamicObject bill, List<BillRelationDTO> relationList, String newBillNo) {
        String blueInvoiceCode = StringUtils.trimToEmpty((String)bill.getString("blueinvoicecode"));
        String blueInvoiceNo = StringUtils.trimToEmpty((String)bill.getString("blueinvoiceno"));
        if (StringUtils.isNotEmpty((CharSequence)blueInvoiceNo)) {
            QFilter blueFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo((String)blueInvoiceCode, (String)blueInvoiceNo);
            DynamicObject blueInvoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])blueFilter.toArray());
            if (blueInvoiceObj == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230:%s\u5bf9\u5e94\u7684\u539f\u84dd\u7968\u4fe1\u606f", (String)"NoSplitServiceImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), blueInvoiceNo));
            }
            HashSet<Long> sBillIdSet = new HashSet<Long>();
            ArrayList<BillRelationDTO> result = new ArrayList<BillRelationDTO>();
            for (BillRelationDTO billRelationDTO : relationList) {
                if (sBillIdSet.contains(billRelationDTO.getsBillId())) continue;
                billRelationDTO.setPushType("-1");
                billRelationDTO.settTable("sim_red_confirm_bill");
                billRelationDTO.settBillNo(newBillNo);
                result.add(billRelationDTO);
                sBillIdSet.add(billRelationDTO.getsBillId());
            }
            return result;
        }
        return relationList;
    }

    private DynamicObject createVatInvoice(DynamicObject bill, List<BillRelationDTO> relationList, String newBillNo) {
        DynamicObject prepareInvoice = this.copyInvoiceCommonField(bill, relationList, "sim_vatinvoice", newBillNo);
        this.initPrepareInvoice(prepareInvoice, bill);
        prepareInvoice.set("splitorder", (Object)1);
        return prepareInvoice;
    }

    public List<DynamicObject> createBlueInvoice(DynamicObject bill, LimitAmountsDTO limitAmounts, List<BillRelationDTO> relationList, String newBillNo) {
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(8);
        BigDecimal limitAmount = this.checkLimit(limitAmounts, bill);
        if (bill.getBigDecimal("invoiceamount").compareTo(limitAmount) > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62c6\u5206\u53d1\u7968\u7684\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9650\u989d%s", (String)"NoSplitServiceImpl_3", (String)"imc-sim-service", (Object[])new Object[0]), limitAmount.setScale(2, 4)));
        }
        String invoiceType = bill.getString("invoicetype");
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        if (billItems.size() > 2000) {
            if (InvoiceUtils.isPaperInvoice((String)invoiceType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u63a7\u7eb8\u7968\u660e\u7ec6\u884c\u4e0d\u80fd\u5927\u4e8e2000", (String)"NoSplitServiceImpl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                if (EnterpriseHelper.isLqptChannel((String)bill.getString("salertaxno"))) {
                    if (billItems.size() > 3000) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u7535\u7968\u4e50\u4f01\u660e\u7ec6\u884c\u4e0d\u80fd\u5927\u4e8e3000", (String)"NoSplitServiceImpl_8", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u7535\u7968\u660e\u7ec6\u884c\u4e0d\u80fd\u5927\u4e8e2000", (String)"NoSplitServiceImpl_7", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
        }
        if (InvoiceUtils.isEtcInvoice((String)invoiceType) && !InvoiceUtils.isAllEInvoice((Object)invoiceType) && billItems.size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u660e\u7ec6\u884c\u4e0d\u80fd\u5927\u4e8e100", (String)"NoSplitServiceImpl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject invoice = this.createVatInvoice(bill, relationList, newBillNo);
        invoiceList.add(invoice);
        return invoiceList;
    }

    public void initPrepareInvoice(DynamicObject prepareInovice, DynamicObject bill) {
        prepareInovice.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")));
        prepareInovice.set("systemsource", (Object)bill.getString("systemsource"));
        if (!this.isRedInvoice(bill)) {
            prepareInovice.set("originalinvoicecode", null);
            prepareInovice.set("originalinvoiceno", null);
            prepareInovice.set("originalinvoicetype", null);
            prepareInovice.set("originalissuetime", null);
        } else {
            if (bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0) {
                String originalInvoiceCode = bill.getString("blueinvoicecode");
                String originalInvoiceNo = bill.getString("blueinvoiceno");
                if (StringUtils.isNotBlank((CharSequence)originalInvoiceCode)) {
                    String string = originalInvoiceCode = originalInvoiceCode.contains(";") ? null : originalInvoiceCode;
                }
                if (StringUtils.isNotBlank((CharSequence)originalInvoiceNo)) {
                    originalInvoiceNo = originalInvoiceNo.contains(";") ? null : originalInvoiceNo;
                }
                prepareInovice.set("originalinvoicecode", (Object)originalInvoiceCode);
                prepareInovice.set("originalinvoiceno", (Object)originalInvoiceNo);
                prepareInovice.set("originalissuetime", bill.get("originalissuetime"));
                prepareInovice.set("originalinvoicetype", bill.get("blueinvoicetype"));
                prepareInovice.set("redreason", bill.get("redreason"));
            } else {
                prepareInovice.set("originalinvoicecode", (Object)"");
                prepareInovice.set("originalinvoiceno", (Object)"");
            }
            prepareInovice.set("remark", (Object)RemarkTemplateHelper.generateRemark((DynamicObject)prepareInovice));
        }
        prepareInovice.set("billdate", bill.get("billdate"));
        prepareInovice.set("issuetype", (Object)(bill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 ? "1" : "0"));
        BigDecimal deduction = bill.getBigDecimal("deduction");
        String taxationStyle = bill.getString("taxationstyle");
        if (StringUtils.isNotBlank((CharSequence)taxationStyle)) {
            prepareInovice.set("taxedtype", (Object)taxationStyle);
        } else if (!MathUtils.isNullOrZero((BigDecimal)deduction)) {
            prepareInovice.set("deduction", (Object)deduction);
            if (!InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)bill.getString("iselepaper"))) {
                prepareInovice.set("taxedtype", (Object)TaxedTypeEnum.deduction.getValue());
            }
        } else {
            prepareInovice.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
        }
        prepareInovice.set("batchbelong", (Object)this.getMergeBillNoFirst(bill.getString("billno")));
        if (!InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype"))) {
            prepareInovice.set("jqbh", bill.get("jqbh"));
        }
        prepareInovice.set("drawer", bill.get("drawer"));
        prepareInovice.set("payee", bill.get("payee"));
        prepareInovice.set("reviewer", bill.get("reviewer"));
        prepareInovice.set("remark", bill.get("invoiceremark"));
        NoSplitServiceImpl.buildMainInvoiceData(prepareInovice);
    }

    private boolean isRedConfirm(DynamicObject bill) {
        String invoiceType = bill.getString("invoicetype");
        String isElePaper = bill.getString("iselepaper");
        return (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) && this.isRedInvoice(bill);
    }

    private boolean isRedInfo(DynamicObject bill) {
        String invoiceType = bill.getString("invoicetype");
        String isElePaper = bill.getString("iselepaper");
        return this.isRedInvoice(bill) && InvoiceUtils.isSpecialInvoice((String)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper);
    }

    private boolean isRedInvoice(DynamicObject obj) {
        BigDecimal invoiceAmoount = obj.getBigDecimal("invoiceamount");
        return invoiceAmoount.compareTo(BigDecimal.ZERO) < 0;
    }

    public List<DynamicObject> createRedInfo(DynamicObject bill, List<BillRelationDTO> relationList, String newBillNo, SplitRequestDTO request) {
        String invoiceContent = StringUtils.isNotBlank((CharSequence)request.getInvoiceContent()) ? request.getInvoiceContent() : ImcConfigUtil.getValue((String)"sim_redinfo_deal_bill", (String)bill.getString("salertaxno"));
        boolean issuedByBill = "2".equals(invoiceContent);
        ArrayList<DynamicObject> redInfoList = new ArrayList<DynamicObject>(8);
        String infoCodes = bill.getString("infocode");
        if (StringUtils.isBlank((CharSequence)infoCodes)) {
            redInfoList.add(this.copyRedInfoFromBill(bill, relationList, newBillNo));
            bill.set("split", (Object)(issuedByBill ? "2" : "1"));
            bill.set("mergekey", (Object)"0");
            return redInfoList;
        }
        RedInfoHelper.checkRedInfo((String)infoCodes, (DynamicObject)bill);
        HashSet<String> infoCodeSet = new HashSet<String>(Arrays.asList(infoCodes.split(",")));
        ArrayList<String> existInfoCode = new ArrayList<String>(infoCodeSet.size());
        ArrayList redInfos = Lists.newArrayListWithCapacity((int)infoCodeSet.size());
        for (String infoCode2 : infoCodeSet) {
            QFilter qFilter = new QFilter("infocode", "=", (Object)infoCode2).and("org", "in", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")));
            DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"id", (QFilter[])qFilter.toArray());
            if (redInfo == null) {
                DynamicObject newRedInfo = this.copyRedInfoFromBill(bill, relationList, newBillNo);
                newRedInfo.set("infosource", (Object)"6");
                newRedInfo.set("status", (Object)"3");
                bill.set("split", (Object)"2");
                bill.set("mergekey", (Object)"-1");
                redInfoList.add(newRedInfo);
                continue;
            }
            existInfoCode.add(infoCode2);
            redInfo = BusinessDataServiceHelper.loadSingle((Object)redInfo.getPkValue(), (String)"sim_red_info");
            redInfo.set("invoicetype", bill.get("invoicetype"));
            bill.set("split", (Object)(issuedByBill ? "2" : "1"));
            bill.set("mergekey", (Object)"1");
            redInfos.add(redInfo);
        }
        if (issuedByBill && infoCodeSet.size() > 1 && infoCodeSet.size() != existInfoCode.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7684\u7ea2\u5b57\u4fe1\u606f\u8868%2$s\u5728\u53d1\u7968\u4e91\u4e0d\u5b58\u5728\uff08\u591a\u4e2a\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u9700\u5728\u53d1\u7968\u4e91\u90fd\u5b58\u5728\uff09", (String)"NoSplitServiceImpl_6", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), infoCodeSet.stream().filter(infoCode -> !existInfoCode.contains(infoCode)).collect(Collectors.joining(","))));
        }
        if (existInfoCode.size() > 1) {
            bill.set("split", (Object)"1");
            bill.set("mergekey", (Object)"-1");
        }
        for (DynamicObject redInfo : redInfos) {
            this.buildRedInfoRelation(bill, relationList, newBillNo, redInfoList, redInfo);
        }
        return redInfoList;
    }

    private DynamicObject copyRedInfoFromBill(DynamicObject bill, List<BillRelationDTO> relationList, String newBillNo) {
        DynamicObject redInfo = this.copyInvoiceCommonField(bill, relationList, "sim_red_info", newBillNo);
        redInfo.set("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")));
        redInfo.set("issuetime", null);
        redInfo.set("systemsource", (Object)bill.getString("systemsource"));
        redInfo.set("hsbz", bill.get("hsbz"));
        redInfo.set("infosource", (Object)"5");
        redInfo.set("jqbh", bill.get("jqbh"));
        redInfo.set("infodate", (Object)new Date());
        redInfo.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo((String)bill.getString("jqbh")));
        redInfo.set("orderno", (Object)UUID.next());
        redInfo.set("createtime", (Object)new Date());
        redInfo.set("batchbelong", (Object)this.getMergeBillNoFirst(bill.getString("billno")));
        redInfo.set("status", (Object)"1");
        redInfo.set("originaldeduction", ObjectUtils.defaultIfNull((Object)bill.getBigDecimal("deduction"), (Object)0));
        redInfo.set("originalinvoicecode", bill.get("blueinvoicecode"));
        redInfo.set("originalinvoiceno", bill.get("blueinvoiceno"));
        redInfo.set("originalissuetime", bill.get("originalissuetime"));
        redInfo.set("applyreason", (Object)GBKUtils.cutGBKString((String)bill.getString("invoiceremark"), (int)100));
        redInfo.set("deduction", (Object)bill.getBigDecimal("deduction"));
        String applicant = bill.getString("applicant");
        redInfo.set("applicant", (Object)(StringUtils.isBlank((CharSequence)applicant) ? RedInfoConstant.ApplicantEnum.SALER.getCode() : applicant));
        redInfo.set("applytaxno", (Object)(RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant) ? redInfo.getString("salertaxno") : redInfo.getString("buyertaxno")));
        redInfo.set("infocode", bill.get("infocode"));
        if (StringUtils.isBlank((CharSequence)redInfo.getString("inventorymark"))) {
            redInfo.set("inventorymark", (Object)"0");
        }
        redInfo.set("taxorg", (Object)RedInfoHelper.getTaxOrgId((String)redInfo.getString("applytaxno")));
        redInfo.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        return redInfo;
    }

    private void buildRedInfoRelation(DynamicObject bill, List<BillRelationDTO> relationList, String newBillNo, List<DynamicObject> redInfoList, DynamicObject redInfo) {
        this.fillInRedInfoFromOriginalbill(redInfo, bill, newBillNo);
        redInfoList.add(redInfo);
        Long sDetailId = ((DynamicObject)bill.getDynamicObjectCollection("sim_original_bill_item").get(0)).getLong("id");
        Long tDetailId = ((DynamicObject)redInfo.getDynamicObjectCollection("items").get(0)).getLong("id");
        BillRelationDTO relation = new BillRelationDTO(Long.valueOf(bill.getLong("id")), "", sDetailId, Long.valueOf(redInfo.getLong("id")), redInfo.getString("billno"), tDetailId, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "sim_red_info", "-1", DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")));
        relationList.add(relation);
    }

    private DynamicObject copyInvoiceCommonField(DynamicObject bill, List<BillRelationDTO> relationList, String entityName, String newBillNo) {
        Long invoiceId = DBServiceHelper.genGlobalLongId();
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)bill, (DynamicObject)invoice);
        invoice.set("id", (Object)invoiceId);
        invoice.set("billno", (Object)newBillNo);
        String remark = "";
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < billItems.size(); ++i) {
            DynamicObject billItem = (DynamicObject)billItems.get(i);
            if (i == 0) {
                remark = billItem.getString("remark");
            }
            if (billItem.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject invoiceItem = this.createInvoiceItem(bill, billItem, invoice, relationList);
            SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)invoiceItem);
            ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)invoiceItem);
            if ("2".equals(billItem.getString("rowtype"))) {
                invoiceItem.set("rowtype", (Object)"0");
                continue;
            }
            if (!"1".equals(billItem.getString("rowtype"))) continue;
            DynamicObject preInvoiceItem = (DynamicObject)invoice.getDynamicObjectCollection("items").get(i - 1);
            preInvoiceItem.set("rowtype", (Object)"2");
        }
        if (!this.isRedInfo(bill)) {
            invoice.set("remark", (Object)remark);
        }
        if (!"1".equals(invoice.getString("inventorymark"))) {
            if (billItems.size() > 8) {
                invoice.set("inventorymark", (Object)"1");
            } else {
                invoice.set("inventorymark", (Object)"0");
            }
        }
        NoSplitServiceImpl.copyOtherEntry(bill, invoice, new HashSet<String>(Collections.singletonList("items")));
        return invoice;
    }

    private void fillInRedInfoFromOriginalbill(DynamicObject redInfo, DynamicObject bill, String newBillNo) {
        redInfo.set("billno", (Object)newBillNo);
        redInfo.set("batchbelong", (Object)this.getMergeBillNoFirst(bill.getString("billno")));
        redInfo.set("systemsource", (Object)bill.getString("systemsource"));
        if (!"6".equals(redInfo.get("infosource"))) {
            redInfo.set("infosource", (Object)"5");
        }
        this.fillInNullValue(redInfo, bill, "payee");
        this.fillInNullValue(redInfo, bill, "reviewer");
        this.fillInNullValue(redInfo, bill, "drawer");
        this.fillInNullValue(redInfo, bill, "salerbank");
        this.fillInNullValue(redInfo, bill, "saleraddr");
        this.fillInNullValue(redInfo, bill, "buyerbank");
        this.fillInNullValue(redInfo, bill, "buyeraddr");
    }

    private void fillInNullValue(DynamicObject redInfo, DynamicObject source, String key) {
        String value = redInfo.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            redInfo.set(key, source.get(key));
        }
    }

    private DynamicObject createInvoiceItem(DynamicObject bill, DynamicObject billItem, DynamicObject invoice, List<BillRelationDTO> relationList) {
        DynamicObject invoiceItem = invoice.getDynamicObjectCollection("items").addNew();
        DynamicObjectUtil.copyDynamicObject((DynamicObject)billItem, (DynamicObject)invoiceItem);
        invoiceItem.set("simplegoodsname", (Object)billItem.getString("goodssimplename"));
        invoiceItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
        BigDecimal remainValidAmount = billItem.getBigDecimal("remainvalidamount");
        BigDecimal remainValidTax = billItem.getBigDecimal("remainvalidtax");
        BigDecimal remainValidNum = billItem.getBigDecimal("remainvalidnum");
        BigDecimal amount = remainValidAmount.subtract(remainValidTax);
        invoiceItem.set("num", (Object)remainValidNum);
        invoiceItem.set("amount", (Object)amount);
        invoiceItem.set("taxamount", (Object)amount.add(remainValidTax));
        invoiceItem.set("tax", (Object)remainValidTax);
        BillRelationDTO relation = new BillRelationDTO(Long.valueOf(bill.getLong("id")), "", Long.valueOf(billItem.getLong("id")), Long.valueOf(invoice.getLong("id")), invoice.getString("billno"), Long.valueOf(invoiceItem.getLong("id")), amount, remainValidTax, remainValidNum, billItem.getBigDecimal("unitprice"), this.isRedInfo(bill) ? "sim_red_info" : "sim_vatinvoice", "1", DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")));
        relationList.add(relation);
        invoiceItem.set("taxpremark", (Object)billItem.getString("policylogo"));
        invoiceItem.set("zzstsgl", (Object)billItem.getString("policycontants"));
        if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)invoiceItem, (String)"originseq") && DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)billItem, (String)"originalseq")) {
            invoiceItem.set("originseq", (Object)billItem.getString("originalseq"));
        }
        return invoiceItem;
    }
}

