/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.workhotel.event.BillCenterCommonCustomEvent;
import kd.imc.sim.billcenter.workhotel.event.BillCenterIssueResultCustomEvent;
import kd.imc.sim.billcenter.workhotel.event.BillCenterPreviewCustomEvent;
import kd.imc.sim.billcenter.workhotel.event.BillCenterProcessCustomEvent;
import kd.imc.sim.common.helper.SimCallBackHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;

public class BillCenterWorkHotelPlugin
extends AbstractFormPlugin {
    private static final Set<String> NOT_SHOW_LOADING = new ImmutableSet.Builder().add((Object)"common/tip").add((Object)"issue/showDetail").build();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"process_nextstep", "preview_prestep", "result_issue", "result_print", "result_view"});
    }

    public void click(EventObject evt) {
        String key;
        Tab tab = (Tab)this.getView().getControl("tabap");
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "process_nextstep": {
                AbstractBillWorkbenchCustomEvent.updateCustomControl(this, null, "process/nextStep");
                break;
            }
            case "preview_prestep": {
                tab.activeTab("process");
                this.setCurrentDisplay(0);
                break;
            }
            case "result_issue": {
                AbstractBillWorkbenchCustomEvent.updateCustomControl(this, null, "preview/issue");
                break;
            }
            case "result_print": {
                break;
            }
            case "result_view": {
                QFilter qFilter = null;
                String invoiceIds = AbstractBillWorkbenchCustomEvent.getPageCacheVal(this, "invoiceIds");
                if (StringUtils.isNotBlank((CharSequence)invoiceIds)) {
                    String[] blueids = invoiceIds.split(",");
                    Object[] blueList = Arrays.stream(blueids).map(s -> Long.parseLong(s.trim())).toArray();
                    DynamicObject[] blueInfoObjs = BusinessDataServiceHelper.load((Object[])blueList, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
                    ArrayList<String> invoiceNoList = new ArrayList<String>(blueInfoObjs.length);
                    for (DynamicObject blueInfoObject : blueInfoObjs) {
                        invoiceNoList.add(blueInfoObject.getString("invoiceno"));
                    }
                    qFilter = new QFilter("invoiceno", "in", invoiceNoList);
                }
                ViewUtil.openListPageByMainPage((AbstractFormPlugin)this, qFilter, (String)"sim_vatinvoice", (String)"sim_vatinvoice", (ShowType)ShowType.MainNewTabPage);
            }
        }
    }

    public void setCurrentDisplay(int curIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("curIndex", curIndex);
        AbstractBillWorkbenchCustomEvent.updateCustomControl(this, params, "setCurrentDisplay");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customEvent(CustomEventArgs e) {
        try {
            String event = e.getEventName();
            if (!NOT_SHOW_LOADING.contains(event)) {
                this.getView().showLoading(new LocaleString());
            }
            AbstractBillWorkbenchCustomEvent customEvent = event.startsWith("process/") ? new BillCenterProcessCustomEvent() : (event.startsWith("preview/") ? new BillCenterPreviewCustomEvent() : (event.startsWith("issue/") ? new BillCenterIssueResultCustomEvent() : new BillCenterCommonCustomEvent()));
            ((AbstractBillWorkbenchCustomEvent)customEvent).customEvent(this, e);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("process/openTitlePage".equals(event.getActionId())) {
            ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
            DynamicObject scanInvoice = BusinessDataServiceHelper.loadSingle((Object)list.getPrimaryKeyValues()[0], (String)"sim_scan_invoice");
            String str = AbstractBillWorkbenchCustomEvent.getPageCacheVal(this, "process/openTitlePage");
            JSONObject params = JSONObject.parseObject((String)str);
            params.put("buyername", scanInvoice.getString("buyername"));
            params.put("buyertaxno", scanInvoice.getString("buyertaxno"));
            params.put("buyeraddr", scanInvoice.getString("address") + scanInvoice.getString("invoicephone"));
            params.put("buyerbank", scanInvoice.getString("bank") + scanInvoice.getString("bankaccount"));
            params.put("buyeremail", scanInvoice.getString("buyeremail"));
            params.put("buyerphone", scanInvoice.getString("buyerphone"));
            AbstractBillWorkbenchCustomEvent.updateCustomControl(this, (Map<String, Object>)params, "process/openTitlePage");
        } else if ("preview/change_saler_address".equals(event.getActionId())) {
            BillProcessTabUtil.handleCustomEventSelectSalerAddr(this, event);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        SimCallBackHelper.callBack((AbstractFormPlugin)this, (Object)messageBoxClosedEvent);
    }
}

