/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SimSafeguardOrgMappingPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(SimSafeguardOrgMappingPlugin.class);

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("left_entry_entity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl("center_entry_entity");
        entryGrid2.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initFrontSystemDataMethod();
    }

    private void initFrontSystemDataMethod() {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        DynamicObjectCollection frontSystemCollection = orgMappingService.loadAllFrontSystemList();
        if (frontSystemCollection != null) {
            logger.info("initFrontSystemDataMethod, dynamicObjectCollection\u5927\u5c0f:{}", (Object)(frontSystemCollection == null ? 0 : frontSystemCollection.size()));
            this.getModel().beginInit();
            for (DynamicObject frontSystemObject : frontSystemCollection) {
                int row = this.getModel().createNewEntryRow("left_entry_entity");
                this.getModel().setValue("front_system", (Object)frontSystemObject, row);
            }
            this.getModel().endInit();
            this.getView().updateView("left_entry_entity");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("left_entry_entity".equals(key)) {
            int currentRow = evt.getRow();
            this.dealLoadFrontSystemOrgSourceData(currentRow);
        }
    }

    private void dealLoadFrontSystemOrgSourceData(int currentRow) {
        DynamicObject frontSystem;
        DynamicObject leftEntryObject = this.getModel().getEntryRowEntity("left_entry_entity", currentRow);
        if (leftEntryObject != null && (frontSystem = leftEntryObject.getDynamicObject("front_system")) != null) {
            this.getModel().deleteEntryData("center_entry_entity");
            BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
            frontSystem = billCenterOrgMappingService.loadSingle(frontSystem.getLong("id"));
            DynamicObjectCollection systemSourceOrgCollection = frontSystem.getDynamicObjectCollection("system_source_org");
            this.getModel().beginInit();
            StringBuilder bs = new StringBuilder();
            for (DynamicObject systemSourceOrg : systemSourceOrgCollection) {
                int row = this.getModel().createNewEntryRow("center_entry_entity");
                String systemCode = systemSourceOrg.getString("system_code");
                String orgCode = systemSourceOrg.getString("source_org_code");
                String orgName = systemSourceOrg.getString("source_org_name");
                QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode).and("name", "=", (Object)orgName);
                BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                DynamicObject targetOrgId = null;
                Long relId = null;
                DynamicObject orgMappingDataObject = orgMappingService.loadSingleTargetOrgMapping(qFilter);
                if (orgMappingDataObject == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u53d1\u7968\u4e91\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\uff01", (String)"SimSafeguardOrgMappingPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), orgName);
                    bs.append(msg).append("\r\n");
                } else {
                    targetOrgId = orgMappingDataObject.getDynamicObject("target_org_id");
                    relId = orgMappingDataObject.getLong("id");
                }
                this.getModel().setValue("org_name", (Object)orgName, row);
                this.getModel().setValue("org_code", (Object)orgCode, row);
                this.getModel().setValue("system_code", (Object)systemCode, row);
                this.getModel().setValue("system_entry_id", (Object)systemSourceOrg.getLong("id"), row);
                this.getModel().setValue("target_org_object", (Object)targetOrgId, row);
                this.getModel().setValue("rel_id", (Object)relId, row);
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"org_name", "org_code", "system_code"});
                if (targetOrgId == null) continue;
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"target_org1"});
            }
            this.getModel().endInit();
            this.getView().updateView("center_entry_entity");
            if (StringUtils.isNotEmpty((CharSequence)bs.toString())) {
                this.getView().showErrorNotification(bs.toString());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)opKey)) {
            this.deleteEntryObjectMethod();
            int leftEntryRow = this.getModel().getEntryCurrentRowIndex("left_entry_entity");
            this.dealLoadFrontSystemOrgSourceData(leftEntryRow);
        }
    }

    private void deleteEntryObjectMethod() {
        int centerCurrentRow = this.getModel().getEntryCurrentRowIndex("center_entry_entity");
        DynamicObject centerEntryObject = this.getModel().getEntryRowEntity("center_entry_entity", centerCurrentRow);
        if (centerEntryObject != null) {
            String relId = centerEntryObject.getString("rel_id");
            String systemEntryId = centerEntryObject.getString("system_entry_id");
            this.getModel().deleteEntryRow("center_entry_entity", centerCurrentRow);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sim_source_targe_org_rel");
            if (StringUtils.isNotEmpty((CharSequence)relId)) {
                DeleteServiceHelper.delete((IDataEntityType)type, (Object[])new String[]{relId});
            }
            int leftCurrentRow = this.getModel().getEntryCurrentRowIndex("left_entry_entity");
            DynamicObject leftEntryObject = this.getModel().getEntryRowEntity("left_entry_entity", leftCurrentRow);
            DynamicObject systemObject = leftEntryObject.getDynamicObject("front_system");
            systemObject = BusinessDataServiceHelper.loadSingle((Object)systemObject.getPkValue(), (String)"sim_front_system_cfg");
            DynamicObjectCollection systemSourceOrgCollection = systemObject.getDynamicObjectCollection("system_source_org");
            ArrayList<DynamicObject> deleteEntryObjectList = new ArrayList<DynamicObject>();
            for (int i = 0; i < systemSourceOrgCollection.size(); ++i) {
                DynamicObject systemSourceOrg = (DynamicObject)systemSourceOrgCollection.get(i);
                Long entryId = (Long)systemSourceOrg.getPkValue();
                if (!StringUtils.isNotEmpty((CharSequence)systemEntryId) || !StringUtils.equals((CharSequence)systemEntryId, (CharSequence)String.valueOf(entryId))) continue;
                deleteEntryObjectList.add(systemSourceOrg);
            }
            if (ObjectUtils.isNotEmpty(deleteEntryObjectList)) {
                systemSourceOrgCollection.removeAll(deleteEntryObjectList);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{systemObject});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("save_btn".equals(opKey)) {
            this.dealSaveFrontSystemOrgMethod();
        }
    }

    private void dealSaveFrontSystemOrgMethod() {
        int leftEntryRow = this.getModel().getEntryCurrentRowIndex("left_entry_entity");
        DynamicObject leftEntryObject = this.getModel().getEntryRowEntity("left_entry_entity", leftEntryRow);
        if (leftEntryObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u8d26\u5355\u4e2d\u5fc3\u2014\u2014\u300b\u6765\u6e90\u7cfb\u7edf\u914d\u7f6e\u8868\uff0c\u7ef4\u62a4\u76f8\u5173\u7684\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"SimSafeguardOrgMappingPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject systemObject = leftEntryObject.getDynamicObject("front_system");
        if (systemObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u8d26\u5355\u4e2d\u5fc3\u2014\u2014\u300b\u6765\u6e90\u7cfb\u7edf\u914d\u7f6e\u8868\uff0c\u7ef4\u62a4\u76f8\u5173\u7684\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (String)"SimSafeguardOrgMappingPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((systemObject = BusinessDataServiceHelper.loadSingle((Object)systemObject.getPkValue(), (String)"sim_front_system_cfg")) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5916\u56f4\u7cfb\u7edf\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"SimSafeguardOrgMappingPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection centerEntryCollection = this.getModel().getEntryEntity("center_entry_entity");
        String errorMsg = this.dealCheckOrgDataIsNullMethod(centerEntryCollection);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        errorMsg = this.dealCheckSameOrgDataMethod(centerEntryCollection);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        this.dealSaveSourceSystemOrgMethod(centerEntryCollection, systemObject);
        this.dealSaveSourceSystemOrgRelMethod(centerEntryCollection, systemObject);
        this.dealLoadFrontSystemOrgSourceData(leftEntryRow);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"SimSafeguardOrgMappingPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    private String dealCheckOrgDataIsNullMethod(DynamicObjectCollection centerEntryCollection) {
        for (int i = 0; i < centerEntryCollection.size(); ++i) {
            DynamicObject centerEntryObject = (DynamicObject)centerEntryCollection.get(i);
            String orgCode = centerEntryObject.getString("org_code");
            String orgName = centerEntryObject.getString("org_name");
            DynamicObject targetOrgObject = centerEntryObject.getDynamicObject("target_org_object");
            if (!StringUtils.isEmpty((CharSequence)orgCode) && !StringUtils.isEmpty((CharSequence)orgName) && targetOrgObject != null) continue;
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c:%1$s\u884c\uff0c\u7ec4\u7ec7\u7f16\u7801\u3001\u7ec4\u7ec7\u540d\u79f0\u3001\u76ee\u6807\u7ec4\u7ec7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"SimSafeguardOrgMappingPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1);
        }
        return null;
    }

    private void dealSaveSourceSystemOrgRelMethod(DynamicObjectCollection centerEntryCollection, DynamicObject systemObject) {
        String systemCode = systemObject.getString("number");
        for (int i = 0; i < centerEntryCollection.size(); ++i) {
            DynamicObject centerEntryObject = (DynamicObject)centerEntryCollection.get(i);
            String orgCode = centerEntryObject.getString("org_code");
            String orgName = centerEntryObject.getString("org_name");
            DynamicObject targetOrgObject = centerEntryObject.getDynamicObject("target_org_object");
            if (targetOrgObject == null) continue;
            QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("number", "=", (Object)orgCode).and("name", "=", (Object)orgName);
            DynamicObject orgRelObject = BusinessDataServiceHelper.loadSingle((String)"sim_source_targe_org_rel", (String)"id, system_code, number, name, target_org_id, status, enable", (QFilter[])new QFilter[]{qFilter});
            if (orgRelObject == null) {
                orgRelObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_source_targe_org_rel");
            }
            orgRelObject.set("system_code", (Object)systemCode);
            orgRelObject.set("number", (Object)orgCode);
            orgRelObject.set("name", (Object)orgName);
            orgRelObject.set("target_org_id", (Object)targetOrgObject);
            orgRelObject.set("status", (Object)"C");
            orgRelObject.set("enable", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orgRelObject});
        }
    }

    private void dealSaveSourceSystemOrgMethod(DynamicObjectCollection centerEntryCollection, DynamicObject systemObject) {
        String systemCode = systemObject.getString("number");
        DynamicObjectCollection systemSourceOrgCollection = systemObject.getDynamicObjectCollection("system_source_org");
        for (int i = 0; i < centerEntryCollection.size(); ++i) {
            String orgName;
            DynamicObject centerEntryObject = (DynamicObject)centerEntryCollection.get(i);
            String orgCode = centerEntryObject.getString("org_code");
            boolean flag = this.dealCheckSameOrgDataMethod(systemSourceOrgCollection, orgCode, orgName = centerEntryObject.getString("org_name"), systemCode);
            if (flag) continue;
            DynamicObject systemSourceObject = systemSourceOrgCollection.addNew();
            systemSourceObject.set("system_code", (Object)systemCode);
            systemSourceObject.set("source_org_code", (Object)orgCode);
            systemSourceObject.set("source_org_name", (Object)orgName);
            systemSourceObject.set("detail_create_date", (Object)new Date());
            systemSourceObject.set("detail_creater", (Object)RequestContext.get().getCurrUserId());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{systemObject});
    }

    private boolean dealCheckSameOrgDataMethod(DynamicObjectCollection systemSourceOrgCollection, String orgCode, String orgName, String systemCode) {
        for (DynamicObject systemSourceOrgObject : systemSourceOrgCollection) {
            String system_code = systemSourceOrgObject.getString("system_code");
            String source_org_code = systemSourceOrgObject.getString("source_org_code");
            String source_org_name = systemSourceOrgObject.getString("source_org_name");
            if (!system_code.equals(systemCode) || !source_org_code.equals(orgCode) || !source_org_name.equals(orgName)) continue;
            return true;
        }
        return false;
    }

    private String dealCheckSameOrgDataMethod(DynamicObjectCollection centerEntryCollection) {
        HashMap<String, Integer> orgMap = new HashMap<String, Integer>();
        for (int i = 0; i < centerEntryCollection.size(); ++i) {
            DynamicObject centerEntryObject = (DynamicObject)centerEntryCollection.get(i);
            String orgCode = centerEntryObject.getString("org_code");
            String orgName = centerEntryObject.getString("org_name");
            if (!StringUtils.isNotEmpty((CharSequence)orgCode) || !StringUtils.isNotEmpty((CharSequence)orgName)) continue;
            String key = orgCode + "-" + orgName;
            if (orgMap.containsKey(key)) {
                Integer num = (Integer)orgMap.get(key);
                num = num + 1;
                orgMap.put(key, num);
                continue;
            }
            orgMap.put(key, 1);
        }
        String errorMsg = null;
        for (Map.Entry entryObject : orgMap.entrySet()) {
            String key = (String)entryObject.getKey();
            String[] array = key.split("-");
            String orgCode = array[0];
            String orgName = array[1];
            Integer num = (Integer)entryObject.getValue();
            if (num <= 1) continue;
            errorMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s\uff0c\u4e1a\u52a1\u7ec4\u7ec7\u540d\u79f0:%2$s,\u51fa\u73b0\u91cd\u590d\u7684\u6570\u636e\uff01", (String)"SimSafeguardOrgMappingPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), orgCode, orgName);
            break;
        }
        return errorMsg;
    }
}

