/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.SimGiftReceiptService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.BillCenterInvoiceEnum;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;

public class SimWorkbenchNewFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(SimWorkbenchNewFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttonap"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("systemname");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        AbstractBillWorkbenchCustomEvent.putPageCache(this, "workbenchtype", "customcontrolap1");
        if (this.getModel().getValue("org") == null) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
        HashMap dataMap = new HashMap(4);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, dataMap, (String)"customcontrolap1");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ArrayList list = Lists.newArrayList();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("systemname".equals(key)) {
            if (this.getModel().getValue("org") == null) {
                list.add(new QFilter("number", "in", (Object)""));
                evt.setCustomQFilters((List)list);
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_source_targe_org_rel", (String)"system_code", (QFilter[])new QFilter("target_org_id", "=", ((DynamicObject)this.getModel().getValue("org")).get("id")).toArray());
            ArrayList<String> idList = new ArrayList<String>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                idList.add(dynamicObject.getString("system_code"));
            }
            list.add(new QFilter("number", "in", idList));
            evt.setCustomQFilters((List)list);
        }
    }

    private void writeBillsData(DynamicObject[] bills) {
        IDataModel modelDetail = this.getControl("entryentity").getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int billNumber = Integer.parseInt(String.valueOf(entryGrid.getEntryData().getData().get("rowcount")));
        for (DynamicObject bill : bills) {
            for (int i = 0; i < billNumber; ++i) {
                if (!modelDetail.getValue("billno", i).equals(bill.get("billno"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u6dfb\u52a0", (String)"SimWorkbenchFormPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            int index = this.getModel().createNewEntryRow("entryentity");
            modelDetail.setValue("billno", bill.get("billno"), index);
            modelDetail.setValue("total_amount", bill.get("total_amount"), index);
            modelDetail.setValue("invoicable_amount", bill.get("invoicable_amount"), index);
            modelDetail.setValue("custom_name", bill.get("custom_name"), index);
            modelDetail.setValue("room_no", bill.get("room_no"), index);
            modelDetail.setValue("user_phone", bill.get("user_phone"), index);
            modelDetail.setValue("bill_date", bill.get("bill_date"), index);
            modelDetail.setValue("billstatus", bill.get("billstatus"), index);
            modelDetail.setValue("pushstatus", bill.get("pushstatus"), index);
            modelDetail.setValue("id", bill.get("id"), index);
        }
        this.calculateAmount(billNumber);
    }

    private void calculateAmount(int billNumber) {
        IDataModel modelDetail = this.getControl("entryentity").getModel();
        this.getModel().setValue("billnumber", (Object)billNumber);
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal invoicableAmount = BigDecimal.ZERO;
        for (int i = 0; i < billNumber; ++i) {
            totalamount = totalamount.add(new BigDecimal(modelDetail.getValue("total_amount", i).toString()));
            invoicableAmount = invoicableAmount.add(new BigDecimal(modelDetail.getValue("invoicable_amount", i).toString()));
        }
        this.getModel().setValue("amount", (Object)totalamount);
        this.getModel().setValue("invoicableAmount", (Object)invoicableAmount);
    }

    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        String arg = e.getEventArgs();
        logger.info("customEvent, arg:{}, event:{}", (Object)arg, (Object)event);
        switch (event) {
            case "queryList": {
                long orgId = (Long)((DynamicObject)this.getModel().getValue("org")).get("id");
                if (arg.length() >= 1) {
                    DynamicObject[] dynamicObjects = SimWorkbenchNewFormPlugin.checkBillsData(orgId, arg);
                    ArrayList<Map> list = new ArrayList<Map>(dynamicObjects.length);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        Map mergeBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject, (boolean)true);
                        mergeBillMap.put("remainAmount", mergeBillMap.get("remain_amount"));
                        list.add(mergeBillMap);
                    }
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("data", list);
                    AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data, "queryList");
                }
                this.getModel().setValue("sbillno", (Object)arg);
                break;
            }
            case "handleSelectValue": {
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                if (arg == null || arg.isEmpty()) break;
                QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(arg));
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data"), (QFilter[])filter.toArray());
                if (dynamicObject != null) {
                    this.writeBillsData(new DynamicObject[]{dynamicObject});
                    AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data, "handleSelectValue");
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5355\u636e\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (String)"SimWorkbenchFormPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "accurateSearch": {
                this.dealAccurateSearchMethod(arg);
                break;
            }
            case "loadSystemList": {
                this.dealLoadSystemCfgListMethod();
                break;
            }
            case "queryCardList": {
                this.dealQueryCardListMethod(arg);
                break;
            }
            case "queryUpdateBill": {
                this.dealRefreshCardDataMethod(arg);
                break;
            }
            case "getQrCode": {
                this.dealGetQrCodeMethod(arg);
                break;
            }
            case "openWorkbenchHotel": {
                this.dealOpenWorkbenchHotelMethod(arg);
                break;
            }
            case "hotelTipMsg": {
                this.dealHotelTipMsgMethod(arg);
                break;
            }
            case "openBillDetail": {
                this.dealOpenBillDetailMethod(arg);
            }
        }
    }

    private void dealAccurateSearchMethod(String arg) {
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String systemCode = jsonObject.getString("systemCode");
        String value = jsonObject.getString("value");
        JSONObject paramObject = new JSONObject();
        paramObject.put("billNo", (Object)value);
        paramObject.put("systemCode", (Object)systemCode);
        paramObject.put("opKey", (Object)"query");
        logger.info("accurateSearch\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570:{}", (Object)SerializationUtils.toJsonString((Object)paramObject));
        List<BillVo> billVos = ExternalSystemDataHandler.getExternalSystemData(paramObject);
        logger.info("accurateSearch\uff0c\u8fd4\u56de\u7ed3\u679c\u5185\u5bb9:{}", billVos);
        ArrayList<Map> list = new ArrayList<Map>(8);
        if (billVos == null || billVos.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8be5\u8d26\u5355\uff0c\u8bf7\u68c0\u67e5\u8d26\u5355\u53f7\u662f\u5426\u6b63\u786e\uff01", (String)"SimWorkbenchFormPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            for (BillVo billVo : billVos) {
                String billNo = billVo.getBillNo();
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
                if (dynamicObject == null) continue;
                Map mergeBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject, (boolean)true);
                list.add(mergeBillMap);
            }
        }
        if (list.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8be5\u8d26\u5355\uff0c\u8bf7\u68c0\u67e5\u8d26\u5355\u53f7\u662f\u5426\u6b63\u786e\uff01", (String)"SimWorkbenchFormPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("accurateSearchList", list);
        data.put("requestId", this.getRequestIdMethod(arg));
        AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data, "accurateSearch");
    }

    private void dealOpenBillDetailMethod(String arg) {
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String systemCode = jsonObject.getString("systemCode");
        String billNo = jsonObject.getString("billNo");
        if (StringUtils.isBlank((CharSequence)systemCode) || StringUtils.isBlank((CharSequence)billNo)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"SimWorkbenchFormPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterObject == null) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"SimWorkbenchFormPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        Long pkId = billCenterObject.getLong("id");
        if (pkId != null && pkId > 0L) {
            billShowParameter.setPkId((Object)pkId);
            billShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        billShowParameter.setFormId("sim_isomerism_bill_data");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void dealOrgChangedMethod() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        dataMap.put("systemCfgList", this.dealGetSystemCfgList());
        AbstractBillWorkbenchCustomEvent.updateCustomControl(this, dataMap, "orgChanged");
    }

    private void dealHotelTipMsgMethod(String arg) {
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String type = jsonObject.getString("type");
        String message = jsonObject.getString("message");
        if ("success".equals(type)) {
            this.getView().showSuccessNotification(message);
        } else {
            this.getView().showTipNotification(message);
        }
    }

    private void dealLoadSystemCfgListMethod() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        dataMap.put("systemCfgList", this.dealGetSystemCfgList());
        AbstractBillWorkbenchCustomEvent.updateCustomControl(this, dataMap, "loadSystemList");
    }

    private void dealGetQrCodeMethod(String arg) {
        Long billCenterId = this.getBillCenterObjectId(arg);
        if (billCenterId != null && billCenterId > 0L) {
            BillShowParameter listParam = new BillShowParameter();
            listParam.setStatus(OperationStatus.ADDNEW);
            listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listParam.setFormId("sim_gift_receipt");
            listParam.setPageId(this.getView().getPageId() + billCenterId);
            listParam.setCustomParam("billcenterId", (Object)billCenterId);
            listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creategiftreceipt"));
            this.getView().showForm((FormShowParameter)listParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("creategiftreceipt".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private Long getBillCenterObjectId(String arg) {
        String systemCode;
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String billNo = jsonObject.getString("billNo");
        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode = jsonObject.getString("systemCode"));
        if (dynamicObject != null) {
            String tipMsg2 = this.dealCheckGetQrCodeRuleMethod(dynamicObject);
            if (StringUtils.isNotBlank((CharSequence)tipMsg2)) {
                this.getView().showTipNotification(tipMsg2);
                return null;
            }
            boolean flag = this.dealCheckAmountIsEqualMethod(dynamicObject);
            if (flag) {
                return dynamicObject.getLong("id");
            }
            String tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u5355\u5934\u603b\u91d1\u989d\u3001\u5546\u54c1\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u3001\u53ef\u5f00\u7968\u652f\u4ed8\u91d1\u989d\u3001\u8d26\u5355\u53ef\u4e0b\u63a8\u91d1\u989d\uff0c\u56db\u79cd\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u70b9\u51fb\u5de5\u4f5c\u53f0\u5f00\u7968\uff01", (String)"SimWorkbenchFormPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            throw new KDBizException(tipMsg);
        }
        return null;
    }

    private String dealCheckGetQrCodeRuleMethod(DynamicObject dynamicObject) {
        String giftReceiptNo = dynamicObject.getString("giftbillno");
        if (StringUtils.isNotBlank((CharSequence)giftReceiptNo)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8be5\u8d26\u5355\u5df2\u7ecf\u751f\u4ea7\u4e86\u5c0f\u7968\u7801\uff1a%s\uff0c\u82e5\u8981\u91cd\u65b0\u751f\u6210\uff0c\u8bf7\u5931\u6548\u6389\u539f\u5148\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), giftReceiptNo);
            throw new KDBizException(errorMsg);
        }
        String billNo = dynamicObject.getString("billno");
        BigDecimal remainAmount = dynamicObject.getBigDecimal("remain_amount");
        if (remainAmount == null || remainAmount.compareTo(BigDecimal.ZERO) <= 0) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u7f16\u53f7:%1$s\u7684\u53ef\u5f00\u7968\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u53ef\u5f00\u7968!", (String)"SimWorkbenchFormPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemObject : itemObjectCollection) {
            String tax_code = itemObject.getString("tax_code");
            BigDecimal tax_rate = itemObject.getBigDecimal("tax_rate");
            if (!StringUtils.isBlank((CharSequence)tax_code) && tax_rate != null && tax_rate.compareTo(BigDecimal.ZERO) != 0) continue;
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u8d26\u5355\u542b\u6709\u672a\u5339\u914d\u5f00\u7968\u9879\u7684\u660e\u7ec6\u884c\uff0c\u8bf7\u70b9\u51fb\u5de5\u4f5c\u53f0\u5f00\u7968!", (String)"SimWorkbenchFormPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        try {
            SimGiftReceiptService simGiftReceiptService = new SimGiftReceiptService();
            simGiftReceiptService.checkGroupGoodsItems(dynamicObject);
        }
        catch (KDBizException e) {
            String tipMsg = e.getMessage();
            return tipMsg;
        }
        return null;
    }

    private boolean dealCheckAmountIsEqualMethod(DynamicObject dynamicObject) {
        BigDecimal total_pay_amount = BigDecimal.ZERO;
        BigDecimal total_item_amount = BigDecimal.ZERO;
        BigDecimal total_amount = dynamicObject.getBigDecimal("total_amount");
        BigDecimal invoicable_amount = dynamicObject.getBigDecimal("invoicable_amount");
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemObject : itemObjectCollection) {
            total_item_amount = total_item_amount.add(itemObject.getBigDecimal("product_amount"));
        }
        DynamicObjectCollection payObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_pay_data");
        for (DynamicObject payObject : payObjectCollection) {
            total_pay_amount = total_pay_amount.add(payObject.getBigDecimal("pay_amount"));
        }
        logger.info("dealCheckAmountIsEqualMethod, total_amount:{}, invoicable_amount:{}, total_item_amount:{}, total_pay_amount:{}", new Object[]{total_amount, invoicable_amount, total_item_amount, total_pay_amount});
        return total_amount.compareTo(invoicable_amount) == 0 && invoicable_amount.compareTo(total_item_amount) == 0 && total_item_amount.compareTo(total_pay_amount) == 0;
    }

    private void dealCheckBillCenterObject(DynamicObject dynamicObject) {
        String billNo = dynamicObject.getString("billno");
        BigDecimal remainAmount = dynamicObject.getBigDecimal("remain_amount");
        if (remainAmount == null || remainAmount.compareTo(BigDecimal.ZERO) <= 0) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u7f16\u53f7:%1$s\u7684\u53ef\u5f00\u7968\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u53ef\u5f00\u7968!", (String)"SimWorkbenchFormPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        int count = 0;
        DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        for (DynamicObject itemObject : itemObjectCollection) {
            String tax_code = itemObject.getString("tax_code");
            BigDecimal tax_rate = itemObject.getBigDecimal("tax_rate");
            if (StringUtils.isBlank((CharSequence)tax_code) || tax_rate == null || tax_rate.compareTo(BigDecimal.ZERO) == 0) {
                String errorMsg = ResManager.loadKDString((String)"\u8be5\u8d26\u5355\u542b\u6709\u672a\u5339\u914d\u5f00\u7968\u9879\u7684\u660e\u7ec6\u884c\uff0c\u4e0d\u53ef\u5f00\u7968!", (String)"SimWorkbenchFormPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            String invoicable_switch = itemObject.getString("invoicable_switch");
            if (!"0".equals(invoicable_switch)) continue;
            ++count;
        }
        if (itemObjectCollection != null && count > 0 && itemObjectCollection.size() == count) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e0b\u7684\u6240\u6709\u6d88\u8d39\u660e\u7ec6\u884c\u90fd\u4e3a\u4e0d\u53ef\u5f00\u7968!", (String)"SimWorkbenchFormPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private void dealOpenWorkbenchHotelMethod(String arg) {
        logger.info("dealOpenWorkbenchHotel, arg:{}", (Object)arg);
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String billList = jsonObject.getString("billList");
        if (StringUtils.isBlank((CharSequence)billList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u5355\u7f16\u53f7\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u6253\u5f00\u5f00\u7968\u5de5\u4f5c\u53f0\u754c\u9762\uff01", (String)"SimWorkbenchNewFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)billList);
        if (jsonArray == null || jsonArray.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u5355\u7f16\u53f7\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u6253\u5f00\u5f00\u7968\u5de5\u4f5c\u53f0\u754c\u9762\uff01", (String)"SimWorkbenchNewFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> billNoList = new ArrayList<String>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject subObject = jsonArray.getJSONObject(i);
            String billNo = subObject.getString("billNo");
            billNoList.add(billNo);
        }
        logger.info("dealOpenWorkbenchHotel, billNoList\u5927\u5c0f:{}", (Object)billNoList.size());
        QFilter qFilter = new QFilter("billno", "in", billNoList);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)true);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u5355\u7f16\u53f7\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u6253\u5f00\u5f00\u7968\u5de5\u4f5c\u53f0\u754c\u9762\uff01", (String)"SimWorkbenchNewFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.dealCheckBillCenterObject(dynamicObject);
            idList.add(dynamicObject.getLong("id"));
        }
        logger.info("dealOpenWorkbenchHotel, idList:{}", idList);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"custom_issue", (String)"sim_isomerism_bill_data", (DynamicObject[])dynamicObjects, null);
        if (operationResult.isSuccess()) {
            HashMap<String, ArrayList<Long>> param = new HashMap<String, ArrayList<Long>>(4);
            param.put("pks", idList);
            ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_bill_center_process", (String)"sim_bill_center_process");
        } else {
            String errorMessage = ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).toString();
            if (errorMessage.isEmpty()) {
                this.getView().showTipNotification(operationResult.getMessage());
            } else {
                this.getView().showTipNotification(errorMessage);
            }
        }
    }

    private void dealQueryCardListMethod(String arg) {
        DynamicObject[] dynamicObjects = this.dealQueryRencentlyBillMethod(arg);
        ArrayList<Map> list = new ArrayList<Map>(8);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            String string = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6b64\u8d26\u5355\u6216\u8be5\u8d26\u5355\u6570\u636e\u4e3a\u7a7a!", (String)"SimWorkbenchFormPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(string);
        } else {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Map mergeBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject, (boolean)true);
                String billNo = (String)mergeBillMap.get("billno");
                BigDecimal invoicable_amount = (BigDecimal)mergeBillMap.get("invoicable_amount");
                logger.info("dealQueryCardListMethod, billNo:{}, invoicable_amount:{}", (Object)billNo, (Object)invoicable_amount);
                if (invoicable_amount == null || invoicable_amount.compareTo(BigDecimal.ZERO) <= 0) {
                    mergeBillMap.put("invoice_status", "-1");
                }
                mergeBillMap.put("remainAmount", mergeBillMap.get("remain_amount"));
                list.add(mergeBillMap);
            }
            String string = String.format(ResManager.loadKDString((String)"\u6210\u529f\u62c9\u53d6:%1$s\u6761\u6700\u65b0\u7684\u5df2\u7ed3\u8d26\u8d26\u5355\uff01", (String)"SimWorkbenchFormPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]), list.size());
            this.getView().showSuccessNotification(string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("requestId", this.getRequestIdMethod(arg));
        hashMap.put("cardDataList", list);
        logger.info("dealQueryCardListMethod, list:{}", (Object)list.size());
        AbstractBillWorkbenchCustomEvent.updateCustomControl(this, hashMap, "queryCardList");
    }

    private String getRequestIdMethod(String arg) {
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        return jsonObject.getString("requestId");
    }

    private DynamicObject[] dealQueryRencentlyBillMethod(String arg) {
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String systemCode = jsonObject.getString("systemCode");
        if (StringUtils.isBlank((CharSequence)systemCode)) {
            systemCode = this.getSystemCodeMethod();
        }
        DynamicObject[] dynamicObjects = null;
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        if (frontSystemObject != null) {
            int getDataType = BillCenterInvoiceEnum.ACTIVE_DATA_TYPE.getValue();
            String get_data_type = frontSystemObject.getString("get_data_type");
            if (StringUtils.isNotBlank((CharSequence)get_data_type)) {
                getDataType = Integer.parseInt(get_data_type);
            }
            if (BillCenterInvoiceEnum.SYNC_DATA_TYPE.getValue() == getDataType) {
                long orgId = (Long)((DynamicObject)this.getModel().getValue("org")).get("id");
                QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("org", "=", (Object)orgId);
                String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data");
                dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"bill_date desc", (int)10);
            } else {
                JSONObject paramObject = new JSONObject();
                paramObject.put("systemCode", (Object)systemCode);
                JSONObject paramContent = this.getParamContentBySystem(null, systemCode, "newBill");
                paramObject.put("paramContent", (Object)paramContent);
                logger.info("dealQueryRencentlyBillMethod, \u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)SerializationUtils.toJsonString((Object)paramObject));
                List<BillVo> applyBillList = ExternalSystemDataHandler.getExternalSystemData(paramObject);
                logger.info("dealQueryRencentlyBillMethod, \u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u662f:{}", applyBillList);
                if (applyBillList == null || applyBillList.isEmpty()) {
                    return null;
                }
                for (BillVo billVo : applyBillList) {
                    BillErrorVo billErrorVo;
                    if (!(billVo instanceof BillErrorVo) || !StringUtils.isNotEmpty((CharSequence)(billErrorVo = (BillErrorVo)billVo).getErrorMsg())) continue;
                    logger.error("\u8fd4\u56de\u7684\u9519\u8bef\u5185\u5bb9:{}", (Object)billErrorVo.getErrorMsg());
                    return null;
                }
                ArrayList<String> billNoList = new ArrayList<String>(applyBillList.size());
                for (BillVo billVo : applyBillList) {
                    String billNo = billVo.getBillNo();
                    billNoList.add(billNo);
                }
                logger.info("dealQueryRencentlyBillMethod, billNoList\u5927\u5c0f:{}", (Object)billNoList.size());
                long l = (Long)((DynamicObject)this.getModel().getValue("org")).get("id");
                QFilter qFilter = new QFilter("billno", "in", billNoList).and("org", "=", (Object)l);
                String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data");
                dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])qFilter.toArray());
            }
        }
        return dynamicObjects;
    }

    private String getSystemCodeMethod() {
        Map<String, Object> elementMap;
        String systemCode = null;
        List<Map<String, Object>> list = this.dealGetSystemCfgList();
        Iterator<Map<String, Object>> iterator = list.iterator();
        while (iterator.hasNext() && !StringUtils.isNotBlank((CharSequence)(systemCode = (String)(elementMap = iterator.next()).get("systemCode")))) {
        }
        return systemCode;
    }

    private void dealRefreshCardDataMethod(String arg) {
        if (arg.length() >= 1) {
            ArrayList<Map> list = new ArrayList<Map>(8);
            DynamicObject dynamicObject = this.dealQueryUpdateBillMethod(arg);
            JSONObject jsonObject = JSONObject.parseObject((String)arg);
            String billNo = jsonObject.getString("billNo");
            if (dynamicObject == null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8be5\u8d26\u5355:%1$s", (String)"SimWorkbenchFormPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
                this.getView().showTipNotification(errorMsg);
            } else {
                DynamicObjectCollection itemObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
                if (itemObjectCollection == null || itemObjectCollection.isEmpty()) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7:%1$s\uff0c\u5bf9\u5e94\u7684\u8d26\u5355\u660e\u7ec6\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"SimWorkbenchFormPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
                    this.getView().showTipNotification(tipMsg);
                } else {
                    Map mergeBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject, (boolean)true);
                    BigDecimal invoicable_amount = (BigDecimal)mergeBillMap.get("invoicable_amount");
                    if (invoicable_amount == null || invoicable_amount.compareTo(BigDecimal.ZERO) <= 0) {
                        mergeBillMap.put("invoice_status", "-1");
                    }
                    mergeBillMap.put("remainAmount", mergeBillMap.get("remain_amount"));
                    list.add(mergeBillMap);
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7:%1$s\uff0c\u66f4\u65b0\u6570\u636e\u6210\u529f\uff01", (String)"SimWorkbenchFormPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), billNo);
                    this.getView().showSuccessNotification(tipMsg);
                }
            }
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("updateDataList", list);
            data.put("billNo", billNo);
            data.put("requestId", this.getRequestIdMethod(arg));
            AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data, "queryUpdateBill");
        }
    }

    private DynamicObject dealQueryUpdateBillMethod(String arg) {
        JSONObject jsonObject = JSONObject.parseObject((String)arg);
        String billNo = jsonObject.getString("billNo");
        String systemCode = jsonObject.getString("systemCode");
        logger.info("dealQueryUpdateBillMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        DynamicObject billCenterObject = null;
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        if (frontSystemObject != null) {
            boolean flag = false;
            String flagStr = frontSystemObject.getString("client_enc_key");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)flagStr)) {
                flag = Boolean.parseBoolean(flagStr);
            }
            if (flag) {
                BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
            } else {
                try {
                    JSONObject paramObject = new JSONObject();
                    paramObject.put("systemCode", (Object)systemCode);
                    JSONObject paramContent = this.getParamContentBySystem(billNo, systemCode, "getBill");
                    paramObject.put("paramContent", (Object)paramContent);
                    logger.info("dealQueryUpdateBillMethod, \u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)SerializationUtils.toJsonString((Object)paramObject));
                    List<BillVo> applyBillList = ExternalSystemDataHandler.getExternalSystemData(paramObject);
                    logger.info("dealQueryUpdateBillMethod, \u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u662f:{}", applyBillList);
                    if (applyBillList == null || applyBillList.isEmpty()) {
                        return null;
                    }
                    for (BillVo billVo : applyBillList) {
                        BillErrorVo billErrorVo;
                        if (!(billVo instanceof BillErrorVo) || !StringUtils.isNotEmpty((CharSequence)(billErrorVo = (BillErrorVo)billVo).getErrorMsg())) continue;
                        logger.error("\u8fd4\u56de\u7684\u9519\u8bef\u5185\u5bb9:{}", (Object)billErrorVo.getErrorMsg());
                        return null;
                    }
                    BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                    billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5355\u4e2a\u8d26\u5355\u8fd4\u56de\u7684\u5f02\u5e38\u7ed3\u679c:{}", (Object)e.getMessage());
                    billCenterObject = null;
                }
            }
        }
        return billCenterObject;
    }

    private JSONObject getParamContentBySystem(String billNo, String systemCode, String operate) {
        JSONObject jsonObject = new JSONObject();
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystem = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        if (frontSystem == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6765\u6e90\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"SimWorkbenchFormPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String number = frontSystem.getString("number");
        String hostName = frontSystem.getString("system_url");
        String username = frontSystem.getString("client_id");
        String password = frontSystem.getString("client_secret");
        jsonObject.put("operate", (Object)operate);
        jsonObject.put("hotelName", (Object)number);
        jsonObject.put("confNos", (Object)billNo);
        jsonObject.put("hostName", (Object)hostName);
        jsonObject.put("username", (Object)username);
        jsonObject.put("password", (Object)password);
        return jsonObject;
    }

    private List<Map<String, Object>> dealGetSystemCfgList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        QFilter qFilter = new QFilter("target_org_id", "=", ((DynamicObject)this.getModel().getValue("org")).get("id"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_source_targe_org_rel", (String)"system_code", (QFilter[])qFilter.toArray());
        HashSet<String> systemCodeSet = new HashSet<String>(dynamicObjects.length);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String systemName;
                DynamicObject frontSystemObject;
                String systemCode = dynamicObject.getString("system_code");
                if (!StringUtils.isNotBlank((CharSequence)systemCode) || (frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode)) == null || !StringUtils.isNotBlank((CharSequence)(systemName = frontSystemObject.getString("name"))) || !systemName.toUpperCase().contains("OPERA") && !systemName.toUpperCase().contains("HERO")) continue;
                String element = systemCode + "-" + systemName;
                systemCodeSet.add(element);
            }
        }
        for (String element : systemCodeSet) {
            String systemCode = element.split("-")[0];
            String systemName = element.split("-")[1];
            HashMap<String, String> dataMap = new HashMap<String, String>(8);
            dataMap.put("systemCode", systemCode);
            dataMap.put("systemName", systemName);
            list.add(dataMap);
        }
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "org": {
                DynamicObject orgObject;
                ChangeData[] changeSet = e.getChangeSet();
                if (changeSet != null && (orgObject = (DynamicObject)changeSet[0].getOldValue()) != null) {
                    AbstractBillWorkbenchCustomEvent.putPageCache(this, "orgId", String.valueOf(orgObject.getLong("id")));
                }
                String showContent = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4f1a\u6e05\u7a7a\u5f53\u524d\u9875\u9762\u8d26\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SimWorkbenchFormPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)showContent, (String)"orgChanged");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String name = event.getResult().name();
        if (event.getCallBackId().equals("orgChanged") && "Yes".equals(name)) {
            this.dealOrgChangedMethod();
        } else {
            String orgId = AbstractBillWorkbenchCustomEvent.getPageCacheVal(this, "orgId");
            this.getView().getModel().beginInit();
            this.getModel().setValue("org", (Object)orgId);
            this.getView().getModel().endInit();
            this.getView().updateView("org");
        }
    }

    private static DynamicObject[] checkBillsData(long orgId, String arg) {
        DynamicObject[] dynamicObjects;
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        if (arg.isEmpty()) {
            dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data"), (QFilter[])filter.toArray());
        } else {
            QFilter filter1 = new QFilter("custom_name", "like", (Object)("%" + arg + "%"));
            if (arg.length() >= 2) {
                filter1.or("billno", "like", (Object)("%" + arg + "%")).or("room_no", "like", (Object)("%" + arg + "%")).or("user_phone", "like", (Object)("%" + arg + "%"));
            }
            filter.and(filter1);
            dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data"), (QFilter[])filter.toArray(), (String)"id", (int)0, (int)10);
        }
        return dynamicObjects;
    }
}

