/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter.op;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.sim.billcenter.SimGiftReceiptService;
import org.apache.commons.collections.CollectionUtils;

public class SimIsomerismBillGiftReceiptCreateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("giftbillno");
        e.getFieldKeys().add("system_code");
        e.getFieldKeys().add("org_code");
        e.getFieldKeys().add("giftstatus");
        e.getFieldKeys().add("total_amount");
        e.getFieldKeys().add("remain_amount");
        e.getFieldKeys().add("sim_isomerism_item_data.product_code");
        e.getFieldKeys().add("sim_isomerism_item_data.product_name");
        e.getFieldKeys().add("sim_isomerism_item_data.unpushamount");
        e.getFieldKeys().add("sim_isomerism_item_data.unpushtax");
        e.getFieldKeys().add("sim_isomerism_item_data.unpushnum");
        e.getFieldKeys().add("sim_isomerism_item_data.invoicable_switch");
        e.getFieldKeys().add("sim_isomerism_item_data.line_property");
        e.getFieldKeys().add("sim_isomerism_item_data.product_amount");
        e.getFieldKeys().add("sim_isomerism_item_data.product_price");
        e.getFieldKeys().add("sim_isomerism_item_data.avg_amount");
        e.getFieldKeys().add("sim_isomerism_item_data.tax_amount");
        e.getFieldKeys().add("sim_isomerism_item_data.product_quantity");
        e.getFieldKeys().add("sim_isomerism_item_data.tax_rate");
        e.getFieldKeys().add("sim_isomerism_item_data.tax_code");
        e.getFieldKeys().add("sim_isomerism_pay_data.pay_amount");
        e.getFieldKeys().add("sim_isomerism_pay_data.is_invoiced");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    try {
                        SimIsomerismBillGiftReceiptCreateOp.this.checkBill(bill);
                        SimGiftReceiptService simGiftReceiptService = new SimGiftReceiptService();
                        simGiftReceiptService.checkGroupGoodsItems(bill);
                    }
                    catch (KDBizException e) {
                        this.addErrorMessage(dataEntity, e.getMessage());
                    }
                }
            }
        });
    }

    public void checkBill(DynamicObject bill) {
        String giftReceiptNo = bill.getString("giftbillno");
        if (StringUtils.isNotBlank((CharSequence)giftReceiptNo)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8be5\u8d26\u5355\u5df2\u7ecf\u751f\u4ea7\u4e86\u5c0f\u7968\u7801\uff1a%s\uff0c\u82e5\u8981\u91cd\u65b0\u751f\u6210\uff0c\u8bf7\u5931\u6548\u6389\u539f\u5148\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), giftReceiptNo);
            throw new KDBizException(errorMsg);
        }
        DynamicObjectCollection payItems = bill.getDynamicObjectCollection("sim_isomerism_pay_data");
        if (CollectionUtils.isEmpty((Collection)payItems)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u652f\u4ed8\u660e\u7ec6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_0", (String)"imc-sim-formplugin", (Object[])new Object[]{bill.getString("billno")}));
        }
        BigDecimal totalPayAmount = BigDecimal.ZERO;
        for (DynamicObject payItem : payItems) {
            if (!"1".equals(payItem.getString("is_invoiced"))) continue;
            totalPayAmount = totalPayAmount.add(payItem.getBigDecimal("pay_amount"));
        }
        if (totalPayAmount.compareTo(bill.getBigDecimal("total_amount")) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u652f\u4ed8\u660e\u7ec6\u6c47\u603b\u91d1\u989d\u4e0e\u8d26\u5355\u603b\u91d1\u989d\u4e0d\u7b49\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_1", (String)"imc-sim-formplugin", (Object[])new Object[]{bill.getString("billno")}));
        }
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_isomerism_item_data");
        if (CollectionUtils.isEmpty((Collection)billItems)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < billItems.size(); ++i) {
            DynamicObject billItem = (DynamicObject)billItems.get(i);
            if (!"1".equals(billItem.getString("invoicable_switch"))) continue;
            int index = i + 1;
            BigDecimal unPushAmount = billItem.getBigDecimal("unpushamount");
            totalAmount = totalAmount.add(unPushAmount);
            BigDecimal unPushTax = billItem.getBigDecimal("unpushtax");
            BigDecimal unPushNum = billItem.getBigDecimal("unpushnum");
            if (unPushAmount.compareTo(billItem.getBigDecimal("product_amount")) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7b2c%2$s\u884c\u53ef\u4e0b\u63a8\u91d1\u989d\u4e0d\u7b49\u4e8e\u5546\u54c1\u91d1\u989d\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), index));
            }
            if (unPushAmount.compareTo(billItem.getBigDecimal("avg_amount")) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7b2c%2$s\u884c\u53ef\u4e0b\u63a8\u91d1\u989d\u4e0d\u7b49\u4e8e\u53ef\u5f00\u7968\u91d1\u989d\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), index));
            }
            if (unPushTax.compareTo(billItem.getBigDecimal("tax_amount")) != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7b2c%2$s\u884c\u53ef\u4e0b\u63a8\u7a0e\u989d\u4e0d\u7b49\u4e8e\u53ef\u5f00\u7968\u7a0e\u989d\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), index));
            }
            if (unPushNum.compareTo(billItem.getBigDecimal("product_quantity")) == 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7b2c%2$s\u884c\u53ef\u4e0b\u63a8\u6570\u91cf\u4e0d\u7b49\u4e8e\u53ef\u5f00\u7968\u6570\u91cf\uff0c\u4e0d\u80fd\u751f\u6210\u5c0f\u7968\u7801\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), bill.getString("billno"), index));
        }
        if (totalAmount.compareTo(bill.getBigDecimal("total_amount")) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u8d26\u5355\u5355\u5934\u603b\u91d1\u989d\u3001\u5546\u54c1\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u3001\u53ef\u5f00\u7968\u652f\u4ed8\u91d1\u989d\u3001\u8d26\u5355\u53ef\u4e0b\u63a8\u91d1\u989d\u4e4b\u548c\uff0c\u56db\u79cd\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u70b9\u51fb\u5de5\u4f5c\u53f0\u5f00\u7968\u3002", (String)"SimIsomerismBillGiftReceiptCreateOp_6", (String)"imc-sim-formplugin", (Object[])new Object[]{bill.getString("billno")}));
        }
    }
}

