/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.FileField;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class InvoiceBatchFileImportUtil {
    private static final Log LOGGER = LogFactory.getLog(InvoiceBatchFileImportUtil.class);

    public static Map<String, LinkedList<Map<String, Object>>> doParse(Workbook workbook, List<FileField> fields, int starRow, Map<String, String> errMap, String passType) {
        Sheet sheet = workbook.getSheetAt(0);
        HashMap<String, LinkedList<Map<String, Object>>> list = new HashMap<String, LinkedList<Map<String, Object>>>(sheet.getLastRowNum());
        Map<String, LinkedList<Row>> mapSheet = InvoiceBatchFileImportUtil.checkRowData(sheet, fields, starRow, passType);
        for (Map.Entry<String, LinkedList<Row>> entry : mapSheet.entrySet()) {
            LinkedList<Map<String, Object>> rowListMap = new LinkedList<Map<String, Object>>();
            for (Row hss : entry.getValue()) {
                Object str;
                Map<String, Object> rowMap;
                if (!ExcelHelper.isRowNotEmpty((Row)hss) || null == (rowMap = InvoiceBatchFileImportUtil.parseRows(hss, fields, errMap))) continue;
                rowMap.put("taxrate", InvoiceBatchFileImportUtil.formartRate1(rowMap.get("taxrate")));
                if (StringUtils.isNotBlank((Object)rowMap.get("discountrate"))) {
                    rowMap.put("discountrate", InvoiceBatchFileImportUtil.formartRate(rowMap.get("discountrate")));
                }
                rowListMap.add(rowMap);
                if (StringUtils.isNotBlank((Object)rowMap.get("discountamount"))) {
                    str = rowMap.get("discountamount");
                    Object amount = rowMap.get("amount");
                    if (Math.abs(Float.parseFloat(str.toString())) > Math.abs(Float.parseFloat(amount.toString()))) {
                        throw new MsgException(ResManager.loadKDString((String)"\u6298\u6263\u91d1\u989d\u5927\u4e8e\u91d1\u989d\uff01", (String)"InvoiceBatchFileImportUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                    if (!(Math.abs(Float.parseFloat(str.toString())) > 0.0f)) continue;
                    Map<String, Object> newMap = InvoiceBatchFileImportUtil.parseDiscountRow(rowMap);
                    rowListMap.add(newMap);
                    continue;
                }
                if (!StringUtils.isNotBlank((Object)rowMap.get("discountrate")) || !(Math.abs(Float.parseFloat((str = rowMap.get("discountrate")).toString())) > 0.0f) || !(Math.abs(Float.parseFloat(str.toString())) < 1.0f)) continue;
                Map<String, Object> newMap = InvoiceBatchFileImportUtil.parseDiscountRow(rowMap);
                rowListMap.add(newMap);
            }
            if (rowListMap.size() <= 0) continue;
            list.put(entry.getKey(), rowListMap);
        }
        return list;
    }

    private static Map<String, Object> parseDiscountRow(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
        newMap.putAll(map);
        map.put("rowtype", "\u88ab\u6298\u6263\u884c");
        map.put("discountrow", "");
        newMap.put("rowtype", "\u6298\u6263\u884c");
        newMap.put("discountrow", "1");
        if (StringUtils.isNotBlank((Object)map.get("discountrate"))) {
            map.put("discountrate", "");
        }
        if (StringUtils.isNotBlank((Object)map.get("discountamount"))) {
            map.put("discountamount", "");
        }
        return newMap;
    }

    private static String formartRate(Object obj) {
        String result = "0";
        if (StringUtils.isBlank((Object)obj)) {
            return result;
        }
        String param = obj.toString();
        result = param.contains(".") && !param.contains("%") ? param : (param.contains("%") ? new BigDecimal(param.replace("%", "")).divide(new BigDecimal("100")).toString() : new BigDecimal(param).divide(new BigDecimal("100")).toString());
        return result;
    }

    private static String formartRate1(Object obj) {
        String result = "";
        if (StringUtils.isBlank((Object)obj)) {
            return result;
        }
        String param = obj.toString();
        result = param.contains(".") && !param.contains("%") ? param : (param.contains("%") ? new BigDecimal(param.replace("%", "")).divide(new BigDecimal("100")).toString() : new BigDecimal(param).divide(new BigDecimal("100")).toString());
        BigDecimal taxRate = new BigDecimal(result);
        return TaxRate.getRateStr((BigDecimal)taxRate);
    }

    private static Map<String, Object> parseRows(Row hss, List<FileField> fields, Map<String, String> errMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(fields.size(), 1.0f);
        Integer rowNum = hss.getRowNum();
        map.put("rowIndex", rowNum);
        map.put("row", hss);
        Boolean flag = Boolean.TRUE;
        try {
            for (FileField field : fields) {
                int index = -1;
                String errMsg = field.getRegexErrorMsg();
                try {
                    List<String> arr;
                    index = field.getColIndex() - 1;
                    String value = InvoiceBatchFileImportUtil.getCellValue(hss.getCell(index));
                    if (StringUtils.isBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)field.getDefaultValue())) {
                        value = field.getDefaultValue();
                    }
                    if (field.getRequired().booleanValue() && StringUtils.isBlank((CharSequence)value)) {
                        InvoiceBatchFileImportUtil.setBaseErrorMessage(hss, field, errMap, StringUtils.isNotBlank((CharSequence)errMsg) ? errMsg : String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceBatchFileImportUtil_1", (String)"imc-sim-service", (Object[])new Object[0]), field.getFieldName()));
                        flag = Boolean.FALSE;
                        continue;
                    }
                    if (field.getMaxLength() != null && InvoiceBatchFileImportUtil.getStringGBKLength(value) > field.getMaxLength()) {
                        InvoiceBatchFileImportUtil.setBaseErrorMessage(hss, field, errMap, StringUtils.isNotBlank((CharSequence)errMsg) ? errMsg : String.format(ResManager.loadKDString((String)"%s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%d\u4e2a\u5b57\u7b26", (String)"InvoiceBatchFileImportUtil_2", (String)"imc-sim-service", (Object[])new Object[0]), field.getFieldName(), field.getMaxLength()));
                        flag = Boolean.FALSE;
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getRegex()) && StringUtils.isNotBlank((CharSequence)value) && !Pattern.matches(field.getRegex(), value)) {
                        if ("buyerphone".equals(field.getFieldCode()) && !MsgAuthSettingCacheHelper.isCheckPhone((long)RequestContext.get().getOrgId())) {
                            LOGGER.info(String.format("\u624b\u673a\u53f7:%s\u4e0d\u6821\u9a8c", value));
                        } else {
                            InvoiceBatchFileImportUtil.setBaseErrorMessage(hss, field, errMap, StringUtils.isNotBlank((CharSequence)errMsg) ? errMsg : ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef", (String)"InvoiceBatchFileImportUtil_3", (String)"imc-sim-service", (Object[])new Object[0]));
                            flag = Boolean.FALSE;
                            continue;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)field.getContainsContent()) && StringUtils.isNotBlank((CharSequence)value) && !(arr = Arrays.asList(field.getContainsContent().split("~~~"))).contains(value)) {
                        InvoiceBatchFileImportUtil.setBaseErrorMessage(hss, field, errMap, StringUtils.isNotBlank((CharSequence)errMsg) ? errMsg : String.format(ResManager.loadKDString((String)"%s\u5185\u5bb9\u586b\u5199\u9519\u8bef", (String)"InvoiceBatchFileImportUtil_4", (String)"imc-sim-service", (Object[])new Object[0]), field.getFieldName()));
                        flag = Boolean.FALSE;
                        continue;
                    }
                    map.put(field.getFieldCode(), value);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    errMsg = e.getMessage();
                    InvoiceBatchFileImportUtil.setBaseErrorMessage(hss, field, errMap, StringUtils.isNotBlank((CharSequence)errMsg) ? errMsg : String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e", (String)"InvoiceBatchFileImportUtil_5", (String)"imc-sim-service", (Object[])new Object[0]), field.getFieldName()));
                    flag = Boolean.FALSE;
                }
            }
        }
        catch (Exception e) {
            flag = Boolean.FALSE;
            LOGGER.error((Throwable)e);
        }
        return flag != false ? map : null;
    }

    private static String getCellValue(Cell cell) {
        if (null == cell) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue()).trim();
            }
            case FORMULA: {
                try {
                    return String.valueOf(cell.getNumericCellValue());
                }
                catch (IllegalStateException e) {
                    return String.valueOf(cell.getRichStringCellValue());
                }
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return sdf.format(cell.getDateCellValue());
                }
                String cellValue = String.valueOf(cell.getNumericCellValue());
                if (cellValue.contains("e") || cellValue.contains("E")) {
                    cellValue = new BigDecimal(cellValue).stripTrailingZeros().toPlainString();
                }
                return cellValue;
            }
        }
        return cell.getStringCellValue().trim();
    }

    private static Map<String, LinkedList<Row>> checkRowData(Sheet sheet, List<FileField> fields, Integer starNum, String passType) {
        HashMap<String, LinkedList<Row>> listMap = new HashMap<String, LinkedList<Row>>();
        Integer first = 0;
        Integer second = 1;
        for (FileField field : fields) {
            if ("bill".equals(passType)) {
                if (!field.getFieldCode().equals("billno")) continue;
                first = field.getColIndex() - 1;
                break;
            }
            if (field.getFieldCode().equals("invoicecode")) {
                first = field.getColIndex() - 1;
            }
            if (!field.getFieldCode().equals("invoiceno")) continue;
            second = field.getColIndex() - 1;
        }
        for (int i = starNum.intValue(); i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            String billnumberNo = "";
            if ("bill".equals(passType)) {
                Cell billnumber = row.getCell(first.intValue());
                billnumberNo = ExcelHelper.getStringValueFromCell((Cell)billnumber);
            } else {
                Cell code = row.getCell(first.intValue());
                Cell no = row.getCell(second.intValue());
                billnumberNo = ExcelHelper.getStringValueFromCell((Cell)code) + ExcelHelper.getStringValueFromCell((Cell)no);
            }
            List list = (List)listMap.get(billnumberNo);
            if (null != list) {
                list.add(row);
                continue;
            }
            LinkedList<Row> rowList = new LinkedList<Row>();
            rowList.addLast(row);
            listMap.put(billnumberNo, rowList);
        }
        return listMap;
    }

    private static int getStringGBKLength(String str) {
        int length;
        try {
            length = str.getBytes("GBK").length;
        }
        catch (Exception e) {
            length = 0;
        }
        return length;
    }

    public static void showBatchFileImportResult(Workbook workbook, String fileName, IFormView view, int okRwo, int failRow, Map<String, String> errMap) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.write((OutputStream)out);
        byte[] bookByteAry = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bookByteAry);
        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("totalline", workbook.getSheetAt(0).getLastRowNum() - 1);
        customParams.put("successline", okRwo);
        customParams.put("failline", failRow);
        customParams.put("url", urls);
        customParams.put("errMap", errMap);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("sim_inv_import_result");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static Map<String, Object> countTaxMount(String taxincludedNo, String quantityNo, String taxrateNo, String priceNo, String amountmoneyNo, String invoicenature) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u662f\u5426\u542b\u7a0e:%s,\u6570\u91cf:%s,\u7a0e\u7387:%s,\u5355\u4ef7:%s,\u91d1\u989d:%s,\u53d1\u7968\u884c\u6027\u8d28;%s", taxincludedNo, quantityNo, taxrateNo, priceNo, amountmoneyNo, invoicenature));
        }
        String qString = "0";
        String aString = "0";
        if (StringUtils.isBlank((CharSequence)quantityNo) && StringUtils.isBlank((CharSequence)priceNo)) {
            qString = "1";
        }
        if (StringUtils.isBlank((CharSequence)amountmoneyNo)) {
            aString = "1";
        }
        String flag = taxincludedNo + qString + aString;
        try {
            BigDecimal price = new BigDecimal(StringUtils.isBlank((CharSequence)priceNo) ? "0" : priceNo).setScale(8, 4);
            BigDecimal quantity = new BigDecimal(StringUtils.isBlank((CharSequence)quantityNo) ? "0" : quantityNo).setScale(8, 4);
            BigDecimal taxrate = new BigDecimal(taxrateNo).setScale(4, 4);
            BigDecimal amountmoney = new BigDecimal("0");
            BigDecimal taxamount = new BigDecimal("0");
            Boolean isFlag = Boolean.TRUE;
            if (invoicenature.equals("1")) {
                if (amountmoneyNo.trim().startsWith("-")) {
                    flag = taxincludedNo + "10";
                } else {
                    resultMap.put("errMsg", ResManager.loadKDString((String)"\u6298\u6263\u884c\u7a0e\u989d\u8ba1\u7b97\u51fa\u9519\uff0c\u6570\u636e\u72b6\u6001\u975e\u6cd5\u3002", (String)"InvoiceBatchFileImportUtil_6", (String)"imc-sim-service", (Object[])new Object[0]));
                    isFlag = Boolean.FALSE;
                }
            }
            if (flag.equals("000") || flag.equals("001")) {
                amountmoney = price.multiply(quantity);
                taxamount = amountmoney.multiply(taxrate).setScale(2, 4);
            } else if (flag.equals("010")) {
                amountmoney = new BigDecimal(amountmoneyNo);
                taxamount = amountmoney.multiply(taxrate).setScale(2, 4);
            } else if (flag.equals("100") || flag.equals("101")) {
                BigDecimal money = quantity.multiply(price);
                amountmoney = money.divide(taxrate.add(new BigDecimal("1")), 2, 4);
                taxamount = money.subtract(amountmoney).setScale(2, 4);
            } else if (flag.equals("110")) {
                BigDecimal money = new BigDecimal(amountmoneyNo);
                amountmoney = money.divide(taxrate.add(new BigDecimal("1")), 2, 4);
                taxamount = money.subtract(amountmoney).setScale(2, 4);
            } else {
                resultMap.put("errMsg", ResManager.loadKDString((String)"\u7a0e\u989d\u8ba1\u7b97\u51fa\u9519\uff0c\u6570\u636e\u72b6\u6001\u975e\u6cd5\u3002", (String)"InvoiceBatchFileImportUtil_7", (String)"imc-sim-service", (Object[])new Object[0]));
                isFlag = Boolean.FALSE;
            }
            if (isFlag.booleanValue()) {
                resultMap.put("errCode", "0000");
                resultMap.put("amount", amountmoney.setScale(2, 4));
                resultMap.put("tax", taxamount);
            }
        }
        catch (Exception e) {
            resultMap.put("errMsg", ResManager.loadKDString((String)"\u7a0e\u989d\u8ba1\u7b97\u51fa\u9519\uff0c\u6570\u636e\u72b6\u6001\u975e\u6cd5\u3002", (String)"InvoiceBatchFileImportUtil_7", (String)"imc-sim-service", (Object[])new Object[0]));
            LOGGER.error("\u7a0e\u989d\u8ba1\u7b97\u51fa\u9519\uff1a", (Throwable)e);
        }
        return resultMap;
    }

    public static Boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Map<String, Map<String, String>> queryTaxNumber() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        String field = "id,taxcode.number,specifications,price,unit,taxrate,privilegeflag,privilegetype";
        QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)RequestContext.get().getOrgId());
        DynamicObject[] goodsInfo = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)field, (QFilter[])new QFilter[]{orgFilter});
        if (goodsInfo.length > 0) {
            for (DynamicObject object : goodsInfo) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("id", object.getString("id"));
                map.put("goodscode", object.getString("taxcode.mergecode"));
                map.put("specification", object.getString("specifications"));
                map.put("unitprice", object.getString("price"));
                map.put("unit", object.getString("unit"));
                map.put("taxrate", object.getString("taxrate"));
                map.put("taxpremark", object.getString("privilegeflag"));
                map.put("zzstsgl", object.getString("privilegetype"));
                map.put("success", "0");
                result.put(object.getString("taxcode.mergecode"), map);
            }
        }
        return result;
    }

    public static void setErrorMessage(Row row, Integer rowIndex, Map<String, String> errMap, Map<String, FileField> fieldMap, String errMsg, String field) {
        Integer numCell = fieldMap.get(field).getColIndex() - 1;
        ExcelHelper.setCellErrorComment((Cell)row.getCell(numCell.intValue()), (String)errMsg, (Row)row, (int)numCell);
        String prefixRow = rowIndex + 1 < 10 ? "0" : "";
        errMap.put(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s\u884c%3$s\u5217", (String)"InvoiceBatchFileImportUtil_8", (String)"imc-sim-service", (Object[])new Object[0]), prefixRow, rowIndex + 1, ExcelHelper.excelColIndexToStr((int)(numCell + 1))), errMsg);
    }

    public static void setBaseErrorMessage(Row row, FileField field, Map<String, String> errMap, String errMsg) {
        int index = field.getColIndex() - 1;
        String prefix = row.getRowNum() < 9 ? "0" : "";
        ExcelHelper.setCellErrorComment((Cell)row.getCell(index), (String)errMsg, (Row)row, (int)index);
        errMap.put(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s\u884c%3$s\u5217", (String)"InvoiceBatchFileImportUtil_8", (String)"imc-sim-service", (Object[])new Object[0]), prefix, row.getRowNum() + 1, ExcelHelper.excelColIndexToStr((int)(index + 1))), errMsg);
    }
}

