/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.check.CheckInvoiceResponse;
import kd.imc.bdm.lqpt.model.response.check.CheckResponse;
import kd.imc.bdm.lqpt.service.InvoiceNoService;
import kd.imc.sim.async.LqAsyncIssueHandlerImpl;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceRequestDTO;
import kd.imc.sim.common.dto.allele.AllEleUpdateInvoiceStatusRequestDTO;
import kd.imc.sim.common.dto.allele.AlleQueryIssuedResponseDTO;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.RimLqptQueryHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import org.apache.commons.lang.StringUtils;

public class WaitInvoiceControl {
    private static final Log LOG = LogFactory.getLog(WaitInvoiceControl.class);
    public static final String checkAllEIssueField = String.join((CharSequence)",", "id", "orderno", "thirdserialno", "issuestatus", "invoicecode", "invoiceno", "result", "salertaxno", "jqbh", "invoicetype", "iselepaper", "govorderno", "systemsource", "buyertype", "issuesource", "orgid", "totalamount", "invoiceamount", "totaltax", "billno", "account", "issuebillstatus", "mergelable", "issuetype", "createtime", "originalinvoicecode", "originalinvoiceno", "buyertaxno", "issuetime", "infocode");

    public DynamicObject[] checkOrg(AbstractFormPlugin plugin, ListSelectedRowCollection selectedRowCollection, ImcPermItemEnum perm) {
        if (selectedRowCollection.size() == 0) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"WaitInvoiceControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return null;
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)checkAllEIssueField, (QFilter[])new QFilter("id", "in", (Object)selectedRowCollection.getPrimaryKeyValues()).toArray());
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)perm, (DynamicObject[])invoices);
        boolean alleCount = false;
        boolean taxControlCount = false;
        HashSet<String> jqbhSet = new HashSet<String>(invoices.length);
        for (DynamicObject invoice : invoices) {
            Object invoiceType = invoice.get("invoicetype");
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                alleCount = true;
                continue;
            }
            taxControlCount = true;
            jqbhSet.add(invoice.getString("jqbh"));
        }
        if (jqbhSet.size() > 1) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u540c\u8bbe\u5907\u5f00\u7968\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u56de\u9000/\u5220\u9664\uff01", (String)"WaitInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return null;
        }
        if (alleCount && taxControlCount) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u4e0e\u7a0e\u63a7\u7968\u4e0d\u5141\u8bb8\u540c\u65f6\u56de\u9000/\u5220\u9664\uff01", (String)"WaitInvoiceControl_17", (String)"imc-sim-service", (Object[])new Object[0]));
            return null;
        }
        return invoices;
    }

    public List<JSONObject> getIssuedInvoiceList(DynamicObject[] invoices) {
        boolean isComponentDevice;
        DynamicObject equipment;
        String jqbh;
        ArrayList<JSONObject> issuedInvoiceList = new ArrayList<JSONObject>();
        String equipmentType = "";
        if (!InvoiceUtils.isAllEInvoice((Object)invoices[0].getString("invoicetype")) && StringUtils.isNotBlank((String)(jqbh = invoices[0].getString("jqbh"))) && (equipment = QueryServiceHelper.queryOne((String)"bdm_tax_equipment", (String)"equipmenttype", (QFilter[])new QFilter("equipmentno", "=", (Object)jqbh).and("disen", "=", (Object)"1").toArray())) != null && (isComponentDevice = EquipmentHelper.isComponentDevice((String)(equipmentType = equipment.getString("equipmenttype")))) && !EquipmentHelper.isDevOnline((String)jqbh).booleanValue()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7a0e\u76d8\u3010%s\u3011\u7684\u4fe1\u606f\uff0c\u65e0\u6cd5\u6821\u9a8c\uff0c\u8bf7\u5148\u8fde\u63a5\u7a0e\u76d8\uff0c\u5e76\u542f\u52a8\u5f00\u7968\u7ec4\u4ef6\u3002", (String)"WaitInvoiceControl_2", (String)"imc-sim-service", (Object[])new Object[0]), invoices[0].getString("jqbh")));
        }
        JSONArray invoiceJsonArray = this.checkInvoiceIsIssue(equipmentType, (DynamicObject[])Stream.of(invoices).filter(invoice -> IssueStatusEnum.failed.getCode().equals(invoice.getString("issuestatus"))).toArray(DynamicObject[]::new));
        for (Object invoiceJsonObj : invoiceJsonArray) {
            JSONObject invoiceJson = (JSONObject)invoiceJsonObj;
            if (!StringUtils.isNotBlank((String)invoiceJson.getString("fphm"))) continue;
            issuedInvoiceList.add(invoiceJson);
        }
        return issuedInvoiceList;
    }

    private JSONArray checkInvoiceIsIssue(String equipmentType, DynamicObject[] invoices) {
        if (invoices.length == 0) {
            return new JSONArray();
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoices[0].getString("invoicetype"))) {
            return this.checkAllEInvoiceIssue(invoices);
        }
        if (EquipmentHelper.isComponentDevice((String)equipmentType)) {
            return this.checkComponentInvoiceIssue(invoices);
        }
        if (EquipmentType.isLyServer((String)equipmentType)) {
            return this.checkLyInvoiceIssue(invoices);
        }
        return new JSONArray();
    }

    public JSONArray checkAllEInvoiceIssue(DynamicObject[] invoices) {
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject invoice : invoices) {
            boolean isLqpt = StringUtils.isBlank((String)invoice.getString("issuesource")) ? EnterpriseHelper.isLqptChannel((String)invoice.getString("salertaxno")) : "13".equals(invoice.getString("issuesource"));
            if (isLqpt) {
                this.checkLqInvoiceRollback(invoice, jsonArray);
                continue;
            }
            String orderNo = invoice.getString("orderno");
            AllEleQueryInvoiceRequestDTO request = new AllEleQueryInvoiceRequestDTO();
            request.setSerialNo(orderNo);
            request.setAccount(invoice.getString("account"));
            request.setRequest_path(AllEleInterfaceTypeEnum.QUERY_INVOICE_BY_ORDERNO.getRequestPath());
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)invoice.getString("salertaxno"), (AllEleRequestDTO)request, AllEleUpdateInvoiceStatusRequestDTO.class);
            if (response.getSuccess().booleanValue()) {
                AllEleUpdateInvoiceStatusRequestDTO data = (AllEleUpdateInvoiceStatusRequestDTO)response.getData();
                request.setRequest_path(AllEleInterfaceTypeEnum.ISSUE_INVOICE_QUERY.getRequestPath());
                if (data == null) {
                    if (this.checkInvoiceCanRevoke(request, invoice.getString("salertaxno"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u6b63\u5728\u5f00\u7968\u4e2d\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a:[%s]", (String)"WaitInvoiceControl_3", (String)"imc-sim-service", (Object[])new Object[0]), orderNo));
                }
                if (data.getStatus() == 6) continue;
                if (StringUtils.isNotBlank((String)data.getInvoiceNo())) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("fplsh", (Object)orderNo);
                    jsonObject.put("fphm", (Object)data.getInvoiceNo());
                    jsonArray.add((Object)jsonObject);
                    continue;
                }
                if (this.checkInvoiceCanRevoke(request, invoice.getString("salertaxno"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u6b63\u5728\u5f00\u7968\u4e2d\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a:[%s]", (String)"WaitInvoiceControl_3", (String)"imc-sim-service", (Object[])new Object[0]), orderNo));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f[%1$s]\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a:[%2$s]", (String)"WaitInvoiceControl_4", (String)"imc-sim-service", (Object[])new Object[0]), response.getDescription(), orderNo));
        }
        return jsonArray;
    }

    private boolean checkInvoiceCanRevoke(AllEleQueryInvoiceRequestDTO request, String taxNo) {
        AlleQueryIssuedResponseDTO data;
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)request, AlleQueryIssuedResponseDTO.class);
        if (response.getSuccess().booleanValue() && (data = (AlleQueryIssuedResponseDTO)response.getData()) != null) {
            return data.isResetFlag();
        }
        return false;
    }

    private void checkLqInvoiceRollback(DynamicObject invoice, JSONArray jsonArray) {
        String invoiceNo = invoice.getString("invoiceno");
        if (StringUtils.isBlank((String)invoiceNo)) {
            return;
        }
        LOG.info(String.format("\u53d1\u7968\u53f7\u7801[%s]\uff0c\u6d41\u6c34\u53f7[%s]\u5f00\u59cb\u8c03\u7528\u4e50\u4f01\u67e5\u9a8c\u80fd\u529b\u6821\u9a8c\u6570\u7535\u7968\u662f\u5426\u5f00\u5177\u6210\u529f", invoiceNo, invoice.getString("orderno")));
        LqptResponse lqptResponse = new RimLqptQueryHelper().allEInvoiceInspection(invoice);
        CheckResponse checkResponse = (CheckResponse)lqptResponse.getData();
        if (checkResponse == null) {
            jsonArray.add((Object)this.createRollbackJson(invoice, lqptResponse.getDescription()));
            return;
        }
        CheckInvoiceResponse checkInvoice = checkResponse.getInvoice();
        if (checkInvoice == null) {
            if ("02".equals(checkResponse.getReturncode())) {
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801[%s]\uff0c\u6d41\u6c34\u53f7[%s]\u8c03\u7528\u4e50\u4f01\u67e5\u9a8c\u80fd\u529b\u67e5\u65e0\u6570\u636e\uff0c\u5141\u8bb8\u56de\u9000", invoiceNo, invoice.getString("orderno")));
                new InvoiceNoService().sendBack(invoice.getString("salertaxno"), invoiceNo);
            } else {
                jsonArray.add((Object)this.createRollbackJson(invoice, checkResponse.getReturnmsg()));
            }
            return;
        }
        String compareMsg = new LqAsyncIssueHandlerImpl().compareInvoice(invoice.get("id"), checkInvoice);
        jsonArray.add((Object)this.createRollbackJson(invoice, compareMsg));
    }

    private JSONObject createRollbackJson(DynamicObject invoice, String description) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fplsh", (Object)invoice.getString("orderno"));
        jsonObject.put("fphm", (Object)invoice.getString("invoiceno"));
        jsonObject.put("type", (Object)"leqi");
        jsonObject.put("description", (Object)description);
        return jsonObject;
    }

    private JSONArray checkComponentInvoiceIssue(DynamicObject[] invoices) {
        JSONArray returnData = new JSONArray();
        Map<String, List<DynamicObject>> jqbhGroup = Stream.of(invoices).collect(Collectors.groupingBy(invoice -> invoice.getString("jqbh")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = jqbhGroup.entrySet();
        JSONObject requestJson = new JSONObject();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            requestJson.put("czlx", (Object)"505");
            requestJson.put("hxbzdh", (Object)"");
            JSONArray jsonArray = new JSONArray();
            List<DynamicObject> invoiceList = entry.getValue();
            for (DynamicObject invoice2 : invoiceList) {
                JSONObject json = new JSONObject();
                json.put("fplsh", (Object)invoice2.getString("orderno"));
                jsonArray.add((Object)json);
            }
            requestJson.put("data", (Object)jsonArray);
            JSONObject responseJson = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)entry.getKey()), (String)requestJson.toJSONString());
            String errcode = responseJson.getString("errcode");
            if ("0000".equals(errcode) || "0".equals(errcode) || "0001".equals(errcode)) {
                JSONArray array = responseJson.getJSONArray("data");
                returnData.addAll((Collection)array);
                continue;
            }
            throw new KDBizException(responseJson.getString("description"));
        }
        return returnData;
    }

    private JSONArray checkLyInvoiceIssue(DynamicObject[] invoices) {
        JSONArray returnData = new JSONArray();
        for (DynamicObject invoice : invoices) {
            JSONObject invoiceJson = LyServerInvoiceHelper.getInvoiceByOrderNo((DynamicObject)invoice);
            if (CollectionUtils.isEmpty((Map)invoiceJson)) continue;
            returnData.add((Object)invoiceJson);
        }
        return returnData;
    }

    public void submitIssueMQ(AbstractFormPlugin plugin, String cacheKey) {
        String issuedOrderNos = plugin.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((String)issuedOrderNos)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u5f53\u524d\u63d0\u4ea4\u5df2\u5f00\u7968\u6570\u636e\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\uff1a[%s]", issuedOrderNos));
            }
            plugin.getPageCache().remove(cacheKey);
            QFilter qFilter = new QFilter("orderno", "in", (Object)issuedOrderNos.split(","));
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)IssueInvoiceMqHelper.submitMqField, (QFilter[])qFilter.toArray());
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invoices);
        }
    }

    public void deleteWaitInvoice(AbstractListPlugin plugin) {
        BillList list = (BillList)plugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        DynamicObject[] waitInvoiceList = this.checkOrg((AbstractFormPlugin)plugin, selectedRows, ImcPermItemEnum.ITEM_DELETE);
        if (waitInvoiceList == null) {
            return;
        }
        ArrayList<DynamicObject> failDeleteList = new ArrayList<DynamicObject>(waitInvoiceList.length);
        ArrayList<Object> needDeleteList = new ArrayList<Object>(waitInvoiceList.length);
        for (DynamicObject waitInvoice : waitInvoiceList) {
            String issueStatus = waitInvoice.getString("issuestatus");
            String buyerType = waitInvoice.getString("buyertype");
            if (IssueStatusEnum.ok.getCode().equals(issueStatus) || IssueStatusEnum.underway.getCode().equals(issueStatus) || IssueStatusEnum.submit.getCode().equals(issueStatus) || IssueStatusEnum.timeout.getCode().equals(issueStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s%2$s,\u4e0d\u5141\u8bb8\u5220\u9664", (String)"WaitInvoiceControl_5", (String)"imc-sim-service", (Object[])new Object[0]), waitInvoice.getString("billno"), IssueStatusEnum.getName((String)waitInvoice.getString("issuestatus"))));
            }
            if ("4".equals(buyerType) || "11".equals(buyerType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s \u5df2\u5173\u8054\u5f00\u7968\u7533\u8bf7\u5355,\u4e0d\u5141\u8bb8\u5220\u9664", (String)"WaitInvoiceControl_6", (String)"imc-sim-service", (Object[])new Object[0]), waitInvoice.getString("billno")));
            }
            if ("12".equals(buyerType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s \u4e3a\u5c0f\u7968\u7801\u5f00\u7968,\u4e0d\u5141\u8bb8\u5220\u9664", (String)"WaitInvoiceControl_7", (String)"imc-sim-service", (Object[])new Object[0]), waitInvoice.getString("billno")));
            }
            if ("B".equals(waitInvoice.getString("issuebillstatus")) || "C".equals(waitInvoice.getString("issuebillstatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s \u5f00\u7968\u5ba1\u6279\u72b6\u6001\u662f\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u7684,\u4e0d\u5141\u8bb8\u5220\u9664", (String)"WaitInvoiceControl_8", (String)"imc-sim-service", (Object[])new Object[0]), waitInvoice.getString("billno")));
            }
            if (BotpHelper.isSrcCancelRedMarked((DynamicObject)waitInvoice)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s \u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u7ecf\u88ab\u51b2\u9500,\u4e0d\u5141\u8bb8\u5220\u9664", (String)"WaitInvoiceControl_9", (String)"imc-sim-service", (Object[])new Object[0]), waitInvoice.getString("billno")));
            }
            if (IssueStatusEnum.failed.getCode().equals(issueStatus)) {
                failDeleteList.add(waitInvoice);
                continue;
            }
            needDeleteList.add(waitInvoice.getPkValue());
        }
        boolean deleteSingle = false;
        if (!failDeleteList.isEmpty()) {
            List<JSONObject> issuedInvoiceList = this.getIssuedInvoiceList(failDeleteList.toArray(new DynamicObject[0]));
            if (CollectionUtils.isEmpty(issuedInvoiceList)) {
                Object[] failDeletePks = failDeleteList.stream().map(DataEntityBase::getPkValue).toArray();
                LOG.info(String.format("\u5355\u5f20\u5f00\u7968\u5f85\u5f00\uff0c\u6267\u884c\u5220\u9664\uff1a%s", failDeletePks));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])failDeletePks);
                plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"WaitInvoiceControl_10", (String)"imc-sim-service", (Object[])new Object[0]));
            } else {
                for (JSONObject jsonObject : issuedInvoiceList) {
                    if (!"leqi".equals(jsonObject.getString("type"))) continue;
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s\u5df2\u4e50\u4f01\u9884\u8d4b\u7801\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5f00\u7968", (String)"WaitInvoiceControl_19", (String)"imc-sim-service", (Object[])new Object[0]), jsonObject.getString("fphm")));
                    return;
                }
                ArrayList<String> showContent = new ArrayList<String>(issuedInvoiceList.size());
                ArrayList<String> showRedContent = new ArrayList<String>(issuedInvoiceList.size());
                ArrayList<String> issuedOrderNo = new ArrayList<String>(issuedInvoiceList.size());
                HashMap<String, JSONObject> redMap = new HashMap<String, JSONObject>();
                for (JSONObject invoiceJson : issuedInvoiceList) {
                    issuedOrderNo.add(invoiceJson.getString("fplsh"));
                    String description = invoiceJson.getString("description");
                    if (StringUtils.isNotBlank((String)description)) {
                        showContent.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s\uff0c\u53d1\u7968\u53f7\u7801%3$s\uff0c\u5220\u9664\u5f02\u5e38\u4fe1\u606f[%4$s]\uff1b", (String)"WaitInvoiceControl_18", (String)"imc-sim-service", (Object[])new Object[0]), invoiceJson.getString("fplsh"), invoiceJson.getString("fpdm"), invoiceJson.getString("fphm"), description));
                    } else {
                        showContent.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7%1$s\u5b58\u5728\u5df2\u5f00\u53d1\u7968\uff0c\u53d1\u7968\u4ee3\u7801%2$s\uff0c\u53d1\u7968\u53f7\u7801%3$s\uff1b", (String)"WaitInvoiceControl_11", (String)"imc-sim-service", (Object[])new Object[0]), invoiceJson.getString("fplsh"), invoiceJson.getString("fpdm"), invoiceJson.getString("fphm")));
                    }
                    redMap.put(invoiceJson.getString("fplsh"), invoiceJson);
                }
                plugin.getPageCache().put("issuedInvoiceListDelete", String.join((CharSequence)",", issuedOrderNo));
                this.submitIssueMQ((AbstractFormPlugin)plugin, "issuedInvoiceListDelete");
                boolean hasBlue = false;
                for (DynamicObject dynamicObject : failDeleteList) {
                    if (IssueType.BLUE_INVOICE.getTypeCode().equals(dynamicObject.getString("issuetype"))) {
                        hasBlue = true;
                        continue;
                    }
                    JSONObject invoiceJson = (JSONObject)redMap.get(dynamicObject.getString("orderno"));
                    showRedContent.add(String.format(ResManager.loadKDString((String)"\u84dd\u7968\u53d1\u7968\u53f7\u7801\u3010%1$s\u3011\uff1a\u53d1\u7968\u5df2\u88ab\u7ea2\u51b2\uff0c\u7ea2\u7968\u53f7\u7801\u3010%2$s\u3011\uff1b", (String)"WaitInvoiceControl_12", (String)"imc-sim-service", (Object[])new Object[0]), dynamicObject.getString("originalinvoiceno"), invoiceJson.getString("fphm")));
                }
                if (hasBlue) {
                    ViewUtil.openConfirm((String)"issuedInvoiceListDelete", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u5df2\u5f00\u51fa\uff0c\u60a8\u53ef\u8fdb\u5165\u9500\u9879\u5168\u7968\u6c60->\u53d1\u7968\u67e5\u8be2\u9875\u9762\u67e5\u770b\u3002", (String)"WaitInvoiceControl_13", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WaitInvoiceControl_14", (String)"imc-sim-service", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"WaitInvoiceControl_15", (String)"imc-sim-service", (Object[])new Object[0]), (String)showContent.stream().collect(Collectors.joining(System.lineSeparator())));
                } else {
                    ViewUtil.openConfirm((String)"issuedInvoiceListDelete", (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u5df2\u88ab\u7ea2\u51b2\uff0c\u672c\u6b21\u5c06\u81ea\u52a8\u66f4\u65b0\u539f\u84dd\u7968\u72b6\u6001\uff0c\u4fdd\u5b58\u7ea2\u7968\u6570\u636e\u3002\u60a8\u53ef\u8fdb\u5165\u9500\u9879\u5168\u7968\u6c60->\u53d1\u7968\u67e5\u8be2\u9875\u9762\u67e5\u770b\u3002", (String)"WaitInvoiceControl_16", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"WaitInvoiceControl_14", (String)"imc-sim-service", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"WaitInvoiceControl_15", (String)"imc-sim-service", (Object[])new Object[0]), (String)showRedContent.stream().collect(Collectors.joining(System.lineSeparator())));
                }
            }
            deleteSingle = true;
        }
        if (!needDeleteList.isEmpty() && !deleteSingle) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])needDeleteList.toArray());
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"WaitInvoiceControl_10", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public void createAllEleRequest(Map<String, Object> params, DynamicObject invoice) {
        params.put("orderno", invoice.getString("orderno"));
        params.put("id", invoice.getPkValue());
        params.put("salertaxno", invoice.get("salertaxno"));
        params.put("invoicetype", invoice.get("invoicetype"));
        params.put("buyertaxno", invoice.get("buyertaxno"));
        params.put("invoiceamount", invoice.get("invoiceamount"));
        params.put("totaltax", invoice.get("totaltax"));
        params.put("totalamount", invoice.get("totalamount"));
        params.put("result", invoice.get("result"));
        Date issueTime = invoice.getDate("issuetime");
        if (issueTime == null) {
            issueTime = invoice.getDate("createtime");
        }
        params.put("issuetime", DateUtils.format((Date)issueTime));
    }
}

