/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.dto.allelespecial.BillBuildInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillTravlerInfoVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceItemDTO;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceResponseDTO;
import kd.imc.sim.common.dto.allele.AllVehicleBillResponseDTO;
import kd.imc.sim.common.dto.allele.UsedCarFullInvoiceResponseDTO;
import kd.imc.sim.common.dto.allele.VehicleInvoiceResponseDTO;
import kd.imc.sim.common.dto.syncinvoice.SyncQueryInvoiceDTO;
import kd.imc.sim.common.enums.SeatClassTypeEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.InvalidInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.service.ImcPushInvoiceToIsmcService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncResponseControl;
import org.apache.commons.lang3.StringUtils;

public class InvoiceSyncControl {
    public static final String PAGE_CACHE_SYNC_PROGRESS = "pageCacheSyncProgress";
    public static final String PAGE_CACHE_SYNC_MSG = "pageCacheSyncMsg";
    private static final Log LOGGER = LogFactory.getLog(InvoiceSyncControl.class);

    public static String codeSync(String devno, String terminalNo, String invoicecode, String invoiceno, String invoicetype, long orgId) {
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        DynamicObject equipment = EquipmentUtil.getCommonEquipment((String)devno, (String)saleInfo.getSaleTaxNo(), (String)terminalNo);
        if (equipment != null) {
            String equipmentType = equipment.getString("equipmenttype");
            if ("8".equals(equipmentType)) {
                if ("-1".equals(invoicetype)) {
                    return ResManager.loadKDString((String)"\u767e\u671b\u670d\u52a1\u5668\u8bbe\u5907\u5fc5\u987b\u9009\u62e9\u5177\u4f53\u7684\u53d1\u7968\u7c7b\u578b", (String)"InvoiceSyncControl_0", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                JSONObject invoiceJson = InvoiceSyncControl.setRequestParam(devno, terminalNo, invoicecode, invoiceno, invoicetype, saleInfo);
                MsgResponse msgResponse = BwServerInvoiceHelper.getInvoice((JSONObject)invoiceJson);
                if (msgResponse != null && ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    JSONArray invoiceArr = JSONObject.parseArray((String)msgResponse.getRespData());
                    return InvoiceSyncControl.bwSingleResponse(invoicetype, invoiceArr, orgId);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u53d1\u7968\u540c\u6b65\u5931\u8d25, \u8fd4\u56de\u63cf\u8ff0:[%s]", msgResponse == null ? "\u8bf7\u6c42\u5931\u8d25" : msgResponse.getErrorMsg()));
                }
                if (msgResponse == null) {
                    return ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u5931\u8d25:\u8bf7\u6c42\u5931\u8d25", (String)"InvoiceSyncControl_1", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                return String.format(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u5931\u8d25:%1$s", (String)"InvoiceSyncControl_2", (String)"imc-sim-service", (Object[])new Object[0]), msgResponse.getErrorMsg());
            }
            if (EquipmentType.isLyServer((String)equipmentType)) {
                if ("-1".equals(invoicetype)) {
                    return ResManager.loadKDString((String)"\u8054\u4e91\u6258\u7ba1\u8bbe\u5907\u5fc5\u987b\u9009\u62e9\u5177\u4f53\u7684\u53d1\u7968\u7c7b\u578b", (String)"InvoiceSyncControl_3", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                JSONObject invoiceJson = InvoiceSyncControl.setRequestParam(devno, terminalNo, invoicecode, invoiceno, invoicetype, saleInfo);
                MsgResponse msgResponse = LyServerInvoiceHelper.getInvoice((JSONObject)invoiceJson);
                JSONArray invoiceArr = JSONObject.parseArray((String)msgResponse.getRespData());
                return InvoiceSyncResponseControl.singleResponse(invoiceArr, orgId);
            }
            if (EquipmentHelper.isComponentDevice((String)equipmentType)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("czlx", (Object)"5");
                jsonObject.put("hxbzdh", (Object)(StringUtils.isEmpty((CharSequence)terminalNo) ? "" : terminalNo));
                JSONObject dataObject = new JSONObject();
                dataObject.put("kpzl", (Object)invoicetype);
                dataObject.put("fpdm", (Object)invoicecode);
                dataObject.put("fphm", (Object)invoiceno);
                jsonObject.put("sjd", (Object)dataObject);
                JSONObject responseJson = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)devno), (String)JSONObject.toJSONString((Object)jsonObject));
                return InvoiceSyncControl.singleResponse(devno, invoicecode, invoiceno, responseJson, orgId);
            }
            return String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7c7b\u578b%1$s\u8bbe\u5907\u7f16\u53f7%2$s\u6682\u4e0d\u652f\u6301\u53d1\u7968\u540c\u6b65", (String)"InvoiceSyncControl_4", (String)"imc-sim-service", (Object[])new Object[0]), EquipmentType.EQUIPMENT_MAP.get(equipmentType), devno);
        }
        return String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7:%1$s\u4e0d\u5b58\u5728\uff0c\u540c\u6b65\u53d1\u7968\u5931\u8d25", (String)"InvoiceSyncControl_5", (String)"imc-sim-service", (Object[])new Object[0]), devno);
    }

    private static JSONObject setRequestParam(String devno, String terminalNo, String invoicecode, String invoiceno, String invoicetype, SaleInfo saleInfo) {
        JSONObject invoiceJson = new JSONObject();
        invoiceJson.put("terminalno", (Object)terminalNo);
        invoiceJson.put("invoicetype", (Object)InvoiceSyncControl.transType(invoicetype));
        invoiceJson.put("invoicecode", (Object)invoicecode);
        invoiceJson.put("invoiceno", (Object)invoiceno);
        invoiceJson.put("salertaxno", (Object)saleInfo.getSaleTaxNo());
        invoiceJson.put("jqbh", (Object)devno);
        return invoiceJson;
    }

    public static String bwSingleResponse(String invoiceType, JSONArray invoiceArr, long orgId) {
        if (invoiceArr != null) {
            for (int i = 0; i < invoiceArr.size(); ++i) {
                JSONObject resultObj = invoiceArr.getJSONObject(i);
                if (resultObj == null) continue;
                QFilter filter = new QFilter("invoicecode", "=", (Object)resultObj.getString("fpdm"));
                filter.and("invoiceno", "=", (Object)resultObj.getString("fphm"));
                DynamicObject vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
                boolean invoiceExist = false;
                if (vatObj != null) {
                    invoiceExist = true;
                } else if (!StringUtils.isEmpty((CharSequence)resultObj.getString("ddh"))) {
                    QFilter filter2 = new QFilter("thirdserialno", "=", (Object)resultObj.getString("ddh"));
                    vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter2.toArray());
                    if (vatObj != null) {
                        invoiceExist = true;
                    }
                }
                if (invoiceExist) {
                    InvoiceSyncControl.invoiceExistBw(resultObj, vatObj);
                } else {
                    vatObj = InvoiceSyncControl.transBwObj(invoiceType, resultObj);
                    vatObj.set("billno", (Object)("300_" + UUID.getBatchNumber() + "_0001"));
                    vatObj.set("issuesource", (Object)DeviceUtil.getDevType((String)resultObj.getString("jqbh")));
                    vatObj.set("jqbh", (Object)resultObj.getString("jqbh"));
                    vatObj.set("orgid", (Object)orgId);
                    vatObj.set("ofdstatus", (Object)"0");
                    IssueInvoiceService.updateDiscountInfo((DynamicObject)vatObj);
                }
                vatObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
                IssueInvoiceService.updateBaseInvoiceType((DynamicObject)vatObj);
                DynamicObject saveObj = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)vatObj);
                if (!invoiceExist) {
                    WideInvoiceSevice.addInvoiceToWide((DynamicObject)saveObj);
                }
                InvoiceSyncControl.afterSaveInvoice(invoiceExist, vatObj);
            }
        }
        return ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f", (String)"InvoiceSyncControl_6", (String)"imc-sim-service", (Object[])new Object[0]);
    }

    public static String singleResponse(String devno, String invoicecode, String invoiceno, JSONObject responseJson, long orgId) {
        String errCode = responseJson.getString("errcode");
        String description = responseJson.getString("description");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5355\u5f20\u53d1\u7968\u540c\u6b65\u54cd\u5e94\u72b6\u6001\uff1a" + errCode + "," + description);
        }
        if ("7011".equals(errCode)) {
            JSONObject resultObj = responseJson.getJSONObject("sjd");
            if (resultObj != null) {
                QFilter filter = new QFilter("invoicecode", "=", (Object)invoicecode);
                filter.and("invoiceno", "=", (Object)invoiceno);
                DynamicObject vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
                boolean invoiceExist = false;
                if (vatObj == null) {
                    LOGGER.info("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u5355\u5f20\u540c\u6b65\uff0c" + resultObj.getString("ddh"));
                    if (!StringUtils.isEmpty((CharSequence)resultObj.getString("ddh"))) {
                        QFilter filter2 = new QFilter("orderno", "=", (Object)resultObj.getString("ddh"));
                        vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter2.toArray());
                        if (vatObj != null) {
                            invoiceExist = true;
                        }
                    }
                } else {
                    invoiceExist = true;
                }
                if (invoiceExist) {
                    InvoiceSyncControl.invoiceExist(resultObj, vatObj);
                } else {
                    vatObj = InvoiceSyncControl.transObj(resultObj);
                    vatObj.set("billno", (Object)("300_" + UUID.getBatchNumber() + "_0001"));
                    vatObj.set("issuesource", (Object)DeviceUtil.getDevType((String)devno));
                    vatObj.set("jqbh", (Object)devno);
                    vatObj.set("orgid", (Object)orgId);
                    vatObj.set("ofdstatus", (Object)"0");
                    InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)vatObj);
                    IssueInvoiceService.updateDiscountInfo((DynamicObject)vatObj);
                }
                InvoiceSyncControl.updateOriginInvoiceCodeByRemark(vatObj);
                vatObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
                IssueInvoiceService.updateBaseInvoiceType((DynamicObject)vatObj);
                DynamicObject savedObj = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)vatObj);
                if (!invoiceExist) {
                    WideInvoiceSevice.addInvoiceToWide((DynamicObject)savedObj);
                }
                DynamicObject finalVatObj = vatObj;
                InvoiceSyncControl.afterSaveInvoice(invoiceExist, finalVatObj);
            }
            return ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f", (String)"InvoiceSyncControl_6", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u5931\u8d25%1$s", (String)"InvoiceSyncControl_7", (String)"imc-sim-service", (Object[])new Object[0]), description);
    }

    public static void afterSaveInvoice(boolean invoiceExist, DynamicObject finalVatObj) {
        if (!invoiceExist) {
            ThreadPools.executeOnceIncludeRequestContext((String)"invoice_query_handleHyperLinkClick", () -> ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest((DynamicObject)finalVatObj, (boolean)true));
        } else {
            RequestContext requestContext = RequestContext.get();
            ThreadPools.executeOnceIncludeRequestContext((String)"exists_invoice_write_back_single", () -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                IssuedInvoiceWriteBackHelper.writeBackIssueAmount2OriginBill((DynamicObject)finalVatObj);
                IssueInvoiceService.invokeRimSaveInvoice((DynamicObject)finalVatObj);
                IssueInvoiceService.syncInvoiceCallback((DynamicObject)finalVatObj);
            });
        }
    }

    public static void invoiceExist(JSONObject resultObj, DynamicObject vatObj) {
        String hjbhsje;
        String zfbz = resultObj.getString("zfbz");
        if (!"0".equals(zfbz)) {
            vatObj.set("invoicestatus", (Object)"6");
        } else if (StringUtils.isBlank((CharSequence)vatObj.getString("invoicestatus")) || "7".equals(vatObj.getString("invoicestatus"))) {
            vatObj.set("invoicestatus", (Object)"0");
        }
        if (StringUtils.isBlank((CharSequence)vatObj.getString("billstatus"))) {
            vatObj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_valid_list", (String)"2"));
        }
        if (StringUtils.isBlank((CharSequence)vatObj.getString("fileurl"))) {
            vatObj.set("fileurl", resultObj.get((Object)"ofd_url"));
        }
        if (StringUtils.isNotBlank((CharSequence)(hjbhsje = resultObj.getString("hjbhsje")))) {
            BigDecimal bhsje = new BigDecimal(hjbhsje);
            if (bhsje.compareTo(BigDecimal.ZERO) < 0) {
                vatObj.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
            } else {
                vatObj.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
            }
        }
        vatObj.set("invoicecode", resultObj.get((Object)"fpdm"));
        vatObj.set("invoiceno", resultObj.get((Object)"fphm"));
        vatObj.set("issuetime", (Object)DateUtils.stringToDate((String)resultObj.getString("kprq"), (String)"yyyy-MM-dd HH:mm:ss"));
        vatObj.set("buyeraddr", resultObj.get((Object)"ghf_dzdh"));
        vatObj.set("buyerbank", resultObj.get((Object)"ghf_yhzh"));
        vatObj.set("remark", resultObj.get((Object)"bz"));
        if (vatObj.get("orgid") == null) {
            LOGGER.info(String.format("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u66f4\u65b0\u7ec4\u7ec7\uff1a%d", RequestContext.get().getOrgId()));
            vatObj.set("orgid", (Object)RequestContext.get().getOrgId());
        }
        vatObj.set("skm", resultObj.get((Object)"secret"));
        vatObj.set("checkcode", resultObj.get((Object)"jym"));
        LOGGER.info(String.format("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u5bc6\u7801\u533a\uff1a%s", resultObj.get((Object)"secret")));
        vatObj.set("result", (Object)"");
    }

    public static void invoiceExistBw(JSONObject resultObj, DynamicObject vatObj) {
        String fpzt = resultObj.getString("fpzt");
        String invoiceStatus = InvoiceSyncControl.castInvoiceStatus(fpzt);
        vatObj.set("invoicestatus", (Object)invoiceStatus);
        String hjje = resultObj.getString("hjje");
        if (StringUtils.isNotBlank((CharSequence)hjje)) {
            BigDecimal bhsje = new BigDecimal(hjje);
            if (bhsje.compareTo(BigDecimal.ZERO) < 0) {
                vatObj.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
            } else {
                vatObj.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
            }
        }
        vatObj.set("invoicecode", resultObj.get((Object)"fpdm"));
        vatObj.set("invoiceno", resultObj.get((Object)"fphm"));
        vatObj.set("issuetime", (Object)DateUtils.stringToDate((String)resultObj.getString("kprq"), (String)"yyyy-MM-dd HH:mm:ss"));
        vatObj.set("buyeraddr", resultObj.get((Object)"ghdwdzdh"));
        vatObj.set("buyerbank", resultObj.get((Object)"ghdwyhzh"));
        vatObj.set("remark", resultObj.get((Object)"bz"));
        if (vatObj.get("orgid") == null) {
            LOGGER.info(String.format("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u66f4\u65b0\u7ec4\u7ec7\uff1a%d", RequestContext.get().getOrgId()));
            vatObj.set("orgid", (Object)RequestContext.get().getOrgId());
        }
        vatObj.set("skm", resultObj.get((Object)"skm"));
        vatObj.set("checkcode", resultObj.get((Object)"jym"));
        LOGGER.info(String.format("\u53d1\u7968\u7a0e\u76d8\u540c\u6b65\uff0c\u5bc6\u7801\u533a\uff1a%s", resultObj.get((Object)"skm")));
        vatObj.set("result", (Object)"");
        if (StringUtils.isBlank((CharSequence)vatObj.getString("billno"))) {
            vatObj.set("billno", (Object)("300_" + UUID.getBatchNumber() + "_0001"));
        }
    }

    private static String castInvoiceStatus(String fpzt) {
        if ("00".equals(fpzt) || "01".equals(fpzt)) {
            return "0";
        }
        if ("02".equals(fpzt) || "03".equals(fpzt) || "04".equals(fpzt)) {
            return "6";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u53d1\u7968\u72b6\u6001\uff0c\u65e0\u6cd5\u8f6c\u6362", (String)"InvoiceSyncControl_8", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    public static DynamicObject transObj(JSONObject resultObj) {
        DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectCollection items = invoiceObj.getDynamicObjectCollection("items");
        invoiceObj.set("buyertype", (Object)"2");
        invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoiceObj.set("invoicecode", resultObj.get((Object)"fpdm"));
        invoiceObj.set("invoiceno", resultObj.get((Object)"fphm"));
        invoiceObj.set("invoicetype", (Object)InvoiceSyncControl.transType(resultObj.getString("kpzl")));
        invoiceObj.set("originalinvoicecode", resultObj.get((Object)"yfpdm"));
        invoiceObj.set("originalinvoiceno", resultObj.get((Object)"yfphm"));
        invoiceObj.set("issuetime", (Object)DateUtils.handleDate((String)resultObj.getString("kprq")));
        invoiceObj.set("invoiceamount", resultObj.get((Object)"hjbhsje"));
        invoiceObj.set("totaltax", resultObj.get((Object)"kphjse"));
        invoiceObj.set("totalamount", (Object)InvoiceSyncControl.addNum(resultObj.getString("hjbhsje"), resultObj.getString("kphjse")));
        invoiceObj.set("remainredamount", (Object)resultObj.getString("hjbhsje"));
        invoiceObj.set("canredtaxamount", (Object)resultObj.getString("kphjse"));
        invoiceObj.set("salername", resultObj.get((Object)"xhf_mc"));
        invoiceObj.set("salertaxno", resultObj.get((Object)"xhf_nsrsbh"));
        invoiceObj.set("saleraddr", resultObj.get((Object)"xhf_dzdh"));
        invoiceObj.set("salerbank", resultObj.get((Object)"xhf_yhzh"));
        invoiceObj.set("buyername", resultObj.get((Object)"ghf_mc"));
        invoiceObj.set("buyertaxno", resultObj.get((Object)"ghf_nsrsbh"));
        invoiceObj.set("buyeraddr", resultObj.get((Object)"ghf_dzdh"));
        invoiceObj.set("buyerbank", resultObj.get((Object)"ghf_yhzh"));
        invoiceObj.set("fileurl", resultObj.get((Object)"ofd_url"));
        invoiceObj.set("remark", (Object)String.valueOf(resultObj.get((Object)"bz")));
        invoiceObj.set("drawer", resultObj.get((Object)"kpy"));
        invoiceObj.set("payee", resultObj.get((Object)"sky"));
        invoiceObj.set("reviewer", resultObj.get((Object)"fhr"));
        invoiceObj.set("createtime", (Object)new Date());
        invoiceObj.set("skm", resultObj.get((Object)"secret"));
        invoiceObj.set("checkcode", resultObj.get((Object)"jym"));
        invoiceObj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_valid_list", (String)"2"));
        String zfbz = resultObj.getString("zfbz");
        if ("0".equals(zfbz)) {
            invoiceObj.set("invoicestatus", (Object)"0");
        } else {
            invoiceObj.set("invoicestatus", (Object)"6");
        }
        String ddh = StringUtils.isBlank((CharSequence)resultObj.getString("ddh")) ? UUID.randomUUID() : resultObj.getString("ddh");
        invoiceObj.set("orderno", (Object)ddh);
        if (invoiceObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            invoiceObj.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        } else {
            invoiceObj.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        }
        invoiceObj.set("taxedtype", (Object)"0");
        invoiceObj.set("hsbz", (Object)"0");
        JSONArray itemArray = resultObj.getJSONArray("items");
        if (null == itemArray && "1".equals(zfbz)) {
            return invoiceObj;
        }
        if (itemArray == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u4e0d\u5b58\u5728", (String)"InvoiceSyncControl_9", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        int normalRowCount = 0;
        for (int i = 0; i < itemArray.size(); ++i) {
            JSONObject itemObj = itemArray.getJSONObject(i);
            String goodsName = String.valueOf(itemObj.get((Object)"xmmc"));
            if (!StringUtils.isEmpty((CharSequence)goodsName) && goodsName.contains("\u5408\u8ba1")) continue;
            DynamicObject itemDynamic = items.addNew();
            itemDynamic.set("specification", itemObj.get((Object)"ggxh"));
            itemDynamic.set("rowtype", itemObj.get((Object)"xmlx"));
            ++normalRowCount;
            itemDynamic.set("goodsname", itemObj.get((Object)"xmmc"));
            itemDynamic.set("unit", itemObj.get((Object)"xmdw"));
            itemDynamic.set("taxrate", itemObj.get((Object)"sl"));
            itemDynamic.set("amount", itemObj.get((Object)"xmje"));
            itemDynamic.set("tax", itemObj.get((Object)"se"));
            BigDecimal hsje = InvoiceSyncControl.addNum(itemObj.getString("xmje"), itemObj.getString("se"));
            itemDynamic.set("taxamount", (Object)hsje);
            itemDynamic.set("unitprice", itemObj.get((Object)"xmdj"));
            itemDynamic.set("taxflag", (Object)"0");
            String xmsl = itemObj.getString("xmsl");
            if (!Strings.isNullOrEmpty((String)xmsl) && !"0".equals(xmsl)) {
                itemDynamic.set("num", (Object)xmsl);
                itemDynamic.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)hsje, (BigDecimal)new BigDecimal(xmsl), (boolean)Boolean.FALSE));
            }
            itemDynamic.set("zerotaxmark", itemObj.getJSONObject("taxcode").get((Object)"lslbs"));
            itemDynamic.set("goodscode", itemObj.getJSONObject("taxcode").get((Object)"ssflbm"));
            itemDynamic.set("taxpremark", itemObj.getJSONObject("taxcode").get((Object)"ssyhzc"));
            itemDynamic.set("zzstsgl", itemObj.getJSONObject("taxcode").get((Object)"ssyhzcnr"));
            itemDynamic.set("seq", (Object)(i + 1));
        }
        if ("2".equals(resultObj.get((Object)"tspz"))) {
            invoiceObj.set("specialtype", (Object)"02");
        } else if ("11".equals(resultObj.get((Object)"tspz"))) {
            invoiceObj.set("specialtype", (Object)"11");
        } else {
            invoiceObj.set("specialtype", (Object)"00");
        }
        if (normalRowCount > 8) {
            invoiceObj.set("inventorymark", (Object)"1");
        } else {
            invoiceObj.set("inventorymark", (Object)"0");
        }
        if (!InvoiceUtils.isEtcInvoice((String)invoiceObj.getString("invoicetype")) && !"1".equals(CacheHelper.get((String)"paperNeedPdf"))) {
            invoiceObj.set("ofdstatus", (Object)"3");
        }
        InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)invoiceObj);
        IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoiceObj);
        return invoiceObj;
    }

    public static DynamicObject transBwObj(String invoiceType, JSONObject resultObj) {
        DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectCollection items = invoiceObj.getDynamicObjectCollection("items");
        invoiceObj.set("buyertype", (Object)"2");
        LOGGER.info("\u53d1\u7968\u767e\u671b\u670d\u52a1\u5668\u540c\u6b65\uff0c\u65b0\u589e\u53d1\u7968\uff0c\u7ec4\u7ec7\uff1a" + RequestContext.get().getOrgId());
        invoiceObj.set("orderno", (Object)UUID.randomUUID());
        invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoiceObj.set("orgid", (Object)RequestContext.get().getOrgId());
        invoiceObj.set("invoicecode", resultObj.get((Object)"fpdm"));
        invoiceObj.set("invoiceno", resultObj.get((Object)"fphm"));
        invoiceObj.set("invoicetype", (Object)InvoiceSyncControl.transType(invoiceType));
        invoiceObj.set("originalinvoicecode", resultObj.get((Object)"yfpdm"));
        invoiceObj.set("originalinvoiceno", resultObj.get((Object)"yfphm"));
        invoiceObj.set("issuetime", (Object)DateUtils.stringToDate((String)resultObj.getString("kprq"), (String)"yyyy-MM-dd HH:mm:ss"));
        invoiceObj.set("invoiceamount", resultObj.get((Object)"hjje"));
        invoiceObj.set("totaltax", resultObj.get((Object)"hjse"));
        invoiceObj.set("totalamount", (Object)InvoiceSyncControl.addNum(resultObj.getString("hjje"), resultObj.getString("hjse")));
        invoiceObj.set("remainredamount", (Object)InvoiceSyncControl.subNum(resultObj.getString("hjje"), resultObj.getString("ykfsje")));
        invoiceObj.set("canredtaxamount", (Object)InvoiceSyncControl.subNum(resultObj.getString("hjse"), InvoiceSyncControl.multNum(resultObj.getString("ykfsje"), resultObj.getString("zhsl")).toString()));
        invoiceObj.set("salername", resultObj.get((Object)"xhdwmc"));
        invoiceObj.set("salertaxno", resultObj.get((Object)"xhdwsbh"));
        invoiceObj.set("saleraddr", resultObj.get((Object)"xhdwdzdh"));
        invoiceObj.set("salerbank", resultObj.get((Object)"xhdwyhzh"));
        invoiceObj.set("buyername", resultObj.get((Object)"ghdwmc"));
        invoiceObj.set("buyertaxno", resultObj.get((Object)"ghdwsbh"));
        invoiceObj.set("buyeraddr", resultObj.get((Object)"ghdwdzdh"));
        invoiceObj.set("buyerbank", resultObj.get((Object)"ghdwyhzh"));
        invoiceObj.set("remark", (Object)String.valueOf(resultObj.get((Object)"bz")));
        invoiceObj.set("drawer", resultObj.get((Object)"kpr"));
        invoiceObj.set("payee", resultObj.get((Object)"skr"));
        invoiceObj.set("reviewer", resultObj.get((Object)"fhr"));
        invoiceObj.set("createtime", (Object)new Date());
        invoiceObj.set("skm", resultObj.get((Object)"skm"));
        invoiceObj.set("checkcode", resultObj.get((Object)"jym"));
        invoiceObj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_valid_list", (String)"2"));
        String fpzt = resultObj.getString("fpzt");
        Boolean zfFlag = Boolean.FALSE;
        if ("00".equals(fpzt)) {
            invoiceObj.set("issuetype", (Object)IssueTypeEnum.blue);
        } else if ("01".equals(fpzt)) {
            invoiceObj.set("issuetype", (Object)IssueTypeEnum.red);
        } else if ("02".equals(fpzt)) {
            zfFlag = Boolean.TRUE;
        } else if ("03".equals(fpzt)) {
            invoiceObj.set("issuetype", (Object)IssueTypeEnum.blue);
            zfFlag = Boolean.TRUE;
        } else if ("04".equals(fpzt)) {
            invoiceObj.set("issuetype", (Object)IssueTypeEnum.red);
            zfFlag = Boolean.TRUE;
        }
        String zfbz = resultObj.getString("zfbz");
        invoiceObj.set("invaliddate", (Object)DateUtils.stringToDate((String)resultObj.getString("zfrq"), (String)"yyyy-MM-dd HH:mm:ss"));
        invoiceObj.set("invalider", (Object)resultObj.getString("zfr"));
        if (zfFlag.booleanValue()) {
            invoiceObj.set("invoicestatus", (Object)"6");
        } else {
            invoiceObj.set("invoicestatus", (Object)"0");
        }
        invoiceObj.set("orderno", (Object)MD5.md5Hex((String)UUID.next()).substring(8, 24));
        if (invoiceObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            invoiceObj.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        } else {
            invoiceObj.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        }
        invoiceObj.set("taxedtype", (Object)resultObj.getString("zsfs"));
        invoiceObj.set("hsbz", (Object)"0");
        JSONArray itemArray = resultObj.getJSONArray("items");
        if (null == itemArray && "1".equals(zfbz)) {
            return invoiceObj;
        }
        if (itemArray == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u4e0d\u5b58\u5728", (String)"InvoiceSyncControl_9", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        int normalRowCount = 0;
        for (int i = 0; i < itemArray.size(); ++i) {
            JSONObject itemObj = itemArray.getJSONObject(i);
            DynamicObject itemDynamic = items.addNew();
            itemDynamic.set("specification", itemObj.get((Object)"ggxh"));
            itemDynamic.set("rowtype", itemObj.get((Object)"fphxz"));
            ++normalRowCount;
            itemDynamic.set("goodsname", itemObj.get((Object)"spmc"));
            itemDynamic.set("unit", itemObj.get((Object)"dw"));
            itemDynamic.set("taxrate", itemObj.get((Object)"sl"));
            itemDynamic.set("amount", itemObj.get((Object)"je"));
            itemDynamic.set("tax", itemObj.get((Object)"se"));
            BigDecimal hsje = InvoiceSyncControl.addNum(itemObj.getString("je"), itemObj.getString("se"));
            itemDynamic.set("taxamount", (Object)hsje);
            itemDynamic.set("unitprice", itemObj.get((Object)"dj"));
            itemDynamic.set("taxflag", itemObj.get((Object)"hsbz"));
            String xmsl = itemObj.getString("spsl");
            if (!Strings.isNullOrEmpty((String)xmsl) && !"0".equals(xmsl)) {
                itemDynamic.set("num", (Object)xmsl);
                itemDynamic.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)hsje, (BigDecimal)new BigDecimal(xmsl), (boolean)Boolean.FALSE));
            }
            itemDynamic.set("zerotaxmark", (Object)itemObj.getString("lslbs"));
            itemDynamic.set("goodscode", (Object)itemObj.getString("spbm"));
            itemDynamic.set("taxpremark", (Object)itemObj.getString("yhzcbs"));
            itemDynamic.set("zzstsgl", (Object)itemObj.getString("zzstsgl"));
            itemDynamic.set("seq", (Object)(i + 1));
        }
        if ("2".equals(resultObj.get((Object)"tspz"))) {
            invoiceObj.set("specialtype", (Object)"02");
        } else if ("11".equals(resultObj.get((Object)"tspz"))) {
            invoiceObj.set("specialtype", (Object)"11");
        } else {
            invoiceObj.set("specialtype", (Object)"00");
        }
        if (normalRowCount > 8) {
            invoiceObj.set("inventorymark", (Object)"1");
        } else {
            invoiceObj.set("inventorymark", (Object)"0");
        }
        if (!InvoiceUtils.isEtcInvoice((String)invoiceObj.getString("invoicetype")) && !"1".equals(CacheHelper.get((String)"paperNeedPdf"))) {
            invoiceObj.set("ofdstatus", (Object)"3");
        }
        InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)invoiceObj);
        IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoiceObj);
        return invoiceObj;
    }

    public static DynamicObject transRpaObj(Long orgId, AllEleFullInvoiceResponseDTO requestBody) {
        DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectCollection items = invoiceObj.getDynamicObjectCollection("items");
        invoiceObj.set("buyertype", (Object)"2");
        LOGGER.info("\u53d1\u7968\u767e\u671b\u670d\u52a1\u5668\u540c\u6b65\uff0c\u65b0\u589e\u53d1\u7968\uff0c\u7ec4\u7ec7\uff1a" + RequestContext.get().getOrgId());
        invoiceObj.set("orderno", (Object)UUID.randomUUID());
        invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoiceObj.set("orgid", (Object)orgId);
        invoiceObj.set("invoicecode", (Object)StringUtils.trimToEmpty((String)requestBody.getInvoiceCode()));
        invoiceObj.set("invoiceno", (Object)requestBody.getInvoiceNo());
        invoiceObj.set("alletaxinvoiceno", (Object)requestBody.getEtaxInvoiceNo());
        invoiceObj.set("invoicetype", (Object)(StringUtils.isEmpty((CharSequence)requestBody.getInvoiceType()) ? requestBody.getInvoiceType() : InvoiceType.getTypeCodeByBase((String)requestBody.getInvoiceType())));
        invoiceObj.set("issuetime", (Object)DateUtils.handleDate((String)requestBody.getInvoiceDate()));
        invoiceObj.set("invoiceamount", (Object)(StringUtils.isEmpty((CharSequence)requestBody.getInvoiceAmount()) ? "0" : requestBody.getInvoiceAmount()));
        invoiceObj.set("totaltax", (Object)requestBody.getTotalTaxAmount());
        invoiceObj.set("totalamount", (Object)requestBody.getTotalAmount());
        invoiceObj.set("salername", (Object)requestBody.getSalerName());
        invoiceObj.set("salertaxno", (Object)requestBody.getSalerTaxNo());
        invoiceObj.set("saleraddr", (Object)requestBody.getSalerAddressPhone());
        invoiceObj.set("salerbank", (Object)requestBody.getSalerAccount());
        invoiceObj.set("buyername", (Object)requestBody.getBuyerName());
        invoiceObj.set("buyertaxno", (Object)requestBody.getBuyerTaxNo());
        invoiceObj.set("buyeraddr", (Object)requestBody.getBuyerAddressPhone());
        invoiceObj.set("buyerbank", (Object)requestBody.getBuyerAccount());
        if (String.valueOf(requestBody.getRemark()).length() <= 230) {
            invoiceObj.set("remark", (Object)requestBody.getRemark());
        }
        invoiceObj.set("drawer", (Object)requestBody.getDrawer());
        invoiceObj.set("payee", (Object)requestBody.getPayee());
        invoiceObj.set("reviewer", (Object)requestBody.getReviewer());
        invoiceObj.set("createtime", (Object)new Date());
        invoiceObj.set("skm", (Object)requestBody.getPassword());
        invoiceObj.set("checkcode", (Object)requestBody.getCheckCode());
        invoiceObj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_valid_list", (String)"2"));
        String invoiceStatus = requestBody.getInvoiceStatus();
        invoiceObj.set("invoicestatus", (Object)InvoiceSyncControl.transInvoiceStatus(invoiceStatus));
        invoiceObj.set("orderno", (Object)MD5.md5Hex((String)UUID.next()).substring(8, 24));
        String issueType = IssueType.BLUE_INVOICE.getTypeCode();
        if (invoiceObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            issueType = IssueType.RED_INVOICE.getTypeCode();
        }
        invoiceObj.set("issuetype", (Object)issueType);
        invoiceObj.set("hsbz", (Object)"0");
        invoiceObj.set("specialtype", (Object)"00");
        List itemArray = requestBody.getItems();
        if (itemArray == null || itemArray.isEmpty()) {
            invoiceObj.set("inventorymark", (Object)"0");
            invoiceObj.set("ofdstatus", (Object)"3");
            LOGGER.info("RPA\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u4e0d\u5b58\u5728\uff1a{}", (Object)JSON.toJSONString((Object)requestBody));
            return invoiceObj;
        }
        int itemCount = 0;
        for (int i = 0; i < itemArray.size(); ++i) {
            AllEleFullInvoiceItemDTO itemObj = (AllEleFullInvoiceItemDTO)itemArray.get(i);
            String goodsName = itemObj.getGoodsName();
            if (!StringUtils.isEmpty((CharSequence)goodsName) && goodsName.contains("\u5408\u8ba1")) continue;
            DynamicObject itemDynamic = items.addNew();
            itemDynamic.set("goodsname", (Object)goodsName);
            itemDynamic.set("unit", (Object)itemObj.getUnit());
            if (StringUtils.isNotEmpty((CharSequence)itemObj.getTaxRate())) {
                String taxRateTemp = new BigDecimal(itemObj.getTaxRate()).stripTrailingZeros().toPlainString();
                itemDynamic.set("taxrate", (Object)TaxRateUtil.convertTaxRate((String)taxRateTemp));
            }
            itemDynamic.set("amount", (Object)itemObj.getDetailAmount());
            itemDynamic.set("tax", (Object)itemObj.getTaxAmount());
            itemDynamic.set("num", (Object)itemObj.getNum());
            BigDecimal hsje = InvoiceSyncControl.addNum(itemObj.getDetailAmount(), itemObj.getTaxAmount());
            itemDynamic.set("taxamount", (Object)hsje);
            itemDynamic.set("unitprice", (Object)itemObj.getUnitPrice());
            itemDynamic.set("taxflag", (Object)"0");
            itemDynamic.set("goodscode", (Object)itemObj.getGoodsCode());
            itemDynamic.set("zerotaxmark", (Object)itemObj.getZerotaxrateFlag());
            itemDynamic.set("specification", (Object)itemObj.getSpecModel());
            itemDynamic.set("seq", (Object)i);
            ++itemCount;
        }
        if (itemCount > 8) {
            invoiceObj.set("inventorymark", (Object)"1");
        } else {
            invoiceObj.set("inventorymark", (Object)"0");
        }
        if (!InvoiceUtils.isEtcInvoice((String)invoiceObj.getString("invoicetype")) && !"1".equals(CacheHelper.get((String)"paperNeedPdf"))) {
            invoiceObj.set("ofdstatus", (Object)"3");
        }
        InvoiceSyncControl.setDiscountType(invoiceObj);
        InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)invoiceObj);
        IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoiceObj);
        return invoiceObj;
    }

    private static void setDiscountType(DynamicObject invoiceObj) {
        DynamicObjectCollection items = invoiceObj.getDynamicObjectCollection("items");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        String issueType = invoiceObj.getString("issuetype");
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject itemObj = (DynamicObject)items.get(i);
            itemObj.set("rowtype", (Object)"0");
            BigDecimal amount = itemObj.getBigDecimal("amount");
            if (!StringUtils.equals((CharSequence)issueType, (CharSequence)IssueType.BLUE_INVOICE.getTypeCode()) || amount.compareTo(BigDecimal.ZERO) >= 0) continue;
            itemObj.set("rowtype", (Object)"1");
            int index = i - 1;
            if (index < 0) continue;
            ((DynamicObject)items.get(index)).set("rowtype", (Object)"2");
        }
    }

    public static String transInvoiceStatus(String invoiceStatus) {
        switch (invoiceStatus) {
            case "2": {
                return "6";
            }
            case "3": 
            case "8": {
                return "3";
            }
            case "7": {
                return "2";
            }
        }
        return "0";
    }

    public static BigDecimal addNum(String num1, String num2) {
        if (null == num1) {
            num1 = "0";
        }
        if (null == num2) {
            num2 = "0";
        }
        return new BigDecimal(num1).add(new BigDecimal(num2));
    }

    public static BigDecimal subNum(String num1, String num2) {
        if (null == num1) {
            num1 = "0";
        }
        if (null == num2) {
            num2 = "0";
        }
        return new BigDecimal(num1).subtract(new BigDecimal(num2));
    }

    public static BigDecimal multNum(String num1, String num2) {
        if (null == num1) {
            num1 = "0";
        }
        if (null == num2) {
            num2 = "0";
        }
        return new BigDecimal(num1).multiply(new BigDecimal(num2));
    }

    public static String transType(String type) {
        switch (type) {
            case "0": {
                return InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode();
            }
            case "2": {
                return InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
            }
            case "12": {
                return InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode();
            }
            case "41": {
                return InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode();
            }
            case "51": {
                return InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode();
            }
            case "61": {
                return InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode();
            }
        }
        throw new MsgException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u8fd4\u56de\u672a\u77e5\u7684\u53d1\u7968\u7c7b\u578b\uff1a%1$s", (String)"InvoiceSyncControl_10", (String)"imc-sim-service", (Object[])new Object[0]), type));
    }

    public static String transAllEleType(String type) {
        switch (type) {
            case "08xdp": {
                return InvoiceType.ALL_E_SPECIAL.getBaseCode();
            }
            case "10xdp": {
                return InvoiceType.ALL_E_NORMAL.getBaseCode();
            }
            case "0": {
                return InvoiceType.PAPER_SPECIAL_INVOICE.getBaseCode();
            }
            case "2": {
                return InvoiceType.PAPER_NOMAL_INVOICE.getBaseCode();
            }
            case "12": {
                return InvoiceType.PAPER_VEHICLE_INVOICE.getBaseCode();
            }
            case "41": {
                return InvoiceType.PAPER_VOLUME_INVOICE.getBaseCode();
            }
            case "51": {
                return InvoiceType.ELECTRICAL_NORMAL_INVOICE.getBaseCode();
            }
            case "61": {
                return InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getBaseCode();
            }
        }
        throw new MsgException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u8fd4\u56de\u672a\u77e5\u7684\u53d1\u7968\u7c7b\u578b\uff1a%1$s", (String)"InvoiceSyncControl_10", (String)"imc-sim-service", (Object[])new Object[0]), type));
    }

    public static String transAllEleTypeFromTypeCode(String type) {
        switch (type) {
            case "08xdp": {
                return type;
            }
            case "10xdp": {
                return type;
            }
            case "004": {
                return InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCodeHx();
            }
            case "007": {
                return InvoiceType.PAPER_NOMAL_INVOICE.getTypeCodeHx();
            }
            case "006": {
                return InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCodeHx();
            }
            case "025": {
                return InvoiceType.PAPER_VOLUME_INVOICE.getTypeCodeHx();
            }
            case "026": {
                return InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCodeHx();
            }
            case "028": {
                return InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCodeHx();
            }
        }
        throw new MsgException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u8fd4\u56de\u672a\u77e5\u7684\u53d1\u7968\u7c7b\u578b\uff1a%1$s", (String)"InvoiceSyncControl_10", (String)"imc-sim-service", (Object[])new Object[0]), type));
    }

    public static void updateOriginInvoiceCodeByRemark(DynamicObject invoiceObj) {
        if (IssueType.RED_INVOICE.getTypeCode().equals(invoiceObj.getString("issuetype")) && StringUtils.isEmpty((CharSequence)invoiceObj.getString("originalinvoicecode")) && !StringUtils.isEmpty((CharSequence)invoiceObj.getString("remark"))) {
            String remark = invoiceObj.getString("remark");
            LOGGER.info(String.format("updateOriginInvoiceCodeByRemark %s", remark));
            try {
                String originalInvoiceCode = remark.substring(remark.lastIndexOf("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:") + 9, remark.indexOf("\u53f7\u7801")).trim();
                String originalInvoiceNo = remark.substring(remark.indexOf("\u53f7\u7801:") + 3, remark.indexOf("\u53f7\u7801") + 11);
                if (StringUtils.isNumeric((CharSequence)originalInvoiceCode) && StringUtils.isNumeric((CharSequence)originalInvoiceNo)) {
                    invoiceObj.set("originalinvoicecode", (Object)originalInvoiceCode);
                    invoiceObj.set("originalinvoiceno", (Object)originalInvoiceNo);
                } else {
                    LOGGER.error("\u5339\u914d\u51fa\u6765\u4e0d\u662f\u6570\u5b57...");
                }
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u7ea2\u7968\u5907\u6ce8\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static void afterCommonBatchSync(List<DynamicObject> newInvoiceList, List<DynamicObject> updateList) {
        DynamicObject[] savedInvoice = (DynamicObject[])ImcSaveServiceHelper.save(newInvoiceList);
        for (DynamicObject dynamicObject : savedInvoice) {
            WideInvoiceSevice.addInvoiceToWide((DynamicObject)dynamicObject);
        }
        ImcSaveServiceHelper.update(updateList);
        for (DynamicObject dynamicObject : newInvoiceList) {
            ThreadPools.executeOnceIncludeRequestContext((String)"invoice_query_handleHyperLinkClick", () -> ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest((DynamicObject)dynamicObject, (boolean)true));
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"exists_invoice_write_back", () -> {
            for (DynamicObject invoice : updateList) {
                IssuedInvoiceWriteBackHelper.writeBackIssueAmount2OriginBill((DynamicObject)invoice);
                IssueInvoiceService.invokeRimSaveInvoice((DynamicObject)invoice);
                IssueInvoiceService.syncInvoiceCallback((DynamicObject)invoice);
                if (!InvoiceUtils.isPaperInvoice((String)invoice.getString("invoicetype")) || !"6".equals(invoice.getString("invoicestatus")) || !"2".equals(invoice.getString("abolishwritebackstatus"))) continue;
                InvalidInvoiceWriteBackHelper.writeBack2OriginBillByInvalid((DynamicObject)invoice);
                ImcSaveServiceHelper.update((DynamicObject)invoice);
            }
        });
    }

    public static DynamicObject fillSpecialFields(DynamicObject invoice, AllEleFullInvoiceResponseDTO responseDTO, boolean isNeedSave) {
        String specialType = InvoiceSyncControl.convertSpecialType(responseDTO.getBusinessType());
        if ("00".equals(specialType)) {
            return invoice;
        }
        invoice.set("specialtype", (Object)specialType);
        BillBuildInfoVo buildInfo = responseDTO.getBuildInfo();
        if ("E03".equals(specialType) && null != buildInfo && StringUtils.isNotBlank((CharSequence)buildInfo.getBuildingName())) {
            invoice.set("landtaxno", (Object)buildInfo.getLandTaxNo());
            invoice.set("crosscitysign", (Object)buildInfo.getCrossCitySign());
            invoice.set("simpleaddress", (Object)buildInfo.getSimpleAddress());
            invoice.set("buildingname", (Object)buildInfo.getBuildingName());
            return invoice;
        }
        List baseFreightItems = responseDTO.getFreightList();
        if ("E04".equals(specialType) && null != baseFreightItems) {
            DynamicObjectCollection freightItems = invoice.getDynamicObjectCollection("freights");
            if (baseFreightItems.size() > 0) {
                freightItems.clear();
                for (Object baseFreightItem : baseFreightItems) {
                    DynamicObject newFreightItem = freightItems.addNew();
                    DynamicObjectUtil.bean2DynamicObject((Object)baseFreightItem, (DynamicObject)newFreightItem);
                }
            }
            if (isNeedSave) {
                return (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)invoice);
            }
        }
        List estateLeaseItems = responseDTO.getEstateLeaseInfoList();
        if ("E06".equals(specialType) && null != estateLeaseItems) {
            DynamicObjectCollection estateItems = invoice.getDynamicObjectCollection("estatesales");
            if (estateLeaseItems.size() > 0) {
                estateItems.clear();
                for (BillEstateSaleItemVo estateLeaseItem : estateLeaseItems) {
                    DynamicObject newLeaseItem = estateItems.addNew();
                    DynamicObjectUtil.bean2DynamicObject((Object)estateLeaseItem, (DynamicObject)newLeaseItem);
                }
            }
            if (isNeedSave) {
                return (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)invoice);
            }
        }
        List travelerList = responseDTO.getTravelerList();
        if ("E09".equals(specialType) && null != travelerList) {
            DynamicObjectCollection travelerItems = invoice.getDynamicObjectCollection("travelers");
            if (travelerList.size() > 0) {
                travelerItems.clear();
                for (BillTravlerInfoVo billTravlerInfoVo : travelerList) {
                    DynamicObject newTravelerItem = travelerItems.addNew();
                    DynamicObjectUtil.bean2DynamicObject((Object)billTravlerInfoVo, (DynamicObject)newTravelerItem);
                    String seatClass = newTravelerItem.getString("travelerseatclass");
                    String seatName = null;
                    if ("1".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.FLIGHT_BUS_CLASS.getName();
                    }
                    if ("2".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.FLIGHT_FIRST_CLASS.getName();
                    }
                    if ("3".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.FLIGHT_ECONOMY_CLASS.getName();
                    }
                    if ("4".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.TRAIN_ONE_CLASS.getName();
                    }
                    if ("5".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.TRAIN_TWO_CLASS.getName();
                    }
                    if ("6".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.TRAIN_SOFT_CLASS.getName();
                    }
                    if ("7".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.TRAIN_HARD_CLASS.getName();
                    }
                    if ("8".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.SHIP_ONE_CLASS.getName();
                    }
                    if ("9".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.SHIP_TWO_CLASS.getName();
                    }
                    if ("10".equals(seatClass)) {
                        seatName = SeatClassTypeEnum.SHIP_THREE_CLASS.getName();
                    }
                    newTravelerItem.set("travelerseatclass", (Object)seatName);
                }
            }
            if (isNeedSave) {
                return (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)invoice);
            }
        }
        return invoice;
    }

    private static String convertSpecialType(String businessType) {
        if ("03".equals(businessType)) {
            return "E03";
        }
        if ("04".equals(businessType)) {
            return "E04";
        }
        if ("05".equals(businessType)) {
            return "E05";
        }
        if ("06".equals(businessType)) {
            return "E06";
        }
        if ("07".equals(businessType)) {
            return "E07";
        }
        if ("01".equals(businessType)) {
            return "E01";
        }
        if ("18".equals(businessType)) {
            return "E18";
        }
        if ("09".equals(businessType)) {
            return "E09";
        }
        return "00";
    }

    public static DynamicObject transRpaVehicleObj(Long orgId, AllVehicleBillResponseDTO responseDTO, SyncQueryInvoiceDTO body) {
        if (responseDTO instanceof UsedCarFullInvoiceResponseDTO) {
            String businessType;
            UsedCarFullInvoiceResponseDTO usedCarResponse = (UsedCarFullInvoiceResponseDTO)responseDTO;
            DynamicObject usedCarInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_vehicles");
            String invoiceStatus = usedCarResponse.getInvoiceStatus();
            usedCarInvoice.set("invoicestatus", (Object)InvoiceSyncControl.transInvoiceStatus(invoiceStatus));
            DynamicObjectUtil.bean2DynamicObject((Object)usedCarResponse, (DynamicObject)usedCarInvoice);
            if (StringUtils.isNotBlank((CharSequence)usedCarResponse.getAuctionName())) {
                usedCarInvoice.set("issuename", (Object)usedCarResponse.getAuctionName());
                usedCarInvoice.set("issuetaxno", (Object)usedCarResponse.getAuctionTaxpayerId());
                usedCarInvoice.set("usedcarenterprisenature", (Object)"08");
            }
            if (StringUtils.isNotBlank((CharSequence)usedCarResponse.getMarketName())) {
                usedCarInvoice.set("issuename", (Object)usedCarResponse.getMarketName());
                usedCarInvoice.set("issuetaxno", (Object)usedCarResponse.getMarketTaxpayerId());
                usedCarInvoice.set("usedcarenterprisenature", (Object)"07");
            }
            if (StringUtils.isNotBlank((CharSequence)usedCarResponse.getTaxRate())) {
                BigDecimal taxRateDecimalValue = new BigDecimal(usedCarResponse.getTaxRate());
                String rateStr = TaxRate.getRateStr((BigDecimal)taxRateDecimalValue);
                usedCarInvoice.set("taxrate", (Object)rateStr);
            }
            if ("51".equals(businessType = usedCarResponse.getBusinessType())) {
                usedCarInvoice.set("issueway", (Object)"0");
            }
            if ("52".equals(businessType)) {
                usedCarInvoice.set("issueway", (Object)"1");
            }
            return usedCarInvoice;
        }
        VehicleInvoiceResponseDTO vehicleResponse = (VehicleInvoiceResponseDTO)responseDTO;
        DynamicObject vehicleInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_vehicles");
        DynamicObjectUtil.bean2DynamicObject((Object)vehicleResponse, (DynamicObject)vehicleInvoice);
        String invoiceStatus = vehicleResponse.getInvoiceStatus();
        vehicleInvoice.set("invoicestatus", (Object)InvoiceSyncControl.transInvoiceStatus(invoiceStatus));
        if (StringUtils.isNotBlank((CharSequence)vehicleResponse.getTaxRate())) {
            BigDecimal taxRateDecimalValue = new BigDecimal(vehicleResponse.getTaxRate());
            String rateStr = TaxRate.getRateStr((BigDecimal)taxRateDecimalValue);
            vehicleInvoice.set("taxrate", (Object)rateStr);
        }
        return vehicleInvoice;
    }
}

