/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncControl;

public class InvoiceSyncResponseControl {
    public static String singleResponse(JSONArray invoiceArr, long orgId) {
        if (!CollectionUtils.isEmpty((Collection)invoiceArr)) {
            for (int i = 0; i < invoiceArr.size(); ++i) {
                JSONObject resultObj = invoiceArr.getJSONObject(i);
                if (resultObj == null) continue;
                String invoiceCode = resultObj.getString("invoicecode");
                String invoiceNo = resultObj.getString("invoiceno");
                DynamicObject vatObj = InvoiceSyncResponseControl.checkExist(invoiceCode, invoiceNo);
                boolean invoiceExist = false;
                if (vatObj != null) {
                    invoiceExist = true;
                }
                if (invoiceExist) {
                    InvoiceSyncResponseControl.invoiceExist(resultObj, vatObj);
                } else {
                    vatObj = InvoiceSyncResponseControl.transObj(resultObj);
                    vatObj.set("billno", (Object)("300_" + UUID.getBatchNumber() + "_0001"));
                    vatObj.set("issuesource", (Object)DeviceUtil.getDevType((String)resultObj.getString("jqbh")));
                    vatObj.set("jqbh", (Object)resultObj.getString("jqbh"));
                    vatObj.set("orgid", (Object)orgId);
                    vatObj.set("ofdstatus", (Object)"0");
                    IssueInvoiceService.updateDiscountInfo((DynamicObject)vatObj);
                }
                vatObj.set("buyertype", (Object)"2");
                IssueInvoiceService.updateBaseInvoiceType((DynamicObject)vatObj);
                IssueInvoiceService.updateTaxOrg((DynamicObject)vatObj);
                DynamicObject saveObj = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)vatObj);
                if (!invoiceExist) {
                    WideInvoiceSevice.addInvoiceToWide((DynamicObject)saveObj);
                }
                InvoiceSyncControl.afterSaveInvoice(invoiceExist, vatObj);
            }
            return ResManager.loadKDString((String)"\u53d1\u7968\u540c\u6b65\u6210\u529f", (String)"InvoiceSyncResponseControl_0", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u53ef\u540c\u6b65\u6570\u636e", (String)"InvoiceSyncResponseControl_1", (String)"imc-sim-service", (Object[])new Object[0]);
    }

    public static void invoiceExist(JSONObject resultObj, DynamicObject vatObj) {
        String invoiceStatus = resultObj.getString("invoicestatus");
        vatObj.set("invoicestatus", (Object)invoiceStatus);
        if (StringUtils.isBlank((CharSequence)vatObj.getString("billstatus"))) {
            vatObj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_valid_list", (String)"2"));
        }
        String issueType = resultObj.getString("issuetype");
        vatObj.set("issuetype", (Object)issueType);
        vatObj.set("buyeraddr", (Object)resultObj.getString("buyeraddr"));
        vatObj.set("buyerbank", (Object)resultObj.getString("buyerbank"));
        vatObj.set("remark", (Object)resultObj.getString("remark"));
        if (vatObj.get("orgid") == null) {
            vatObj.set("orgid", (Object)RequestContext.get().getOrgId());
        }
        vatObj.set("skm", (Object)resultObj.getString("skm"));
        vatObj.set("checkcode", (Object)resultObj.getString("checkcode"));
        vatObj.set("result", (Object)"");
    }

    private static DynamicObject checkExist(String invoicecode, String invoiceno) {
        QFilter filter = new QFilter("invoicecode", "=", (Object)invoicecode);
        filter.and("invoiceno", "=", (Object)invoiceno);
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])filter.toArray());
    }

    public static DynamicObject transObj(JSONObject resultObj) {
        DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)resultObj, (DynamicObject)invoiceObj, (boolean)false);
        invoiceObj.set("buyertype", (Object)"2");
        invoiceObj.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoiceObj.set("createtime", (Object)new Date());
        invoiceObj.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_invoice_valid_list", (String)"buyertype"));
        String ddh = StringUtils.isBlank((CharSequence)resultObj.getString("orderno")) ? UUID.randomUUID() : resultObj.getString("orderno");
        invoiceObj.set("orderno", (Object)ddh);
        invoiceObj.set("issuetime", resultObj.get((Object)"issuetime"));
        invoiceObj.set("invaliddate", resultObj.get((Object)"invaliddate"));
        InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)invoiceObj);
        IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoiceObj);
        return invoiceObj;
    }
}

