/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.dataimport;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.NumberGenerateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HistoryInvoiceDataImportService {
    private static final String BATCH_NO_PRE = "FP";

    public static void saveHistoryImportTaskData(DynamicObjectCollection epInfos, String dataType, String invoiceType, String downloadChannel, String issueAccount, List<String> dateRangeList) {
        if (epInfos == null || epInfos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u65b9\u4fe1\u606f", (String)"HistoryInvoiceDataImportService_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(epInfos.size());
        for (DynamicObject epInfoMul : epInfos) {
            DynamicObject epInfo = epInfoMul.getDynamicObject("fbasedataId");
            DynamicObject dynamicObject = HistoryInvoiceDataImportService.getHistoryImportTaskData(epInfo, dataType, invoiceType, downloadChannel, issueAccount, dateRangeList);
            dataList.add(dynamicObject);
        }
        ImcSaveServiceHelper.save(dataList);
    }

    public static DynamicObject getHistoryImportTaskData(DynamicObject epInfo, String dataType, String invoiceType, String downloadChannel, String issueAccount, List<String> dateRangeList) {
        String[] invoiceTypeArr = HistoryInvoiceDataImportService.checkInvoiceType(invoiceType);
        boolean isInvoiceData = "1".equals(dataType);
        String importMethod = "1";
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_his_inv_data_import");
        HistoryInvoiceDataImportService.setBaseData(dynamicObject, dataType, invoiceType, importMethod, epInfo);
        dynamicObject.set("downloadchannel", (Object)downloadChannel);
        if ("2".equals(downloadChannel) && StringUtils.isEmpty((CharSequence)issueAccount)) {
            Pair accountPair;
            String taxNo = epInfo.getString("number");
            DynamicObject accountDO = AllEleAuthHelper.getAccountByTaxNo((String)taxNo);
            boolean accountIsNull = true;
            if (accountDO != null && StringUtils.isNotEmpty((CharSequence)(issueAccount = (String)(accountPair = AllEleAuthHelper.getAccountList((DynamicObject)accountDO, (boolean)true)).getLeft()))) {
                accountIsNull = false;
            }
            if (accountIsNull) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u9ed8\u8ba4\u8d26\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"HistoryInvoiceDataImportService_2", (String)"imc-sim-service", (Object[])new Object[0]), epInfo.getString("name")));
            }
        }
        dynamicObject.set("issueaccount", (Object)issueAccount);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (String dateRange : dateRangeList) {
            if (!isInvoiceData) {
                HistoryInvoiceDataImportService.setEntryEntityData(entryEntity, invoiceType, dateRange);
                continue;
            }
            for (String invoiceTypeStr : invoiceTypeArr) {
                HistoryInvoiceDataImportService.setEntryEntityData(entryEntity, invoiceTypeStr, dateRange);
            }
        }
        return dynamicObject;
    }

    public static void setBaseData(DynamicObject dynamicObject, String dataType, String invoiceType, String importMethod, DynamicObject epInfo) {
        dynamicObject.set("billno", (Object)HistoryInvoiceDataImportService.getBatchNo());
        dynamicObject.set("org", (Object)RequestContext.get().getOrgId());
        dynamicObject.set("epinfo", (Object)epInfo);
        dynamicObject.set("executionstatus", (Object)"0");
        dynamicObject.set("datatype", (Object)dataType);
        dynamicObject.set("invoicetype", (Object)invoiceType);
        dynamicObject.set("importmethod", (Object)importMethod);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("billstatus", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
    }

    private static void setEntryEntityData(DynamicObjectCollection entryEntity, String invoiceTypeStr, String dateRange) {
        DynamicObject item = entryEntity.addNew();
        item.set("detailinvoicetype", (Object)invoiceTypeStr);
        item.set("detailinvoicedate", (Object)dateRange);
        item.set("detailexecutionstatus", (Object)"0");
    }

    private static void setEntryEntityDataWithTaskNo(DynamicObjectCollection entryEntity, String invoiceTypeStr, String dateRange) {
        DynamicObject item = entryEntity.addNew();
        item.set("detailtaskno", (Object)NumberGenerateUtil.generateByPrefixWithRandom((String)BATCH_NO_PRE, (int)20));
        item.set("detailinvoicetype", (Object)invoiceTypeStr);
        item.set("detailinvoicedate", (Object)dateRange);
        item.set("detailexecutionstatus", (Object)"0");
    }

    private static String getBatchNo() {
        return NumberGenerateUtil.generateByPrefixWithRandom((String)BATCH_NO_PRE, (int)8);
    }

    private static String[] checkInvoiceType(String invoiceType) {
        String[] invoiceTypeArr;
        if (StringUtils.isEmpty((CharSequence)invoiceType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u7968\u79cd\u7c7b", (String)"HistoryInvoiceDataImportService_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (invoiceType.startsWith(",")) {
            invoiceType = invoiceType.substring(1);
        }
        if ((invoiceTypeArr = invoiceType.split(",")).length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u7968\u79cd\u7c7b", (String)"HistoryInvoiceDataImportService_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        return invoiceTypeArr;
    }

    public static void saveInvoiceFileDownloadTaskData(DynamicObjectCollection epInfos, String dataType, String invoiceType, String downloadChannel, String issueAccount, List<String> dateRangeList) {
        if (epInfos == null || epInfos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u65b9\u4fe1\u606f", (String)"HistoryInvoiceDataImportService_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(epInfos.size());
        for (DynamicObject epInfoMul : epInfos) {
            DynamicObject epInfo = epInfoMul.getDynamicObject("fbasedataId");
            DynamicObject dynamicObject = HistoryInvoiceDataImportService.getInvoiceFileTaskData(epInfo, dataType, invoiceType, downloadChannel, issueAccount, dateRangeList);
            dataList.add(dynamicObject);
        }
        ImcSaveServiceHelper.save(dataList);
    }

    public static DynamicObject getInvoiceFileTaskData(DynamicObject epInfo, String dataType, String invoiceType, String downloadChannel, String issueAccount, List<String> dateRangeList) {
        String[] invoiceTypeArr = HistoryInvoiceDataImportService.checkInvoiceType(invoiceType);
        String importMethod = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_his_inv_data_import");
        HistoryInvoiceDataImportService.setBaseData(dynamicObject, dataType, invoiceType, importMethod, epInfo);
        dynamicObject.set("downloadchannel", (Object)downloadChannel);
        dynamicObject.set("importmethod", (Object)"1");
        dynamicObject.set("issueaccount", (Object)issueAccount);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (String dateRange : dateRangeList) {
            for (String invoiceTypeStr : invoiceTypeArr) {
                HistoryInvoiceDataImportService.setEntryEntityDataWithTaskNo(entryEntity, invoiceTypeStr, dateRange);
            }
        }
        return dynamicObject;
    }
}

