/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.BillRelateInvoicesConstant;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SplitRuleHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillCommonCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillInvoiceRelationHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByRuleServiceImpl;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class IssueInvoiceControlHelper {
    private static final Log LOGGER = LogFactory.getLog(IssueInvoiceControlHelper.class);

    @Deprecated
    public ErrorMsgDTO checkSpecialTypeRemark(IFormView view, String itemJsonArray) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> issueInvoice(DynamicObject[] bills, String deviceNo, String terminalNo, String account, Integer autoInvoice, boolean isMergeBill, boolean isMergeBillDetail) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList invoiceList = Lists.newArrayList();
        ArrayList redInfoList = Lists.newArrayList();
        ArrayList redConfirmList = Lists.newArrayList();
        HashMap failedInfo = Maps.newHashMap();
        List<String> billNos = Arrays.stream(bills).map(e -> e.getString("billno")).collect(Collectors.toList());
        if (!StringUtils.isEmpty((String)terminalNo)) {
            Arrays.stream(bills).forEach(e -> e.set("terminalno", (Object)terminalNo));
        }
        LOGGER.info(String.format("IssueInvoiceHelper issueInvoice billNos:%s", SerializationUtils.toJsonString(billNos)));
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("orgid"));
        try {
            HashMap hashMap;
            BillOperationLockUtil.getBillsLock(billNos, (boolean)false, (long)orgId);
            if (bills.length <= 0) {
                throw new KDBizException(new ErrorCode("50001", ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u4e0d\u5b58\u5728", (String)"IssueInvoiceControlHelper_0", (String)"imc-sim-service", (Object[])new Object[0])), new Object[0]);
            }
            MergeRequestDTO billRequest = new MergeRequestDTO.Builder().mergeBill(isMergeBill).mergeBillDetail(isMergeBillDetail).setJqbh(deviceNo).bills(bills).build();
            MergeResponseDTO mergeResponseDTO = new BillMergeHelper().mergeBill(billRequest);
            Map<String, String> errorMap = IssueInvoiceControlHelper.checkMerge(bills, mergeResponseDTO);
            LOGGER.info(String.format("issueInvoice errorMap:%s", SerializationUtils.toJsonString(errorMap)));
            for (String message : errorMap.values()) {
                String billNo = message.split(":")[0];
                bills = (DynamicObject[])Arrays.stream(bills).filter(o -> !o.getString("billno").equals(billNo)).toArray(DynamicObject[]::new);
                if (!StringUtils.isNotBlank((String)billNo)) continue;
                failedInfo.put(billNo, message);
                LOGGER.info(String.format("issueInvoice mergeResponseDTO.getRelations:%s,billNo:%s", SerializationUtils.toJsonString((Object)mergeResponseDTO.getRelations()), billNo));
                mergeResponseDTO.getRelations().removeIf(e -> e.getsBillNo().equals(billNo));
                LOGGER.info(String.format("issueInvoice mergeResponseDTO.getBills:%s,billNo:%s", SerializationUtils.toJsonString((Object)mergeResponseDTO.getBills()), billNo));
                mergeResponseDTO.getBills().removeIf(e -> e.getString("billno").contains(billNo));
            }
            Map<Long, List<BillRelationDTO>> mergeRelationMap = mergeResponseDTO.getRelations().stream().collect(Collectors.groupingBy(BillRelationDTO::gettBillId));
            List billList = mergeResponseDTO.getBills();
            LOGGER.info(String.format("issueInvoice merge success billList:%s", SerializationUtils.toJsonString((Object)billList)));
            ArrayList splitSuccessBill = Lists.newArrayList();
            ArrayList billRelations = Lists.newArrayList();
            ArrayList invoiceRelationList = Lists.newArrayList();
            SplitRequestDTO splitRequest = new SplitRequestDTO();
            Iterator iterator = billList.iterator();
            HashMap<String, DynamicObject> ruleMap = new HashMap<String, DynamicObject>(10);
            while (iterator.hasNext()) {
                DynamicObject bill2 = (DynamicObject)iterator.next();
                try {
                    splitRequest.setBill(bill2);
                    splitRequest.setBillNoMap(mergeResponseDTO.getBillNoMap());
                    String ruleCode = bill2.getString("splitrule");
                    if (StringUtils.isNotBlank((String)ruleCode) && !SplitByRuleServiceImpl.DEFAULT_RULE.contains((Object)ruleCode)) {
                        DynamicObject rule = (DynamicObject)ruleMap.get(orgId + ruleCode);
                        if (rule == null) {
                            rule = SplitRuleHelper.getRuleByCode((Long)orgId, (String)ruleCode);
                        }
                        ruleMap.put(orgId + ruleCode, rule);
                        splitRequest.setRuleObj(rule);
                    }
                    SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill(splitRequest, StringUtils.isBlank((String)deviceNo) ? bill2.getString("jqbh") : deviceNo);
                    invoiceRelationList.addAll(splitResponseDTO.getRelations());
                    if (BillHelper.isRedInfo((DynamicObject)bill2)) {
                        redInfoList.addAll(splitResponseDTO.getInvoices());
                    } else if (BillHelper.isAllERedConfirm((DynamicObject)bill2)) {
                        if (!OpenApiInterfaceCodeEnum.BILL_PUSH.getCode().equals(account)) {
                            for (DynamicObject invoice : splitResponseDTO.getInvoices()) {
                                invoice.set("account", (Object)account);
                            }
                        }
                        redConfirmList.addAll(splitResponseDTO.getInvoices());
                    } else {
                        DynamicObject invoice;
                        List invoices = splitResponseDTO.getInvoices();
                        invoice = invoices.iterator();
                        while (invoice.hasNext()) {
                            DynamicObject invoice2 = (DynamicObject)invoice.next();
                            if (!OpenApiInterfaceCodeEnum.BILL_PUSH.getCode().equals(account)) {
                                invoice2.set("account", (Object)account);
                            }
                            if (!StringUtils.isNotBlank((String)bill2.getString("mergelable"))) continue;
                            invoice2.set("mergelable", (Object)"1");
                        }
                        invoiceList.addAll(splitResponseDTO.getInvoices());
                    }
                    billRelations.addAll((Collection)mergeRelationMap.get(bill2.getLong("id")));
                }
                catch (Exception e2) {
                    iterator.remove();
                    Set<Long> failBillIds = mergeRelationMap.get(bill2.getLong("id")).stream().collect(Collectors.groupingBy(BillRelationDTO::getsBillId)).keySet();
                    for (Long failBillId : failBillIds) {
                        failedInfo.put(failBillId.toString(), e2.getMessage());
                    }
                    LOGGER.error("IssueInvoiceHelper issueInvoice invoke", (Throwable)e2);
                }
            }
            Set<Long> successBillIds = billRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::getsBillId)).keySet();
            List<DynamicObject> origSuccessBills = Arrays.stream(bills).filter(bill -> successBillIds.contains(bill.getLong("id"))).collect(Collectors.toList());
            IssueInvoiceControlHelper.doOriginalTaxDeviation(mergeResponseDTO.getBills(), billRelations, invoiceRelationList);
            List<BillRelationDTO> invRelation = BillInvoiceRelationHelper.mergeRelation(billRelations, invoiceRelationList);
            TXHandle tx = TX.requiresNew();
            ArrayList idList = Lists.newArrayListWithCapacity((int)0);
            MsgException msgException = null;
            ArrayList<BillRelationDTO> matchRelation = new ArrayList<BillRelationDTO>();
            try {
                BillProcessTabUtil.fillInvoiceInfoFromBill(bills, invRelation, invoiceList);
                IssueInvoiceControlHelper.setOriginalBillByInvRelation(origSuccessBills, invRelation);
                List<DynamicObject> invRelationDOList = IssueInvoiceControlHelper.saveInvRelation(invRelation);
                IssueInvoiceControlHelper.createMergeOrMatchBill(billNos, orgId, mergeResponseDTO, invRelation, matchRelation);
                if (CollectionUtils.isNotEmpty((Collection)invoiceList)) {
                    InvoiceUtils.dealInvoicesListMark(new HashMap(), (List)invoiceList);
                    IssueInvoiceControlHelper.copySpecialInfoAndExtraInfo(invoiceList, bills);
                    ImcSaveServiceHelper.save((List)invoiceList);
                }
                if (CollectionUtils.isNotEmpty((Collection)redInfoList)) {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_info", (DynamicObject[])redInfoList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    if (!operationResult.isSuccess()) {
                        throw new KDBizException(operationResult.getMessage());
                    }
                    for (DynamicObject redInfo : redInfoList) {
                        if (!"3".equals(redInfo.get("status"))) continue;
                        DynamicObject waitInvoice = OriginalBillPluginIssueControl.genWaitInvoice(redInfo);
                        ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                        invoiceList.add(waitInvoice);
                    }
                } else if (CollectionUtils.isNotEmpty((Collection)redConfirmList)) {
                    for (DynamicObject invoiceDO : redConfirmList) {
                        DynamicObject redConfirmBill = BillProcessTabUtil.warpRedAllEInvoiceData(invRelationDOList, invoiceDO, true);
                        if (StringUtils.isEmpty((String)redConfirmBill.getString("number")) || RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirmBill.getString("confirmstatus"))) {
                            ApiResult submitResult = RedConfirmBillHelper.submit(redConfirmBill);
                            if (submitResult != null) {
                                IssueInvoiceControlHelper.saveMatchInvRelation(invRelation, matchRelation, redConfirmBill, true);
                                LOGGER.info(String.format("\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355\u8fd4\u56de\uff1a%s", JSON.toJSONString((Object)submitResult)));
                                msgException = new MsgException(submitResult.getErrorCode(), String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u7ea2\u51b2\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\u51fa\u9519\uff1a%s", (String)"RedConfirmBillHelper_8", (String)"imc-sim-service", (Object[])new Object[0]), submitResult.getMessage()));
                                continue;
                            }
                            if (RedConfirmStatusEnum.isNotInvoiceByNumber((String)redConfirmBill.getString("confirmstatus"))) {
                                IssueInvoiceControlHelper.saveMatchInvRelation(invRelation, matchRelation, redConfirmBill, false);
                                msgException = new MsgException(ApiErrCodeEnum.REDCONFIRM_ERROR_STATUS.getCode(), String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u7ea2\u51b2\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u4e3a\uff1a%s\uff0c\u4e0d\u652f\u6301\u7acb\u5373\u5f00\u7968", (String)"RedConfirmBillHelper_18", (String)"imc-sim-service", (Object[])new Object[0]), RedConfirmStatusEnum.getBillCodeByDesc((String)redConfirmBill.getString("confirmstatus"))));
                                continue;
                            }
                        }
                        IssueInvoiceControlHelper.saveMatchInvRelation(invRelation, matchRelation, redConfirmBill, false);
                        DynamicObject waitInvoice = RedConfirmBillHelper.createWaitInvoice(redConfirmBill);
                        waitInvoice.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDO.get("orgid")));
                        waitInvoice.set("buyertype", (Object)"4");
                        waitInvoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
                        waitInvoice.set("batchbelong", (Object)invoiceDO.getString("batchbelong"));
                        ArrayList<DynamicObject> copyList = new ArrayList<DynamicObject>();
                        copyList.add(waitInvoice);
                        IssueInvoiceControlHelper.copySpecialInfoAndExtraInfo(copyList, bills);
                        ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                        idList.add(redConfirmBill.getPkValue());
                        invoiceList.add(waitInvoice);
                    }
                }
                LOGGER.info(String.format("issueInvoice origSuccessBills:%s", SerializationUtils.toJsonString(origSuccessBills)));
                DynamicObject[] invoices = IssueInvoiceControlHelper.getAllInvoices(invRelation);
                ItemMerge2OneHelper.dealOriginalBillNumDifference((DynamicObject[])invoices);
            }
            catch (Throwable e3) {
                tx.markRollback();
                LOGGER.error(e3);
                throw new KDBizException(new ErrorCode("5003", e3.getMessage()), new Object[0]);
            }
            finally {
                tx.close();
            }
            RedConfirmBillMailHelper.sendEmailImm(idList);
            if (null != msgException) {
                throw msgException;
            }
            if (autoInvoice == 1 && CollectionUtils.isNotEmpty((Collection)invoiceList)) {
                if (CollectionUtils.isEmpty((Collection)invoiceList)) {
                    hashMap = resultMap;
                    return hashMap;
                }
                LOGGER.info(String.format("submitInvoice2MQ invoiceList:%s", SerializationUtils.toJsonString((Object)invoiceList)));
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
                IssueInvoiceControlHelper.callBackThirdApiSystem(invoiceList);
            }
            resultMap.put("splitSuccessBill", splitSuccessBill);
            resultMap.put("failedInfo", failedInfo);
            resultMap.put("invoiceList", invoiceList);
            hashMap = resultMap;
            return hashMap;
        }
        finally {
            BillOperationLockUtil.unOperationLook((String)String.valueOf(orgId), billNos);
        }
    }

    public static void copySpecialInfoAndExtraInfo(List<DynamicObject> invoiceList, DynamicObject[] bills) {
        ArrayList<DynamicObject> redAllEInvoices = new ArrayList<DynamicObject>();
        ArrayList<String> redConfirmNos = new ArrayList<String>();
        QFilter filter = null;
        for (DynamicObject invoice : invoiceList) {
            String specialType = invoice.getString("specialtype");
            if ("00".equals(specialType) || StringUtils.isBlank((String)specialType)) continue;
            if (InvoiceUtils.isRedConfirmInvoice((String)invoice.getString("issuetype"), (String)invoice.getString("invoicetype"))) {
                redAllEInvoices.add(invoice);
            }
            if (StringUtils.isNotBlank((String)invoice.getString("infocode"))) {
                redConfirmNos.add(invoice.getString("infocode"));
            }
            if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("originalinvoicetype")) || !StringUtils.isNotBlank((String)invoice.getString("originalinvoiceno"))) continue;
            if (null == filter) {
                filter = new QFilter("invoiceno", "=", (Object)invoice.getString("originalinvoiceno"));
                continue;
            }
            filter = filter.or("invoiceno", "=", (Object)invoice.getString("originalinvoiceno"));
        }
        if (redAllEInvoices.size() == 0) {
            return;
        }
        HashMap<String, Object> redConfirmNoMap = new HashMap<String, Object>(redAllEInvoices.size());
        HashMap<String, DynamicObject> blueInvoiceMap = new HashMap<String, DynamicObject>(redAllEInvoices.size());
        if (redConfirmNos.size() > 0) {
            QFilter redConfirmFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceList.get(0).get("orgid"))).and("number", "in", redConfirmNos);
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])redConfirmFilter.toArray());
            DynamicObject[] dynamicObjectArray = redConfirms;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                Object redConfirm = dynamicObjectArray[i];
                redConfirmNoMap.put(redConfirm.getString("number"), redConfirm);
            }
        }
        if (null != filter) {
            DynamicObject[] blueInvs;
            for (DynamicObject blueInv : blueInvs = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray())) {
                blueInvoiceMap.put(blueInv.getString("invoiceno"), blueInv);
            }
        }
        HashMap<String, Object> redConfirmNoBillMap = new HashMap<String, Object>(redAllEInvoices.size());
        HashMap<String, Object> blueInvoiceNoBillMap = new HashMap<String, Object>(redAllEInvoices.size());
        if (null != bills) {
            for (DynamicObject bill : bills) {
                String infoCode = bill.getString("infocode");
                String blueInvoiceNo = bill.getString("blueinvoiceno");
                if (StringUtils.isNotBlank((String)infoCode)) {
                    redConfirmNoBillMap.put(infoCode, bill);
                }
                if (!StringUtils.isNotBlank((String)blueInvoiceNo)) continue;
                blueInvoiceNoBillMap.put(blueInvoiceNo, bill);
            }
        }
        for (DynamicObject invoice : redAllEInvoices) {
            DynamicObject bill;
            String infoCode = invoice.getString("infocode");
            String originalInvoiceNo = invoice.getString("originalinvoiceno");
            DynamicObject redConfirm = (DynamicObject)redConfirmNoMap.get(infoCode);
            DynamicObject blueInvoice = (DynamicObject)blueInvoiceMap.get(originalInvoiceNo);
            boolean isSetSpecialField = false;
            if (null != redConfirm) {
                isSetSpecialField = IssueInvoiceControlHelper.fillSpecialInfoFromRedConfirm(invoice, redConfirm, isSetSpecialField);
            }
            if (!isSetSpecialField && null != blueInvoice) {
                IssueInvoiceControlHelper.fillSpecialInfoFromBlueInvoice(invoice, blueInvoice);
            }
            if (null == (bill = (DynamicObject)redConfirmNoBillMap.get(infoCode))) {
                bill = (DynamicObject)blueInvoiceNoBillMap.get(originalInvoiceNo);
            }
            if (null == bill) continue;
            IssueInvoiceControlHelper.fillSpecialInfoFromBill(invoice, bill);
        }
    }

    private static void fillSpecialInfoFromBill(DynamicObject invoice, DynamicObject bill) {
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "landtaxno", "landtaxno");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "simpleaddress", "simpleaddress");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "detailaddress", "detailaddress");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "startleasedate", "startleasedate");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "endleasedate", "endleasedate");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "buildingname", "buildingname");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "crosscitysign", "crosscitysign");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "estateid", "estateid");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "areaunit", "areaunit");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "approvedprice", "approvedprice");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "actualturnover", "actualturnover");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "estatecode", "estatecode");
        IssueInvoiceControlHelper.setDefaultValueFromBill(bill, invoice, "crosscitytaxverifyno", "crosscitytaxverifyno");
        IssueInvoiceControlHelper.copySpecialItems(bill, invoice, "freights", false);
        IssueInvoiceControlHelper.copySpecialItems(bill, invoice, "estatesales", false);
        IssueInvoiceControlHelper.copySpecialItems(bill, invoice, "travelers", false);
        IssueInvoiceControlHelper.copySpecialItems(bill, invoice, "vehichevesselships", false);
    }

    private static void setDefaultValueFromBill(DynamicObject bill, DynamicObject invoice, String billKey, String invoiceKey) {
        Object targetValue = invoice.get(invoiceKey);
        boolean isValueEmpty = IssueInvoiceControlHelper.isValueEmpty(targetValue);
        if (isValueEmpty) {
            Object soruceValue = bill.get(billKey);
            invoice.set(invoiceKey, soruceValue);
        }
    }

    private static void fillSpecialInfoFromBlueInvoice(DynamicObject invoice, DynamicObject blueInvoice) {
        boolean isSetSpecialField = false;
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "landtaxno", "landtaxno", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "simpleaddress", "simpleaddress", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "detailaddress", "detailaddress", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "startleasedate", "startleasedate", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "endleasedate", "endleasedate", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "buildingname", "buildingname", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "crosscitysign", "crosscitysign", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "estateid", "estateid", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "areaunit", "areaunit", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "approvedprice", "approvedprice", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "actualturnover", "actualturnover", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "estatecode", "estatecode", isSetSpecialField);
        IssueInvoiceControlHelper.setValueIfEmpty(blueInvoice, invoice, "crosscitytaxverifyno", "crosscitytaxverifyno", isSetSpecialField);
        IssueInvoiceControlHelper.copySpecialItems(blueInvoice, invoice, "freights", true);
        IssueInvoiceControlHelper.copySpecialItems(blueInvoice, invoice, "estatesales", true);
        IssueInvoiceControlHelper.copySpecialItems(blueInvoice, invoice, "travelers", true);
        IssueInvoiceControlHelper.copySpecialItems(blueInvoice, invoice, "vehichevesselships", true);
    }

    private static void copySpecialItems(DynamicObject blueInvoice, DynamicObject invoice, String itemsKey, boolean isTargetEmptyFillValue) {
        int i;
        DynamicObjectCollection sourceItems = blueInvoice.getDynamicObjectCollection(itemsKey);
        DynamicObjectCollection targetItems = invoice.getDynamicObjectCollection(itemsKey);
        int difference = sourceItems.size() - targetItems.size();
        if (difference > 0) {
            for (i = 0; i < difference; ++i) {
                targetItems.addNew();
            }
        }
        for (i = 0; i < sourceItems.size(); ++i) {
            DynamicObject sourceItem = (DynamicObject)sourceItems.get(i);
            DynamicObject targetItem = (DynamicObject)targetItems.get(i);
            DataEntityPropertyCollection properties = sourceItem.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                Object sourceValue;
                boolean isValueEmpty;
                String name = property.getName();
                if (isTargetEmptyFillValue) {
                    Object targetValue;
                    if ("id".equals(name) || !(isValueEmpty = IssueInvoiceControlHelper.isValueEmpty(targetValue = targetItem.get(name)))) continue;
                    targetItem.set(name, sourceItem.get(name));
                    continue;
                }
                if ("id".equals(name) || (isValueEmpty = IssueInvoiceControlHelper.isValueEmpty(sourceValue = sourceItem.get(name)))) continue;
                targetItem.set(name, sourceItem.get(name));
            }
        }
    }

    private static boolean isValueEmpty(Object sourceValue) {
        boolean isValueEmpty = false;
        if (sourceValue instanceof BigDecimal && BigDecimalUtil.compareZero((BigDecimal)((BigDecimal)sourceValue))) {
            isValueEmpty = true;
        }
        if (sourceValue instanceof String && StringUtils.isBlank((String)((String)sourceValue))) {
            isValueEmpty = true;
        }
        if (null == sourceValue) {
            isValueEmpty = true;
        }
        if (sourceValue instanceof Long && 0L == (Long)sourceValue) {
            isValueEmpty = true;
        }
        if (sourceValue instanceof Integer && 0 == (Integer)sourceValue) {
            isValueEmpty = true;
        }
        return isValueEmpty;
    }

    private static boolean fillSpecialInfoFromRedConfirm(DynamicObject invoice, DynamicObject redConfirm, boolean isSetSpecialField) {
        DynamicObject targetItem;
        DynamicObject sourceItem;
        int i;
        int difference;
        String specialType = invoice.getString("specialtype");
        if ("E03".equals(specialType)) {
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "landtaxno", "landtaxno", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "simpleaddress", "simpleaddress", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "detailaddress", "detailaddress", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "startleasedate", "startleasedate", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "endleasedate", "endleasedate", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "buildingname", "buildingname", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "crosscitysign", "crosscitysign", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "estateid", "estateid", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "areaunit", "areaunit", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "approvedprice", "approvedprice", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "actualturnover", "actualturnover", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "estatecode", "estatecode", isSetSpecialField);
            isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(redConfirm, invoice, "crosscitytaxverifyno", "crosscitytaxverifyno", isSetSpecialField);
        }
        if ("E04".equals(specialType)) {
            DynamicObjectCollection freightItems = invoice.getDynamicObjectCollection("freights");
            DynamicObjectCollection confirmFreightItems = redConfirm.getDynamicObjectCollection("freights");
            difference = confirmFreightItems.size() - freightItems.size();
            if (confirmFreightItems.size() > 0) {
                if (difference > 0) {
                    for (i = 0; i < difference; ++i) {
                        freightItems.addNew();
                    }
                }
                for (i = 0; i < confirmFreightItems.size(); ++i) {
                    sourceItem = (DynamicObject)confirmFreightItems.get(i);
                    targetItem = (DynamicObject)freightItems.get(i);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "transporttype", "transporttype", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "startplace", "startplace", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "endplace", "endplace", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "licenseplate", "licenseplate", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "transportgoods", "transportgoods", isSetSpecialField);
                }
            }
        }
        if ("E09".equals(specialType)) {
            DynamicObjectCollection travelerItems = invoice.getDynamicObjectCollection("travelers");
            DynamicObjectCollection confirmTravelerItems = redConfirm.getDynamicObjectCollection("travelers");
            difference = confirmTravelerItems.size() - travelerItems.size();
            if (confirmTravelerItems.size() > 0) {
                if (difference > 0) {
                    for (i = 0; i < difference; ++i) {
                        travelerItems.addNew();
                    }
                }
                for (i = 0; i < confirmTravelerItems.size(); ++i) {
                    sourceItem = (DynamicObject)confirmTravelerItems.get(i);
                    targetItem = (DynamicObject)travelerItems.get(i);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "traveler", "traveler", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "travelercardtype", "travelercardtype", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "travelercardno", "travelercardno", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "traveldate", "traveldate", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "travelerstartplace", "travelerstartplace", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "travelerendplace", "travelerendplace", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "travelertransporttype", "travelertransporttype", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "travelerseatclass", "travelerseatclass", isSetSpecialField);
                }
            }
        }
        if ("E07".equals(specialType)) {
            DynamicObjectCollection shipItems = invoice.getDynamicObjectCollection("vehichevesselships");
            DynamicObjectCollection confirmShipItems = redConfirm.getDynamicObjectCollection("vehichevesselships");
            difference = confirmShipItems.size() - shipItems.size();
            if (confirmShipItems.size() > 0) {
                if (difference > 0) {
                    for (i = 0; i < difference; ++i) {
                        shipItems.addNew();
                    }
                }
                for (i = 0; i < confirmShipItems.size(); ++i) {
                    sourceItem = (DynamicObject)confirmShipItems.get(i);
                    targetItem = (DynamicObject)shipItems.get(i);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "policyno", "policyno", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "shipsno", "shipsno", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "perioddate", "perioddate", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "vehiclecode", "vehiclecode", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "vehiclevesselamount", "vehiclevesselamount", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "vehiclelateamount", "vehiclelateamount", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "vehicletotalamount", "vehicletotalamount", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "periodstartdate", "periodstartdate", isSetSpecialField);
                    isSetSpecialField = IssueInvoiceControlHelper.setValueIfEmpty(sourceItem, targetItem, "periodenddate", "periodenddate", isSetSpecialField);
                }
            }
        }
        return isSetSpecialField;
    }

    private static boolean setValueIfEmpty(DynamicObject redConfirm, DynamicObject invoice, String redConfirmKey, String invoiceFiledKey, boolean isSetNewValue) {
        Object sourceValue = redConfirm.get(redConfirmKey);
        boolean isValueEmpty = IssueInvoiceControlHelper.isValueEmpty(sourceValue);
        if (!isValueEmpty) {
            invoice.set(invoiceFiledKey, sourceValue);
            return true;
        }
        if (isSetNewValue) {
            return isSetNewValue;
        }
        return false;
    }

    private static void callBackThirdApiSystem(List<DynamicObject> invoiceList) {
        try {
            boolean hasField = DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)invoiceList.get(0), (String)"textfield1");
            if (!hasField) {
                return;
            }
            for (DynamicObject dynamicObject : invoiceList) {
                String systemSource = dynamicObject.getString("systemsource");
                if (!"BILL_CENTER".equals(systemSource)) continue;
                String systemCode = dynamicObject.getString("textfield1");
                LOGGER.info("callBackThirdApiSystem, systemSource:{}, systemCode:{}", (Object)systemSource, (Object)systemCode);
                if (!"FuShiImage".equals(systemCode) && !"9999".equals(systemCode)) continue;
                dynamicObject.set("systemsource", (Object)systemCode);
                new ExternalSystemDataHandler().dealUpdateOpenInvoiceStatus(dynamicObject, null);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static DynamicObject[] getAllInvoices(List<BillRelationDTO> invRelation) {
        ArrayList<Long> invoicePks = new ArrayList<Long>();
        for (BillRelationDTO billRelationDTO : invRelation) {
            invoicePks.add(billRelationDTO.gettBillId());
        }
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"mergelable", (QFilter[])new QFilter("id", "in", (Object)invoicePks.toArray()).toArray());
    }

    private static void doOriginalTaxDeviation(List<DynamicObject> mergeBills, List<BillRelationDTO> billRelationList, List<BillRelationDTO> invoiceRelationList) {
        Map<Long, List<BillRelationDTO>> billRelationMap = billRelationList.stream().collect(Collectors.groupingBy(BillRelationDTO::gettDetailId));
        List invoiceRelations = invoiceRelationList.stream().filter(relation -> relation.getTaxDeviation().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        for (BillRelationDTO invoiceRelation : invoiceRelations) {
            List<BillRelationDTO> billRelations = billRelationMap.get(invoiceRelation.getsDetailId());
            if (CollectionUtils.isEmpty(billRelations)) continue;
            billRelations.stream().max(Comparator.comparing(BillRelationDTO::getTax)).ifPresent(relation -> {
                relation.setTax(relation.getTax().subtract(invoiceRelation.getTaxDeviation()));
                relation.setAmount(relation.getAmount().add(invoiceRelation.getTaxDeviation()));
            });
        }
        for (DynamicObject mergeBill : mergeBills) {
            DynamicObjectCollection mergeBillItems = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject mergeBillItem : mergeBillItems) {
                List<BillRelationDTO> relations;
                BigDecimal taxdeviation = mergeBillItem.getBigDecimal("taxdeviation");
                if (taxdeviation.compareTo(BigDecimal.ZERO) == 0 || CollectionUtils.isEmpty(relations = billRelationMap.get(mergeBillItem.getLong("id")))) continue;
                relations.stream().max(Comparator.comparing(BillRelationDTO::getTax)).ifPresent(relation -> {
                    relation.setTax(relation.getTax().subtract(taxdeviation));
                    relation.setAmount(relation.getAmount().add(taxdeviation));
                });
            }
        }
    }

    private static Map<String, String> checkMerge(DynamicObject[] bills, MergeResponseDTO mergeResponseDTO) {
        Map<String, DynamicObject> origBillMap = Arrays.stream(bills).collect(Collectors.groupingBy(e -> e.getString("billno"), Collectors.collectingAndThen(Collectors.toList(), v -> (DynamicObject)v.get(0))));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        for (DynamicObject bill : mergeResponseDTO.getBills()) {
            String[] split;
            if (!BigDecimalUtil.lessZero((BigDecimal)bill.getBigDecimal("totalamount"))) continue;
            String billNos = bill.getString("billno");
            for (String billNo : split = StringUtils.split((String)billNos, (char)',')) {
                DynamicObject errorBill = origBillMap.get(billNo);
                String showTip = "";
                String billProperties = errorBill.getString("billproperties");
                String invoiceType = errorBill.getString("invoicetype");
                if ("-1".equals(billProperties) && !BillHelper.isFilledBlue((DynamicObject)errorBill)) {
                    if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                        showTip = String.format(ResManager.loadKDString((String)"%1$s:\u6b63\u8d1f\u6570\u5355\u636e\u5408\u5e76\u6210\u8d1f\u6570\u5355\u636e\u5931\u8d25\uff0c\u8d1f\u6570\u6570\u7535\u9700\u8981\u8865\u5145\u539f\u84dd\u7968\u4fe1\u606f\u3002%2$s", (String)"IssueInvoiceControlHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), errorBill.getString("billno"), "<br>");
                    } else if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
                        showTip = String.format(ResManager.loadKDString((String)"%1$s:\u6b63\u8d1f\u6570\u5355\u636e\u5408\u5e76\u6210\u8d1f\u6570\u5355\u636e\u5931\u8d25\uff0c\u8d1f\u6570\u666e\u7968\u9700\u8981\u8865\u5145\u539f\u84dd\u7968\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u3002%2$s", (String)"IssueInvoiceControlHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), errorBill.getString("billno"), "<br>");
                    } else if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                        String applicant = errorBill.getString("applicant");
                        if (StringUtils.isNotBlank((String)applicant)) {
                            if (RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applicant)) {
                                showTip = String.format(ResManager.loadKDString((String)"%1$s:\u8d2d\u65b9\u7533\u8bf7\u7684\u8d1f\u6570\u4e13\u7968\u5355\u636e\u5fc5\u987b\u586b\u5199\u7ea2\u5b57\u4fe1\u606f\u7f16\u53f7\u4fe1\u606f\u624d\u80fd\u5f00\u7968\u3002%2$s", (String)"IssueInvoiceControlHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), "<br>");
                            } else if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
                                showTip = String.format(ResManager.loadKDString((String)"%1$s:\u9500\u65b9\u7533\u8bf7\u7684\u8d1f\u6570\u4e13\u7968\u5355\u636e\u5fc5\u987b\u586b\u5199\u7ea2\u5b57\u4fe1\u606f\u8868\u6807\u53f7\u6216\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u624d\u80fd\u5f00\u7968\u3002%2$s", (String)"IssueInvoiceControlHelper_4", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), "<br>");
                            }
                        } else {
                            showTip = String.format(ResManager.loadKDString((String)"%1$s:\u8d1f\u6570\u4e13\u7968\u5355\u636e\u5fc5\u987b\u586b\u7533\u8bf7\u65b9\u4ee5\u53ca\u3010\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7/\u7ea2\u5b57\u786e\u8ba4\u5355\u3011\u6216\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u624d\u80fd\u5f00\u7968\u3002%2$s", (String)"IssueInvoiceControlHelper_5", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), "<br>");
                        }
                    }
                    resultMap.put(billNo, showTip);
                    continue;
                }
                if (!"1".equals(errorBill.getString("billproperties"))) continue;
                showTip = String.format(ResManager.loadKDString((String)"%s:\u6b63\u8d1f\u6570\u5355\u636e\u5408\u5e76\u6210\u8d1f\u6570\u5355\u636e\u5931\u8d25\u3002", (String)"IssueInvoiceControlHelper_6", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                resultMap.put(billNo, showTip);
            }
        }
        return resultMap;
    }

    public static List<DynamicObject> saveInvRelation(List<BillRelationDTO> invRelation) {
        return IssueInvoiceControlHelper.saveInvRelation(invRelation, "sim_bill_inv_relation");
    }

    public static List<DynamicObject> saveInvRelation(List<BillRelationDTO> invRelation, String tableId) {
        ArrayList<DynamicObject> relation = new ArrayList<DynamicObject>(invRelation.size());
        if (invRelation.size() > 0) {
            for (BillRelationDTO billRelationDTO : invRelation) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)tableId);
                DynamicObjectUtil.bean2DynamicObject((Object)billRelationDTO, (DynamicObject)dynamicObject);
                relation.add(dynamicObject);
            }
            ImcSaveServiceHelper.save(relation);
        }
        return relation;
    }

    public static void issueInvoice(DynamicObject[] bills, Integer autoInvoice, boolean isMergeBill, boolean isMergeBillDetail, String channelType) {
        if (bills.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u6570\u636e\u4e0d\u5b58\u5728", (String)"IssueInvoiceControlHelper_7", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        LOGGER.info("issueInvoice, bills:{}, channelType:{}", (Object)bills.length, (Object)channelType);
        Map<String, List<DynamicObject>> billMap = Stream.of(bills).collect(Collectors.groupingBy(k -> k.getString("jqbh")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = billMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            Map<String, Object> resultMap = IssueInvoiceControlHelper.issueInvoice(entry.getValue().toArray(new DynamicObject[0]), entry.getKey(), null, "", autoInvoice, isMergeBill, isMergeBillDetail);
            if (!resultMap.containsKey("failedInfo")) continue;
            Map failedInfoMap = (Map)resultMap.get("failedInfo");
            for (Map.Entry entryObject : failedInfoMap.entrySet()) {
                String message = (String)entryObject.getValue();
                if (!StringUtils.isNotEmpty((String)message)) continue;
                throw new KDBizException(message);
            }
        }
    }

    @SdkDeprecated
    public static void issueInvoice(DynamicObject[] bills, Integer autoInvoice, boolean isMergeBill, boolean isMergeBillDetail) {
        if (bills.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u6570\u636e\u4e0d\u5b58\u5728", (String)"IssueInvoiceControlHelper_7", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        Map<String, List<DynamicObject>> billMap = Stream.of(bills).collect(Collectors.groupingBy(k -> k.getString("jqbh")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = billMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            IssueInvoiceControlHelper.issueInvoice(entry.getValue().toArray(new DynamicObject[0]), entry.getKey(), null, OpenApiInterfaceCodeEnum.BILL_PUSH.getCode(), autoInvoice, isMergeBill, isMergeBillDetail);
        }
    }

    public static DynamicObject[] findRelateInvoice(List<Long> pkList) {
        QFilter isCancelFilter = new QFilter("iscancel", "!=", (Object)BillRelateInvoicesConstant.IsCancelEnum.YES);
        DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)"serialno", (QFilter[])new QFilter("originalbillid", "in", (Object)pkList.toArray()).and(isCancelFilter).toArray());
        HashSet<String> typeSet = new HashSet<String>(4);
        if (dbRelate != null && dbRelate.length > 0) {
            for (DynamicObject invoice : dbRelate) {
                typeSet.add(invoice.getString("serialno"));
            }
        }
        if (typeSet.size() > 0) {
            return BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)String.join((CharSequence)",", "id", "originalbillid"), (QFilter[])new QFilter("serialno", "in", (Object)typeSet.toArray()).and(BillHelper.notCancelFilter()).toArray());
        }
        return null;
    }

    public static void setOriginalBillByInvRelation(List<DynamicObject> origSuccessBills, List<BillRelationDTO> invRelations) {
        if (CollectionUtils.isEmpty(origSuccessBills) || CollectionUtils.isEmpty(invRelations)) {
            return;
        }
        Map<Long, List<BillRelationDTO>> billRelationMap = invRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::getsDetailId));
        for (DynamicObject origBill : origSuccessBills) {
            boolean isTax = "1".equals(origBill.getString("hsbz"));
            boolean isRelation = invRelations.stream().filter(Relation -> Relation.getsBillId().equals(origBill.getPkValue())).anyMatch(relation -> "-1".equals(relation.getPushType()));
            if (isRelation) {
                IssueInvoiceControlHelper.setOriginalAllConfirmed(origBill);
                continue;
            }
            BigDecimal confirmAmount = origBill.getBigDecimal("confirmamount");
            BigDecimal mainTaxDeviation = origBill.getBigDecimal("maintaxdeviation");
            DynamicObjectCollection items = origBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                BigDecimal amountSum = BigDecimal.ZERO;
                BigDecimal numSum = BigDecimal.ZERO;
                BigDecimal taxSum = BigDecimal.ZERO;
                List<BillRelationDTO> relations = billRelationMap.get(item.getLong("id"));
                if (CollectionUtils.isNotEmpty(relations)) {
                    for (BillRelationDTO relation2 : relations) {
                        confirmAmount = confirmAmount.add(relation2.getAmount().add(isTax ? relation2.getTax() : BigDecimal.ZERO));
                        amountSum = amountSum.add(relation2.getAmount());
                        numSum = numSum.add(relation2.getNum());
                        taxSum = taxSum.add(relation2.getTax());
                    }
                }
                BigDecimal remainValidAmount = item.getBigDecimal("remainvalidamount").subtract(isTax ? item.getBigDecimal("remainvalidtax") : BigDecimal.ZERO);
                item.set("amountdeviation", (Object)item.getBigDecimal("amountdeviation").add(remainValidAmount.subtract(amountSum)));
                item.set("numdeviation", (Object)item.getBigDecimal("numdeviation").add(item.getBigDecimal("remainvalidnum").subtract(numSum)));
                BigDecimal taxDeviation = item.getBigDecimal("remainvalidtax").subtract(taxSum);
                item.set("taxdeviation", (Object)item.getBigDecimal("taxdeviation").add(taxDeviation));
                item.set("remainvalidamount", (Object)BigDecimal.ZERO);
                item.set("remainvalidtax", (Object)BigDecimal.ZERO);
                item.set("remainvalidnum", (Object)BigDecimal.ZERO);
                if (!item.getBoolean("gift") && item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
                    item.set("zeropushflag", (Object)"1");
                }
                mainTaxDeviation = mainTaxDeviation.add(taxDeviation);
            }
            origBill.set("maintaxdeviation", (Object)mainTaxDeviation);
            origBill.set("confirmamount", (Object)confirmAmount);
            origBill.set("confirmstate", (Object)"2");
            IssueInvoiceControlHelper.foreignCurrencyDeviation(origBill);
        }
        ImcSaveServiceHelper.update(origSuccessBills);
    }

    private static void foreignCurrencyDeviation(DynamicObject bill) {
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        if (!CurrencyHelper.isFrom((Object)fromCurr)) {
            return;
        }
        BigDecimal formTaxDeviationSum = BigDecimal.ZERO;
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            BigDecimal taxDeviation = item.getBigDecimal("taxdeviation");
            if (MathUtils.isNullOrZero((BigDecimal)taxDeviation)) continue;
            BigDecimal fromTax = item.getBigDecimal("fromtax");
            BigDecimal fromTaxDeviation = fromTax.multiply(taxDeviation.divide(item.getBigDecimal("tax"), 100, 4)).setScale(fromCurr.getInt("amtprecision"), 4);
            item.set("fromtaxdeviation", (Object)fromTaxDeviation);
            formTaxDeviationSum = formTaxDeviationSum.add(fromTaxDeviation);
        }
        bill.set("foreigntaxdifference", (Object)formTaxDeviationSum);
    }

    public static void setOriginalAllConfirmed(DynamicObject bill) {
        boolean isTax = "1".equals(bill.getString("hsbz"));
        bill.set("confirmamount", (Object)bill.getBigDecimal(isTax ? "totalamount" : "invoiceamount"));
        bill.set("confirmstate", (Object)"2");
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.set("remainvalidamount", (Object)BigDecimal.ZERO);
            item.set("remainvalidtax", (Object)BigDecimal.ZERO);
            item.set("remainvalidnum", (Object)BigDecimal.ZERO);
            if (item.getBoolean("gift") || item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0) continue;
            item.set("zeropushflag", (Object)"1");
        }
    }

    public static void setSplitOriginalBillByInvRelation(List<DynamicObject> origSuccessBills, List<BillRelationDTO> invRelation) {
        DynamicObject[] bills;
        if (CollectionUtils.isEmpty(origSuccessBills) || CollectionUtils.isEmpty(invRelation)) {
            return;
        }
        for (DynamicObject original : bills = BusinessDataServiceHelper.load((Object[])origSuccessBills.stream().map(bill -> bill.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) {
            original.set("comprehensivestatus", origSuccessBills.get(0).get("comprehensivestatus"));
            original.set("operatebatch", origSuccessBills.get(0).get("operatebatch"));
        }
        if (invRelation.stream().anyMatch(relation -> relation.getsDetailId() == null)) {
            for (DynamicObject bill2 : bills) {
                IssueInvoiceControlHelper.setOriginalAllConfirmed(bill2);
            }
            ImcSaveServiceHelper.update((DynamicObject[])bills);
            return;
        }
        Map<Long, List<BillRelationDTO>> billRelationMap = invRelation.stream().collect(Collectors.groupingBy(BillRelationDTO::getsDetailId));
        for (DynamicObject origBill : bills) {
            boolean isTax = "1".equals(origBill.getString("hsbz"));
            BigDecimal confirmamount = origBill.getBigDecimal("confirmamount");
            boolean isDetailAllConfirm = true;
            DynamicObjectCollection items = origBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                List<BillRelationDTO> relations = billRelationMap.get(item.getLong("id"));
                BigDecimal remainValidAmount = item.getBigDecimal("remainvalidamount");
                BigDecimal remainValidTax = item.getBigDecimal("remainvalidtax");
                BigDecimal remainValidNum = item.getBigDecimal("remainvalidnum");
                if (CollectionUtils.isNotEmpty(relations)) {
                    for (BillRelationDTO relation2 : relations) {
                        confirmamount = confirmamount.add(relation2.getAmount().add(isTax ? relation2.getTax() : BigDecimal.ZERO));
                        remainValidTax = remainValidTax.subtract(relation2.getTax());
                        remainValidNum = remainValidNum.subtract(relation2.getNum());
                        remainValidAmount = remainValidAmount.subtract(relation2.getAmount().add(isTax ? relation2.getTax() : BigDecimal.ZERO));
                    }
                }
                item.set("remainvalidamount", (Object)remainValidAmount);
                item.set("remainvalidtax", (Object)remainValidTax);
                item.set("remainvalidnum", (Object)remainValidNum);
                if (remainValidAmount.compareTo(BigDecimal.ZERO) == 0 || remainValidAmount.add(remainValidTax).compareTo(BigDecimal.ZERO) == 0) continue;
                isDetailAllConfirm = false;
            }
            origBill.set("confirmamount", (Object)confirmamount);
            if (isDetailAllConfirm) {
                origBill.set("confirmstate", (Object)"2");
                continue;
            }
            origBill.set("confirmstate", (Object)"1");
        }
        ImcSaveServiceHelper.update((DynamicObject[])bills);
    }

    private static void saveMatchInvRelation(List<BillRelationDTO> invRelation, List<BillRelationDTO> matchRelation, DynamicObject redConfirm, boolean isApplyError) {
        ArrayList<BillRelationDTO> matchInvRelation = new ArrayList<BillRelationDTO>(invRelation);
        HashSet<String> billNoSet = new HashSet<String>(matchInvRelation.size());
        for (BillRelationDTO billRelationDTO : matchRelation) {
            for (BillRelationDTO matchInv : matchInvRelation) {
                if (!matchInv.getsBillNo().equals(billRelationDTO.getsBillNo()) || !matchInv.gettBillNo().equals(redConfirm.getString("billno"))) continue;
                matchInv.setsBillId(billRelationDTO.gettBillId());
                matchInv.setsDetailId(billRelationDTO.gettDetailId());
                matchInv.settBillId((Long)redConfirm.getPkValue());
            }
            billNoSet.add(billRelationDTO.getsBillNo());
        }
        for (String billNo : billNoSet) {
            DynamicObject matchBill;
            DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)"infocode,comprehensivestatus,blueinvoiceno", (QFilter[])new QFilter("billno", "=", (Object)billNo).toArray());
            if (isApplyError) {
                originalBill.set("comprehensivestatus", (Object)"38");
            } else if (StringUtils.isNotBlank((String)originalBill.getString("infocode"))) {
                originalBill.set("comprehensivestatus", (Object)"41");
            } else {
                originalBill.set("comprehensivestatus", (Object)"37");
            }
            ImcSaveServiceHelper.save((DynamicObject)originalBill);
            DynamicObject blueInvoice = null;
            if (StringUtils.isBlank((String)originalBill.getString("infocode"))) {
                blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("invoiceno", "=", (Object)originalBill.getString("blueinvoiceno")).toArray());
            }
            if ((matchBill = BusinessDataServiceHelper.loadSingle((String)"sim_match_bill", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billNo).toArray())) == null) continue;
            matchBill = BusinessDataServiceHelper.loadSingle((Object)matchBill.getPkValue(), (String)"sim_match_bill");
            DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject matchItem = (DynamicObject)items.get(i);
                matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                if (blueInvoice == null) {
                    DynamicObjectCollection redConfirmItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
                    DynamicObject redConfirmItem = redConfirmItems.addNew();
                    redConfirmItem.set("confirminfocode", (Object)redConfirm.getString("number"));
                    redConfirmItem.set("redconfirmpk", redConfirm.getPkValue());
                    redConfirmItem.set("confirmoriinvoicecode", (Object)redConfirm.getString("originalinvoicecode"));
                    redConfirmItem.set("confirmoriinvoiceno", (Object)redConfirm.getString("originalinvoiceno"));
                    continue;
                }
                DynamicObjectCollection oriInvoiceItems = matchItem.getDynamicObjectCollection("subentryentity");
                DynamicObject oriItem = oriInvoiceItems.addNew();
                oriItem.set("oriinvoiceid", blueInvoice.getPkValue());
                oriItem.set("oriitemseq", (Object)-1);
                oriItem.set("infocode", (Object)redConfirm.getString("number"));
                oriItem.set("oriinvoicecode", (Object)blueInvoice.getString("invoicecode"));
                oriItem.set("oriinvoiceno", (Object)blueInvoice.getString("invoiceno"));
                oriItem.set("pushstatus", (Object)"1");
                oriItem.set("oriitemamount", (Object)blueInvoice.getBigDecimal("invoiceamount"));
                oriItem.set("oriitemtax", (Object)blueInvoice.getBigDecimal("totaltax"));
            }
            matchBill.set("matchamount", (Object)redConfirm.getBigDecimal("invoiceamount"));
            matchBill.set("matchtax", (Object)redConfirm.getBigDecimal("totaltax"));
            matchBill.set("matchtotalamount", (Object)redConfirm.getBigDecimal("totalamount"));
            matchBill.set("pushdownamount", matchBill.get("applyamount"));
            matchBill.set("pushdowntax", matchBill.get("applytax"));
            matchBill.set("pushdowninvoicenum", (Object)1);
            ImcSaveServiceHelper.save((DynamicObject)matchBill);
        }
        IssueInvoiceControlHelper.saveInvRelation(matchInvRelation, "sim_match_inv_relation");
    }

    private static void createMergeOrMatchBill(List<String> billNos, long orgId, MergeResponseDTO mergeResponseDTO, List<BillRelationDTO> invRelation, List<BillRelationDTO> matchRelation) {
        String operateBatch = new AllEBillCommonCustomEvent().getOperateBatch();
        List mergeBillList = mergeResponseDTO.getBills();
        ArrayList<DynamicObject> positiveBillList = new ArrayList<DynamicObject>(mergeBillList.size());
        for (DynamicObject mergeBill : mergeBillList) {
            if (mergeBill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) <= 0) continue;
            positiveBillList.add(mergeBill);
        }
        QFilter qFilter = new QFilter("billno", "in", billNos);
        qFilter.and("orgid", "=", (Object)orgId);
        DynamicObject[] originalBillList = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty(positiveBillList)) {
            ArrayList<DynamicObject> mergeBills = new ArrayList<DynamicObject>(mergeBillList.size());
            for (DynamicObject bill : positiveBillList) {
                DynamicObject mergeBill = new AllEBillTabCustomEvent().createMergeBill(bill, operateBatch);
                mergeBill.set("billno", (Object)bill.getString("billno").split(",")[0]);
                mergeBills.add(mergeBill);
            }
            ImcSaveServiceHelper.save(mergeBills);
            for (DynamicObject bill : originalBillList) {
                if (!"08".equals(bill.get("comprehensivestatus"))) {
                    bill.set("comprehensivestatus", (Object)"02");
                }
                bill.set("operatebatch", (Object)(operateBatch + "blue"));
            }
            ImcSaveServiceHelper.save((DynamicObject[])originalBillList);
            List billRelations = mergeResponseDTO.getRelations();
            IssueInvoiceControlHelper.saveInvRelation(billRelations, "sim_mergebill_relation");
            for (BillRelationDTO invRelationDTO : invRelation) {
                for (BillRelationDTO billRelation : billRelations) {
                    if (!billRelation.getsDetailId().toString().equals(invRelationDTO.getsDetailId().toString())) continue;
                    invRelationDTO.setsBillId(billRelation.gettBillId());
                    invRelationDTO.setsDetailId(billRelation.gettDetailId());
                }
            }
            IssueInvoiceControlHelper.saveInvRelation(invRelation, "sim_merge_inv_relation");
        } else if (!mergeBillList.isEmpty()) {
            ArrayList<DynamicObject> matchBills = new ArrayList<DynamicObject>(mergeBillList.size());
            for (DynamicObject bill : originalBillList) {
                bill.set("comprehensivestatus", (Object)"35");
                bill.set("operatebatch", (Object)(operateBatch + "red"));
                DynamicObject matchBill = IssueInvoiceControlHelper.createMatchBillByOriginalBill(bill, operateBatch + "red", matchRelation);
                if (StringUtils.isNotBlank((String)bill.getString("infocode"))) {
                    matchBill.set("matchtarget", (Object)"2");
                } else {
                    matchBill.set("matchtarget", (Object)"3");
                }
                matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                matchBill.set("pushdownstatus", (Object)"2");
                matchBill.set("matchtype", (Object)"0");
                matchBill.set("matchinvoicenum", (Object)1);
                matchBills.add(matchBill);
            }
            ImcSaveServiceHelper.save(matchBills);
            IssueInvoiceControlHelper.saveInvRelation(matchRelation, "sim_matchbill_relation");
            ImcSaveServiceHelper.save((DynamicObject[])originalBillList);
        }
    }

    public static DynamicObject createMatchBillByOriginalBill(DynamicObject originalBill, String matchBatch, List<BillRelationDTO> matchRelation) {
        DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)originalBill, (DynamicObject)matchBill);
        long sBillId = DBServiceHelper.genGlobalLongId();
        matchBill.set("id", (Object)sBillId);
        String billNo = originalBill.getString("billno").split(",")[0];
        matchBill.set("billno", (Object)billNo);
        matchBill.set("matchbatch", (Object)matchBatch);
        matchBill.set("billno", (Object)MinusBillMatchHelper.getMergeBillNoFirst(matchBill.getString("billno")));
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            BillRelationDTO billRelationDTO = new BillRelationDTO();
            billRelationDTO.setsBillId(Long.valueOf(originalBill.getLong("id")));
            billRelationDTO.setsBillNo(billNo);
            billRelationDTO.settBillNo(billNo);
            billRelationDTO.setsDetailId((Long)item.getPkValue());
            billRelationDTO.setAmount(item.getBigDecimal("remainvalidamount").subtract(item.getBigDecimal("remainvalidtax")));
            billRelationDTO.setTax(item.getBigDecimal("remainvalidtax"));
            billRelationDTO.setPrice(item.getBigDecimal("unitprice"));
            billRelationDTO.setNum(item.getBigDecimal("remainvalidnum"));
            billRelationDTO.settBillId(Long.valueOf(sBillId));
            DynamicObject matchItem = matchItems.addNew();
            DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)item, (DynamicObject)matchItem);
            long sDetailId = DBServiceHelper.genGlobalLongId();
            matchItem.set("id", (Object)sDetailId);
            billRelationDTO.settDetailId(Long.valueOf(sDetailId));
            SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)item);
            matchItem.set("goodsname", (Object)item.getString("goodsname"));
            matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
            matchItem.set("amount", (Object)item.getBigDecimal("remainvalidamount").subtract(item.getBigDecimal("remainvalidtax")));
            matchItem.set("tax", (Object)item.getBigDecimal("remainvalidtax"));
            matchItem.set("num", (Object)item.getBigDecimal("remainvalidnum"));
            matchRelation.add(billRelationDTO);
        }
        matchBill.set("applyamount", (Object)originalBill.getBigDecimal("invoiceamount"));
        matchBill.set("applytax", (Object)originalBill.getBigDecimal("totaltax"));
        matchBill.set("applytotalamount", (Object)originalBill.getBigDecimal("totalamount"));
        matchBill.set("billstatus", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
        matchBill.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        matchBill.set("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid")));
        matchBill.set("matchrule", null);
        matchBill.set("remark", (Object)originalBill.getString("invoiceremark"));
        matchBill.set("pushdownstatus", (Object)"0");
        matchBill.set("matchtime", (Object)new Date());
        matchBill.set("matchstatus", (Object)"");
        matchBill.set("matchtarget", (Object)"");
        return matchBill;
    }
}

