/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.AllELqInvoiceConstant;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.BillDeductionItemVo;
import kd.imc.bdm.common.dto.BillFreightItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillCoBuyerItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.enums.AllEPrivilegeTypeEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.BaseInvoiceItem;
import kd.imc.bdm.common.util.BeanUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ViewBuildInvoiceHelper {
    public static void dealFreightItems(AbstractFormPlugin plugin, DynamicObject waitInvoiceDynamicObject) {
        if (!"E04".equals(waitInvoiceDynamicObject.getString("specialtype"))) {
            return;
        }
        String freights = plugin.getPageCache().get("freightItem");
        DynamicObjectCollection freightItems = waitInvoiceDynamicObject.getDynamicObjectCollection("freights");
        freightItems.clear();
        if (StringUtils.isNotEmpty((CharSequence)freights)) {
            JSONArray dedcArray = JSONObject.parseArray((String)freights);
            int rowIndex = 1;
            for (Object o : dedcArray) {
                JSONObject row = (JSONObject)o;
                DynamicObject item = freightItems.addNew();
                item.set("startplace", row.get((Object)"startplace"));
                item.set("endplace", row.get((Object)"endplace"));
                item.set("transporttype", row.get((Object)"transporttype"));
                item.set("licenseplate", row.get((Object)"licenseplate"));
                item.set("transportgoods", row.get((Object)"transportgoods"));
                ++rowIndex;
            }
        }
    }

    public static void dealVesselShipItems(AbstractFormPlugin plugin, DynamicObject invoiceDynamicObject) {
        if ("E07".equals(invoiceDynamicObject.getString("specialtype"))) {
            String billNo = invoiceDynamicObject.getString("billno");
            DynamicObjectCollection itemObjectCollection = invoiceDynamicObject.getDynamicObjectCollection("items");
            for (DynamicObject itemObject : itemObjectCollection) {
                String unit = itemObject.getString("unit");
                String rowtype = itemObject.getString("rowtype");
                if (!"2".equals(rowtype) && !"0".equals(rowtype) || "\u8f86".equals(unit)) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"BillValidaterHelper_124", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                throw new MsgException(errorMsg);
            }
            String vesselShipList = plugin.getPageCache().get("vesselShipItem");
            DynamicObjectCollection vesselShipCollection = invoiceDynamicObject.getDynamicObjectCollection("vehichevesselships");
            if (!vesselShipCollection.isEmpty()) {
                vesselShipCollection.clear();
            }
            if (StringUtils.isBlank((CharSequence)vesselShipList) || "[]".equals(vesselShipList)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u660e\u7ec6\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!", (String)"BillValidaterHelper_134", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                throw new MsgException(errorMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)vesselShipList)) {
                JSONArray jsonArray = JSONObject.parseArray((String)vesselShipList);
                boolean flag = ViewBuildInvoiceHelper.checkVesselShipIsAllNull(jsonArray);
                if (flag) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u660e\u7ec6\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!", (String)"BillValidaterHelper_134", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                    throw new MsgException(errorMsg);
                }
                for (Object object : jsonArray) {
                    Object[] array;
                    JSONObject jsonObject = (JSONObject)object;
                    String policyNo = jsonObject.getString("policyno");
                    String vehiclecode = jsonObject.getString("vehiclecode");
                    String shipsNo = jsonObject.getString("shipsno");
                    String perioddate = jsonObject.getString("perioddate");
                    BigDecimal vehiclevesselamount = jsonObject.getBigDecimal("vehiclevesselamount");
                    BigDecimal vehiclelateamount = jsonObject.getBigDecimal("vehiclelateamount");
                    BigDecimal vehicletotalamount = jsonObject.getBigDecimal("vehicletotalamount");
                    for (Object element : array = new Object[]{policyNo, vehiclecode, shipsNo, perioddate, vehiclevesselamount, vehiclelateamount, vehicletotalamount}) {
                        if (!StringUtils.isBlank((Object)element)) continue;
                        String errorMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u4fdd\u9669\u5355\u53f7\u3001\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u3001\u91d1\u989d\u7b49\u7279\u5b9a\u4fe1\u606f\u5fc5\u586b!", (String)"BillValidaterHelper_135", (String)"imc-sim-service", (Object[])new Object[0]);
                        throw new MsgException(errorMsg);
                    }
                    DynamicObject vesselShipItem = vesselShipCollection.addNew();
                    vesselShipItem.set("policyno", (Object)policyNo);
                    vesselShipItem.set("vehiclecode", (Object)vehiclecode);
                    vesselShipItem.set("perioddate", (Object)perioddate);
                    String[] periodDateArray = perioddate.split(" ");
                    String periodStartDate = periodDateArray[0];
                    String periodEndDate = periodDateArray[1];
                    if (StringUtils.isBlank((CharSequence)periodStartDate) || StringUtils.isBlank((CharSequence)periodEndDate)) {
                        String errorMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u5b57\u6bb5\u5fc5\u586b!", (String)"BillValidaterHelper_137", (String)"imc-sim-service", (Object[])new Object[0]);
                        throw new MsgException(errorMsg);
                    }
                    vesselShipItem.set("periodstartdate", (Object)DateUtils.stringToDate((String)periodStartDate, (String)"yyyy-MM"));
                    vesselShipItem.set("periodenddate", (Object)DateUtils.stringToDate((String)periodEndDate, (String)"yyyy-MM"));
                    vesselShipItem.set("shipsno", (Object)shipsNo);
                    vesselShipItem.set("vehiclevesselamount", (Object)vehiclevesselamount);
                    vesselShipItem.set("vehiclelateamount", (Object)vehiclelateamount);
                    vesselShipItem.set("vehicletotalamount", (Object)vehicletotalamount);
                }
            }
        }
    }

    public static void dealTravelrItems(AbstractFormPlugin plugin, DynamicObject invoiceDynamicObject) {
        if ("E09".equals(invoiceDynamicObject.getString("specialtype"))) {
            DynamicObjectCollection itemObjectCollection = invoiceDynamicObject.getDynamicObjectCollection("items");
            int count = ViewBuildInvoiceHelper.countItemNumMethod(itemObjectCollection);
            if (count > 1) {
                String errorMsg = ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"BillValidaterHelper_129", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new MsgException(errorMsg);
            }
            String travelerList = plugin.getPageCache().get("travelerItem");
            DynamicObjectCollection travelerCollection = invoiceDynamicObject.getDynamicObjectCollection("travelers");
            if (!travelerCollection.isEmpty()) {
                travelerCollection.clear();
            }
            if (StringUtils.isNotEmpty((CharSequence)travelerList)) {
                JSONArray jsonArray = JSONObject.parseArray((String)travelerList);
                boolean flag = ViewBuildInvoiceHelper.checkTravelerIsAllNull(jsonArray);
                if (flag) {
                    return;
                }
                for (Object object : jsonArray) {
                    JSONObject jsonObject = (JSONObject)object;
                    String traveler = jsonObject.getString("traveler");
                    String startPlace = jsonObject.getString("travelerstartplace");
                    String endPlace = jsonObject.getString("travelerendplace");
                    String transportType = jsonObject.getString("travelertransporttype");
                    String cardNo = jsonObject.getString("travelercardno");
                    String cardType = jsonObject.getString("travelercardtype");
                    String seatClass = jsonObject.getString("travelerseatclass");
                    String travelDate = jsonObject.getString("traveldate");
                    DynamicObject travelerItem = travelerCollection.addNew();
                    travelerItem.set("traveler", (Object)traveler);
                    travelerItem.set("travelerstartplace", (Object)startPlace);
                    travelerItem.set("travelerendplace", (Object)endPlace);
                    travelerItem.set("travelertransporttype", (Object)transportType);
                    travelerItem.set("travelercardno", (Object)cardNo);
                    travelerItem.set("travelercardtype", (Object)cardType);
                    travelerItem.set("travelerseatclass", (Object)seatClass);
                    travelerItem.set("traveldate", (Object)DateUtils.stringToDate((String)travelDate));
                }
            }
        }
    }

    private static int countItemNumMethod(DynamicObjectCollection itemObjectCollection) {
        int count = 0;
        if (itemObjectCollection != null && !itemObjectCollection.isEmpty()) {
            for (DynamicObject dynamicObject : itemObjectCollection) {
                String rowtype = dynamicObject.getString("rowtype");
                if (!"0".equals(rowtype) && !"2".equals(rowtype)) continue;
                ++count;
            }
        }
        return count;
    }

    private static boolean checkVesselShipIsAllNull(JSONArray jsonArray) {
        int num = 0;
        for (Object object : jsonArray) {
            String errorMsg;
            JSONObject jsonObject = (JSONObject)object;
            String policyNo = jsonObject.getString("policyno");
            String vehiclecode = jsonObject.getString("vehiclecode");
            String shipsNo = jsonObject.getString("shipsno");
            String perioddate = jsonObject.getString("perioddate");
            if ("".equals(jsonObject.get((Object)"vehiclevesselamount")) || jsonObject.get((Object)"vehiclevesselamount") == null) {
                errorMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u4fdd\u9669\u5355\u53f7\u3001\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u3001\u91d1\u989d\u7b49\u7279\u5b9a\u4fe1\u606f\u5fc5\u586b!", (String)"BillValidaterHelper_135", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new MsgException(errorMsg);
            }
            if ("".equals(jsonObject.get((Object)"vehiclelateamount")) || jsonObject.get((Object)"vehiclelateamount") == null) {
                errorMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u4fdd\u9669\u5355\u53f7\u3001\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u3001\u91d1\u989d\u7b49\u7279\u5b9a\u4fe1\u606f\u5fc5\u586b!", (String)"BillValidaterHelper_135", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new MsgException(errorMsg);
            }
            if ("".equals(jsonObject.get((Object)"vehicletotalamount")) || jsonObject.get((Object)"vehicletotalamount") == null) {
                errorMsg = ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u4fdd\u9669\u5355\u53f7\u3001\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u3001\u91d1\u989d\u7b49\u7279\u5b9a\u4fe1\u606f\u5fc5\u586b!", (String)"BillValidaterHelper_135", (String)"imc-sim-service", (Object[])new Object[0]);
                throw new MsgException(errorMsg);
            }
            if (!ViewBuildInvoiceHelper.checkAmountRule(jsonObject.get((Object)"vehiclevesselamount"))) {
                throw new MsgException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u91d1\u989d\u76f8\u5173\u5b57\u6bb5\u5fc5\u987b\u662f\u6570\u5b57", (String)"BillValidaterHelper_136", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BigDecimal vehiclevesselamount = jsonObject.getBigDecimal("vehiclevesselamount");
            if (!ViewBuildInvoiceHelper.checkAmountRule(jsonObject.get((Object)"vehiclelateamount"))) {
                throw new MsgException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u91d1\u989d\u76f8\u5173\u5b57\u6bb5\u5fc5\u987b\u662f\u6570\u5b57", (String)"BillValidaterHelper_136", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BigDecimal vehiclelateamount = jsonObject.getBigDecimal("vehiclelateamount");
            if (!ViewBuildInvoiceHelper.checkAmountRule(jsonObject.get((Object)"vehicletotalamount"))) {
                throw new MsgException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u91d1\u989d\u76f8\u5173\u5b57\u6bb5\u5fc5\u987b\u662f\u6570\u5b57", (String)"BillValidaterHelper_136", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BigDecimal vehicletotalamount = jsonObject.getBigDecimal("vehicletotalamount");
            Object[] array = new Object[]{policyNo, vehiclecode, shipsNo, perioddate, vehiclevesselamount, vehiclelateamount, vehicletotalamount};
            int count = 0;
            for (Object element : array) {
                if (!StringUtils.isBlank((Object)element)) continue;
                ++count;
            }
            if (array.length != count) continue;
            ++num;
        }
        return num > 0 && num == jsonArray.size();
    }

    private static boolean checkAmountRule(Object amountObject) {
        if (amountObject == null) {
            return false;
        }
        try {
            Double.parseDouble(amountObject.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkTravelerIsAllNull(JSONArray jsonArray) {
        int num = 0;
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String traveler = jsonObject.getString("traveler");
            String startPlace = jsonObject.getString("travelerstartplace");
            String endPlace = jsonObject.getString("travelerendplace");
            String transportType = jsonObject.getString("travelertransporttype");
            String cardNo = jsonObject.getString("travelercardno");
            String cardType = jsonObject.getString("travelercardtype");
            String seatClass = jsonObject.getString("travelerseatclass");
            String travelDate = jsonObject.getString("traveldate");
            String[] array = new String[]{traveler, cardType, cardNo, travelDate, startPlace, endPlace, transportType, seatClass};
            int count = 0;
            for (String element : array) {
                if (!StringUtils.isBlank((CharSequence)element)) continue;
                ++count;
            }
            if (array.length != count) continue;
            ++num;
        }
        return num > 0 && num == jsonArray.size();
    }

    public DynamicObject buildInvoiceByView(AbstractFormPlugin plugin, IFormView view, String itemJsonArray, String entityName) {
        if (StringUtils.isEmpty((CharSequence)itemJsonArray)) {
            throw new MsgException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u660e\u7ec6\u884c\u4fe1\u606f", (String)"ViewBuildInvoiceHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        IDataEntityType entityType = invoiceDynamicObject.getDataEntityType();
        try {
            invoiceDynamicObject.set("endleasedate", plugin.getView().getModel().getValue("endleasedate"));
            invoiceDynamicObject.set("startleasedate", plugin.getView().getModel().getValue("startleasedate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataEntityPropertyCollection collect = entityType.getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            Control control = plugin.getControl(field);
            if (control == null || property instanceof EntryProp) continue;
            invoiceDynamicObject.set(field, view.getModel().getValue(field));
        }
        if (!StringUtils.isEmpty((CharSequence)plugin.getPageCache().get("invoiceBatchFid"))) {
            invoiceDynamicObject.set("id", (Object)Long.parseLong(plugin.getPageCache().get("invoiceBatchFid")));
        }
        if (!StringUtils.isEmpty((CharSequence)view.getModel().getValue("originalinvoicecode").toString())) {
            invoiceDynamicObject.set("originalinvoicecode", view.getModel().getValue("originalinvoicecode"));
            invoiceDynamicObject.set("originalinvoiceno", view.getModel().getValue("originalinvoiceno"));
            invoiceDynamicObject.set("originalinvoicetype", view.getModel().getValue("originalinvoicetype"));
            invoiceDynamicObject.set("redreason", view.getModel().getValue("redreason"));
        }
        invoiceDynamicObject.set("iselepaper", view.getModel().getValue("iselepaper"));
        IssueInvoiceService.reverseBuyerSellerByPurchase((DynamicObject)invoiceDynamicObject);
        boolean isCheckDevice = StringUtils.isEmpty((CharSequence)plugin.getPageCache().get("invoiceBatchFid"));
        invoiceDynamicObject.set("orgid", view.getModel().getValue("orgid"));
        String errorMsg = InvoiceCheckService.checkBaseParams((DynamicObject)invoiceDynamicObject, (boolean)isCheckDevice);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            throw new MsgException(errorMsg);
        }
        JSONArray itemJSONArray = JSON.parseArray((String)itemJsonArray);
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        Long invoiceId = invoiceDynamicObject.getLong("id");
        DynamicObjectCollection invoiceItemList = invoiceDynamicObject.getDynamicObjectCollection("items");
        String specialType = String.valueOf(view.getModel().getValue("specialtype"));
        String invoiceType = String.valueOf(view.getModel().getValue("invoicetype"));
        HashMap<Long, BigDecimal> itemIdMap = new HashMap<Long, BigDecimal>();
        for (int i = 0; i < itemJSONArray.size(); ++i) {
            DynamicObject invoiceItemDynamicObject = invoiceItemList.addNew();
            JSONObject itemJson = itemJSONArray.getJSONObject(i);
            String xmje = itemJson.getString("xmje");
            String se = itemJson.getString("se");
            String num = itemJson.getString("xmsl");
            String price = itemJson.getString("xmdj");
            String unit = itemJson.getString("xmdw");
            String rowType = itemJson.getString("xmlx");
            try {
                InvoiceCheckService.checkVehicleItem((String)specialType, (String)invoiceType, (String)rowType, (int)i, (String)num, (String)price, (String)unit);
            }
            catch (Exception e) {
                throw new MsgException(e.getMessage());
            }
            if (StringUtils.isBlank((CharSequence)num) && StringUtils.isNotBlank((CharSequence)price)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u5355\u4ef7\u4e0d\u4e3a\u7a7a\uff0c\u6570\u91cf\u4e3a\u7a7a", (String)"ViewBuildInvoiceHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isBlank((CharSequence)price) && StringUtils.isNotBlank((CharSequence)num)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u5355\u4ef7\u4e3a\u7a7a\uff0c\u6570\u91cf\u4e0d\u4e3a\u7a7a", (String)"ViewBuildInvoiceHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isEmpty((CharSequence)xmje)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"ViewBuildInvoiceHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isEmpty((CharSequence)se)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u660e\u7ec6\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ViewBuildInvoiceHelper_4", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
            }
            if (!AllEPrivilegeTypeEnum.T_10.getName().equals(itemJson.getString("zzstsgl")) && TaxedTypeEnum.all_e_reduced_tax.getValue().equals(view.getModel().getValue("taxedtype"))) {
                throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u51cf\u6309\u5f81\u7a0e\uff0c\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u662f\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (String)"ViewBuildInvoiceHelper_8", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BigDecimal xmjeBigDecimal = new BigDecimal(xmje);
            BigDecimal seBigDecimal = new BigDecimal(se);
            totalAmount = totalAmount.add(xmjeBigDecimal);
            totalTax = totalTax.add(seBigDecimal);
            ViewBuildInvoiceHelper.buildItemData(i, invoiceItemDynamicObject, itemJson);
            if (itemJson.get((Object)"id") == null || itemJson.get((Object)"adjustedData") == null) continue;
            itemIdMap.put(itemJson.getLong("id"), itemJson.getBigDecimal("adjustedData"));
        }
        ViewBuildInvoiceHelper.dealCEZSItems(plugin, invoiceDynamicObject);
        ViewBuildInvoiceHelper.dealFreightItems(plugin, invoiceDynamicObject);
        ViewBuildInvoiceHelper.dealTravelrItems(plugin, invoiceDynamicObject);
        ViewBuildInvoiceHelper.dealVesselShipItems(plugin, invoiceDynamicObject);
        this.taxAdjustAndEditOriginal(invoiceId, itemIdMap);
        this.dealEstateSalesItemsAndCobuyerItems(plugin, invoiceDynamicObject, invoiceType, specialType);
        ViewBuildInvoiceHelper.rebuildExtraItems(view, invoiceDynamicObject);
        String inventoryMark = null;
        try {
            inventoryMark = (String)view.getModel().getValue("inventorymark");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == inventoryMark && invoiceItemList.size() <= 8) {
            inventoryMark = "0";
        }
        if (invoiceItemList.size() > 8) {
            inventoryMark = "1";
        }
        invoiceDynamicObject.set("inventorymark", (Object)inventoryMark);
        if ("1".equals(view.getPageCache().get("qdhp"))) {
            invoiceDynamicObject.set("inventorymark", (Object)"1");
        }
        invoiceDynamicObject.set("totalamount", (Object)totalAmount.add(totalTax));
        invoiceDynamicObject.set("invoiceamount", (Object)totalAmount);
        invoiceDynamicObject.set("totaltax", (Object)totalTax);
        this.buildInvoiceMainData(view, invoiceDynamicObject);
        errorMsg = InvoiceCheckService.checkParams((DynamicObject)invoiceDynamicObject, (boolean)isCheckDevice);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            throw new MsgException(errorMsg);
        }
        this.checkAllEleSpecialFields(invoiceDynamicObject);
        errorMsg = InvoiceCheckService.checkExtraItems((DynamicObject)invoiceDynamicObject);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            throw new MsgException(errorMsg);
        }
        return invoiceDynamicObject;
    }

    public static void rebuildExtraItems(IFormView view, DynamicObject invoiceDynamicObject) {
        DynamicObjectCollection extraItems = view.getModel().getEntryEntity("extra");
        DynamicObjectCollection invExtraItems = invoiceDynamicObject.getDynamicObjectCollection("extra");
        invExtraItems.clear();
        for (DynamicObject extraItem : extraItems) {
            DynamicObject newExtraItem = invExtraItems.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)extraItem, (DynamicObject)newExtraItem);
        }
    }

    private void dealEstateSalesItemsAndCobuyerItems(AbstractFormPlugin plugin, DynamicObject invoiceDynamicObject, String invoiceType, String specialType) {
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && ("E05".equals(specialType) || "E06".equals(specialType))) {
            DynamicObjectCollection estatesales = invoiceDynamicObject.getDynamicObjectCollection("estatesales");
            estatesales.clear();
            DynamicObjectCollection salesEntity = plugin.getView().getModel().getEntryEntity("estatesales");
            List estateProperties = AllELqInvoiceConstant.ESTATETRING;
            if ("E05".equals(specialType)) {
                estateProperties.addAll(AllELqInvoiceConstant.ESTATESALESTRING);
            }
            if ("E06".equals(specialType)) {
                estateProperties.addAll(AllELqInvoiceConstant.ESTATELEASESTRING);
            }
            for (int i = 0; i < salesEntity.size(); ++i) {
                DynamicObject estatesale = estatesales.addNew();
                estatesale.set("seq", (Object)i);
                for (String s : estateProperties) {
                    estatesale.set(s, plugin.getView().getModel().getValue(s, i));
                }
            }
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && "E05".equals(specialType) && "1".equals(plugin.getView().getModel().getValue("cobuyerflag"))) {
            DynamicObjectCollection cobuyers = invoiceDynamicObject.getDynamicObjectCollection("cobuyers");
            cobuyers.clear();
            DynamicObjectCollection cobuyerEntity = plugin.getView().getModel().getEntryEntity("cobuyers");
            for (int i = 0; i < cobuyerEntity.size(); ++i) {
                DynamicObject cobuyer = cobuyers.addNew();
                cobuyer.set("seq", (Object)i);
                for (String s : AllELqInvoiceConstant.COBUYERSTRING) {
                    cobuyer.set(s, plugin.getView().getModel().getValue(s, i));
                }
            }
        }
    }

    public static void dealCEZSItems(AbstractFormPlugin plugin, DynamicObject waitInvoiceDynamicObject) {
        if (!TaxedTypeEnum.all_e_deduction.getValue().equals(waitInvoiceDynamicObject.getString("taxedtype"))) {
            return;
        }
        String deducItems = plugin.getPageCache().get("issueDeducItem");
        DynamicObjectCollection dedcItems = waitInvoiceDynamicObject.getDynamicObjectCollection("deductions");
        dedcItems.clear();
        BigDecimal totalDeducAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)deducItems)) {
            JSONArray dedcArray = JSONObject.parseArray((String)deducItems);
            int rowIndex = 1;
            for (Object o : dedcArray) {
                JSONObject row = (JSONObject)o;
                DynamicObject item = dedcItems.addNew();
                item.set("evidencetype", row.get((Object)"evidencetype"));
                item.set("etaxinvoiceno", row.get((Object)"etaxinvoiceno"));
                item.set("deductioninvoicecode", row.get((Object)"deductioninvoicecode"));
                item.set("deductioninvoiceno", row.get((Object)"deductioninvoiceno"));
                item.set("evidenceno", row.get((Object)"evidenceno"));
                if (StringUtils.isNotBlank((CharSequence)row.getString("invoicedate"))) {
                    try {
                        Date date = DateUtils.stringToDate((String)row.getString("invoicedate"), (String)"yyyy-MM-dd");
                        item.set("invoicedate", (Object)date);
                    }
                    catch (Exception e) {
                        throw new MsgException(String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\u65e5\u671f\u683c\u5f0f\u6709\u8bef,\u683c\u5f0f\u4e3ayyyy-MM-dd", (String)"ViewBuildInvoiceHelper_5", (String)"imc-sim-service", (Object[])new Object[0]), rowIndex));
                    }
                }
                try {
                    item.set("evidenceamount", row.get((Object)"evidenceamount"));
                }
                catch (Exception e) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\u51ed\u8bc1\u5408\u8ba1\u91d1\u989d\u683c\u5f0f\u6709\u8bef", (String)"ViewBuildInvoiceHelper_6", (String)"imc-sim-service", (Object[])new Object[0]), rowIndex));
                }
                try {
                    item.set("deductionamount", row.get((Object)"deductionamount"));
                }
                catch (Exception e) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\u672c\u6b21\u6263\u9664\u91d1\u989d\u683c\u5f0f\u6709\u8bef", (String)"ViewBuildInvoiceHelper_7", (String)"imc-sim-service", (Object[])new Object[0]), rowIndex));
                }
                item.set("deductionremark", row.get((Object)"deductionremark"));
                item.set("orievidenceamount", row.get((Object)"orievidenceamount"));
                totalDeducAmount = totalDeducAmount.add(item.getBigDecimal("deductionamount"));
                ++rowIndex;
            }
        }
        waitInvoiceDynamicObject.set("deduction", (Object)totalDeducAmount);
    }

    private void checkAllEleSpecialFields(DynamicObject dynamicObject) {
        DynamicObjectCollection coBuyerItems;
        DynamicObjectCollection estateSaleItems;
        DynamicObjectCollection freightsItems;
        DynamicObjectCollection deducItems;
        BaseInvoice baseInvoice = (BaseInvoice)DynamicObjectUtil.dynamicObject2Bean(BaseInvoice.class, (DynamicObject)dynamicObject);
        String invoiceType = dynamicObject.getString("invoicetype");
        String specialType = dynamicObject.getString("specialtype");
        DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
        if ("E12".equals(specialType)) {
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                throw new MsgException(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u5f00\u5177\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968", (String)"ViewBuildInvoiceHelper_9", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item2 = (DynamicObject)items.get(i);
                String taxRate = item2.getString("taxrate");
                String zzstsgl = item2.getString("zzstsgl");
                String goodsCode = item2.getString("goodscode");
                BigDecimal taxRateDecimalValue = BigDecimal.TEN;
                try {
                    taxRateDecimalValue = new BigDecimal(taxRate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ("\u514d\u7a0e".equals(zzstsgl) && taxRateDecimalValue.compareTo(BigDecimal.ZERO) == 0) continue;
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a\uff1a0,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\uff1a\u514d\u7a0e\uff08\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u7a0e\u7387\u8981\u6c42\u5fc5\u987b\u4e3a\u514d\u7a0e\uff09", (String)"ViewBuildInvoiceHelper_10", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
            }
        }
        if (!items.isEmpty()) {
            ArrayList itemList = new ArrayList(items.size());
            items.forEach(item -> itemList.add(BeanUtil.dynamicObject2SimpleBean((DynamicObject)item, BaseInvoiceItem.class)));
            baseInvoice.setInvoiceItemList(itemList);
        }
        if (!(deducItems = dynamicObject.getDynamicObjectCollection("deductions")).isEmpty()) {
            ArrayList<BillDeductionItemVo> deducList = new ArrayList<BillDeductionItemVo>();
            for (Object deducItem : deducItems) {
                BillDeductionItemVo vo = new BillDeductionItemVo();
                vo.setDeduction(deducItem.getBigDecimal("deductionamount"));
                vo.setEtaxInvoiceNo(deducItem.getString("etaxinvoiceno"));
                vo.setInvoiceCode(deducItem.getString("deductioninvoicecode"));
                vo.setInvoiceNo(deducItem.getString("deductioninvoiceno"));
                vo.setInvoiceDate(DateUtils.format((Date)deducItem.getDate("invoicedate"), (String)"yyyy-MM-dd"));
                vo.setRemark(deducItem.getString("deductionremark"));
                vo.setEvidenceType(deducItem.getString("evidencetype"));
                vo.setEvidenceNo(deducItem.getString("evidenceno"));
                vo.setEvidenceAmount(deducItem.getBigDecimal("evidenceamount"));
                vo.setOriEvidenceAmount(deducItem.getBigDecimal("orievidenceamount"));
                deducList.add(vo);
            }
            baseInvoice.setDeductionItems(deducList);
        }
        if (!(freightsItems = dynamicObject.getDynamicObjectCollection("freights")).isEmpty()) {
            ArrayList<Object> deducList = new ArrayList<Object>();
            for (DynamicObject freightItem : freightsItems) {
                BillFreightItemVo vo = new BillFreightItemVo();
                vo.setStartPlace(freightItem.getString("startplace"));
                vo.setEndPlace(freightItem.getString("endplace"));
                vo.setTransportType(freightItem.getString("transporttype"));
                vo.setLicensePlate(freightItem.getString("licenseplate"));
                vo.setTransportGoods(freightItem.getString("transportgoods"));
                deducList.add(vo);
            }
            baseInvoice.setFreightItems(deducList);
        }
        InvoiceCheckService.checkEleDeduction((BaseInvoice)baseInvoice, (boolean)true);
        if (!InvoiceUtils.isAllEInvoice((Object)baseInvoice.getInvoicetype()) && !AllEleAuthHelper.isElePaper((Object)baseInvoice.getIselepaper())) {
            return;
        }
        if (!InvoiceSpecialType.allEleSpecialType((String)baseInvoice.getSpecialtype())) {
            return;
        }
        DynamicObject simpleAddress = dynamicObject.getDynamicObject("simpleaddress");
        if (simpleAddress != null) {
            baseInvoice.setSimpleaddress(simpleAddress.getString("name"));
        }
        if (!(estateSaleItems = dynamicObject.getDynamicObjectCollection("estatesales")).isEmpty()) {
            ArrayList<BillEstateSaleItemVo> salesList = new ArrayList<BillEstateSaleItemVo>();
            for (DynamicObject estateSaleItem : estateSaleItems) {
                BillEstateSaleItemVo vo = new BillEstateSaleItemVo();
                vo.setEstateCode(estateSaleItem.getString("saleestatecode"));
                vo.setOnLineContracteNo(estateSaleItem.getString("onlinecontracteno"));
                vo.setProvinceAdress(estateSaleItem.getString("saleprincename"));
                vo.setCityAdreess(estateSaleItem.getString("salecityname"));
                vo.setDetailAddress(estateSaleItem.getString("saledetailaddress"));
                vo.setLandTaxNo(estateSaleItem.getString("salelandtaxno"));
                vo.setCrossCitySign(estateSaleItem.getString("salecrosscitysign"));
                vo.setApprovedPrice(estateSaleItem.getBigDecimal("assessmenttaxamount"));
                vo.setActualTurnover(estateSaleItem.getBigDecimal("actualtotalamount"));
                vo.setEstateId(estateSaleItem.getString("saleestateid"));
                vo.setAreaunit(estateSaleItem.getString("saleunit"));
                vo.setStartLeaseDate(estateSaleItem.getString("leasestartdate"));
                vo.setEndLeaseDate(estateSaleItem.getString("leaseenddate"));
                vo.setCarBrandNo(estateSaleItem.getString("carbrandno"));
                salesList.add(vo);
            }
            baseInvoice.setEstateSaleItems(salesList);
        }
        if (!(coBuyerItems = dynamicObject.getDynamicObjectCollection("cobuyers")).isEmpty()) {
            ArrayList<BillCoBuyerItemVo> coBuyerList = new ArrayList<BillCoBuyerItemVo>();
            for (DynamicObject coBuyerItem : coBuyerItems) {
                BillCoBuyerItemVo vo = new BillCoBuyerItemVo();
                vo.setCoBuyer(coBuyerItem.getString("cobuyer"));
                vo.setCardType(coBuyerItem.getString("cobuyercardtype"));
                vo.setCardNo(coBuyerItem.getString("cobuyercardno"));
                coBuyerList.add(vo);
            }
            baseInvoice.setCoBuyerItems(coBuyerList);
        }
        InvoiceCheckService.checkEleSpecialType((BaseInvoice)baseInvoice);
    }

    private void taxAdjustAndEditOriginal(Long tbillid, Map<Long, BigDecimal> itemIdMap) {
        if (tbillid != 0L && !itemIdMap.isEmpty()) {
            QFilter qFilter = new QFilter("tbillid", "=", (Object)tbillid).and("ttable", "=", (Object)"sim_vatinvoice").and("isdelete", "!=", (Object)"Y");
            DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
            if (billInvRelations.length != 0) {
                Object[] sbillIds = Stream.of(billInvRelations).map(relation -> relation.getLong("sbillid")).distinct().toArray();
                DynamicObject[] originalBills = BusinessDataServiceHelper.load((Object[])sbillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                HashMap<Long, Pair> itemsMap = new HashMap<Long, Pair>();
                for (DynamicObject originalBill : originalBills) {
                    String confirmState = originalBill.getString("confirmstate");
                    String hsbz = originalBill.getString("hsbz");
                    String mainId = originalBill.getString("id");
                    DynamicObjectCollection oriItems = originalBill.getDynamicObjectCollection("sim_original_bill_item");
                    for (DynamicObject oriItem : oriItems) {
                        itemsMap.put(oriItem.getLong("id"), Pair.of((Object)(confirmState + "#&@" + hsbz + "#&@" + mainId), (Object)oriItem));
                    }
                }
                Map<Long, List<DynamicObject>> tDetialIdGroup = Stream.of(billInvRelations).collect(Collectors.groupingBy(relation -> relation.getLong("tdetailid")));
                itemIdMap.forEach((tDetialId, adjustedData) -> {
                    DynamicObject billRelationDTO;
                    List invRelationList = (List)tDetialIdGroup.get(tDetialId);
                    ArrayList oriItemsList = Lists.newArrayListWithCapacity((int)itemsMap.size());
                    for (Object relation2 : invRelationList) {
                        oriItemsList.add(itemsMap.get(relation2.getLong("sdetailid")));
                    }
                    ArrayList tempOriList = Lists.newArrayListWithCapacity((int)itemsMap.size());
                    for (Pair pair : oriItemsList) {
                        tempOriList.add(pair.getRight());
                    }
                    DynamicObject detail = tempOriList.stream().max(Comparator.comparing(itemTax -> itemTax.getBigDecimal("tax"))).get();
                    String confirmState = (String)((Pair)itemsMap.get(detail.getLong("id"))).getLeft();
                    String[] confirmAndHsbz = confirmState.split("#&@");
                    if (confirmAndHsbz[0].equals("2")) {
                        detail.set("taxdeviation", (Object)detail.getBigDecimal("taxdeviation").subtract((BigDecimal)adjustedData));
                        detail.set("amountdeviation", (Object)detail.getBigDecimal("amountdeviation").add((BigDecimal)adjustedData));
                    } else {
                        if (confirmAndHsbz[1].equals("0")) {
                            detail.set("remainvalidamount", (Object)detail.getBigDecimal("remainvalidamount").add((BigDecimal)adjustedData));
                        }
                        detail.set("remainvalidtax", (Object)detail.getBigDecimal("remainvalidtax").subtract((BigDecimal)adjustedData));
                    }
                    if (confirmAndHsbz[1].equals("0")) {
                        Arrays.stream(originalBills).forEach(o -> {
                            if (o.getString("id").equals(confirmAndHsbz[confirmAndHsbz.length - 1])) {
                                o.set("confirmamount", (Object)o.getBigDecimal("confirmamount").subtract((BigDecimal)adjustedData));
                            }
                        });
                    }
                    if ((billRelationDTO = (DynamicObject)invRelationList.stream().filter(relation -> detail.getLong("id") == relation.getLong("sdetailid")).findFirst().orElse(null)) != null) {
                        billRelationDTO.set("tax", (Object)billRelationDTO.getBigDecimal("tax").add((BigDecimal)adjustedData));
                        billRelationDTO.set("amount", (Object)billRelationDTO.getBigDecimal("amount").subtract((BigDecimal)adjustedData));
                    }
                });
                for (DynamicObject originalBill : originalBills) {
                    BigDecimal mainTaxDeviation = BigDecimal.ZERO;
                    BigDecimal amount = BigDecimal.ZERO;
                    BigDecimal tax = BigDecimal.ZERO;
                    DynamicObjectCollection originalBillItems = originalBill.getDynamicObjectCollection("sim_original_bill_item");
                    for (DynamicObject originalBillItem : originalBillItems) {
                        mainTaxDeviation = mainTaxDeviation.add(originalBillItem.getBigDecimal("taxdeviation"));
                        amount = amount.add(originalBillItem.getBigDecimal("remainvalidamount"));
                        tax = tax.add(originalBillItem.getBigDecimal("remainvalidtax"));
                    }
                    originalBill.set("maintaxdeviation", (Object)mainTaxDeviation);
                }
                ImcSaveServiceHelper.update((DynamicObject[])originalBills);
                ImcSaveServiceHelper.update((DynamicObject[])billInvRelations);
            }
        }
    }

    private void buildInvoiceMainData(IFormView view, DynamicObject dynamicObject) {
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("issuetype", view.getModel().getValue("issuetype"));
        String value = (String)view.getModel().getValue("issuetype");
        if (String.valueOf(IssueTypeEnum.red.getValue()).equals(value)) {
            dynamicObject.set("originalinvoicetype", (Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode());
            dynamicObject.set("originalissuetime", view.getModel().getValue("originalissuetime"));
        }
        dynamicObject.set("wxid", view.getModel().getValue("wxid"));
        dynamicObject.set("systemsource", view.getModel().getValue("systemsource"));
        if ("11".equals(String.valueOf(view.getModel().getValue("checkboxtobacco")))) {
            dynamicObject.set("specialtype", (Object)"11");
        } else if (view.getModel().getValue("specialtype") == null) {
            dynamicObject.set("specialtype", (Object)"00");
        }
        BigDecimal deduction = (BigDecimal)view.getModel().getValue("deduction");
        if (!InvoiceUtils.isAllEInvoice((Object)dynamicObject.getString("invoicetype"))) {
            if (!MathUtils.isZero((BigDecimal)deduction) || TaxedTypeEnum.deduction.getValue().equals(view.getModel().getValue("taxedtype"))) {
                dynamicObject.set("taxedtype", (Object)TaxedTypeEnum.deduction.getValue());
                dynamicObject.set("deduction", (Object)deduction.setScale(2, RoundingMode.HALF_UP));
            } else {
                dynamicObject.set("deduction", null);
                dynamicObject.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
            }
        }
        dynamicObject.set("uploadmark", (Object)"0");
    }

    public static void buildItemData(int index, DynamicObject itemDynamicObject, JSONObject json) {
        itemDynamicObject.set("seq", (Object)index);
        itemDynamicObject.set("goodsname", (Object)json.getString("xmmc"));
        itemDynamicObject.set("goodscode", (Object)json.getString("spbm"));
        itemDynamicObject.set("specification", (Object)json.getString("ggxh"));
        itemDynamicObject.set("unit", (Object)json.getString("xmdw"));
        itemDynamicObject.set("num", (Object)json.getBigDecimal("xmsl"));
        itemDynamicObject.set("unitprice", (Object)json.getBigDecimal("xmdj"));
        itemDynamicObject.set("taxunitprice", (Object)json.getBigDecimal("xmdjhs"));
        itemDynamicObject.set("amount", (Object)json.getString("xmje"));
        itemDynamicObject.set("taxamount", (Object)json.getBigDecimal("xmjehs"));
        itemDynamicObject.set("tax", (Object)json.getString("se"));
        itemDynamicObject.set("taxrate", (Object)json.getString("sl"));
        if ("0.00Z1".equals(json.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zerotaxmark", (Object)1);
            itemDynamicObject.set("zzstsgl", (Object)"\u514d\u7a0e");
            itemDynamicObject.set("taxrate", (Object)"0");
        } else if ("0.00Z2".equals(json.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zerotaxmark", (Object)2);
            itemDynamicObject.set("zzstsgl", (Object)"\u4e0d\u5f81\u7a0e");
            itemDynamicObject.set("taxrate", (Object)"0");
        } else if ("0.00Z0".equals(json.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zerotaxmark", (Object)0);
            itemDynamicObject.set("zzstsgl", (Object)"\u51fa\u53e3\u9000\u7a0e");
            itemDynamicObject.set("taxrate", (Object)"0");
        } else if ("0.00Z3".equals(json.getString("slText"))) {
            itemDynamicObject.set("taxpremark", (Object)0);
            itemDynamicObject.set("zerotaxmark", (Object)3);
            itemDynamicObject.set("zzstsgl", (Object)"");
            itemDynamicObject.set("taxrate", (Object)"0");
        } else if (!StringUtils.isEmpty((CharSequence)json.getString("zzstsgl"))) {
            itemDynamicObject.set("taxpremark", (Object)1);
            itemDynamicObject.set("zzstsgl", (Object)json.getString("zzstsgl"));
        } else {
            itemDynamicObject.set("zzstsgl", (Object)"");
            itemDynamicObject.set("taxpremark", (Object)0);
        }
        itemDynamicObject.set("taxflag", (Object)"0");
        itemDynamicObject.set("rowtype", (Object)json.getString("xmlx"));
        itemDynamicObject.set("simplegoodsname", (Object)json.getString("spmc"));
        itemDynamicObject.set("itemremainredamount", json.get((Object)"itemremainredamount"));
        itemDynamicObject.set("originalinvoiceitemid", (Object)json.getLongValue("originalinvoiceitemid"));
        itemDynamicObject.set("billsourceid", json.get((Object)"billsourceid"));
    }

    public static void dealEstateSale(AbstractFormPlugin plugin, DynamicObject waitInvoiceDynamicObject) {
        if ("E03".equals(waitInvoiceDynamicObject.getString("specialtype"))) {
            waitInvoiceDynamicObject.set("crosscitytaxverifyno", plugin.getView().getModel().getValue("crosscitytaxverifyno"));
            waitInvoiceDynamicObject.set("detailaddress", plugin.getView().getModel().getValue("detailaddress"));
            waitInvoiceDynamicObject.set("buildingname", plugin.getView().getModel().getValue("buildingname"));
            waitInvoiceDynamicObject.set("landtaxno", plugin.getView().getModel().getValue("landtaxno"));
            waitInvoiceDynamicObject.set("crosscitysign", plugin.getView().getModel().getValue("crosscitysign"));
            waitInvoiceDynamicObject.set("simpleaddress", plugin.getView().getModel().getValue("simpleaddress"));
        }
        if ("E05".equals(waitInvoiceDynamicObject.getString("specialtype")) || "E06".equals(waitInvoiceDynamicObject.getString("specialtype"))) {
            DynamicObjectCollection estateSaleList = waitInvoiceDynamicObject.getDynamicObjectCollection("estatesales");
            estateSaleList.clear();
            DynamicObjectCollection estatesales = plugin.getView().getModel().getEntryEntity("estatesales");
            for (int i = 0; i < estatesales.size(); ++i) {
                DynamicObject item = estateSaleList.addNew();
                item.set("saleestatecode", plugin.getView().getModel().getValue("saleestatecode", i));
                item.set("onlinecontracteno", plugin.getView().getModel().getValue("onlinecontracteno", i));
                item.set("saleprincename", plugin.getView().getModel().getValue("saleprincename", i));
                item.set("salecityname", plugin.getView().getModel().getValue("salecityname", i));
                item.set("salecityname", plugin.getView().getModel().getValue("salecityname", i));
                item.set("saledetailaddress", plugin.getView().getModel().getValue("saledetailaddress", i));
                item.set("salelandtaxno", plugin.getView().getModel().getValue("salelandtaxno", i));
                item.set("salecrosscitysign", plugin.getView().getModel().getValue("salecrosscitysign", i));
                item.set("saleestateid", plugin.getView().getModel().getValue("saleestateid", i));
                item.set("assessmenttaxamount", plugin.getView().getModel().getValue("assessmenttaxamount", i));
                item.set("actualtotalamount", plugin.getView().getModel().getValue("actualtotalamount", i));
                item.set("saleunit", plugin.getView().getModel().getValue("saleunit", i));
                item.set("carbrandno", plugin.getView().getModel().getValue("carbrandno", i));
                item.set("leasestartdate", plugin.getView().getModel().getValue("leasestartdate", i));
                item.set("leaseenddate", plugin.getView().getModel().getValue("leaseenddate", i));
            }
        }
    }
}

