/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.paperprint.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.PaperPrintHelper;
import org.apache.commons.lang3.StringUtils;

public class PrintInvoiceControl {
    private static final Log LOGGER = LogFactory.getLog(PrintInvoiceControl.class);
    private static final String PRINT_INVOICE_MACHINE_KEY = "print_invoice_machine_key_";
    private static final String PRINT_VEHICLE_INVOICE_MACHINE_KEY = "print_vehicle_invoice_machine_key_";
    private static final String PRINT_QD_MACHINE_KEY = "print_qd_machine_key_";

    public static String getFormId(String printType) {
        String tableFormId = "sim_vatinvoice";
        if (PrintTypeEnum.VEHICLE_PRINT.getType().equals(printType)) {
            tableFormId = "sim_vatinvoice_vehicles";
        }
        return tableFormId;
    }

    public static void initListViewAndShowSummation(AbstractFormPlugin plugin, String printType, DynamicObject[] vatInvoiceList) {
        IDataModel modelDetail = plugin.getView().getControl("entryentity").getModel();
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject vatInvoice : vatInvoiceList) {
            int index = plugin.getView().getModel().createNewEntryRow("entryentity");
            modelDetail.setValue("invoicecode", vatInvoice.get("invoicecode"), index);
            modelDetail.setValue("invoiceno", vatInvoice.get("invoiceno"), index);
            modelDetail.setValue("invoiceamount", vatInvoice.get("invoiceamount"), index);
            modelDetail.setValue("totaltax", vatInvoice.get("totaltax"), index);
            modelDetail.setValue("totalamount", vatInvoice.get("totalamount"), index);
            modelDetail.setValue("invoicetype", vatInvoice.get("invoicetype"), index);
            if (PrintTypeEnum.VEHICLE_PRINT.getType().equals(printType)) {
                modelDetail.setValue("inventorymark", (Object)"0", index);
            } else {
                modelDetail.setValue("inventorymark", vatInvoice.get("inventorymark"), index);
            }
            totalTax = totalTax.add(vatInvoice.getBigDecimal("totaltax"));
            totalAmount = totalAmount.add(vatInvoice.getBigDecimal("totalamount"));
        }
        Label titleLabel = (Label)plugin.getView().getControl("allaccount");
        titleLabel.setText(String.format(ResManager.loadKDString((String)"\u603b\u8ba1\uff1a \u5f00\u7968\u4efd\u6570%1$s\u4efd\uff0c\u5408\u8ba1\u7a0e\u989d%2$s\u5143\uff0c\u4ef7\u7a0e\u5408\u8ba1%3$s\u5143", (String)"PrintInvoiceControl_0", (String)"imc-sim-service", (Object[])new Object[0]), vatInvoiceList.length, totalTax.setScale(2, 0), totalAmount.setScale(2, 0)));
    }

    public static JSONObject sendGetPrintMachineRequest(String devNo, long orgId) {
        JSONObject reqData = JSONObject.parseObject((String)"{}");
        SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
        reqData.put("czlx", (Object)"901");
        reqData.put("hxbzdh", (Object)saleInfo.getDefaultTerminal());
        String requestData = reqData.toJSONString();
        String remoteUrl = ComponentServiceHelper.getComponentRequestUrl((String)devNo);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("invoiceprint_url_" + remoteUrl);
        }
        return ComponentServiceHelper.doPost((String)remoteUrl, (String)requestData);
    }

    public static void handleGetPrinterMachineResponse(AbstractFormPlugin plugin, JSONObject printMachineResponseJson, String printNameKey) {
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"print"});
        JSONObject machineObj = printMachineResponseJson.getJSONObject("sjd");
        JSONArray printerJsonArray = machineObj.getJSONArray("printers");
        String defaultMachine = PrintInvoiceControl.getPrintName(machineObj.getString("default_printer"), CacheHelper.get((String)printNameKey), printerJsonArray);
        LOGGER.info(String.format("\u83b7\u53d6\u7f13\u5b58\u7684\u9ed8\u8ba4\u6253\u5370\u673aPRINT_MACHINE_KEY\uff1a%s, CacheValue:%s", printNameKey, CacheHelper.get((String)printNameKey)));
        plugin.getView().getModel().setValue("printmer", (Object)defaultMachine);
        if (printerJsonArray.size() > 0) {
            ComboEdit comboEdit = (ComboEdit)plugin.getView().getControl("printmer");
            ArrayList<ComboItem> arrList = new ArrayList<ComboItem>(printerJsonArray.size());
            for (Object obj : printerJsonArray) {
                JSONObject macObj = JSONObject.parseObject((String)obj.toString());
                String macName = macObj.getString("name");
                ComboItem item = new ComboItem();
                item.setImageKey(macName);
                item.setValue(macName);
                item.setCaption(new LocaleString(macName));
                arrList.add(item);
                comboEdit.setComboItems(arrList);
            }
        }
    }

    public static String sendPrintInvoiceRequest(String requestData, String requestUrl, DynamicObject obj) {
        String errorMsg = "";
        try {
            JSONObject printInvoice = ComponentServiceHelper.doPost((String)requestUrl, (String)requestData);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u6253\u5370\u53d1\u7968(\u6e05\u5355)\u8c03\u7528\u7ec4\u4ef6http\u8fd4\u56de\u6570\u636e\uff1a" + printInvoice);
            }
            if ("5011".equalsIgnoreCase(printInvoice.getString("errcode").trim())) {
                obj.set("printflag", (Object)"1");
            } else {
                obj.set("printflag", (Object)"2");
                errorMsg = String.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"PrintInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]), printInvoice.toJSONString());
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{obj});
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u6253\u5370\u53d1\u7968(\u6e05\u5355)\u66f4\u65b0\u53d1\u7968\u6253\u5370\u72b6\u6001\uff1a\u53d1\u7968\u53f7\u7801" + obj.getString("invoiceno") + "\uff1a\u72b6\u60011\u5df2\u6253\u5370-2\u6253\u5370\u5931\u8d25\uff1a" + obj.getString("printflag"));
            }
        }
        catch (MsgException msgException) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"PrintInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]), msgException.getErrorMsg());
        }
        return errorMsg;
    }

    public static JSONObject makeComponentReqJSON(DynamicObject invoiceDynamicObject, String typeFlag, String printerName) {
        JSONObject reqData = JSONObject.parseObject((String)"{}");
        reqData.put("czlx", (Object)"4");
        if (!typeFlag.equals(PrintTypeEnum.VEHICLE_PRINT.getType())) {
            reqData.put("hxbzdh", (Object)(StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("terminalno")) ? "" : invoiceDynamicObject.getString("terminalno")));
        }
        JSONObject sjd = JSONObject.parseObject((String)"{}");
        sjd.put("kpzl", (Object)InvoiceType.getTypeCodeHx((String)invoiceDynamicObject.getString("invoicetype")));
        sjd.put("fpdm", (Object)invoiceDynamicObject.getString("invoicecode"));
        sjd.put("fphm", (Object)invoiceDynamicObject.getString("invoiceno"));
        sjd.put("ylbz", (Object)"0");
        sjd.put("print_type", (Object)(typeFlag.equals(PrintTypeEnum.QD_PRINT.getType()) ? "1" : "0"));
        sjd.put("printer_name", (Object)printerName);
        reqData.put("sjd", (Object)sjd);
        return reqData;
    }

    public static Map<String, Object> getSendCustomViewData(String printSeq, String invoiceCode, String invoiceNo, String timeFlag, String printType) {
        HashMap<String, Object> showMap = new HashMap<String, Object>(8);
        showMap.put("eventKey", "updatePrint");
        showMap.put("printseq", "0".equals(printSeq) ? ResManager.loadKDString((String)"\u5f00\u59cb\u51c6\u5907\u6253\u5370", (String)"PrintInvoiceControl_2", (String)"imc-sim-service", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6253\u5370\u7b2c%s\u5f20\u53d1\u7968...", (String)"PrintInvoiceControl_3", (String)"imc-sim-service", (Object[])new Object[0]), printSeq));
        showMap.put("invoicecode", invoiceCode);
        showMap.put("invoiceno", invoiceNo);
        showMap.put("timeflag", timeFlag);
        showMap.put("printtype", printType);
        showMap.put("time", System.currentTimeMillis());
        return showMap;
    }

    public static void jumpShowPrintSuccessOrErrorPage(AbstractFormPlugin plugin, String printErrCache, boolean success) {
        String caption;
        Map customParams = PaperPrintHelper.getCustomParams((AbstractFormPlugin)plugin);
        String typeFlag = customParams.get("type").toString();
        customParams.put("state", success);
        if (success) {
            caption = typeFlag.equals(PrintTypeEnum.QD_PRINT.getType()) ? ResManager.loadKDString((String)"\u6e05\u5355\u6253\u5370\u6210\u529f", (String)"PrintInvoiceControl_4", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u6210\u529f", (String)"PrintInvoiceControl_5", (String)"imc-sim-service", (Object[])new Object[0]);
        } else {
            caption = typeFlag.equals(PrintTypeEnum.QD_PRINT.getType()) ? ResManager.loadKDString((String)"\u6e05\u5355\u6253\u5370\u5931\u8d25", (String)"PrintInvoiceControl_6", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u5931\u8d25", (String)"PrintInvoiceControl_7", (String)"imc-sim-service", (Object[])new Object[0]);
            JSONObject errMsg = JSONObject.parseObject((String)plugin.getPageCache().get(printErrCache));
            customParams.put("defeatNum", errMsg.getString("printseq"));
            customParams.put("invoicecode", errMsg.getString("invoicecode"));
            customParams.put("invoiceno", errMsg.getString("invoiceno"));
            customParams.put("printErrorMsg", plugin.getPageCache().get("printErrorMsg"));
        }
        customParams.put("state", success);
        ViewUtil.openDialog((AbstractFormPlugin)plugin, (String)caption, (Map)customParams, (String)"sim_print_success", (String)"sim_print_success");
    }

    public static String getPrinterNameCacheKey(String printType, String jqbh) {
        String printName;
        if (PrintTypeEnum.QD_PRINT.getType().equals(printType)) {
            printName = PRINT_QD_MACHINE_KEY + jqbh + '_' + RequestContext.get().getUserId();
        } else if (PrintTypeEnum.INVOICE_PRINT.getType().equals(printType)) {
            printName = PRINT_INVOICE_MACHINE_KEY + jqbh + '_' + RequestContext.get().getUserId();
        } else if (PrintTypeEnum.VEHICLE_PRINT.getType().equals(printType)) {
            printName = PRINT_VEHICLE_INVOICE_MACHINE_KEY + jqbh + '_' + RequestContext.get().getUserId();
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u8bc6\u522b\u7684\u6253\u5370\u7c7b\u578b%s", (String)"PrintInvoiceControl_8", (String)"imc-sim-service", (Object[])new Object[0]), printType));
        }
        return printName;
    }

    public static String getPrintName(String defaultPrinter, String cachePrintName, JSONArray otherPrintMachine) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u83b7\u53d6\u7684\u7ec4\u4ef6\u9ed8\u8ba4\u6253\u5370\u673a default_printer\uff1a" + defaultPrinter);
        }
        if (StringUtils.isNotBlank((CharSequence)cachePrintName) && otherPrintMachine.size() > 0) {
            boolean flag = false;
            for (Object obj : otherPrintMachine) {
                JSONObject jObj = JSONObject.parseObject((String)obj.toString());
                if (!cachePrintName.equals(jObj.getString("name"))) continue;
                flag = true;
                break;
            }
            if (flag) {
                defaultPrinter = cachePrintName;
            }
        }
        return defaultPrinter;
    }
}

