/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.util;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.formplugin.invoicebatch.InvoiceBatchFileImportUtil;
import org.apache.poi.ss.usermodel.Row;

public class InvoiceImportDialogUtil {
    private static final Log LOGGER = LogFactory.getLog(InvoiceImportDialogUtil.class);
    private static final JSONArray POLICY_CONTENTS = JSONArray.parseArray((String)"[\"\u51fa\u53e3\u514d\u7a0e\u548c\u5176\u5b83\u514d\u7a0e\u4f18\u60e0\u653f\u7b56\",\"\u4e0d\u5f81\u589e\u503c\u7a0e\",\"\u5373\u5f81\u5373\u900050%\", \"\u5373\u5f81\u5373\u900030%\", \"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81\", \"\u7a00\u571f\u4ea7\u54c1\", \"\u8d85\u7a0e\u8d1f12%\u5373\u5f81\u5373\u9000\", \"\u4e0d\u5f81\u7a0e\", \"\u5373\u5f81\u5373\u900070%\", \"\u7b80\u6613\u5f81\u6536\", \"\u63093%\u7b80\u6613\u5f81\u6536\", \"\u5373\u5f81\u5373\u9000100%\", \"50%\u5148\u5f81\u540e\u9000\", \"\u514d\u7a0e\", \"\u5148\u5f81\u540e\u9000\", \"\u63095%\u7b80\u6613\u5f81\u6536\", \"\u8d85\u7a0e\u8d1f8%\u5373\u5f81\u5373\u9000\", \"100%\u5148\u5f81\u540e\u9000\", \"\u8d85\u7a0e\u8d1f3%\u5373\u5f81\u5373\u9000\"]");

    public static void formatExcelData(LinkedList<Map<String, Object>> list) {
        if (list.size() > 0) {
            for (Map map : list) {
                if (map.get("issuetype").equals("\u7ea2\u7968")) {
                    map.put("issuetype", "1");
                } else {
                    map.put("issuetype", "0");
                }
                if (map.get("invoicestatus").equals("\u6b63\u5e38")) {
                    map.put("invoicestatus", "0");
                } else if (map.get("invoicestatus").equals("\u7ea2\u51b2")) {
                    map.put("invoicestatus", "3");
                } else {
                    map.put("invoicestatus", "6");
                }
                if (map.get("invoicetype").equals("\u7535\u5b50\u666e\u901a\u53d1\u7968")) {
                    map.put("invoicetype", "026");
                } else if (map.get("invoicetype").equals("\u7535\u5b50\u4e13\u7528\u53d1\u7968")) {
                    map.put("invoicetype", "028");
                } else if (map.get("invoicetype").equals("\u7eb8\u8d28\u666e\u901a\u53d1\u7968")) {
                    map.put("invoicetype", "007");
                } else {
                    map.put("invoicetype", "004");
                }
                if (map.get("taxedtype").equals("\u666e\u901a\u5f81\u7a0e")) {
                    map.put("taxedtype", "0");
                } else {
                    map.put("taxedtype", "2");
                }
                if (map.get("rowtype").equals("\u6298\u6263\u884c")) {
                    map.put("rowtype", "1");
                } else {
                    map.put("rowtype", "0");
                }
                if (StringUtils.isNotBlank(map.get("taxpremark"))) {
                    if (map.get("taxpremark").equals("\u4eab\u53d7")) {
                        map.put("taxpremark", "1");
                    } else {
                        map.put("taxpremark", "0");
                    }
                }
                String taxRate = (String)map.get("taxrate");
                map.put("taxrate", TaxRateUtil.okTaxRate((String)taxRate));
                if (!map.get("invoicecopy").equals("\u65e0")) continue;
                map.put("invoicecopy", "-1");
            }
        }
    }

    public static Boolean invoiceBaseCheck(LinkedList<Map<String, Object>> mapList, Map<String, FileField> fieldMap, ArrayList<String> codeNoList, Map<String, Map<String, String>> TAX_NUMBER_MAP, String saleTaxNo, Map<String, String> errMap) {
        Boolean result = Boolean.TRUE;
        Integer seq = 0;
        for (Map map : mapList) {
            Boolean isAccess;
            BigDecimal tempAmount;
            String fieldKey;
            Row row = (Row)map.get("row");
            String codeNo = map.get("invoicecode") + map.get("invoiceno").toString();
            Integer n = seq;
            seq = Integer.valueOf(seq + 1);
            String[] stringArray = seq;
            map.put("seq", n);
            if (codeNoList.contains(codeNo)) {
                InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "invoicecode", row, ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165", (String)"InvoiceImportDialogUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
                InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "invoiceno", row, ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165", (String)"InvoiceImportDialogUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
                result = Boolean.FALSE;
            }
            if (!saleTaxNo.equals(map.get("salertaxno"))) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "salertaxno", row, ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0e\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4", (String)"InvoiceImportDialogUtil_1", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (!RegexUtil.isInvoiceCode((String)map.get("invoicecode").toString())) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "invoicecode", row, ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_2", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (!RegexUtil.isInvoiceNo((String)map.get("invoiceno").toString())) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "invoiceno", row, ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_3", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (!RegexUtil.isNsrsbh((String)map.get("salertaxno").toString())) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "salertaxno", row, ResManager.loadKDString((String)"\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_4", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (map.get("invoicetype").equals("027") || map.get("invoicetype").equals("004")) {
                if (StringUtils.isBlank(map.get("buyeraddr"))) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "buyeraddr", row, ResManager.loadKDString((String)"\u4e13\u7968\u65f6\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u5fc5\u586b", (String)"InvoiceImportDialogUtil_5", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank(map.get("buyerbank"))) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "buyerbank", row, ResManager.loadKDString((String)"\u4e13\u7968\u65f6\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7\u5fc5\u586b", (String)"InvoiceImportDialogUtil_6", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
            if (StringUtils.isNotBlank(map.get("buyeremail"))) {
                String[] split = map.get("buyeremail").toString().split(",");
                if (split.length > 10) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "buyeremail", row, ResManager.loadKDString((String)"\u90ae\u7bb1\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"InvoiceImportDialogUtil_7", (String)"imc-sim-service", (Object[])new Object[0]));
                } else {
                    for (String email : split) {
                        if (RegexUtil.isEmail((String)email)) continue;
                        result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "buyeremail", row, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_8", (String)"imc-sim-service", (Object[])new Object[0]));
                        break;
                    }
                }
            }
            if (StringUtils.isNotBlank(map.get("taxedtype")) && map.get("taxedtype").equals("2")) {
                try {
                    if (StringUtils.isBlank(map.get("deduction"))) {
                        result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "deduction", row, ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u65f6\u6263\u9664\u989d\u5fc5\u586b", (String)"InvoiceImportDialogUtil_9", (String)"imc-sim-service", (Object[])new Object[0]));
                    } else if (new BigDecimal(map.get("deduction").toString()).compareTo(BigDecimal.ZERO) < 0) {
                        result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "deduction", row, ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u65f6\u6263\u9664\u989d\u5fc5\u987b\u5927\u4e8e\u96f6", (String)"InvoiceImportDialogUtil_10", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "deduction", row, e.getMessage());
                }
            }
            if (map.get("issuetype").equals("0")) {
                fieldKey = "";
                try {
                    if (StringUtils.isNotBlank(map.get("num"))) {
                        fieldKey = "num";
                        if (new BigDecimal(map.get("num").toString()).compareTo(BigDecimal.ZERO) <= 0 && map.get("rowtype").equals("0")) {
                            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "num", row, ResManager.loadKDString((String)"\u53d1\u7968\u4e3a\u84dd\u7968\u7c7b\u578b\u65f6\u666e\u901a\u5546\u54c1\u884c\u7684\u6570\u91cf\u5e94\u5927\u4e8e0", (String)"InvoiceImportDialogUtil_11", (String)"imc-sim-service", (Object[])new Object[0]));
                        }
                    }
                    fieldKey = "amount";
                    if (new BigDecimal(map.get("amount").toString()).compareTo(BigDecimal.ZERO) <= 0 && map.get("rowtype").equals("0")) {
                        result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u53d1\u7968\u4e3a\u84dd\u7968\u7c7b\u578b\u65f6\u666e\u901a\u5546\u54c1\u884c\u7684\u91d1\u989d\u5e94\u5927\u4e8e0", (String)"InvoiceImportDialogUtil_12", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, fieldKey, row, String.format(ResManager.loadKDString((String)"\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u586b\u5165\u6570\u5b57\u7c7b\u578b%s", (String)"InvoiceImportDialogUtil_13", (String)"imc-sim-service", (Object[])new Object[0]), e.getMessage()));
                }
            } else {
                fieldKey = "";
                try {
                    if (StringUtils.isNotBlank(map.get("num"))) {
                        fieldKey = "num";
                        if (new BigDecimal(map.get("num").toString()).compareTo(BigDecimal.ZERO) >= 0 && map.get("rowtype").equals("0")) {
                            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "num", row, ResManager.loadKDString((String)"\u53d1\u7968\u4e3a\u7ea2\u7968\u7c7b\u578b\u65f6\u666e\u901a\u5546\u54c1\u884c\u7684\u6570\u91cf\u5e94\u5c0f\u4e8e0", (String)"InvoiceImportDialogUtil_14", (String)"imc-sim-service", (Object[])new Object[0]));
                        }
                    }
                    fieldKey = "amount";
                    if (new BigDecimal(map.get("amount").toString()).compareTo(BigDecimal.ZERO) >= 0 && map.get("rowtype").equals("0")) {
                        result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u53d1\u7968\u4e3a\u7ea2\u7968\u7c7b\u578b\u65f6\u666e\u901a\u5546\u54c1\u884c\u7684\u91d1\u989d\u5e94\u5c0f\u4e8e0", (String)"InvoiceImportDialogUtil_15", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, fieldKey, row, String.format(ResManager.loadKDString((String)"\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u586b\u5165\u6570\u5b57\u7c7b\u578b%1$s", (String)"InvoiceImportDialogUtil_16", (String)"imc-sim-service", (Object[])new Object[0]), e.getMessage()));
                }
                if (map.get("invoicestatus").equals("3")) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "invoicestatus", row, ResManager.loadKDString((String)"\u7ea2\u7968\u6ca1\u6709\u7ea2\u51b2\u72b6\u6001", (String)"InvoiceImportDialogUtil_17", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank(map.get("originalinvoiceno")) && !RegexUtil.isInvoiceNo((String)map.get("originalinvoiceno").toString())) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "originalinvoiceno", row, ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_18", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank(map.get("originalinvoicecode")) && !RegexUtil.isInvoiceCode((String)map.get("originalinvoicecode").toString())) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "originalinvoicecode", row, ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4ee3\u7801\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_19", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
            if (!RegexUtil.isNumber((String)map.get("goodscode").toString())) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "goodscode", row, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_20", (String)"imc-sim-service", (Object[])new Object[0]));
            } else {
                String goodsName = (String)map.get("goodsname");
                goodsName = goodsName == null ? "" : goodsName;
                Matcher matcher = SimpleGoodsNameUtil.REGEX_GOODS_NAME.matcher(goodsName);
                if (matcher.find() && StringUtils.isNotBlank((CharSequence)goodsName.substring(matcher.group(0).length()))) {
                    Map<String, String> goodsInfo = InvoiceImportDialogUtil.checkBillNumber(map, TAX_NUMBER_MAP);
                    if (goodsInfo.get("success").equals("-1")) {
                        result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "goodscode", row, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u4e3a\u6c47\u603b\u9879", (String)"InvoiceImportDialogUtil_21", (String)"imc-sim-service", (Object[])new Object[0]));
                    } else {
                        DynamicObject taxClassCode;
                        if (!goodsInfo.get("goodscode").equals(map.get("goodscode"))) {
                            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "goodscode", row, ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0\u548c\u7a0e\u6536\u5408\u5e76\u7f16\u7801\u4e0d\u5339\u914d", (String)"InvoiceImportDialogUtil_22", (String)"imc-sim-service", (Object[])new Object[0]));
                        }
                        if ((taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)goodsInfo.get("goodscode"))) != null) {
                            String simplerGoodsName = matcher.group(0);
                            if (simplerGoodsName.equals('*' + taxClassCode.getString("simplename") + '*')) {
                                map.put("simplegoodsname", simplerGoodsName);
                            } else {
                                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "goodsname", row, ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u4e2d\u7684\u7b80\u7801\u4e0e\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5bf9\u5e94\u7684\u7b80\u7801\u4e0d\u4e00\u81f4", (String)"InvoiceImportDialogUtil_23", (String)"imc-sim-service", (Object[])new Object[0]));
                            }
                        } else {
                            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "goodscode", row, ResManager.loadKDString((String)"\u672a\u627e\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5bf9\u5e94\u7684\u5546\u54c1\u7b80\u7801", (String)"InvoiceImportDialogUtil_24", (String)"imc-sim-service", (Object[])new Object[0]));
                        }
                    }
                } else {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "goodsname", row, ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u7684\u5305\u542b\u5546\u54c1\u7b80\u79f0\u548c\u5546\u54c1\u540d\u79f0\uff0c\u683c\u5f0f\u4e3a\u3010*\u5546\u54c1\u7b80\u7801*\u5546\u54c1\u540d\u79f0\u3011", (String)"InvoiceImportDialogUtil_25", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
            if (map.get("invoicestatus").equals("0") && map.get("issuetype").equals("1")) {
                if (StringUtils.isBlank((CharSequence)"originalinvoicecode")) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "originalinvoicecode", row, ResManager.loadKDString((String)"\u6b63\u5e38\u7684\u7ea2\u7968\u539f\u59cb\u53d1\u7968\u4ee3\u7801\u5fc5\u586b", (String)"InvoiceImportDialogUtil_26", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((CharSequence)"originalinvoicecode")) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "originalinvoicecode", row, ResManager.loadKDString((String)"\u6b63\u5e38\u7684\u7ea2\u7968\u539f\u59cb\u53d1\u7968\u53f7\u7801\u5fc5\u586b", (String)"InvoiceImportDialogUtil_27", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            } else {
                map.put("originalinvoicecode", "");
                map.put("originalinvoiceno", "");
            }
            if (map.get("rowtype").equals("1")) {
                if (new BigDecimal(map.get("amount").toString()).compareTo(BigDecimal.ZERO) >= 0) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u6298\u6263\u884c\u7684\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u96f6", (String)"InvoiceImportDialogUtil_28", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                map.put("num", "");
                map.put("unitprice", "");
                map.put("taxunitprice", "");
                map.put("specification", "");
                map.put("unit", "");
            }
            if (StringUtils.isBlank(map.get("num")) && StringUtils.isNotBlank(map.get("unitprice")) || StringUtils.isNotBlank(map.get("num")) && StringUtils.isBlank(map.get("unitprice"))) {
                InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "num", row, ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u6570\u91cf\u548c\u5355\u4ef7\u9700\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u4e0d\u4e3a\u7a7a", (String)"InvoiceImportDialogUtil_29", (String)"imc-sim-service", (Object[])new Object[0]));
                InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "unitprice", row, ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u6570\u91cf\u548c\u5355\u4ef7\u9700\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u4e0d\u4e3a\u7a7a", (String)"InvoiceImportDialogUtil_29", (String)"imc-sim-service", (Object[])new Object[0]));
                result = Boolean.FALSE;
            } else if (StringUtils.isBlank(map.get("num")) && StringUtils.isBlank(map.get("unitprice")) && StringUtils.isBlank(map.get("amount"))) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u6570\u91cf\u548c\u5355\u4ef7\u4e3a\u7a7a\u65f6\u91d1\u989d\u5fc5\u586b", (String)"InvoiceImportDialogUtil_30", (String)"imc-sim-service", (Object[])new Object[0]));
            } else if (StringUtils.isNotBlank(map.get("num")) && StringUtils.isNotBlank(map.get("unitprice")) && (tempAmount = new BigDecimal(map.get("num").toString()).multiply(new BigDecimal(map.get("unitprice").toString())).setScale(2, 4)).compareTo(new BigDecimal(map.get("amount").toString()).setScale(2, 4)) != 0) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u6570\u91cf\u548c\u5355\u4ef7\u4e58\u79ef\u4e0e\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"InvoiceImportDialogUtil_31", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BigDecimal amount = new BigDecimal(map.get("amount").toString());
            if (map.get("taxedtype").equals("2") && map.get("rowtype").equals("0") && StringUtils.isNotBlank(map.get("deduction"))) {
                BigDecimal deduction = new BigDecimal(map.get("deduction").toString()).setScale(2, 4).abs();
                if (map.get("issuetype").equals("1")) {
                    deduction = deduction.negate();
                }
                amount = new BigDecimal(map.get("amount").toString()).subtract(deduction);
            }
            if (amount.multiply(new BigDecimal(map.get("taxrate").toString())).subtract(new BigDecimal(map.get("tax").toString())).abs().compareTo(new BigDecimal("0.06")) > 0) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "tax", row, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u5355\u884c\u7a0e\u989d\u8bef\u5dee\u4e0d\u80fd\u5927\u4e8e0.06", (String)"InvoiceImportDialogUtil_32", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if ((isAccess = InvoiceImportDialogUtil.TAX_PREMARKCheck(map, row, errMap, fieldMap)).booleanValue()) continue;
            result = Boolean.FALSE;
        }
        return result;
    }

    private static Boolean dealErrResult(Map<String, FileField> fieldMap, Map<String, String> errMap, String key, Row row, String msg) {
        InvoiceBatchFileImportUtil.setBaseErrorMessage(row, fieldMap.get(key), errMap, msg);
        return Boolean.FALSE;
    }

    private static Map<String, String> checkBillNumber(Map<String, Object> map, Map<String, Map<String, String>> TAX_NUMBER_MAP) {
        Map<Object, Object> goodsInfo = Maps.newHashMapWithExpectedSize((int)8);
        String goodscode = (String)map.get("goodscode");
        if (StringUtils.isNotBlank((CharSequence)goodscode)) {
            goodsInfo = TAX_NUMBER_MAP.get(goodscode);
            if (goodsInfo == null) {
                goodsInfo = InvoiceImportDialogUtil.findParamsByGoodsCode(goodscode);
            }
        } else {
            goodsInfo.put("success", "-1");
        }
        return goodsInfo;
    }

    private static Map<String, String> findParamsByGoodsCode(Object goodscode) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        if (StringUtils.isNotBlank((Object)goodscode)) {
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)goodscode.toString());
            if (taxClassCode != null) {
                result.put("goodscode", taxClassCode.getString("mergecode"));
                result.put("taxrate", taxClassCode.getString("taxrate"));
                result.put("success", "1");
            } else {
                result.put("success", "-1");
            }
        } else {
            result.put("success", "-1");
        }
        return result;
    }

    public static Boolean checkDetailAndCount(DynamicObject dynamicObject, Map<String, FileField> fieldMap, Row row, Map<String, String> errMap) {
        Boolean result = Boolean.TRUE;
        BigDecimal totalAmount = dynamicObject.getBigDecimal("totalamount").setScale(2, 4);
        BigDecimal invoiceAmount = dynamicObject.getBigDecimal("invoiceamount").setScale(2, 4);
        BigDecimal totalTax = dynamicObject.getBigDecimal("totaltax").setScale(2, 4);
        DynamicObjectCollection dyCollection = dynamicObject.getDynamicObjectCollection("items");
        BigDecimal tAmount = BigDecimal.ZERO;
        BigDecimal iAmount = BigDecimal.ZERO;
        BigDecimal tTax = BigDecimal.ZERO;
        Integer disFlag = 0;
        Boolean isFuShu = invoiceAmount.compareTo(BigDecimal.ZERO) < 0;
        String taxRate = "";
        BigDecimal amount = BigDecimal.ZERO;
        for (DynamicObject object : dyCollection) {
            String isDis = object.getString("rowtype");
            if (isDis.equals("1")) {
                if (object.getInt("seq") - disFlag < 1) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "rowtype", row, ResManager.loadKDString((String)"\u6298\u6263\u884c\u5fc5\u987b\u8ddf\u968f\u5728\u88ab\u6298\u6263\u884c\u4e4b\u540e\uff0c\u4e14\u4e0d\u80fd\u4e3a\u660e\u7ec6\u884c\u7b2c\u4e00\u884c", (String)"InvoiceImportDialogUtil_33", (String)"imc-sim-service", (Object[])new Object[0]));
                } else if (isFuShu.booleanValue()) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "rowtype", row, ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968\u4e0d\u80fd\u6709\u6298\u6263\u884c", (String)"InvoiceImportDialogUtil_34", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (!taxRate.equals(object.getString("taxrate"))) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "taxrate", row, ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u7a0e\u7387\u9700\u4e0e\u88ab\u6298\u6263\u884c(\u666e\u901a\u5546\u54c1\u884c)\u4fdd\u6301\u4e00\u81f4", (String)"InvoiceImportDialogUtil_35", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (amount.compareTo(object.getBigDecimal("amount")) < 0) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u91d1\u989d\u9700\u5c0f\u4e8e\u5546\u54c1\u884c\u7684\u91d1\u989d", (String)"InvoiceImportDialogUtil_36", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            } else {
                taxRate = object.getString("taxrate");
                amount = object.getBigDecimal("amount");
            }
            disFlag = object.getInt("seq");
            tAmount = tAmount.add(object.getBigDecimal("taxamount"));
            iAmount = iAmount.add(object.getBigDecimal("amount"));
            tTax = tTax.add(object.getBigDecimal("tax"));
        }
        if (totalAmount.compareTo(tAmount) != 0) {
            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "totalamount", row, ResManager.loadKDString((String)"\u660e\u7ec6\u4ef7\u7a0e\u5408\u8ba1\u4e4b\u548c\u4e0e\u6c47\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4", (String)"InvoiceImportDialogUtil_37", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (invoiceAmount.compareTo(iAmount) != 0) {
            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "invoiceamount", row, ResManager.loadKDString((String)"\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u4e0e\u6c47\u603b\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"InvoiceImportDialogUtil_38", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (totalTax.compareTo(tTax) != 0) {
            result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "totaltax", row, ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u4e4b\u548c\u4e0e\u6c47\u603b\u7a0e\u989d\u4e0d\u4e00\u81f4", (String)"InvoiceImportDialogUtil_39", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (dynamicObject.getString("taxedtype").equals("2")) {
            DynamicObjectCollection details;
            BigDecimal deduction = dynamicObject.getBigDecimal("deduction");
            if (deduction.compareTo(BigDecimal.ZERO) > 0) {
                invoiceAmount = invoiceAmount.subtract(deduction);
            }
            if ((details = dynamicObject.getDynamicObjectCollection("items")).size() > 2) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "taxedtype", row, ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u65f6\u6700\u591a\u53ea\u80fd\u4e00\u884c\u5546\u54c1\u884c\u548c\u4e00\u884c\u6298\u6263\u884c", (String)"InvoiceImportDialogUtil_40", (String)"imc-sim-service", (Object[])new Object[0]));
            } else if (details.size() == 2) {
                if (!((DynamicObject)details.get(0)).getString("rowtype").equals("0")) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "taxedtype", row, ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u65f6\u7b2c\u4e00\u884c\u9700\u4e3a\u666e\u901a\u5546\u54c1\u884c", (String)"InvoiceImportDialogUtil_41", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (!((DynamicObject)details.get(1)).getString("rowtype").equals("1")) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "taxedtype", row, ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u65f6\u7b2c\u4e8c\u884c\u9700\u4e3a\u6298\u6263\u884c", (String)"InvoiceImportDialogUtil_42", (String)"imc-sim-service", (Object[])new Object[0]));
                } else if (invoiceAmount.compareTo(((DynamicObject)details.get(1)).getBigDecimal("amount")) < 0) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "amount", row, ResManager.loadKDString((String)"\u6298\u6263\u884c\u7684\u91d1\u989d\u4e0e\u666e\u901a\u5546\u54c1\u884c\u7684\u6263\u6263\u989d\u4e4b\u548c\u9700\u5c0f\u4e8e\u666e\u901a\u5546\u54c1\u884c\u7684\u91d1\u989d", (String)"InvoiceImportDialogUtil_43", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private static Boolean TAX_PREMARKCheck(Map<String, Object> map, Row row, Map<String, String> errMap, Map<String, FileField> fieldMap) {
        Boolean result = Boolean.TRUE;
        if (StringUtils.isNotBlank((Object)map.get("taxpremark")) && map.get("taxpremark").equals("1")) {
            if (StringUtils.isBlank((Object)map.get("zzstsgl"))) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u4e3a'\u4eab\u53d7'\u65f6\u5fc5\u586b", (String)"InvoiceImportDialogUtil_44", (String)"imc-sim-service", (Object[])new Object[0]));
            } else {
                String privilegeType = map.get("zzstsgl").toString();
                String taxRate = map.get("taxrate").toString();
                if (!POLICY_CONTENTS.contains(map.get("zzstsgl"))) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5339\u914d\u4e0d\u6b63\u786e", (String)"InvoiceImportDialogUtil_45", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if (("\u514d\u7a0e".equals(privilegeType) || "\u4e0d\u5f81\u7a0e".equals(privilegeType)) && !"0".equals(taxRate)) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u514d\u7a0e\u6216\u4e0d\u5f81\u7a0e\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceImportDialogUtil_46", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if ("\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.05".equals(taxRate) && !"0.04".equals(taxRate) && !"0.03".equals(taxRate)) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceImportDialogUtil_47", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if ("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81".equals(privilegeType) && !"0.015".equals(taxRate)) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u5f81,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceImportDialogUtil_48", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if ("\u63095%\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.05".equals(taxRate)) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceImportDialogUtil_49", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if ("\u63093%\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.03".equals(taxRate)) {
                    result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"InvoiceImportDialogUtil_50", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                if ("0".equals(taxRate)) {
                    if ("\u514d\u7a0e".equals(privilegeType)) {
                        map.put("zerotaxmark", "1");
                    } else if ("\u4e0d\u5f81\u7a0e".equals(privilegeType)) {
                        map.put("zerotaxmark", "2");
                    } else if ("\u51fa\u53e3\u9000\u7a0e".equals(privilegeType)) {
                        map.put("zerotaxmark", "0");
                    }
                }
            }
        } else if (map.get("taxpremark") == null || map.get("taxpremark").equals("") || map.get("taxpremark").equals("0")) {
            if (StringUtils.isNotBlank((Object)map.get("zzstsgl"))) {
                result = InvoiceImportDialogUtil.dealErrResult(fieldMap, errMap, "zzstsgl", row, ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u4e3a'\u4e0d\u4eab\u53d7'\u65f6\u9700\u4e3a\u7a7a", (String)"InvoiceImportDialogUtil_51", (String)"imc-sim-service", (Object[])new Object[0]));
            } else if ("0".equals(map.get("taxrate"))) {
                map.put("zerotaxmark", "3");
            }
        }
        return result;
    }
}

