/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;

public class RedInvoiceUtil {
    private static final Log LOG = LogFactory.getLog(RedInvoiceUtil.class);

    public static JSONArray convertRedDynamicObjectItemsToJsonArray(DynamicObject blueInvoiceDynamicObject, DynamicObjectCollection items) {
        boolean isRedInfo = false;
        if ("sim_red_info".equals(blueInvoiceDynamicObject.getDynamicObjectType().getName())) {
            isRedInfo = true;
        }
        JSONArray jsonArray = new JSONArray();
        BigDecimal deduction = blueInvoiceDynamicObject.getDataEntityType().getName().equals("sim_red_info") ? BigDecimal.ZERO : blueInvoiceDynamicObject.getBigDecimal("deduction");
        BigDecimal bigDecimal = deduction.stripTrailingZeros();
        BigDecimal negate = bigDecimal.negate().setScale(2, 4);
        RedInvoiceUtil.buildNormalRedJson(items, jsonArray, negate, isRedInfo);
        return jsonArray;
    }

    private static void buildNormalRedJson(DynamicObjectCollection items, JSONArray jsonArray, BigDecimal negate, boolean isRedInfo) {
        for (DynamicObject blueInvoiceItem : items) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("spmc", (Object)"");
            jsonObject.put("xmmc", blueInvoiceItem.get("goodsname"));
            jsonObject.put("spbm", blueInvoiceItem.get("goodscode"));
            jsonObject.put("xmlx", blueInvoiceItem.get("rowtype"));
            String taxRate = blueInvoiceItem.getString("taxrate");
            jsonObject.put("sl", (Object)taxRate);
            if (TaxRate.ZERO_PERCENT.getRateValue().equals(taxRate)) {
                if ("0".equals(blueInvoiceItem.getString("taxpremark")) && "3".equals(blueInvoiceItem.getString("zerotaxmark"))) {
                    jsonObject.put("slText", (Object)"0.00Z3");
                } else if ("1".equals(blueInvoiceItem.getString("taxpremark")) && "1".equals(blueInvoiceItem.getString("zerotaxmark"))) {
                    jsonObject.put("slText", (Object)"0.00Z1");
                } else if ("1".equals(blueInvoiceItem.getString("taxpremark")) && "2".equals(blueInvoiceItem.getString("zerotaxmark"))) {
                    jsonObject.put("slText", (Object)"0.00Z2");
                } else if (blueInvoiceItem.getString("zzstsgl").contains("\u51fa\u53e3")) {
                    jsonObject.put("slText", (Object)"0.00Z0");
                }
            } else {
                jsonObject.put("slText", (Object)taxRate);
            }
            jsonObject.put("ggxh", blueInvoiceItem.get("specification"));
            jsonObject.put("xmdw", blueInvoiceItem.get("unit"));
            jsonObject.put("kce", (Object)negate);
            BigDecimal num = blueInvoiceItem.getBigDecimal("num");
            if (MathUtils.isZero((BigDecimal)num)) {
                jsonObject.put("xmsl", (Object)"");
            } else {
                jsonObject.put("xmsl", (Object)UnitPriceHelper.getNumValue((BigDecimal)num).toPlainString());
            }
            BigDecimal unitPrice = (BigDecimal)blueInvoiceItem.get("unitprice");
            if (MathUtils.isZero((BigDecimal)unitPrice)) {
                jsonObject.put("xmdj", (Object)"");
                jsonObject.put("xmdjhs", (Object)"");
            } else {
                jsonObject.put("xmdj", (Object)PriceHelper.getValue((BigDecimal)unitPrice, (boolean)Boolean.FALSE).toPlainString());
                jsonObject.put("xmdjhs", (Object)PriceHelper.getValue((BigDecimal)blueInvoiceItem.getBigDecimal("taxunitprice"), (boolean)Boolean.FALSE).toPlainString());
            }
            jsonObject.put("xmje", (Object)blueInvoiceItem.getBigDecimal("amount").setScale(2, 4).toString());
            jsonObject.put("xmjehs", (Object)blueInvoiceItem.getBigDecimal("taxamount").setScale(2, 4).toString());
            if (!isRedInfo) {
                Object originalInvoiceItemId = blueInvoiceItem.get("originalinvoiceitemid");
                if (originalInvoiceItemId != null) {
                    jsonObject.put("originalinvoiceitemid", (Object)originalInvoiceItemId.toString());
                }
                jsonObject.put("itemremainredamount", (Object)blueInvoiceItem.getBigDecimal("itemremainredamount"));
            }
            jsonObject.put("billsourceid", blueInvoiceItem.get("billsourceid"));
            jsonObject.put("se", (Object)blueInvoiceItem.getBigDecimal("tax").setScale(2, 4).toString());
            jsonObject.put("unit", blueInvoiceItem.get("unit"));
            jsonArray.add((Object)jsonObject);
        }
    }

    public static DynamicObjectCollection convertItemsBlueToRed(DynamicObject blueDynamicObject, DynamicObjectCollection detailList, String tableName) {
        DynamicObject redDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)tableName);
        DynamicObjectCollection newRedItems = new DynamicObjectCollection(((DynamicObject)detailList.get(0)).getDynamicObjectType(), (Object)redDynamicObject);
        int zkIndex = 0;
        for (int i = 0; i < detailList.size(); ++i) {
            DynamicObject detail = (DynamicObject)detailList.get(i);
            String rowType = detail.getString("rowtype");
            if (tableName.equals("sim_original_bill") && "2".equals(rowType)) {
                rowType = "0";
            }
            DynamicObject newRedItem = null;
            if ("0".equals(rowType)) {
                if (i + 1 < detailList.size()) {
                    DynamicObject nextRow = (DynamicObject)detailList.get(i + 1);
                    BigDecimal taxAmount = detail.getBigDecimal("taxamount");
                    BigDecimal nextRowTaxAmount = nextRow.getBigDecimal("taxamount");
                    BigDecimal addTaxAmount = taxAmount.add(nextRowTaxAmount);
                    if ("1".equals(nextRow.getString("rowtype")) && BigDecimal.ZERO.compareTo(addTaxAmount) == 0) {
                        ++i;
                        continue;
                    }
                }
                newRedItem = newRedItems.addNew();
                RedInvoiceUtil.handleData(newRedItem, detail);
                ++zkIndex;
            } else if ("2".equals(rowType)) {
                DynamicObject beDiscountRow = (DynamicObject)detailList.get(i);
                DynamicObject discountRow = (DynamicObject)detailList.get(i + 1);
                BigDecimal amount = beDiscountRow.getBigDecimal("amount");
                BigDecimal disAmount = discountRow.getBigDecimal("amount");
                if (amount.abs().compareTo(disAmount.abs()) != 0) {
                    newRedItem = newRedItems.addNew();
                    RedInvoiceUtil.handleItemWithZK(detailList, tableName, i, detail, newRedItem);
                }
            } else if ("1".equals(rowType) && tableName.equals("sim_original_bill")) {
                RedInvoiceUtil.handleOriginBillItemZK(blueDynamicObject, newRedItems, detail, zkIndex);
            }
            if (newRedItem == null || !tableName.equals("sim_vatinvoice")) continue;
            newRedItem.set("originalinvoiceitemid", detail.get("id"));
            newRedItem.set("itemremainredamount", (Object)detail.getBigDecimal("itemremainredamount"));
            newRedItem.set("itemremainredtax", (Object)detail.getBigDecimal("itemremainredtax"));
            newRedItem.set("billsourceid", detail.get("billsourceid"));
        }
        return newRedItems;
    }

    public static void handleOriginBillItemZK(DynamicObject blueDynamicObject, DynamicObjectCollection newRedItems, DynamicObject zkItem, int zkIndex) {
        DynamicObject bzkItem = (DynamicObject)newRedItems.get(zkIndex - 1);
        BigDecimal billItemTaxRate = new BigDecimal(bzkItem.getString("taxrate"));
        if ("0".equals(blueDynamicObject.get("hsbz"))) {
            BigDecimal newAmount = bzkItem.getBigDecimal("amount").subtract(zkItem.getBigDecimal("amount"));
            bzkItem.set("amount", (Object)newAmount);
            BigDecimal tax = newAmount.multiply(billItemTaxRate).setScale(2, RoundingMode.HALF_UP);
            bzkItem.set("tax", (Object)tax);
            BigDecimal newHSAmount = tax.add(newAmount);
            bzkItem.set("taxamount", (Object)newHSAmount);
            if (!MathUtils.isZero((BigDecimal)bzkItem.getBigDecimal("num"))) {
                BigDecimal newNum = UnitPriceHelper.calcNum((BigDecimal)newAmount, (BigDecimal)bzkItem.getBigDecimal("unitprice"));
                bzkItem.set("num", (Object)newNum);
                bzkItem.set("remainvalidnum", (Object)newNum);
            }
            bzkItem.set("remainvalidamount", (Object)newAmount);
            bzkItem.set("remainvalidtax", (Object)tax);
        } else {
            BigDecimal newHSAmount = bzkItem.getBigDecimal("taxamount").subtract(zkItem.getBigDecimal("taxamount"));
            bzkItem.set("taxamount", (Object)newHSAmount);
            BigDecimal newAmount = newHSAmount.divide(BigDecimal.ONE.add(billItemTaxRate), 2, RoundingMode.HALF_UP);
            bzkItem.set("amount", (Object)newAmount);
            BigDecimal tax = newHSAmount.subtract(newAmount);
            bzkItem.set("tax", (Object)tax);
            if (!MathUtils.isZero((BigDecimal)bzkItem.getBigDecimal("num"))) {
                BigDecimal newNum = UnitPriceHelper.calcNum((BigDecimal)newHSAmount, (BigDecimal)bzkItem.getBigDecimal("taxunitprice"));
                bzkItem.set("num", (Object)newNum);
                bzkItem.set("remainvalidnum", (Object)newNum);
            }
            bzkItem.set("remainvalidamount", (Object)newHSAmount);
            bzkItem.set("remainvalidtax", (Object)tax);
        }
        bzkItem.set("issuedamount", (Object)BigDecimal.ZERO);
        bzkItem.set("issuedtotaltaxamount", (Object)BigDecimal.ZERO);
        bzkItem.set("issuedtax", (Object)BigDecimal.ZERO);
        bzkItem.set("taxdeviation", (Object)BigDecimal.ZERO);
        bzkItem.set("amountdeviation", (Object)BigDecimal.ZERO);
        bzkItem.set("numdeviation", (Object)BigDecimal.ZERO);
    }

    private static void handleItemWithZK(DynamicObjectCollection detailList, String tableName, int i, DynamicObject detail, DynamicObject newRedItem) {
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)tableName);
        DynamicObjectCollection items = invoice.getDynamicObjectCollection(detailList.getDynamicObjectType().getName());
        DynamicObject bzk = items.addNew();
        RedInvoiceUtil.handleData(bzk, detail);
        DynamicObject zkDetail = (DynamicObject)detailList.get(i + 1);
        DynamicObject zk = items.addNew();
        RedInvoiceUtil.handleData(zk, zkDetail);
        RedInvoiceUtil.mergeData(bzk, zk, newRedItem);
    }

    private static void handleData(DynamicObject newObj, DynamicObject detail) {
        for (IDataEntityProperty property : detail.getDynamicObjectType().getProperties()) {
            BigDecimal value;
            if ("id".equals(property.getName())) continue;
            if ("unitprice".equals(property.getName())) {
                value = detail.getBigDecimal(property.getName());
                newObj.set(property.getName(), (Object)value);
                continue;
            }
            if ("taxunitprice".equals(property.getName())) {
                value = detail.getBigDecimal(property.getName());
                newObj.set(property.getName(), (Object)value);
                continue;
            }
            if (detail.get(property.getName()) instanceof BigDecimal) {
                value = detail.getBigDecimal(property.getName());
                if (value.compareTo(BigDecimal.ZERO) != 0) {
                    value = value.negate();
                }
                newObj.set(property.getName(), (Object)value);
                continue;
            }
            newObj.set(property.getName(), detail.get(property.getName()));
        }
    }

    public static void mergeData(DynamicObject bzk, DynamicObject zk, DynamicObject newObj) {
        DataEntityPropertyCollection propertys = bzk.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertys) {
            newObj.set(property.getName(), bzk.get(property.getName()));
        }
        BigDecimal amount1 = bzk.getBigDecimal("amount");
        BigDecimal amount2 = zk.getBigDecimal("amount");
        BigDecimal amount3 = amount1.add(amount2);
        newObj.set("amount", (Object)amount3);
        BigDecimal tax1 = bzk.getBigDecimal("tax");
        BigDecimal tax2 = zk.getBigDecimal("tax");
        newObj.set("tax", (Object)tax1.add(tax2));
        BigDecimal taxamount = amount3.add(tax1.add(tax2));
        newObj.set("taxamount", (Object)taxamount);
        BigDecimal num = newObj.getBigDecimal("num");
        if (new BigDecimal(0).compareTo(num) != 0) {
            BigDecimal unitprice = PriceHelper.calcPriceOrNum((BigDecimal)amount3, (BigDecimal)num, (boolean)Boolean.FALSE);
            BigDecimal taxunitprice = PriceHelper.calcPriceOrNum((BigDecimal)taxamount, (BigDecimal)num, (boolean)Boolean.FALSE);
            newObj.set("unitprice", (Object)unitprice);
            newObj.set("taxunitprice", (Object)taxunitprice);
        }
        newObj.set("rowtype", (Object)"0");
    }

    public static DynamicObject blueInvoiceConvertToRed(DynamicObject blueInvoiceObj, boolean isNewObj) {
        DynamicObject redObject;
        boolean isExit = false;
        if (isNewObj) {
            redObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        } else {
            QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)blueInvoiceObj.get("orgid"))).and("originalinvoicecode", "=", blueInvoiceObj.get("invoicecode")).and("originalinvoiceno", "=", blueInvoiceObj.get("invoiceno")).and("invoicestatus", "!=", (Object)"6");
            redObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilter.toArray());
            if (redObject != null) {
                redObject = BusinessDataServiceHelper.loadSingle((Object)redObject.getPkValue(), (String)"sim_vatinvoice");
                isExit = true;
            } else {
                redObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            }
        }
        if (isExit) {
            return redObject;
        }
        DataEntityPropertyCollection properties = blueInvoiceObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            BigDecimal value;
            if ("id".equals(property.getName()) || "invoicingoperator".equals(property.getName())) continue;
            if ("items".equals(property.getName())) {
                DynamicObjectCollection items = RedInvoiceUtil.convertItemsBlueToRed(blueInvoiceObj, blueInvoiceObj.getDynamicObjectCollection("items"), "sim_vatinvoice");
                DynamicObjectCollection redItems = redObject.getDynamicObjectCollection("items");
                for (DynamicObject item : items) {
                    DynamicObject redItem = redItems.addNew();
                    DynamicObjectUtil.copyDynamicObject((DynamicObject)item, (DynamicObject)redItem, (boolean)false, (boolean)true, (boolean)true);
                }
                continue;
            }
            if (property instanceof EntryProp) continue;
            if ("totalamount".equals(property.getName())) {
                value = blueInvoiceObj.getBigDecimal(property.getName()).setScale(2, 4);
                redObject.set(property.getName(), (Object)value.negate());
                continue;
            }
            if ("invoiceamount".equals(property.getName())) {
                value = blueInvoiceObj.getBigDecimal(property.getName()).setScale(2, 4);
                redObject.set(property.getName(), (Object)value.negate());
                continue;
            }
            if ("totaltax".equals(property.getName())) {
                value = blueInvoiceObj.getBigDecimal(property.getName()).setScale(2, 4);
                redObject.set(property.getName(), (Object)value.negate());
                continue;
            }
            redObject.set(property.getName(), blueInvoiceObj.get(property.getName()));
        }
        redObject.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        redObject.set("originalinvoicecode", blueInvoiceObj.get("invoicecode"));
        redObject.set("originalinvoiceno", blueInvoiceObj.get("invoiceno"));
        redObject.set("originalissuetime", blueInvoiceObj.get("issuetime"));
        redObject.set("originalinvoicetype", blueInvoiceObj.get("invoicetype"));
        redObject.set("createtime", (Object)new Date());
        redObject.set("invoicecode", (Object)"");
        redObject.set("invoiceno", (Object)"");
        redObject.set("checkcode", (Object)"");
        redObject.set("skm", (Object)"");
        redObject.set("issuetime", null);
        redObject.set("deduction", (Object)blueInvoiceObj.getBigDecimal("deduction").negate());
        redObject.set("taxedtype", blueInvoiceObj.get("taxedtype"));
        redObject.set("invoicestatus", null);
        redObject.set("remark", (Object)"");
        redObject.set("issuewritebackstatus", (Object)"0");
        redObject.set("issuewritebackreason", (Object)"");
        redObject.set("abolishwritebackstatus", (Object)"2");
        redObject.set("orderno", (Object)UUID.next());
        redObject.set("thirdserialno", (Object)redObject.getString("orderno"));
        redObject.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        redObject.set("invoicestatus", null);
        SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)blueInvoiceObj.get("orgid")));
        redObject.set("salername", (Object)saleInfoByOrg.getSaleName());
        redObject.set("salertaxno", (Object)saleInfoByOrg.getSaleTaxNo());
        redObject.set("remainredamount", (Object)BigDecimal.ZERO);
        redObject.set("canredtaxamount", (Object)BigDecimal.ZERO);
        try {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)((BasedataProp)properties.get((Object)"invoicingoperator")).getBaseEntityId());
            object.set("id", (Object)Long.parseLong(RequestContext.get().getUserId()));
            redObject.set("invoicingoperator", (Object)object);
        }
        catch (Exception e) {
            redObject.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        }
        if (StringUtils.isBlank((CharSequence)redObject.getString("billno"))) {
            redObject.set("billno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        }
        return redObject;
    }

    public static DynamicObject blueInvoiceConvertToRed(DynamicObject blueInvoiceObj) {
        return RedInvoiceUtil.blueInvoiceConvertToRed(blueInvoiceObj, false);
    }
}

