/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import org.apache.commons.collections.CollectionUtils;

public class BillComprehensiveStatusHelper {
    public static final String SELECT_FIELD = String.join((CharSequence)",", "id", "matchstatus", "matchtarget", "pushdownstatus");

    public void setBillComprehensiveStatusByMatchBill(DynamicObject matchBill) {
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "=", (Object)matchBill.getLong("id")).toArray());
        if (CollectionUtils.isEmpty((Collection)relations)) {
            return;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"comprehensivestatus", (QFilter[])new QFilter("id", "in", (Object)relations.stream().map(relation -> relation.getLong("sbillid")).distinct().toArray()).toArray());
        this.setBillsComprehensiveStatusByMatchBill(matchBill, bills);
        ImcSaveServiceHelper.update((DynamicObject[])bills);
    }

    public void setBillsComprehensiveStatusByMatchBill(DynamicObject matchBill, DynamicObject[] bills) {
        String matchTarget;
        boolean isMatchRedConfirm;
        String matchStatus = matchBill.getString("matchstatus");
        if (StringUtils.isBlank((CharSequence)matchStatus) || bills == null || bills.length == 0) {
            return;
        }
        switch (bills[0].getString("comprehensivestatus")) {
            case "08": 
            case "09": 
            case "39": 
            case "42": {
                return;
            }
        }
        if (MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode().equals(matchStatus)) {
            this.setBillComprehensiveStatus(bills, "34");
            return;
        }
        int successSize = 0;
        int failSize = 0;
        DynamicObjectCollection redConfirms = BillComprehensiveStatusHelper.getRedConfirmByMatchBillIds(Collections.singletonList(matchBill.getPkValue()));
        if (CollectionUtils.isNotEmpty((Collection)redConfirms)) {
            for (DynamicObject redConfirm : redConfirms) {
                if ("1".equals(redConfirm.getString("uploadstatus"))) {
                    ++successSize;
                    continue;
                }
                if (!"2".equals(redConfirm.getString("uploadstatus"))) continue;
                ++failSize;
            }
        }
        boolean bl = isMatchRedConfirm = "1".equals(matchTarget = matchBill.getString("matchtarget")) || "2".equals(matchTarget);
        if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchStatus)) {
            if (successSize == 0 && failSize == 0) {
                this.setBillComprehensiveStatus(bills, isMatchRedConfirm ? "40" : "32");
                return;
            }
            if (failSize != 0) {
                this.setBillComprehensiveStatus(bills, successSize == 0 ? "38" : "36");
                return;
            }
            this.setBillComprehensiveStatus(bills, isMatchRedConfirm ? "40" : "36");
            return;
        }
        if (successSize == 0 && failSize == 0) {
            this.setBillComprehensiveStatus(bills, isMatchRedConfirm ? "41" : "33");
            return;
        }
        if (failSize != 0) {
            this.setBillComprehensiveStatus(bills, successSize == 0 ? "38" : "36");
            return;
        }
        if (successSize == redConfirms.size() && "2".equals(matchBill.getString("pushdownstatus"))) {
            this.setBillComprehensiveStatus(bills, isMatchRedConfirm ? "41" : "37");
            return;
        }
        this.setBillComprehensiveStatus(bills, isMatchRedConfirm ? "40" : "36");
    }

    public static DynamicObjectCollection getRedConfirmByMatchBillIds(List<Object> matchIds) {
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "in", matchIds).toArray());
        if (CollectionUtils.isEmpty((Collection)relations)) {
            return new DynamicObjectCollection();
        }
        List redConfirmIds = relations.stream().map(relation -> relation.getLong("tbillid")).distinct().collect(Collectors.toList());
        return QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "uploadstatus", "id", "confirmstatus", "issuestatus"), (QFilter[])new QFilter("id", "in", redConfirmIds).toArray());
    }

    private void setBillComprehensiveStatus(DynamicObject[] bills, String billComprehensiveStatus) {
        for (DynamicObject bill : bills) {
            String comprehensiveStatusStr = bill.getString("comprehensivestatus");
            if (StringUtils.isBlank((CharSequence)comprehensiveStatusStr)) {
                bill.set("comprehensivestatus", (Object)billComprehensiveStatus);
                continue;
            }
            int comprehensiveStatus = Integer.parseInt(comprehensiveStatusStr);
            if (comprehensiveStatus == Integer.parseInt("08") || comprehensiveStatus == Integer.parseInt("09") || comprehensiveStatus == Integer.parseInt("39") || comprehensiveStatus == Integer.parseInt("42")) continue;
            bill.set("comprehensivestatus", (Object)billComprehensiveStatus);
        }
    }
}

