/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.ExtHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.match.MatchInvoiceRedHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MatchBillRedHelper {
    public Set<DynamicObject> matchBillRed(DynamicObject matchBill, List<DynamicObject> redInvoiceLit, String currentAccount, OperationResult operationResult) {
        HashSet<DynamicObject> redConfirms = new HashSet<DynamicObject>(20);
        boolean queryRedConfirm = true;
        String matchTarget = matchBill.getString("matchtarget");
        if ("1".equals(matchTarget)) {
            this.matchRedConfirmRed(matchBill);
            queryRedConfirm = false;
        } else if ("2".equals(matchTarget)) {
            this.manuallyRedconfirmRed(matchBill);
            queryRedConfirm = false;
        } else if ("3".equals(matchTarget)) {
            if (matchBill.getDynamicObjectCollection("sim_original_bill_item").stream().flatMap(item -> item.getDynamicObjectCollection("subentryentity").stream()).noneMatch(oriItem -> oriItem.getInt("oriitemseq") == -1)) {
                new MatchInvoiceRedHelper().matchInvoiceRed(matchBill, redConfirms, redInvoiceLit, operationResult);
            } else {
                this.manuallyInvoiceRed(matchBill, redConfirms, currentAccount);
            }
        } else {
            new MatchInvoiceRedHelper().matchInvoiceRed(matchBill, redConfirms, redInvoiceLit, operationResult);
        }
        if (queryRedConfirm) {
            Object[] redConfirmIds;
            Set ids = redConfirms.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            DynamicObjectCollection relation = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", (Object)matchBill.getLong("id")).toArray());
            Object[] redConfirmId = relation.stream().map(re -> re.getLong("tbillid")).distinct().toArray();
            DynamicObjectCollection relationObj = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)"id", (QFilter[])new QFilter("id", "in", (Object)redConfirmId).and("uploadstatus", "!=", (Object)"1").toArray());
            if (CollectionUtils.isNotEmpty((Collection)relationObj) && (redConfirmIds = relationObj.stream().map(re -> re.getLong("id")).filter(id -> !ids.contains(id)).toArray()).length != 0) {
                redConfirms.addAll(Arrays.stream(BusinessDataServiceHelper.load((Object[])redConfirmIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill"))).collect(Collectors.toList()));
            }
        }
        ImcSaveServiceHelper.save((DynamicObject)matchBill);
        return redConfirms;
    }

    private void matchRedConfirmRed(DynamicObject matchBill) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<String> redConfirmIdAndItemId = new HashSet<String>(matchItems.size());
        HashSet<Object> redConfirmId = new HashSet<Object>(matchItems.size());
        for (DynamicObject matchItem : matchItems) {
            long matchItemId = matchItem.getLong("id");
            DynamicObjectCollection confirmItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject confirmItem : confirmItems) {
                long confirmId = confirmItem.getLong("redconfirmpk");
                long confirmItemId = confirmItem.getLong("redconfirmitempk");
                if (redConfirmIdAndItemId.contains(matchItemId + "\u25cf\u25c6\u25a0" + confirmId + "\u25cf\u25c6\u25a0" + confirmItemId)) continue;
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(matchItemId), Long.valueOf(confirmId), confirmItem.getString("confirminfocode"), Long.valueOf(confirmItemId), confirmItem.getBigDecimal("confirmoriitemamount"), confirmItem.getBigDecimal("confirmoriitemtax"), confirmItem.getBigDecimal("confirmoriitemnum"), confirmItem.getBigDecimal("confirmoriitemunitprice"), "sim_red_confirm_bill");
                relation.setsSubDetailId(Long.valueOf(confirmItem.getLong("id")));
                relationList.add(relation);
                redConfirmIdAndItemId.add(matchItemId + "\u25cf\u25c6\u25a0" + confirmId + "\u25cf\u25c6\u25a0" + confirmItemId);
                redConfirmId.add(confirmId);
            }
        }
        this.setMatchBillAllMatch(matchBill, redConfirmId.size());
        this.setRedConfirmSource(matchBill, redConfirmId, "1", relationList);
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])new QFilter("sbillid", "=", (Object)matchBill.getLong("id")).toArray());
        this.saveRelations(relationList, "1");
    }

    private DynamicObject[] setRedConfirmSource(DynamicObject matchBill, Set<Object> redConfirmId, String marchTarget, List<BillRelationDTO> relationList) {
        DynamicObject[] redConfirms;
        boolean isMatchRedConfirmAndHasIsvItemKey;
        if (CollectionUtils.isEmpty(redConfirmId)) {
            return null;
        }
        Pair<List<String>, List<String>> headAndItemIsvField = this.getMatchBillHeadAndItemIsvField();
        String selectField = String.join((CharSequence)",", "id", "source", "systemsource", "billno", "drawer", "remark", "buyeremail", "buyerphone", "buyerredemail");
        if (CollectionUtils.isNotEmpty((Collection)((Collection)headAndItemIsvField.getKey()))) {
            selectField = selectField + "," + String.join((CharSequence)",", (Iterable)headAndItemIsvField.getKey());
        }
        boolean bl = isMatchRedConfirmAndHasIsvItemKey = "1".equals(marchTarget) && CollectionUtils.isNotEmpty((Collection)((Collection)headAndItemIsvField.getValue()));
        if (isMatchRedConfirmAndHasIsvItemKey) {
            List itemKeyList = ((List)headAndItemIsvField.getValue()).stream().map(field -> "items." + field).collect(Collectors.toList());
            itemKeyList.add("items.id");
            selectField = selectField + "," + String.join((CharSequence)",", itemKeyList);
        }
        if ((redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)selectField, (QFilter[])new QFilter("id", "in", redConfirmId).toArray())) == null || redConfirms.length == 0) {
            return null;
        }
        Map<Long, Long> redConfirmItemId2MatchItemMap = relationList.stream().collect(Collectors.toMap(BillRelationDTO::gettDetailId, BillRelationDTO::getsDetailId, (v1, v2) -> v1));
        Map<Long, DynamicObject> matchItemId2ItemMap = matchBill.getDynamicObjectCollection("sim_original_bill_item").stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        String billNoPrefix = "200_" + UUID.getBatchNumber() + '_';
        int i = 1;
        for (DynamicObject redConfirm : redConfirms) {
            redConfirm.set("billno", (Object)(billNoPrefix + BillHelper.getBatchNumbersuffix((int)i++)));
            this.setMatchBillVal2RedConfirm(matchBill, redConfirm);
            ExtHelper.setExtField(matchBill, redConfirm, (List)headAndItemIsvField.getKey());
            if (!isMatchRedConfirmAndHasIsvItemKey) continue;
            DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
            redConfirmItems.forEach(redConfirmItem -> {
                Long matchItemId = (Long)redConfirmItemId2MatchItemMap.get(redConfirmItem.getLong("id"));
                if (matchItemId != null) {
                    ExtHelper.setExtField((DynamicObject)matchItemId2ItemMap.get(matchItemId), redConfirmItem, (List)headAndItemIsvField.getValue());
                }
            });
        }
        ImcSaveServiceHelper.update((DynamicObject[])redConfirms);
        return redConfirms;
    }

    void setMatchBillVal2RedConfirm(DynamicObject matchBill, DynamicObject redConfirm) {
        redConfirm.set("source", (Object)"10");
        this.fillInNullValue(matchBill, redConfirm, "systemsource");
        this.fillInNullValue(matchBill, redConfirm, "drawer");
        redConfirm.set("remark", (Object)matchBill.getString("remark"));
        this.fillInNullValue(matchBill, redConfirm, "buyeremail", "buyerphone", "buyerredemail");
    }

    public void fillInNullValue(DynamicObject matchBill, DynamicObject redConfirm, String ... keys) {
        boolean isNotNull = false;
        for (String key : keys) {
            isNotNull = isNotNull || StringUtils.isNotBlank((CharSequence)matchBill.getString(key));
        }
        if (!isNotNull) {
            return;
        }
        for (String key : keys) {
            redConfirm.set(key, matchBill.get(key));
        }
    }

    private void manuallyInvoiceRed(DynamicObject matchBill, Set<DynamicObject> redConfirms, String currentAccount) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        String redReason = matchBill.getString("redreason");
        redReason = StringUtils.isNotBlank((CharSequence)redReason) ? RedConfirmBillRedReasonEnum.getCodeByBillCode((String)redReason) : RedConfirmBillRedReasonEnum.INVOICE_ERR.getCode();
        String billNoPrefix = "200_" + UUID.getBatchNumber() + '_';
        int i = 1;
        Pair<List<String>, List<String>> headAndItemIsvField = this.getMatchBillHeadAndItemIsvField();
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<String> invoiceCodeNo = new HashSet<String>(items.size());
        for (DynamicObject item : items) {
            DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
            for (DynamicObject oriItem : oriItems) {
                String invoicCode = oriItem.getString("oriinvoicecode");
                String invoiceNo = oriItem.getString("oriinvoiceno");
                if (invoiceCodeNo.contains(invoicCode + "\u25cf\u25c6\u25a0" + invoiceNo)) {
                    oriItem.set("pushstatus", (Object)"1");
                    continue;
                }
                if ("1".equals(oriItem.getString("pushstatus"))) {
                    invoiceCodeNo.add(invoicCode + "\u25cf\u25c6\u25a0" + invoiceNo);
                    continue;
                }
                oriItem.set("pushstatus", (Object)"1");
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoicCode, (String)invoiceNo).toArray());
                DynamicObject redConfirmObj = RedConfirmBillHelper.formatRedConfirm(billNoPrefix + BillHelper.getBatchNumbersuffix((int)i++), UUID.randomUUID(), redReason, blueInvoice, currentAccount);
                this.setMatchBillVal2RedConfirm(matchBill, redConfirmObj);
                ExtHelper.setExtField(matchBill, redConfirmObj, (List)headAndItemIsvField.getKey());
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirmObj}, null);
                if (!operationResult.isSuccess()) {
                    throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
                }
                invoiceCodeNo.add(invoicCode + "\u25cf\u25c6\u25a0" + invoiceNo);
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(item.getLong("id")), Long.valueOf(redConfirmObj.getLong("id")), redConfirmObj.getString("billno"), Long.valueOf(0L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "sim_red_confirm_bill");
                relationList.add(relation);
                redConfirms.add(redConfirmObj);
            }
        }
        this.setMatchBillAllMatch(matchBill, invoiceCodeNo.size());
        this.saveRelations(relationList, "3");
        this.saveOriginalBillAndRedConfirmRelation(matchBill, redConfirms);
    }

    private void manuallyRedconfirmRed(DynamicObject matchBill) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<Object> redConfirmIdSet = new HashSet<Object>(matchItems.size());
        for (DynamicObject matchItem : matchItems) {
            DynamicObjectCollection confirmItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject confirmItem : confirmItems) {
                if (redConfirmIdSet.contains(confirmItem.get("redconfirmpk"))) continue;
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(matchItem.getLong("id")), Long.valueOf(confirmItem.getLong("redconfirmpk")), confirmItem.getString("confirminfocode"), Long.valueOf(0L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "sim_red_confirm_bill");
                relationList.add(relation);
                redConfirmIdSet.add(confirmItem.get("redconfirmpk"));
            }
        }
        this.setMatchBillAllMatch(matchBill, redConfirmIdSet.size());
        DynamicObject[] redConfirms = this.setRedConfirmSource(matchBill, redConfirmIdSet, "2", relationList);
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])new QFilter("sbillid", "=", (Object)matchBill.getLong("id")).toArray());
        this.saveRelations(relationList, "2");
        if (redConfirms != null) {
            DeleteServiceHelper.delete((String)"sim_bill_inv_relation", (QFilter[])new QFilter("tbillid", "in", redConfirmIdSet).toArray());
            this.saveOriginalBillAndRedConfirmRelation(matchBill, Arrays.stream(redConfirms).collect(Collectors.toSet()));
        }
    }

    private void saveOriginalBillAndRedConfirmRelation(DynamicObject matchBill, Set<DynamicObject> redConfirmSet) {
        DynamicObjectCollection billRelations = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "=", matchBill.getPkValue()).toArray());
        if (CollectionUtils.isEmpty((Collection)billRelations)) {
            return;
        }
        Set billIds = billRelations.stream().map(relation -> relation.getLong("sbillid")).collect(Collectors.toSet());
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(billIds.size());
        for (Long billId : billIds) {
            for (DynamicObject redConfirm : redConfirmSet) {
                DynamicObject relation2 = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation");
                relation2.set("sbillid", (Object)billId);
                relation2.set("sbillno", (Object)matchBill.getString("billno"));
                relation2.set("tbillid", redConfirm.getPkValue());
                relation2.set("tbillno", (Object)redConfirm.getString("billno"));
                relation2.set("ttable", (Object)"sim_red_confirm_bill");
                relation2.set("pushtype", (Object)"-1");
                relation2.set("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org")));
                relations.add(relation2);
            }
        }
        ImcSaveServiceHelper.save(relations);
    }

    public void saveRelations(List<BillRelationDTO> relationList, String matchTarget) {
        if (CollectionUtils.isEmpty(relationList)) {
            return;
        }
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(relationList.size());
        for (BillRelationDTO relation : relationList) {
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_inv_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)relationObj);
            relationObj.set("matchtarget", (Object)matchTarget);
            relations.add(relationObj);
        }
        ImcSaveServiceHelper.save(relations);
    }

    private void setMatchBillAllMatch(DynamicObject matchBill, int pushInvoiceNum) {
        matchBill.set("pushdownstatus", (Object)"2");
        matchBill.set("pushdowninvoicenum", (Object)pushInvoiceNum);
        matchBill.set("pushdownamount", matchBill.get("applyamount"));
        matchBill.set("pushdowntax", matchBill.get("applytax"));
    }

    protected void calcUnitPriceAndNum(DynamicObject oriItem, DynamicObject redInvoiceOrRedConfirmItem) {
        redInvoiceOrRedConfirmItem.set("unitprice", oriItem.get("oriitemunitprice"));
        redInvoiceOrRedConfirmItem.set("taxunitprice", oriItem.get("oriitemtaxunitprice"));
        BigDecimal num = redInvoiceOrRedConfirmItem.getBigDecimal("num");
        if (!MathUtils.isNullOrZero((BigDecimal)num)) {
            BigDecimal unitPrice = redInvoiceOrRedConfirmItem.getBigDecimal("unitprice");
            BigDecimal amount = redInvoiceOrRedConfirmItem.getBigDecimal("amount");
            if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                redInvoiceOrRedConfirmItem.set("num", (Object)UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice));
            }
            BigDecimal taxUnitPrice = redInvoiceOrRedConfirmItem.getBigDecimal("taxunitprice");
            BigDecimal taxAmount = redInvoiceOrRedConfirmItem.getBigDecimal("taxamount");
            if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)taxAmount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                redInvoiceOrRedConfirmItem.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)true));
            }
        }
    }

    protected Pair<List<String>, List<String>> getMatchBillHeadAndItemIsvField() {
        return ExtHelper.getHeadAndItemIsvField("sim_match_bill", "sim_original_bill_item", "sim_red_confirm_bill", "items");
    }
}

