/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.MetadataUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MatchBillRequest;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.dto.minusbill.QueryInvoiceDTO;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.formplugin.match.AbstractMinusBillMatchHelper;
import kd.imc.sim.formplugin.match.BillComprehensiveStatusHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MinusBillMatchHelper
extends AbstractMinusBillMatchHelper {
    private static final Log logger = LogFactory.getLog(MinusBillMatchHelper.class);
    public static final ImmutableSet<String> normalSpecialTypeSet = new ImmutableSet.Builder().add((Object[])new String[]{"00", ""}).build();

    public void match(MinusBillDTO billDTO) {
        String traceId = RequestContext.get().getTraceId();
        this.matchInvoiceItems = new HashSet(16);
        this.setParam(billDTO);
        logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e:{}", (Object)traceId, (Object)billDTO.getBillNo());
        if (this.detailLog) {
            logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e\u8bf7\u6c42\u53c2\u6570:{}", (Object)traceId, (Object)SerializationUtils.toJsonString((Object)this.minusBillDTO));
        }
        this.check(this.minusBillDTO);
        if (this.config.getIgnorePrice().booleanValue() || this.config.getDiscountMatchPrice().booleanValue() && RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason())) {
            this.config.setUnitPriceAffectType("none");
        }
        boolean isQueryWideTable = WideInvoiceSevice.isWideTable((String)this.minusBillDTO.getSalerTaxNo());
        long start = System.currentTimeMillis();
        this.matchBlueInvoice(isQueryWideTable);
        if (this.detailLog) {
            logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e\u8bf7\u6c42\u5339\u914d\u4e4b\u540e:{}", (Object)traceId, (Object)SerializationUtils.toJsonString((Object)this.minusBillDTO));
        }
        logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e\u8017\u65f6:{}\uff0c\u660e\u7ec6\u884c\u6570:{}\uff0c\u5355\u636e\u7f16\u53f7:{}", new Object[]{traceId, System.currentTimeMillis() - start, this.minusBillDTO.getItems().size(), this.minusBillDTO.getBillNo()});
    }

    /*
     * WARNING - void declaration
     */
    private void matchBlueInvoice(boolean isQueryWideTable) {
        String traceId = RequestContext.get().getTraceId();
        QFilter invoicefilter = this.getInvoiceQFilterList(this.minusBillDTO, isQueryWideTable);
        String orderBy = this.getOrderBy();
        ArrayList<MinusBillItemDTO> items = new ArrayList<MinusBillItemDTO>(this.minusBillDTO.getItems().size());
        for (MinusBillItemDTO item : this.minusBillDTO.getItems()) {
            if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(item.getMatchStatus())) continue;
            items.add(item);
        }
        Set<Object> matchedMinusItemId = Collections.newSetFromMap(new ConcurrentHashMap(items.size()));
        ConcurrentHashMap<Long, Pair<Integer, QueryInvoiceDTO>> invoiceExistCount = new ConcurrentHashMap<Long, Pair<Integer, QueryInvoiceDTO>>(items.size() * 50);
        ConcurrentHashMap<Long, Set<MinusBillItemDTO>> invoiceId2ItemMap = new ConcurrentHashMap<Long, Set<MinusBillItemDTO>>(items.size() * 50);
        ConcurrentHashMap<Object, List<String>> matchItemId2InvoiceKeyMap = new ConcurrentHashMap<Object, List<String>>(items.size() * 50);
        ConcurrentHashMap<String, QueryInvoiceDTO> idQueryInvoiceMap = new ConcurrentHashMap<String, QueryInvoiceDTO>(items.size() * 50);
        if (this.openThreadMatch) {
            void var13_17;
            ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService((int)this.corePoolSize, (int)this.maxPoolSize);
            CountDownLatch countdownlatch = new CountDownLatch(items.size());
            boolean bl = false;
            while (var13_17 < items.size()) {
                MinusBillItemDTO item = (MinusBillItemDTO)items.get((int)var13_17);
                void finalI = var13_17++;
                executorService.execute(() -> this.lambda$matchBlueInvoice$0(traceId, (int)finalI, item, invoicefilter, orderBy, isQueryWideTable, matchedMinusItemId, invoiceExistCount, invoiceId2ItemMap, matchItemId2InvoiceKeyMap, idQueryInvoiceMap, countdownlatch));
            }
            try {
                countdownlatch.await();
                executorService.shutdown();
            }
            catch (Exception exception) {
                throw new KDBizException(exception.toString());
            }
        } else {
            for (int i = 0; i < items.size(); ++i) {
                MinusBillItemDTO item = (MinusBillItemDTO)items.get(i);
                if (this.detailLog) {
                    logger.info("traceId:{}\uff0c\u660e\u7ec6\u884c\u6570:{}\uff0c\u6b63\u5728\u67e5\u8be2\u884c\u6570:{}", new Object[]{traceId, this.minusBillDTO.getItems().size(), i + 1});
                }
                this.runQueryInvoice(traceId, item, invoicefilter, orderBy, isQueryWideTable, matchedMinusItemId, invoiceExistCount, invoiceId2ItemMap, matchItemId2InvoiceKeyMap, idQueryInvoiceMap);
            }
        }
        if (this.detailLog) {
            Set entries = invoiceExistCount.entrySet();
            for (Map.Entry entry : entries) {
                Pair value = (Pair)entry.getValue();
                logger.info(String.format("traceId:%s\uff0c\u53d1\u7968\u53f7\u7801%s\u67e5\u8be2\u5230\u7684\u6b21\u6570\u662f%s,\u5f00\u7968\u65f6\u95f4\u662f%s\uff0c\u91d1\u989d\u662f%s", traceId, ((QueryInvoiceDTO)value.getValue()).getInvoiceno(), value.getKey(), DateUtils.format((Date)((QueryInvoiceDTO)value.getValue()).getIssueTime(), (String)"yyyy-MM-dd HH:mm:ss"), ((QueryInvoiceDTO)value.getValue()).getInvoiceAmount().setScale(2, 4)));
            }
        }
        Comparator comparator = (v1, v2) -> {
            if (((Integer)((Pair)v2.getValue()).getKey()).compareTo((Integer)((Pair)v1.getValue()).getKey()) == 0) {
                switch (this.config.getBlueOrder()) {
                    case "timefar": {
                        return ((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getIssueTime().compareTo(((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getIssueTime());
                    }
                    case "timenear": {
                        return ((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getIssueTime().compareTo(((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getIssueTime());
                    }
                    case "amountsmall": {
                        return ((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getInvoiceAmount().compareTo(((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getInvoiceAmount());
                    }
                    case "amountbig": {
                        return ((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getInvoiceAmount().compareTo(((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getInvoiceAmount());
                    }
                }
                return 1;
            }
            return ((Integer)((Pair)v2.getValue()).getKey()).compareTo((Integer)((Pair)v1.getValue()).getKey());
        };
        while (matchedMinusItemId.size() < items.size() && invoiceExistCount.size() != 0) {
            ArrayList list = new ArrayList(invoiceExistCount.entrySet());
            list.sort(comparator);
            Map.Entry entry = (Map.Entry)list.get(0);
            if (this.detailLog) {
                logger.info("traceId:{}\uff0c\u5f53\u524d\u6700\u591a\u6b21\u67e5\u8be2\u5230\u7684\u53d1\u7968\u662f{}", (Object)traceId, (Object)((QueryInvoiceDTO)((Pair)entry.getValue()).getValue()).getInvoiceno());
            }
            this.beginMatch((Long)entry.getKey(), invoiceId2ItemMap, matchItemId2InvoiceKeyMap, idQueryInvoiceMap, matchedMinusItemId, isQueryWideTable);
            invoiceExistCount.remove(entry.getKey());
        }
    }

    private void runQueryInvoice(String traceId, MinusBillItemDTO item, QFilter invoicefilter, String orderBy, boolean isQueryWideTable, Set<Object> matchedMinusItemId, Map<Long, Pair<Integer, QueryInvoiceDTO>> invoiceExistCount, Map<Long, Set<MinusBillItemDTO>> invoiceId2ItemMap, Map<Object, List<String>> matchItemId2InvoiceKeyMap, Map<String, QueryInvoiceDTO> idQueryInvoiceMap) {
        try {
            if (matchedMinusItemId.contains(item.getMatchOrMergeItemId())) {
                return;
            }
            ArrayList<String> querInvoiceIds = new ArrayList<String>(70);
            if (isQueryWideTable) {
                this.queryDetailType = this.wideQueryDetailType;
            }
            QFilter itemFilter = this.getItemQFilter(item, isQueryWideTable);
            if (this.queryDetailType == 1) {
                if (this.detailLog) {
                    logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e:{}\uff0c\u8868\u5934\u8fc7\u6ee4\u6761\u4ef6{}\uff0c\u660e\u7ec6\u8fc7\u6ee4\u6761\u4ef6{}\uff0c\u6392\u5e8f{}\uff0c\u67e5\u8be2\u7c7b\u578b\u5148\u67e5\u8868\u5934\u518d\u67e5\u660e\u7ec6", new Object[]{traceId, this.minusBillDTO.getBillNo(), invoicefilter.toString(), itemFilter.toString(), orderBy});
                }
                this.queryDataHeadThenItem(itemFilter, invoicefilter, orderBy, 1, idQueryInvoiceMap, querInvoiceIds, isQueryWideTable);
            } else {
                QFilter filter = itemFilter.and(invoicefilter);
                if (this.detailLog) {
                    logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e:{}\uff0c\u8fc7\u6ee4\u6761\u4ef6{}\uff0c\u6392\u5e8f{}\uff0c\u67e5\u8be2\u7c7b\u578b\u4e3a\u5173\u8054\u67e5\u8be2", new Object[]{traceId, this.minusBillDTO.getBillNo(), filter.toString(), orderBy});
                }
                this.queryData(filter, orderBy, 1, idQueryInvoiceMap, querInvoiceIds, isQueryWideTable);
            }
            if (CollectionUtils.isEmpty(querInvoiceIds)) {
                if (this.detailLog) {
                    logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e\u660e\u7ec6\u672a\u67e5\u8be2\u5230\u84dd\u7968\u4fe1\u606f\uff0c\u660e\u7ec6\u4fe1\u606f:{}", (Object)traceId, (Object)SerializationUtils.toJsonString((Object)item));
                }
                matchedMinusItemId.add(item.getMatchOrMergeItemId());
                return;
            }
            if (this.detailLog) {
                logger.info("traceId:{}\uff0c\u5339\u914d\u5355\u636e\u660e\u7ec6\u67e5\u8be2\u5230\u84dd\u7968\uff0c\u660e\u7ec6\u4fe1\u606f:{}", (Object)traceId, (Object)SerializationUtils.toJsonString((Object)item));
            }
            for (String querInvoiceId : querInvoiceIds) {
                List item2Invoice = matchItemId2InvoiceKeyMap.computeIfAbsent(item.getMatchOrMergeItemId(), k -> new ArrayList());
                item2Invoice.add(querInvoiceId);
                QueryInvoiceDTO queryInvoice = idQueryInvoiceMap.get(querInvoiceId);
                Pair<Integer, QueryInvoiceDTO> integerQueryInvoicePair = invoiceExistCount.get(queryInvoice.getInvoiceid());
                Integer count = 0;
                if (integerQueryInvoicePair != null) {
                    count = (Integer)integerQueryInvoicePair.getKey();
                }
                count = count + 1;
                invoiceExistCount.put(queryInvoice.getInvoiceid(), (Pair<Integer, QueryInvoiceDTO>)Pair.of((Object)count, (Object)queryInvoice));
                Set minusBillItems = invoiceId2ItemMap.computeIfAbsent(queryInvoice.getInvoiceid(), k -> new HashSet());
                minusBillItems.add(item);
            }
        }
        catch (Exception e) {
            logger.error(String.format("traceId:%s\uff0c\u660e\u7ec6[%s]\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f%s", traceId, item.getGoodsname(), e.getMessage()), (Throwable)e);
        }
    }

    private void beginMatch(Long invoiceId, Map<Long, Set<MinusBillItemDTO>> invoiceId2ItemMap, Map<Object, List<String>> matchItemId2InvoiceKeyMap, Map<String, QueryInvoiceDTO> idQueryInvoiceMap, Set<Object> matchedMinusItemId, boolean isQueryWideTable) {
        Set<MinusBillItemDTO> minusBillItems = invoiceId2ItemMap.get(invoiceId);
        block0: for (MinusBillItemDTO matchBillItem : minusBillItems) {
            List queryInvoiceList;
            List<String> matchItemId2InvoiceKeyList;
            if (matchedMinusItemId.contains(matchBillItem.getMatchOrMergeItemId()) || CollectionUtils.isEmpty(matchItemId2InvoiceKeyList = matchItemId2InvoiceKeyMap.get(matchBillItem.getMatchOrMergeItemId())) || CollectionUtils.isEmpty(queryInvoiceList = matchItemId2InvoiceKeyList.stream().map(idQueryInvoiceMap::get).filter(invoiceDto -> invoiceDto != null && invoiceId.equals(invoiceDto.getInvoiceid())).collect(Collectors.toList()))) continue;
            for (QueryInvoiceDTO invoiceDto2 : queryInvoiceList) {
                BigDecimal compareAmountOrNum;
                MatchInvoiceDTO matchInvoice;
                BigDecimal matchAmountOrNum;
                if (!this.config.getBlueItemCanMatchMultiRow().booleanValue() && this.matchInvoiceItems.contains(invoiceDto2.getInvoiceid() + "\u25cf\u25c6\u25a0" + invoiceDto2.getItemid()) || BigDecimal.ZERO.compareTo(invoiceDto2.getRemainMatchAmountOrNum()) >= 0) continue;
                BigDecimal unMatchAmountOrNum = this.config.getAmountStandard() == false ? matchBillItem.getNum().abs().subtract(matchBillItem.getMatchAmountOrNum()) : matchBillItem.getAmount().abs().subtract(matchBillItem.getMatchAmountOrNum());
                BigDecimal remainAmountOrNum = invoiceDto2.getRemainMatchAmountOrNum();
                if (remainAmountOrNum.compareTo(unMatchAmountOrNum) >= 0) {
                    remainAmountOrNum = remainAmountOrNum.subtract(unMatchAmountOrNum);
                    matchAmountOrNum = unMatchAmountOrNum;
                } else {
                    matchAmountOrNum = remainAmountOrNum;
                    remainAmountOrNum = BigDecimal.ZERO;
                }
                if ((matchInvoice = this.createMatchInvoiceDTO(matchBillItem, invoiceDto2, matchAmountOrNum, isQueryWideTable)) == null) continue;
                if (!this.config.getBlueItemCanMatchMultiRow().booleanValue()) {
                    this.matchInvoiceItems.add(matchInvoice.getInvoiceid() + "\u25cf\u25c6\u25a0" + matchInvoice.getItemid());
                }
                invoiceDto2.setCurrentMatchAmount(invoiceDto2.getCurrentMatchAmount().add(matchInvoice.getItemAmount()));
                invoiceDto2.setCurrentMatchTax(invoiceDto2.getCurrentMatchTax().add(matchInvoice.getItemTax()));
                invoiceDto2.setCurrentMatchNum(invoiceDto2.getCurrentMatchNum().add(matchInvoice.getItemNum()));
                invoiceDto2.setRemainMatchAmountOrNum(remainAmountOrNum);
                matchBillItem.setMatchAmountOrNum(matchBillItem.getMatchAmountOrNum().add(matchAmountOrNum));
                matchBillItem.setMatchTax(matchBillItem.getMatchTax().add(matchInvoice.getItemTax()));
                matchBillItem.getInvoiceList().add(matchInvoice);
                BigDecimal bigDecimal = compareAmountOrNum = this.config.getAmountStandard() != false ? matchBillItem.getAmount() : matchBillItem.getNum();
                if (compareAmountOrNum.abs().compareTo(matchBillItem.getMatchAmountOrNum()) == 0) {
                    matchBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                    matchedMinusItemId.add(matchBillItem.getMatchOrMergeItemId());
                    continue block0;
                }
                if (this.config.getMatchMultiRow().booleanValue() || matchBillItem.getInvoiceList().size() != 1) continue;
                matchedMinusItemId.add(matchBillItem.getMatchOrMergeItemId());
                continue block0;
            }
        }
    }

    private QFilter getItemQFilter(MinusBillItemDTO item, boolean isQueryWideTable) {
        QFilter qFilter = new QFilter(isQueryWideTable ? "taxrate" : "items.taxrate", "=", (Object)item.getTaxRate());
        boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
        if (!this.config.getMatchMultiRow().booleanValue() && !MathUtils.isNullOrZero((BigDecimal)item.getAmount())) {
            if (salesDiscount) {
                qFilter.and(isQueryWideTable ? "itemremainredamount" : "items.itemremainredamount", ">", (Object)BigDecimal.ZERO);
                qFilter.and(isQueryWideTable ? this.config.getMatchAmountField() : "items." + this.config.getMatchAmountField(), ">=", (Object)item.getAmount().abs());
            } else {
                qFilter.and(isQueryWideTable ? "itemremainredamount" : "items.itemremainredamount", ">=", (Object)item.getAmount().abs());
            }
        } else {
            qFilter.and(isQueryWideTable ? "itemremainredamount" : "items.itemremainredamount", ">", (Object)BigDecimal.ZERO);
            if (salesDiscount) {
                qFilter.and(isQueryWideTable ? this.config.getMatchAmountField() : "items." + this.config.getMatchAmountField(), ">", (Object)BigDecimal.ZERO);
            }
        }
        if (!this.config.getAmountStandard().booleanValue()) {
            if (!this.config.getMatchMultiRow().booleanValue()) {
                qFilter.and(isQueryWideTable ? "itemremainrednum" : "items.itemremainrednum", ">=", (Object)item.getNum().abs());
            } else {
                qFilter.and(isQueryWideTable ? "itemremainrednum" : "items.itemremainrednum", ">", (Object)BigDecimal.ZERO);
            }
        }
        if (!"none".equals(this.config.getUnitPriceAffectType())) {
            if (MathUtils.isNullOrZero((BigDecimal)item.getUnitprice())) {
                qFilter.and(isQueryWideTable ? this.config.getMatchPriceField() : "items." + this.config.getMatchPriceField(), "=", (Object)BigDecimal.ZERO);
            } else {
                Pair<BigDecimal, BigDecimal> priceAffect = this.getUnitPriceAffect(item.getUnitprice());
                if (priceAffect != null) {
                    qFilter.and(isQueryWideTable ? this.config.getMatchPriceField() : "items." + this.config.getMatchPriceField(), ">=", priceAffect.getLeft()).and(isQueryWideTable ? this.config.getMatchPriceField() : "items." + this.config.getMatchPriceField(), "<=", priceAffect.getRight());
                }
            }
        }
        EntryProp itemsProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice").getProperty("items");
        DynamicObjectType itemsObjectType = itemsProp.getDynamicCollectionItemPropertyType();
        JSONObject itemExtJson = item.getItemExtJson();
        Set entries = itemExtJson.entrySet();
        for (Map.Entry entry : entries) {
            if ("unitprice".equals(entry.getKey()) || "taxunitprice".equals(entry.getKey()) || "redprice".equals(entry.getKey()) || !this.config.getItemField().contains((CharSequence)entry.getKey()) || itemsObjectType.getProperty((String)entry.getKey()) == null) continue;
            qFilter.and(isQueryWideTable ? (String)entry.getKey() : "items." + (String)entry.getKey(), "=", entry.getValue());
        }
        return qFilter;
    }

    private void queryData(QFilter filter, String order, int page, Map<String, QueryInvoiceDTO> idQueryInvoiceMap, List<String> querInvoiceIds, boolean isQueryWideTable) {
        if (page == this.queryTimes) {
            return;
        }
        ORM orm = ORM.create();
        try (DataSet ds = this.queryInvoice(orm, page, order, filter, isQueryWideTable);){
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"sim_vatinvoice");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return;
            }
            boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
            for (DynamicObject obj : collection) {
                if (!MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainredamount")) && !MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("unitprice")) && MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainrednum")) || CollectionUtils.isNotEmpty((Collection)this.minusBillDTO.getMatchInvoiceIds()) && this.minusBillDTO.getMatchInvoiceIds().contains(obj.getLong("id"))) continue;
                String invoiceKey = obj.getLong("id") + "\u25cf\u25c6\u25a0" + obj.getLong("itemid");
                if (!idQueryInvoiceMap.containsKey(invoiceKey)) {
                    QueryInvoiceDTO invoiceDto = this.createQueryInvoiceDTO(obj, salesDiscount);
                    idQueryInvoiceMap.put(invoiceKey, invoiceDto);
                }
                querInvoiceIds.add(invoiceKey);
                if (querInvoiceIds.size() != this.singleQuerySize) continue;
                return;
            }
            if (collection.size() == this.pageSize) {
                this.queryData(filter, order, ++page, idQueryInvoiceMap, querInvoiceIds, isQueryWideTable);
            }
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u62a5\u9519", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryDataHeadThenItem(QFilter itemFilter, QFilter invoicefilter, String orderBy, int page, Map<String, QueryInvoiceDTO> idQueryInvoiceMap, List<String> querInvoiceIds, boolean isQueryWideTable) {
        if (page == this.queryTimes) {
            return;
        }
        ORM orm = ORM.create();
        try (DataSet ds = this.queryInvoiceHead(orm, orderBy, page, invoicefilter, isQueryWideTable);){
            DynamicObjectCollection invoiceHeadCollection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"sim_vatinvoice");
            if (CollectionUtils.isEmpty((Collection)invoiceHeadCollection)) {
                return;
            }
            Set<Object> invoiceIdSet = invoiceHeadCollection.stream().map(invoice -> invoice.get("id")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty((Collection)this.minusBillDTO.getMatchInvoiceIds())) {
                invoiceIdSet.removeIf(this.minusBillDTO.getMatchInvoiceIds()::contains);
            }
            if (CollectionUtils.isEmpty(invoiceIdSet)) {
                this.queryDataHeadThenItem(itemFilter, invoicefilter, orderBy, ++page, idQueryInvoiceMap, querInvoiceIds, isQueryWideTable);
                return;
            }
            try (DataSet itemDs = this.queryInvoiceDetail(orm, orderBy, invoiceIdSet, itemFilter, isQueryWideTable);){
                DynamicObjectCollection itemCollection = ORMUtil.toDynamicObjectCollection((DataSet)itemDs, (String)"sim_vatinvoice");
                if (CollectionUtils.isEmpty((Collection)itemCollection)) {
                    this.queryDataHeadThenItem(itemFilter, invoicefilter, orderBy, ++page, idQueryInvoiceMap, querInvoiceIds, isQueryWideTable);
                    return;
                }
                boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
                for (DynamicObject obj : itemCollection) {
                    if (!MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainredamount")) && !MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("unitprice")) && MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainrednum"))) continue;
                    String invoiceKey = obj.getLong("id") + "\u25cf\u25c6\u25a0" + obj.getLong("itemid");
                    if (!idQueryInvoiceMap.containsKey(invoiceKey)) {
                        QueryInvoiceDTO invoiceDto = this.createQueryInvoiceDTO(obj, salesDiscount);
                        idQueryInvoiceMap.put(invoiceKey, invoiceDto);
                    }
                    querInvoiceIds.add(invoiceKey);
                    if (querInvoiceIds.size() != this.singleQuerySize) continue;
                    return;
                }
            }
            if (invoiceHeadCollection.size() != this.pageSize) return;
            this.queryDataHeadThenItem(itemFilter, invoicefilter, orderBy, ++page, idQueryInvoiceMap, querInvoiceIds, isQueryWideTable);
            return;
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u62a5\u9519", (Throwable)e);
        }
    }

    public QFilter getInvoiceQFilterList(MinusBillDTO minusBillDTO, boolean isQueryWideTable) {
        QFilter qFilter = new QFilter("salertaxno", "=", (Object)minusBillDTO.getSalerTaxNo());
        if (StringUtils.isNotBlank((CharSequence)this.config.getHeadField()) && this.config.getHeadField().contains("buyername")) {
            if (StringUtils.isNotBlank((CharSequence)minusBillDTO.getBuyerTaxNo())) {
                qFilter.and("buyertaxno", "=", (Object)minusBillDTO.getBuyerTaxNo());
            }
            qFilter.and("buyername", "=", (Object)minusBillDTO.getBuyerName());
        } else if (StringUtils.isNotBlank((CharSequence)minusBillDTO.getBuyerTaxNo())) {
            qFilter.and("buyertaxno", "=", (Object)minusBillDTO.getBuyerTaxNo());
        } else {
            qFilter.and("buyername", "=", (Object)minusBillDTO.getBuyerName());
        }
        if (!isQueryWideTable) {
            qFilter.and("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
            if (CollectionUtils.isNotEmpty((Collection)minusBillDTO.getLimitInvoiceIds())) {
                qFilter.and("id", "in", (Object)minusBillDTO.getLimitInvoiceIds());
            }
        } else if (CollectionUtils.isNotEmpty((Collection)minusBillDTO.getLimitInvoiceIds())) {
            qFilter.and("invoiceid", "in", (Object)minusBillDTO.getLimitInvoiceIds());
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getHeadField()) && this.config.getHeadField().contains("invoicetype")) {
            qFilter.and("invoicetype", "in", (Object)this.getBlueInvoiceType(minusBillDTO, this.config));
        } else {
            qFilter.and("invoicetype", "in", (Object)new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), InvoiceType.ALL_E_SPECIAL.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()});
        }
        Pair<Date, Date> invoiceDates = this.getInvoceDate(new Date());
        qFilter.and("issuetime", ">=", invoiceDates.getLeft()).and("issuetime", "<", invoiceDates.getRight()).and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("remainredamount", ">", (Object)BigDecimal.ZERO).and("occupystatus", "!=", (Object)"1").and("specialtype", "in", normalSpecialTypeSet);
        if (StringUtils.isNotBlank((CharSequence)this.config.getMatchValueAddedTaxuses())) {
            HashSet<String> valueAddedTaxUses = new HashSet<String>(Splitter.on((String)",").trimResults().splitToList((CharSequence)this.config.getMatchValueAddedTaxuses()));
            valueAddedTaxUses.remove("");
            if (valueAddedTaxUses.remove("-1")) {
                valueAddedTaxUses.add("");
            }
            if (CollectionUtils.isNotEmpty(valueAddedTaxUses)) {
                qFilter.and("valueaddedtaxuses", "in", valueAddedTaxUses);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getMatchCreditingStatus())) {
            HashSet<String> creditingStatuses = new HashSet<String>(Splitter.on((String)",").trimResults().splitToList((CharSequence)this.config.getMatchCreditingStatus()));
            creditingStatuses.remove("");
            if (creditingStatuses.remove("-1")) {
                creditingStatuses.add("");
            }
            if (CollectionUtils.isNotEmpty(creditingStatuses)) {
                qFilter.and("creditingstatus", "in", creditingStatuses);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getMatchExciseTaxPurposes())) {
            HashSet<String> exciseTaxPurposeses = new HashSet<String>(Splitter.on((String)",").trimResults().splitToList((CharSequence)this.config.getMatchExciseTaxPurposes()));
            exciseTaxPurposeses.remove("");
            if (exciseTaxPurposeses.remove("-1")) {
                exciseTaxPurposeses.add("");
            }
            if (CollectionUtils.isNotEmpty(exciseTaxPurposeses)) {
                qFilter.and("excisetaxpurposes", "in", exciseTaxPurposeses);
            }
        }
        JSONObject headExtJson = minusBillDTO.getHeadExtJson();
        headExtJson.remove((Object)"invoicetype");
        headExtJson.remove((Object)"buyername");
        if (headExtJson.isEmpty()) {
            return qFilter;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        Set entries = headExtJson.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (!this.config.getHeadField().contains(key) || dataEntityType.getProperty(key) == null) continue;
            qFilter.and(key, "=", entry.getValue());
        }
        return qFilter;
    }

    public static DynamicObject createMatchBillByOriginalBill(DynamicObject originalBill, String matchBatch) {
        DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)originalBill, (DynamicObject)matchBill);
        matchBill.set("matchbatch", (Object)matchBatch);
        matchBill.set("billno", (Object)MinusBillMatchHelper.getMergeBillNoFirst(matchBill.getString("billno")));
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            DynamicObject matchItem = matchItems.addNew();
            DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)item, (DynamicObject)matchItem);
            SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)item);
            matchItem.set("goodsname", (Object)item.getString("goodsname"));
            matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
            matchItem.set("amount", (Object)item.getBigDecimal("remainvalidamount").subtract(item.getBigDecimal("remainvalidtax")));
            matchItem.set("tax", (Object)item.getBigDecimal("remainvalidtax"));
            matchItem.set("num", (Object)item.getBigDecimal("remainvalidnum"));
        }
        matchBill.set("applyamount", (Object)originalBill.getBigDecimal("invoiceamount"));
        matchBill.set("applytax", (Object)originalBill.getBigDecimal("totaltax"));
        matchBill.set("applytotalamount", (Object)originalBill.getBigDecimal("totalamount"));
        matchBill.set("billstatus", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
        matchBill.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        matchBill.set("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid")));
        matchBill.set("matchrule", null);
        matchBill.set("remark", (Object)originalBill.getString("invoiceremark"));
        matchBill.set("pushdownstatus", (Object)"0");
        matchBill.set("matchtime", (Object)MinusBillMatchHelper.getMatchTime());
        matchBill.set("matchstatus", (Object)"");
        matchBill.set("matchtarget", (Object)"");
        matchBill.set("mainissuedamount", (Object)BigDecimal.ZERO);
        matchBill.set("mainissuedtax", (Object)BigDecimal.ZERO);
        return matchBill;
    }

    public static Date getMatchTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getMergeBillNoFirst(String billNo) {
        try {
            String[] billNos = billNo.split(",");
            return billNos[0];
        }
        catch (Exception e) {
            return billNo;
        }
    }

    public MinusBillDTO createMinusBillByMatchBill(MinusBillMatchConfig matchConfig, DynamicObject matchBill) {
        DynamicObject blueInvoice;
        MinusBillDTO minusBill = new MinusBillDTO();
        minusBill.setBillNo(matchBill.getString("billno"));
        minusBill.setBuyerTaxNo(matchBill.getString("buyertaxno"));
        minusBill.setBuyerName(matchBill.getString("buyername"));
        minusBill.setInvoiceType(matchBill.getString("invoicetype"));
        minusBill.setSalerTaxNo(matchBill.getString("salertaxno"));
        minusBill.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org"))));
        minusBill.setMergebillId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.getPkValue())));
        minusBill.setRedreason(matchBill.getString("redreason"));
        minusBill.setHeadExtJson(MinusBillMatchHelper.getExtJson(matchConfig.getHeadField(), matchBill));
        ArrayList<MinusBillItemDTO> items = new ArrayList<MinusBillItemDTO>();
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject matchItem : matchItems) {
            String itemMatchstatus = matchItem.getString("itemmatchstatus");
            DynamicObjectCollection oriInvoiceItems = matchItem.getDynamicObjectCollection("subentryentity");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal num = BigDecimal.ZERO;
            for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                amount = amount.add(oriInvoiceItem.getBigDecimal("oriitemamount"));
                num = num.add(oriInvoiceItem.getBigDecimal("oriitemnum"));
                tax = tax.add(oriInvoiceItem.getBigDecimal("oriitemtax"));
            }
            if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(itemMatchstatus)) continue;
            MinusBillItemDTO item = new MinusBillItemDTO();
            item.setMatchOrMergeItemId((Object)matchItem.getLong("id"));
            item.setTaxRate(matchItem.getString("taxrate"));
            item.setRowtype("2");
            item.setGoodsname(matchItem.getString("goodsname"));
            item.setGoodscode(matchItem.getString("goodscode"));
            item.setSpbm(matchItem.getString("spbm"));
            item.setUnitprice(matchItem.getBigDecimal("unitprice"));
            item.setAmount(matchItem.getBigDecimal("amount").add(amount));
            item.setTax(matchItem.getBigDecimal("tax").add(tax));
            item.setNum(matchItem.getBigDecimal("num").add(num));
            item.setItemExtJson(MinusBillMatchHelper.getExtJson(matchConfig.getItemField(), matchItem));
            items.add(item);
        }
        if (StringUtils.isNotBlank((CharSequence)matchBill.getString("blueinvoiceno")) && (blueInvoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)matchBill.getString("blueinvoicecode"), (String)matchBill.getString("blueinvoiceno")).toArray())) != null) {
            minusBill.setLimitInvoiceIds(Collections.singleton(blueInvoice.getLong("id")));
        }
        minusBill.setItems(items);
        return minusBill;
    }

    public static JSONObject getExtJson(String headField, DynamicObject mergeBill) {
        JSONObject json = new JSONObject();
        try {
            if (StringUtils.isNotBlank((CharSequence)headField)) {
                String[] keys;
                for (String key : keys = headField.split(",")) {
                    if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)mergeBill, (String)key)) continue;
                    Object val = mergeBill.get(key);
                    if (val instanceof DynamicObject) {
                        json.put(key, ((DynamicObject)val).getPkValue());
                        continue;
                    }
                    json.put(key, mergeBill.get(key));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    @Deprecated
    public void updateMatchBill(MinusBillDTO minusBill, DynamicObject matchBill, Set<Long> oriInvoiceIdSet) {
        this.updateMatchBill(new ArrayList<String>(1), minusBill, matchBill, oriInvoiceIdSet);
    }

    public void updateMatchBill(List<String> isvExtFieldList, MinusBillDTO minusBill, DynamicObject matchBill, Set<Long> oriInvoiceIdSet) {
        matchBill.set("matchtype", (Object)"1");
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        Map<Object, DynamicObject> matchItemMap = matchItems.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v, (v1, v2) -> v1));
        HashMap<Object, DynamicObjectCollection> oriInvoiceMap = new HashMap<Object, DynamicObjectCollection>(16);
        List minusBillItems = minusBill.getItems();
        Set matchItemIdSet = minusBillItems.stream().map(MinusBillItemDTO::getMatchOrMergeItemId).collect(Collectors.toSet());
        Set<String> matchFlagSet = matchItems.stream().filter(matchItem -> !matchItemIdSet.contains(matchItem.get("id"))).map(matchItem -> matchItem.getString("itemmatchstatus")).collect(Collectors.toSet());
        for (MinusBillItemDTO minusBillItem : minusBillItems) {
            DynamicObject matchItem2 = matchItemMap.get(minusBillItem.getMatchOrMergeItemId());
            DynamicObjectCollection oriInvoices = matchItem2.getDynamicObjectCollection("subentryentity");
            if (!MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(minusBillItem.getMatchStatus())) {
                if (minusBillItem.getInvoiceList().size() > 0 || oriInvoices.size() > 0) {
                    minusBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                } else {
                    minusBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                }
            }
            matchItem2.set("itemmatchstatus", (Object)minusBillItem.getMatchStatus());
            matchFlagSet.add(minusBillItem.getMatchStatus());
            List invoiceList = minusBillItem.getInvoiceList();
            for (MatchInvoiceDTO matchInvoice : invoiceList) {
                DynamicObject oriInvoice = this.createOriInvoice(oriInvoices, matchInvoice, minusBillItem);
                oriInvoiceIdSet.add(matchInvoice.getInvoiceid());
                if (matchInvoice.getInvoiceid() != null && matchInvoice.getInvoiceid() != 0L) {
                    this.setExtField(isvExtFieldList, oriInvoice, oriInvoiceMap);
                }
                matchBill.set("matchamount", (Object)matchBill.getBigDecimal("matchamount").add(matchInvoice.getItemAmount().negate()));
                matchBill.set("matchtax", (Object)matchBill.getBigDecimal("matchtax").add(matchInvoice.getItemTax().negate()));
            }
        }
        matchBill.set("matchtotalamount", (Object)matchBill.getBigDecimal("matchamount").add(matchBill.getBigDecimal("matchtax")));
        matchBill.set("matchinvoicenum", (Object)(matchBill.getInt("matchinvoicenum") + oriInvoiceMap.size()));
        if (matchFlagSet.size() == 1) {
            matchBill.set("matchstatus", (Object)matchFlagSet.toArray(new String[0])[0]);
        } else {
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        }
        matchBill.set("matchrule", (Object)minusBill.getConfig().getId());
        matchBill.set("redreason", (Object)minusBill.getRedreason());
        matchBill.set("matchtime", (Object)MinusBillMatchHelper.getMatchTime());
        NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
    }

    public List<String> getIsvExtFieldList() {
        List isvExtFieldList = MetadataUtil.getIsvEntityItems((String)"sim_match_bill");
        if (CollectionUtils.isEmpty((Collection)isvExtFieldList)) {
            return new ArrayList<String>(1);
        }
        DynamicObjectType matchItemObjectType = ((EntryProp)EntityMetadataCache.getDataEntityType((String)"sim_match_bill").getProperty("sim_original_bill_item")).getDynamicCollectionItemPropertyType();
        DynamicObjectType oriInvoiceObjectType = ((SubEntryProp)matchItemObjectType.getProperty("subentryentity")).getDynamicCollectionItemPropertyType();
        MainEntityType invoiceEntityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        DynamicObjectType itemObjectType = ((EntryProp)invoiceEntityType.getProperty("items")).getDynamicCollectionItemPropertyType();
        boolean hasItemField = false;
        ArrayList<String> newIsvExtFieldList = new ArrayList<String>(isvExtFieldList.size());
        for (String extField : isvExtFieldList) {
            if (oriInvoiceObjectType.getProperty(extField) == null) continue;
            if (invoiceEntityType.getProperty(extField) != null) {
                newIsvExtFieldList.add(extField);
                continue;
            }
            if (itemObjectType.getProperty(extField) == null) continue;
            hasItemField = true;
            newIsvExtFieldList.add("items".concat(".").concat(extField));
        }
        if (hasItemField) {
            newIsvExtFieldList.add("items".concat(".").concat("id"));
        }
        return newIsvExtFieldList;
    }

    public void setExtField(List<String> isvExtFieldList, DynamicObject oriInvoice, Map<Object, DynamicObjectCollection> oriInvoiceMap) {
        Object invoiceId = oriInvoice.get("oriinvoiceid");
        if (CollectionUtils.isEmpty(isvExtFieldList)) {
            oriInvoiceMap.put(invoiceId, null);
            return;
        }
        String itemId = "items".concat(".").concat("id");
        boolean isContainItem = isvExtFieldList.contains(itemId);
        DynamicObjectCollection invoiceCollect = oriInvoiceMap.get(invoiceId);
        if (invoiceCollect == null && (invoiceCollect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", isvExtFieldList), (QFilter[])new QFilter("id", "=", invoiceId).toArray())) == null) {
            return;
        }
        oriInvoiceMap.put(invoiceId, invoiceCollect);
        DynamicObject item = isContainItem ? (DynamicObject)invoiceCollect.stream().filter(k -> k.get(itemId).equals(oriInvoice.get("oriitemid"))).findFirst().orElse(null) : (DynamicObject)invoiceCollect.get(0);
        if (item != null) {
            for (String extField : isvExtFieldList) {
                if (extField.equals(itemId)) continue;
                oriInvoice.set(extField.replace("items".concat("."), ""), item.get(extField));
            }
        }
    }

    public DynamicObject createOriInvoice(DynamicObjectCollection oriInvoices, MatchInvoiceDTO matchInvoice, MinusBillItemDTO minusBillItem) {
        DynamicObject oriInvoice = oriInvoices.addNew();
        oriInvoice.set("oriinvoiceid", (Object)matchInvoice.getInvoiceid());
        oriInvoice.set("oriinvoicecode", (Object)matchInvoice.getInvoicecode());
        oriInvoice.set("oriinvoiceno", (Object)matchInvoice.getInvoiceno());
        oriInvoice.set("oriitemid", (Object)matchInvoice.getItemid());
        oriInvoice.set("oriitemseq", (Object)matchInvoice.getItemseq());
        oriInvoice.set("oriitemamount", (Object)matchInvoice.getItemAmount());
        oriInvoice.set("oriitemtax", (Object)matchInvoice.getItemTax());
        oriInvoice.set("oritaxrate", (Object)minusBillItem.getTaxRate());
        oriInvoice.set("oriitemnum", (Object)matchInvoice.getItemNum());
        oriInvoice.set("oriitemunitprice", (Object)matchInvoice.getItemUnitprice());
        oriInvoice.set("oriitemtaxunitprice", (Object)matchInvoice.getItemTaxUnitprice());
        oriInvoice.set("oriitemgoodsname", (Object)matchInvoice.getGoodsName());
        oriInvoice.set("oriitemspecification", (Object)matchInvoice.getSpecification());
        oriInvoice.set("oriitemunit", (Object)matchInvoice.getUnit());
        oriInvoice.set("pushstatus", (Object)"-1");
        return oriInvoice;
    }

    public void updateInvoiceOccupyStatus(Collection<Long> oriInvoiceIdSet, String occupyStatus, String billFormId) {
        DynamicObject[] invoiceOrRedConfirms;
        if (oriInvoiceIdSet.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", oriInvoiceIdSet);
        for (DynamicObject obj : invoiceOrRedConfirms = BusinessDataServiceHelper.load((String)billFormId, (String)"occupystatus", (QFilter[])qFilter.toArray())) {
            obj.set("occupystatus", (Object)occupyStatus);
        }
        ImcSaveServiceHelper.save((DynamicObject[])invoiceOrRedConfirms);
        WideInvoiceSevice.dealWideInvoiceOccupyStatus(Arrays.stream(invoiceOrRedConfirms).collect(Collectors.toList()));
    }

    public void saveCreateMatchBills(List<DynamicObject> createMatchBills, MatchBillRequest matchBillRequest, Map<Long, String> matchBillStatus) {
        HashMap<Long, String> billidNoMap = new HashMap<Long, String>(createMatchBills.size());
        HashMap<Long, String> billOperateBatchMap = new HashMap<Long, String>(createMatchBills.size());
        List relations = matchBillRequest.getRelations();
        for (DynamicObject matchBill : createMatchBills) {
            billidNoMap.put(matchBill.getLong("id"), matchBill.getString("billno"));
            billOperateBatchMap.put(matchBill.getLong("id"), matchBill.getString("matchbatch"));
        }
        this.handleRelationZero(createMatchBills, relations);
        HashMap<Long, Long> bill2MatchBill = new HashMap<Long, Long>(relations.size());
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>(relations.size());
        for (BillRelationDTO relation : relations) {
            relation.settBillNo((String)billidNoMap.get(relation.gettBillId()));
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_matchbill_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)relationObj);
            relationList.add(relationObj);
            bill2MatchBill.put(relation.getsBillId(), relation.gettBillId());
        }
        ImcSaveServiceHelper.save(relationList);
        matchBillRequest.getNoMatchOriginalBills().forEach(bill -> {
            bill.set("matchstatus", matchBillStatus.get(bill2MatchBill.get(bill.getLong("id"))));
            bill.set("confirmstate", (Object)"2");
            bill.set("confirmamount", bill.get("1".equals(bill.getString("hsbz")) ? "totalamount" : "invoiceamount"));
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                item.set("remainvalidamount", (Object)BigDecimal.ZERO);
                item.set("remainvalidtax", (Object)BigDecimal.ZERO);
                item.set("remainvalidnum", (Object)BigDecimal.ZERO);
            }
        });
        List bills = matchBillRequest.getNoMatchOriginalBills();
        Map<Long, Long> bill2MatchBillMap = relations.stream().collect(Collectors.toMap(BillRelationDTO::getsBillId, BillRelationDTO::gettBillId, (v1, v2) -> v1));
        BillComprehensiveStatusHelper billComprehensiveStatusHelper = new BillComprehensiveStatusHelper();
        HashMap<Long, List> matchBill2BillsMap = new HashMap<Long, List>(16);
        for (DynamicObject bill2 : bills) {
            Long matchBillId = bill2MatchBillMap.get(bill2.getLong("id"));
            matchBill2BillsMap.computeIfAbsent(matchBillId, k -> new ArrayList()).add(bill2);
            bill2.set("operatebatch", billOperateBatchMap.get(matchBillId));
        }
        for (DynamicObject matchBill : createMatchBills) {
            billComprehensiveStatusHelper.setBillsComprehensiveStatusByMatchBill(matchBill, ((List)matchBill2BillsMap.getOrDefault(matchBill.getLong("id"), new ArrayList(1))).toArray(new DynamicObject[0]));
        }
        ImcSaveServiceHelper.save(createMatchBills);
    }

    public void handleRelationZero(List<DynamicObject> createMatchBills, List<BillRelationDTO> relations) {
        try {
            Map<Long, List<BillRelationDTO>> pushZeroMap = relations.stream().filter(BillRelationDTO::isPushZero).collect(Collectors.groupingBy(BillRelationDTO::gettBillId));
            if (pushZeroMap == null || pushZeroMap.size() == 0) {
                return;
            }
            for (DynamicObject matchBill : createMatchBills) {
                List<BillRelationDTO> billRelations = pushZeroMap.get(matchBill.getLong("id"));
                if (CollectionUtils.isEmpty(billRelations)) continue;
                DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                if (CollectionUtils.isEmpty((Collection)items)) {
                    return;
                }
                long tDetailId = ((DynamicObject)items.get(0)).getLong("id");
                for (BillRelationDTO relation : billRelations) {
                    relation.settDetailId(Long.valueOf(tDetailId));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u5408\u5e76\u4e3a0\u660e\u7ec6\u884c\u5173\u7cfb\u5931\u8d25", (Throwable)e);
        }
    }

    public void writebackMatchBillAndSetBillComprehensive(List<DynamicObject> redConfirmList) {
        DynamicObject[] matchBillArr = new NegativeBillMatchHelper().writeInfoCode2MatchBill(redConfirmList);
        BillComprehensiveStatusHelper billComprehensiveStatusHelper = new BillComprehensiveStatusHelper();
        for (DynamicObject matchBill : matchBillArr) {
            billComprehensiveStatusHelper.setBillComprehensiveStatusByMatchBill(matchBill);
        }
    }
}

