/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.table.MailSettingConstant;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.MailSettingHelper;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;

public class RedConfirmBillMailHelper {
    private static final Log LOGGER = LogFactory.getLog(RedConfirmBillMailHelper.class);

    public static void getRedConfirmBill() {
        DeleteServiceHelper.delete((String)"sim_confirm_mail_record", (QFilter[])new QFilter("uploaddate", "<=", (Object)DateUtils.addDay((Date)new Date(), (int)-3)).toArray());
        QFilter confirmStatusFilter = new QFilter("confirmstatus", "=", (Object)"02");
        DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])new QFilter("uploaddate", ">=", (Object)DateUtils.addDay((Date)new Date(), (int)-3)).and(confirmStatusFilter).toArray());
        ArrayList billNos = Lists.newArrayListWithCapacity((int)redConfirmBills.length);
        for (DynamicObject redConfirmBill : redConfirmBills) {
            try {
                billNos.add(redConfirmBill.getString("billno"));
                RedConfirmBillMailHelper.addAPushRecord(redConfirmBill);
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u64cd\u4f5c\u62a5\u9519[%s], \u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7[%s]", e.getMessage(), redConfirmBill.getString("billno")));
            }
        }
        LOGGER.info(String.format("\u90ae\u4ef6\u53d1\u9001\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\uff1a[%s]", billNos));
    }

    public static void sendEmailImm(DynamicObject redConfirmBill) {
        DynamicObject pushRecord = RedConfirmBillMailHelper.addAPushRecord(redConfirmBill);
        if (pushRecord == null || !pushRecord.getString("pushtimes").contains(",2,") || pushRecord.getInt("pushimm") != 0) {
            return;
        }
        RedConfirmBillMailHelper.sendByPushRecord(pushRecord);
    }

    public static void sendEmailImm(List<Object> pkList) {
        DynamicObject[] redConfirmBills;
        if (pkList == null || pkList.size() == 0) {
            return;
        }
        for (DynamicObject redConfirmBill : redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])new QFilter("id", "in", pkList).toArray())) {
            RedConfirmBillMailHelper.sendEmailImm(redConfirmBill);
        }
    }

    public static void sendAllImmEmail() {
        DynamicObject[] pushRecords;
        for (DynamicObject pushRecord : pushRecords = BusinessDataServiceHelper.load((String)"sim_confirm_mail_record", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_confirm_mail_record"), (QFilter[])new QFilter("pushimm", "=", (Object)0).and("pushtimes", "like", (Object)"%,2,%").toArray())) {
            RedConfirmBillMailHelper.sendByPushRecord(pushRecord);
        }
    }

    private static void sendByPushRecord(DynamicObject pushRecord) {
        HashMap sendMap = Maps.newHashMapWithExpectedSize((int)0);
        pushRecord.set("pushimm", (Object)(pushRecord.getInt("pushimm") + 1));
        RedConfirmBillMailHelper.buildSendMap(pushRecord, sendMap);
        RedConfirmBillMailHelper.sendMailMethod(sendMap);
    }

    public static void deletePushRecord(List<Object> redConfirmBillIdList) {
        try {
            DynamicObject[] pushRecords;
            if (redConfirmBillIdList != null && !redConfirmBillIdList.isEmpty()) {
                for (Object billId : redConfirmBillIdList) {
                    DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"sim_red_confirm_bill");
                    if (redConfirmBill == null || redConfirmBill.getString("confirmstatus").equals("02") || redConfirmBill.getString("confirmstatus").equals("03")) continue;
                    try {
                        DeleteServiceHelper.delete((String)"sim_confirm_mail_record", (QFilter[])new QFilter("redconfirmbillid", "=", billId).toArray());
                    }
                    catch (Exception exception) {}
                }
                return;
            }
            for (DynamicObject pushRecord : pushRecords = BusinessDataServiceHelper.load((String)"sim_confirm_mail_record", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_confirm_mail_record"), (QFilter[])new QFilter("1", "=", (Object)1).toArray())) {
                DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)pushRecord.getLong("redconfirmbillid"), (String)"sim_red_confirm_bill");
                if (redConfirmBill != null && (redConfirmBill.getString("confirmstatus").equals("02") || redConfirmBill.getString("confirmstatus").equals("03"))) continue;
                try {
                    DeleteServiceHelper.delete((String)"sim_confirm_mail_record", (QFilter[])new QFilter("id", "=", pushRecord.getPkValue()).toArray());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u63a8\u5355\u8bb0\u5f55\u5220\u9664\u51fa\u9519[%s]", e.getMessage()));
        }
    }

    private static DynamicObject addAPushRecord(DynamicObject redConfirmBill) {
        if (redConfirmBill == null) {
            return null;
        }
        String confirmStatus = redConfirmBill.getString("confirmstatus");
        if (!"02".equals(confirmStatus) && !"03".equals(confirmStatus)) {
            return null;
        }
        long redConfirmBillId = redConfirmBill.getLong("id");
        DynamicObject pushRecord = BusinessDataServiceHelper.loadSingle((String)"sim_confirm_mail_record", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_confirm_mail_record"), (QFilter[])new QFilter("redconfirmbillid", "=", (Object)redConfirmBillId).toArray());
        if (pushRecord == null) {
            DynamicObject newPushRecord = BusinessDataServiceHelper.newDynamicObject((String)"sim_confirm_mail_record");
            newPushRecord.set("redconfirmbillid", (Object)redConfirmBillId);
            newPushRecord.set("uploaddate", (Object)redConfirmBill.getDate("uploaddate"));
            Long orgId = redConfirmBill.getDynamicObject("createorg").getLong("id");
            DynamicObject pushSettingConfig = RedConfirmBillMailHelper.checkMailPushSettingConfig(orgId, confirmStatus);
            if (pushSettingConfig == null) {
                LOGGER.info(String.format("\u90ae\u4ef6\u53d1\u9001\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u672a\u5339\u914d\u5230\u63a8\u9001\u914d\u7f6e\uff1a\u786e\u8ba4\u5355\u7f16\u53f7[%s]", redConfirmBill.getString("billno")));
                return null;
            }
            newPushRecord.set("pushsettingid", (Object)pushSettingConfig.getLong("id"));
            newPushRecord.set("pushtimes", (Object)pushSettingConfig.getString("pushtimes"));
            newPushRecord.set("pushtimecustom", (Object)pushSettingConfig.getString("pushtimecustom"));
            newPushRecord.set("pushscenario", (Object)pushSettingConfig.getString("pushscenario"));
            newPushRecord.set("pushtarge", (Object)pushSettingConfig.getString("pushtarge"));
            String mailAddress = RedConfirmBillMailHelper.getMailAddress(pushSettingConfig, redConfirmBill);
            if (StringUtils.isEmpty((CharSequence)mailAddress)) {
                LOGGER.info(String.format("\u90ae\u4ef6\u53d1\u9001\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u672a\u5339\u914d\u5230\u90ae\u7bb1\u5730\u5740\uff1a\u786e\u8ba4\u5355\u7f16\u53f7[%s]", redConfirmBill.getString("billno")));
                return null;
            }
            newPushRecord.set("mailaddress", (Object)mailAddress);
            newPushRecord.set("onedaypush", (Object)0);
            newPushRecord.set("twodaypush", (Object)0);
            newPushRecord.set("pushimm", (Object)0);
            newPushRecord.set("pushcustom", (Object)0);
            DynamicObject mailTemplateSetting = RedConfirmBillMailHelper.getRedMailTemplateSetting(orgId, redConfirmBill);
            newPushRecord.set("accepttaxno", (Object)redConfirmBill.getString("buyertaxno"));
            newPushRecord.set("applyname", (Object)redConfirmBill.getString("salername"));
            if ("03".equals(confirmStatus)) {
                newPushRecord.set("accepttaxno", (Object)redConfirmBill.getString("salertaxno"));
                newPushRecord.set("applyname", (Object)redConfirmBill.getString("buyername"));
                mailTemplateSetting = RedConfirmBillMailHelper.getRedMailTemplateSetting(orgId, redConfirmBill);
            }
            if (mailTemplateSetting == null) {
                LOGGER.info(String.format("\u90ae\u4ef6\u53d1\u9001\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u672a\u5339\u914d\u5230\u90ae\u7bb1\u6837\u677f\u914d\u7f6e\uff1a\u786e\u8ba4\u5355\u7f16\u53f7[%s]", redConfirmBill.getString("billno")));
                return null;
            }
            newPushRecord.set("mailsettingid", (Object)mailTemplateSetting.getLong("id"));
            ImcSaveServiceHelper.save((DynamicObject)newPushRecord);
            return newPushRecord;
        }
        return pushRecord;
    }

    private static String getMailAddress(DynamicObject pushSettingConfig, DynamicObject redConfirmBill) {
        DynamicObjectCollection mailSetting = pushSettingConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : mailSetting) {
            String mailType;
            switch (mailType = dynamicObject.getString("mailtype")) {
                case "1": {
                    QFilter qFilter = ImcBaseDataHelper.getInvTitleFilter((Object)redConfirmBill.getDynamicObject("createorg").getLong("id"));
                    DynamicObject title = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])qFilter.and("taxno", "=", (Object)redConfirmBill.getString("buyertaxno")).and("name", "=", (Object)redConfirmBill.getString("buyername")).toArray());
                    if (title == null) break;
                    DynamicObjectCollection items = title.getDynamicObjectCollection("items");
                    for (DynamicObject item : items) {
                        if (!"1".equals(item.getString("isdefault")) || !StringUtils.isNotEmpty((CharSequence)item.getString("itemredemail"))) continue;
                        return item.getString("itemredemail");
                    }
                    break;
                }
                case "2": {
                    if (!StringUtils.isNotEmpty((CharSequence)redConfirmBill.getString("buyerredemail"))) break;
                    return redConfirmBill.getString("buyerredemail");
                }
                case "3": {
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"buyeremail", (QFilter[])new QFilter("invoiceno", "=", (Object)redConfirmBill.getString("originalinvoiceno")).and("invoicecode", "=", (Object)redConfirmBill.getString("originalinvoicecode")).toArray());
                    if (invoice == null || !StringUtils.isNotEmpty((CharSequence)invoice.getString("buyeremail"))) break;
                    return invoice.getString("buyeremail");
                }
            }
        }
        return "";
    }

    private static DynamicObject checkMailPushSettingConfig(Long orgId, String confirmStatus) {
        QFilter qFilter = ImcBaseDataHelper.getRedConfirmBillMailSettingFilter((Object)orgId).and("pushscenario", "=", (Object)confirmStatus);
        LOGGER.info(String.format("\u67e5\u8be2\u914d\u7f6eid[%s],\u7ba1\u63a7\u7b56\u7565\u8fc7\u6ee4\u6761\u4ef6[%s]", orgId, qFilter));
        return MailSettingHelper.getSettingByCtrlStrategy((String)"bdm_red_mail_push_setting", (QFilter)qFilter);
    }

    private static DynamicObject getRedMailTemplateSetting(Long orgId, DynamicObject redConfirmBill) {
        QFilter qFilter = ImcBaseDataHelper.getBdmMailRedConfirmFilter((Object)orgId).and("number", "!=", (Object)"RYZYXSZ01_s");
        DynamicObject dynamicObject = MailSettingHelper.getSettingByCtrlStrategy((String)"bdm_mail_redconfirm", (QFilter)qFilter, (DynamicObject)redConfirmBill);
        if (dynamicObject != null) {
            return dynamicObject;
        }
        return BusinessDataServiceHelper.loadSingle((String)"bdm_mail_redconfirm", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_mail_redconfirm", (boolean)true), (QFilter[])new QFilter("enable", "=", (Object)MailSettingConstant.Status.ENABLE.getValue()).and("number", "=", (Object)"RYZYXSZ01_s").toArray());
    }

    public static void buildSendMap(DynamicObject pushRecord, Map<String, List<DynamicObject>> sendMap) {
        String[] mails;
        String mailAddress = pushRecord.getString("mailaddress");
        for (String mail : mails = mailAddress.split(";")) {
            String mapKey = mail + "*" + pushRecord.getString("mailsettingid") + "*" + pushRecord.getString("accepttaxno") + "*" + pushRecord.getString("pushtarge");
            List<DynamicObject> currentList = sendMap.getOrDefault(mapKey, Lists.newArrayListWithCapacity((int)1));
            currentList.add(pushRecord);
            sendMap.put(mapKey, currentList);
        }
    }

    public static void sendMailMethod(Map<String, List<DynamicObject>> sendMap) {
        for (Map.Entry<String, List<DynamicObject>> entry : sendMap.entrySet()) {
            try {
                String[] strings = entry.getKey().split("\\*");
                String mail = strings[0];
                String mailSettingId = strings[1];
                ArrayList redConfirmBills = Lists.newArrayListWithCapacity((int)entry.getValue().size());
                for (DynamicObject pushRecord : entry.getValue()) {
                    DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)pushRecord.getLong("redconfirmbillid"), (String)"sim_red_confirm_bill");
                    redConfirmBills.add(redConfirmBill);
                }
                String emailTitle = String.format(ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u5f20\u6765\u81ea\u3010%s\u3011\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406", (String)"RedConfirmMailPushTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), entry.getValue().get(0).getString("applyname"));
                MsgResponse msgResponse = SendMsgEmailService.redConfirmBillEmailOneDefaultOrBySelf((List)redConfirmBills, (String)mail, (String)mailSettingId, (String)emailTitle);
                if (msgResponse != null && "0000".equals(msgResponse.getErrorCode())) {
                    LOGGER.info(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff0c\u63a8\u9001\u90ae\u4ef6[%s]\uff0c\u63a8\u9001\u7ea2\u5b57\u786e\u8ba4\u5355[%s]", mail, redConfirmBills));
                    ImcSaveServiceHelper.update(entry.getValue());
                    continue;
                }
                LOGGER.info(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u63a8\u9001\u90ae\u4ef6[%s]\uff0c\u63a8\u9001\u7ea2\u5b57\u786e\u8ba4\u5355[%s]", mail, redConfirmBills));
            }
            catch (Exception e) {
                LOGGER.info(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38\uff0c\u5f02\u5e38KEY[%s]\uff0c\u5f02\u5e38\u539f\u56e0[%s]", entry.getKey(), e.getMessage()));
            }
        }
    }
}

