/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo.service;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.BillConstant;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceBaseControl;
import kd.imc.sim.formplugin.issuing.util.RedInvoiceUtil;

public abstract class AbstractInitRedInfoService {
    protected static final Log log = LogFactory.getLog(AbstractInitRedInfoService.class);
    protected boolean isSaler = false;
    protected boolean isFind = false;
    protected boolean isDeduction = false;
    protected String taxFlag = "0";
    private long orgId;

    public void init(AbstractFormPlugin formPlugin) {
        this.orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)formPlugin.getView().getModel().getValue("org"));
        SaleInfo saleInfo = CreateInvoiceBaseControl.getSaleInfoByOrg(this.orgId, formPlugin.getView());
        if (saleInfo == null) {
            return;
        }
        this.setSpeicalType(formPlugin, saleInfo);
        DynamicObject obj = this.initRedInfo(formPlugin, saleInfo);
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)formPlugin, (long)this.orgId, (String)saleInfo.getSaleTaxNo(), (String)"jqbh", (String)"terminalno", (boolean)true);
        this.setInvoiceHeadView(formPlugin);
        this.setTobacco(obj, formPlugin);
        this.setTaxFlagView(obj, formPlugin);
        RedInfoHelper.initDescribe((AbstractFormPlugin)formPlugin, (boolean)this.isDeduction);
        String itemStr = this.createInvoiceItems(obj, formPlugin);
        this.initCustomControl(obj, itemStr, formPlugin, saleInfo);
    }

    protected void setSpeicalType(AbstractFormPlugin formPlugin, SaleInfo saleInfo) {
        if (!TaxUtils.isTobaccoEnterprise((String)saleInfo.getSaleTaxNo())) {
            formPlugin.getPageCache().put("tobacco_enterprise", "0");
        } else {
            formPlugin.getPageCache().put("tobacco_enterprise", "1");
        }
        if (TaxUtils.isOilEnterpriseByTaxNo((String)saleInfo.getSaleTaxNo())) {
            formPlugin.getPageCache().put("oil_enterprise", "1");
        } else {
            formPlugin.getPageCache().put("oil_enterprise", "0");
        }
    }

    private void initCustomControl(DynamicObject obj, String itemStr, AbstractFormPlugin formPlugin, SaleInfo saleInfo) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        showDataMap.put("inputStyle", "text-indent: 8px;height: 28px;width: 100%; font-size: 14px;");
        if (this.isSaler) {
            if (!this.isFind) {
                showDataMap.put("buyername", obj.get("buyername"));
                ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"querytitlediy");
            }
        } else {
            showDataMap.put("salername", obj.get("salername"));
            ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"saletitlediy");
        }
        DynamicObjectCollection items = obj.getDynamicObjectCollection("items");
        String invoiceType = (String)formPlugin.getView().getModel().getValue("invoicetype");
        showDataMap.put("items", JSONArray.parseArray((String)itemStr));
        showDataMap.put("qdhp", InvoiceUtils.isPaperInvoice((String)invoiceType) && (items.size() > 8 || items.stream().anyMatch(item -> BillConstant.TIP_ITEM_DETAIL.equals(item.getString("goodsname")))) ? "1" : "0");
        showDataMap.put("kplx", String.valueOf(IssueTypeEnum.RED_INFO.getValue()));
        showDataMap.put("editType", "0");
        showDataMap.put("hsbz", this.taxFlag);
        String taxEdit = ImcConfigUtil.getValue((String)"sim_red_info_tax_edit", (String)saleInfo.getSaleTaxNo());
        if (StringUtils.isNotBlank((CharSequence)taxEdit)) {
            showDataMap.put("taxAdjustMode", "1");
        } else {
            showDataMap.put("taxAdjustMode", "-1");
        }
        ViewUtil.bindDataToHtml((AbstractFormPlugin)formPlugin, showDataMap, (String)"customcontrolap");
    }

    private void setInvoiceHeadView(AbstractFormPlugin that) {
        that.getView().getModel().setValue("issuetype", (Object)IssueTypeEnum.red.getValue());
        if (this.isSaler) {
            that.getView().setVisible(Boolean.FALSE, new String[]{"customsalername", "buyeraddrflex", "saleraddrtextflex"});
            that.getView().setEnable(Boolean.FALSE, new String[]{"salername", "salertaxno"});
            if (this.isFind) {
                that.getView().setVisible(Boolean.FALSE, new String[]{"custombuyername"});
                that.getView().setEnable(Boolean.FALSE, new String[]{"buyername", "buyertaxno"});
            } else {
                that.getView().setVisible(Boolean.FALSE, new String[]{"flexbuyername"});
            }
        } else {
            that.getView().setEnable(Boolean.FALSE, new String[]{"buyertaxno", "buyername"});
            that.getView().setVisible(Boolean.FALSE, new String[]{"custombuyername", "flexsalername", "buyeraddrtextflex", "saleraddrflex"});
        }
        this.setInvoiceType(that);
    }

    protected void setTobacco(DynamicObject obj, AbstractFormPlugin that) {
        HashMap<String, String> specialTypeSelectMap = new HashMap<String, String>();
        specialTypeSelectMap.put(ResManager.loadKDString((String)"\u975e\u7279\u6b8a\u7968\u79cd", (String)"AbstractInitRedInfoService_0", (String)"imc-sim-service", (Object[])new Object[0]), "00");
        boolean tobaccoEnterprise = TaxUtils.isTobaccoEnterprise((Long)this.orgId);
        boolean oilEnterprise = TaxUtils.isOilEnterprise((Long)this.orgId);
        if (tobaccoEnterprise) {
            specialTypeSelectMap.put(ResManager.loadKDString((String)"\u5377\u70df", (String)"AbstractInitRedInfoService_1", (String)"imc-sim-service", (Object[])new Object[0]), "11");
        }
        if (oilEnterprise) {
            specialTypeSelectMap.put(ResManager.loadKDString((String)"\u6210\u54c1\u6cb9", (String)"AbstractInitRedInfoService_2", (String)"imc-sim-service", (Object[])new Object[0]), "08");
        }
        ViewUtil.setDropDownViewData((AbstractFormPlugin)that, (String)"checkboxtobacco", specialTypeSelectMap);
        that.getView().getModel().setValue("checkboxtobacco", (Object)(StringUtils.isBlank((CharSequence)obj.getString("specialtype")) ? "00" : obj.getString("specialtype")));
        if (this.isFind) {
            that.getView().setEnable(Boolean.FALSE, new String[]{"checkboxtobacco"});
        }
        if (!(!this.isSaler || tobaccoEnterprise && oilEnterprise)) {
            that.getView().getModel().setValue("checkboxtobacco", (Object)obj.getString("specialtype"));
            that.getView().setVisible(Boolean.FALSE, new String[]{"checkboxtobacco"});
        }
    }

    private void setInvoiceType(AbstractFormPlugin formPlugin) {
        String invoiceCode = (String)formPlugin.getView().getModel().getValue("originalinvoicecode");
        String invoiceType = null;
        if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
            String type = invoiceCode.substring(10);
            HashMap<String, String> invoiceTypeSelectMap = new HashMap<String, String>();
            if (invoiceCode.length() == 12 && "13".equals(type)) {
                invoiceTypeSelectMap.put(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getDescription(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode());
            } else {
                invoiceTypeSelectMap.put(InvoiceType.PAPER_SPECIAL_INVOICE.getDescription(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
                invoiceType = InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode();
            }
            ViewUtil.setDropDownViewData((AbstractFormPlugin)formPlugin, (String)"invoicetype", invoiceTypeSelectMap);
        } else {
            invoiceType = (String)formPlugin.getView().getModel().getValue("invoicetype");
        }
        if (StringUtils.isBlank((CharSequence)invoiceType)) {
            invoiceType = InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode();
        }
        formPlugin.getView().getModel().setValue("invoicetype", (Object)invoiceType);
    }

    protected void setTaxFlagView(DynamicObject obj, AbstractFormPlugin formPlugin) {
        this.taxFlag = obj.getString("hsbz");
        if (this.isFind) {
            HashMap<String, String> hsbzSelectMap = new HashMap<String, String>();
            if ("0".equals(this.taxFlag)) {
                hsbzSelectMap.put("\u4e0d\u542b\u7a0e", "0");
            } else if ("1".equals(this.taxFlag)) {
                hsbzSelectMap.put("\u542b\u7a0e", "1");
            }
            ViewUtil.setDropDownViewData((AbstractFormPlugin)formPlugin, (String)"hsbz", hsbzSelectMap);
        }
        if (StringUtils.isBlank((CharSequence)this.taxFlag)) {
            this.taxFlag = "0";
        }
        formPlugin.getPageCache().put("hsbz", this.taxFlag);
        formPlugin.getView().getModel().setValue("hsbz", (Object)this.taxFlag);
    }

    protected String createInvoiceItems(DynamicObject obj, AbstractFormPlugin formPlugin) {
        DynamicObjectCollection items;
        try {
            items = this.buildRedInfoItems(obj, formPlugin);
        }
        catch (KDBizException e) {
            items = null;
            formPlugin.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            items = null;
            log.error("\u7ea2\u5b57\u4fe1\u606f\u8868\u6784\u5efa\u660e\u7ec6\u51fa\u9519:" + e.getMessage(), (Throwable)e);
        }
        String itemsStr = items == null ? "" : RedInvoiceUtil.convertRedDynamicObjectItemsToJsonArray(obj, items).toJSONString();
        formPlugin.getPageCache().put("loadItems", itemsStr);
        return itemsStr;
    }

    protected abstract DynamicObject initRedInfo(AbstractFormPlugin var1, SaleInfo var2);

    protected abstract DynamicObjectCollection buildRedInfoItems(DynamicObject var1, AbstractFormPlugin var2);
}

