/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle.control;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;

public class VehicleInvoiceBatchRedController {
    private static Log LOGGER = LogFactory.getLog(VehicleInvoiceBatchRedController.class);

    public static DynamicObject handleRespData(List<String> errorMsg, DynamicObject vehicle, JSONObject response) {
        DynamicObject redInvoice = null;
        if ("0".equals(response.getString("errcode"))) {
            String sjd = response.getString("sjd");
            JSONObject resInvoice = JSONObject.parseObject((String)sjd);
            vehicle.set("invoicestatus", (Object)"3");
            redInvoice = VehicleInvoiceBatchRedController.createRedInvoice(vehicle, resInvoice);
            try (TXHandle tx = TX.required();){
                SaveServiceHelper.update((DynamicObject)vehicle);
                ImcSaveServiceHelper.save((DynamicObject)redInvoice);
            }
        } else {
            errorMsg.add(String.format(ResManager.loadKDString((String)"%1$s\u7ea2\u51b2\u5931\u8d25\uff1a%2$s", (String)"VehicleInvoiceBatchRedController_0", (String)"imc-sim-service", (Object[])new Object[0]), vehicle.getString("invoiceno"), response.getString("description")));
        }
        return redInvoice;
    }

    private static DynamicObject createRedInvoice(DynamicObject invoice, JSONObject invoiceJson) {
        String fphm = invoiceJson.getString("fphm");
        String fpdm = invoiceJson.getString("fpdm");
        String serialNum = invoiceJson.getString("serialnum");
        String jym = invoiceJson.getString("jym");
        DynamicObject vehiclesRedInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_vehicles");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)invoice, (DynamicObject)vehiclesRedInvoice);
        vehiclesRedInvoice.set("originalinvoicecode", (Object)invoice.getString("invoicecode"));
        vehiclesRedInvoice.set("originalinvoiceno", (Object)invoice.getString("invoiceno"));
        vehiclesRedInvoice.set("invoicecode", (Object)fpdm);
        vehiclesRedInvoice.set("invoiceno", (Object)fphm);
        vehiclesRedInvoice.set("issuetime", (Object)new Date());
        vehiclesRedInvoice.set("createtime", (Object)new Date());
        vehiclesRedInvoice.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        vehiclesRedInvoice.set("invoicestatus", (Object)"0");
        vehiclesRedInvoice.set("billno", (Object)("600_" + UUID.getBatchNumber() + "_0001"));
        vehiclesRedInvoice.set("drawer", (Object)invoice.getString("drawer"));
        vehiclesRedInvoice.set("totalamount", (Object)invoice.getBigDecimal("totalamount").negate());
        vehiclesRedInvoice.set("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount").negate());
        vehiclesRedInvoice.set("totaltax", (Object)invoice.getBigDecimal("totaltax").negate());
        vehiclesRedInvoice.set("skm", (Object)jym);
        vehiclesRedInvoice.set("orderno", (Object)serialNum);
        vehiclesRedInvoice.set("invaliddate", (Object)"");
        vehiclesRedInvoice.set("invalider", (Object)"");
        return vehiclesRedInvoice;
    }
}

