/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestListDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;

public class AllEleQueryListHelper {
    private static Log LOGGER = LogFactory.getLog(AllEleQueryListHelper.class);

    public static <T> List<T> getAllList(String taxNo, AllEleRequestListDTO request, Class<T> clazz) {
        int totalPage;
        int pageNo = 1;
        if (request.getPageSize() <= 0 || request.getPageSize() > 50) {
            request.setPageSize(50);
        }
        ArrayList responseLists = new ArrayList(16);
        do {
            AllEleResponseListDTO list;
            request.setPage(pageNo);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u6570\u7535\u7ec4\u4ef6\u8bf7\u6c42\u7a0e\u53f7[%s],\u8bf7\u6c42\u7b2c[%s]\u9875 ", taxNo, pageNo));
            }
            if (!(list = AllEleServiceHelper.doPostList((String)taxNo, (AllEleRequestDTO)request, clazz)).getSuccess().booleanValue()) {
                throw new KDBizException(list.getDescription());
            }
            totalPage = (list.getTotalElement() + request.getPageSize() - 1) / request.getPageSize();
            responseLists.addAll(list.getData());
        } while (++pageNo < totalPage);
        return responseLists;
    }
}

