/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.time.LocalTime;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.SendMsgEmailService;

public class InvoiceMailTimingHelper {
    public static String tabId = "sim_mail_timing";
    private static final Log LOG = LogFactory.getLog(InvoiceMailTimingHelper.class);

    public static void saveInvoiceMailTimingInfo(DynamicObject invoice, DynamicObject pushMailStrategy, String pushStatus) {
        try {
            String email = invoice.getString("buyeremail");
            if ("0".equals(pushStatus) && StringUtils.isBlank((CharSequence)email)) {
                return;
            }
            QFilter idFilter = new QFilter("invoiceid", "=", (Object)invoice.getLong("id")).and("pushstatus", "=", (Object)pushStatus);
            DynamicObject oldinvoiceMailTiming = QueryServiceHelper.queryOne((String)tabId, (String)"id", (QFilter[])idFilter.toArray());
            if (null != oldinvoiceMailTiming) {
                return;
            }
            DynamicObject invoiceMailTiming = BusinessDataServiceHelper.newDynamicObject((String)tabId);
            invoiceMailTiming.set("invoiceid", (Object)invoice.getString("id"));
            if (pushMailStrategy != null) {
                invoiceMailTiming.set("mailsendgrouprule", (Object)pushMailStrategy.getString("mailsendgrouprule"));
            }
            invoiceMailTiming.set("pushstatus", (Object)pushStatus);
            invoiceMailTiming.set("invoicecode", (Object)invoice.getString("invoicecode"));
            invoiceMailTiming.set("invoiceno", (Object)invoice.getString("invoiceno"));
            invoiceMailTiming.set("createtime", (Object)new Date());
            ImcSaveServiceHelper.save((DynamicObject)invoiceMailTiming);
        }
        catch (Exception e) {
            LOG.error("InvoiceMailTimingHelperFailed_" + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean getMuteSMSTime(DynamicObject invoice) {
        try {
            String start = SystemParameterHelper.getBdmParameter((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"smssilenttimestart");
            String end = SystemParameterHelper.getBdmParameter((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"smssilenttimeend");
            LOG.info("getMuteSMSTime start: " + start);
            LOG.info("getMuteSMSTime end: " + end);
            if ("-1".equals(start) || "-1".equals(end)) {
                return false;
            }
            return InvoiceMailTimingHelper.isTimeInRange(LocalTime.now().toSecondOfDay(), Integer.parseInt(start), Integer.parseInt(end));
        }
        catch (Exception e) {
            LOG.error("getMuteSMSTimeFailed", (Throwable)e);
            return false;
        }
    }

    private static boolean isTimeInRange(int currentSeconds, int startTime, int endTime) {
        if (endTime <= startTime) {
            return currentSeconds >= startTime || currentSeconds < endTime;
        }
        return currentSeconds >= startTime && currentSeconds < endTime;
    }

    public static void sendSmsOrEmail(DynamicObject invoice, DynamicObject pushMailStrategy) {
        boolean isSMSMute = false;
        String buyerPhone = "";
        if (!InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoice.getString("invoicetype"))) {
            buyerPhone = invoice.getString("buyerphone");
        }
        if (StringUtils.isNotEmpty((CharSequence)buyerPhone) && InvoiceMailTimingHelper.getMuteSMSTime(invoice)) {
            isSMSMute = true;
        }
        boolean isEmailTiming = false;
        if (null != pushMailStrategy && "1".equals(pushMailStrategy.getString("mailsendtype"))) {
            InvoiceMailTimingHelper.saveInvoiceMailTimingInfo(invoice, pushMailStrategy, "0");
            isEmailTiming = true;
        }
        if (isSMSMute) {
            InvoiceMailTimingHelper.saveInvoiceMailTimingInfo(invoice, null, "6");
            if (!isEmailTiming) {
                SendMsgEmailService.sendMultiMsgJson((DynamicObject)invoice, null, (String)invoice.getString("buyeremail"), (String)"1");
            }
        } else if (isEmailTiming) {
            if (StringUtils.isNotEmpty((CharSequence)buyerPhone)) {
                SendMsgEmailService.sendMultiMsgJson((DynamicObject)invoice, (String)buyerPhone, null);
            }
        } else {
            SendMsgEmailService.sendMultiMsgJson((DynamicObject)invoice, (String)buyerPhone, (String)invoice.getString("buyeremail"));
        }
    }
}

