/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class IssueInvoiceFailHelper {
    private static Set<String> getAutoIssueCode() {
        HashSet<String> errCodeSet = new HashSet<String>(4);
        try {
            String errCodeStr = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_ERROR_AUTO_ISSUE_DEFAULT);
            if (StringUtils.isNotBlank((CharSequence)errCodeStr)) {
                errCodeSet.addAll(Arrays.asList(errCodeStr.split(",")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errCodeSet;
    }

    public static void createFailAutoIssueRecord(DynamicObject invoice, String errorMsg, String errorCode) {
        RequestContext context = RequestContext.get();
        ThreadPoolsHelper.issueFailThreadPool.execute(() -> {
            RequestContext.copyAndSet((RequestContext)context);
            String orderNo = invoice.getString("orderno");
            try (DLock lock = DLock.create((String)("fail_issue_" + orderNo));){
                if (!lock.tryLock(1000L)) {
                    return;
                }
                DeleteServiceHelper.delete((String)"sim_fail_auto_issue", (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
                if (IssueInvoiceFailHelper.getAutoIssueCode().contains(errorCode) || CallbackHelperUtil.isAutoIssue((long)orgId, (String)orderNo, (String)errorMsg) || CallbackHelperUtil.isAllOrgAutoIssue((DynamicObject)invoice, (String)errorMsg)) {
                    DynamicObject failReIssueRecord = BusinessDataServiceHelper.newDynamicObject((String)"sim_fail_auto_issue");
                    failReIssueRecord.set("orderno", (Object)orderNo);
                    failReIssueRecord.set("createdate", (Object)new Date());
                    failReIssueRecord.set("failreason", (Object)GBKUtils.cutGBKString((String)errorMsg, (int)200));
                    ImcSaveServiceHelper.save((DynamicObject)failReIssueRecord);
                }
            }
        });
    }
}

