/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.dto.MoudleDataDTO;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HTXXUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import org.apache.commons.lang.StringUtils;

public class LyServerInvoiceHelper {
    private static final Log logger = LogFactory.getLog(LyServerInvoiceHelper.class);

    private static void asyncQueryInvoiceCount(JSONObject params) {
        try {
            LyServerInvoiceHelper.syncQueryInvoiceCount(params);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void syncQueryInvoiceCount(JSONObject params) throws Exception {
        String res = LyServerInvoiceHelper.queryStock(params);
        logger.info(String.format("asyncQueryInvoiceCount res:%s", res));
        MoudleDataDTO moudleDataDTO = (MoudleDataDTO)JSONObject.parseObject((String)res, MoudleDataDTO.class);
        logger.info(String.format("stockData:%s", JSONObject.toJSONString((Object)moudleDataDTO)));
        DynamicObject stock = EquipmentHelper.dealStock((String)params.getString("jqbh"), (MoudleDataDTO)moudleDataDTO);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
        logger.info(String.format("asyncQueryInvoiceCount res:%s", res));
    }

    public static String queryStock(JSONObject params) {
        logger.info(String.format("asyncQueryInvoiceCount params:%s", SerializationUtils.toJsonString((Object)params)));
        String res = HTXXUtil.callIsmcInvoice((JSONObject)params, (String)"LyServerOpenInvoice", (String)"stockAll");
        return res;
    }

    public static MsgResponse invoiceAbolish(DynamicObject invoiceDynamicObject, String canceler, MsgResponse msgResponse) {
        String res;
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("invoicecode", (Object)invoiceDynamicObject.getString("invoicecode"));
            invoiceJson.put("invoiceno", (Object)invoiceDynamicObject.getString("invoiceno"));
            invoiceJson.put("invoicetype", (Object)invoiceDynamicObject.getString("invoicetype"));
            invoiceJson.put("invoiceamount", (Object)invoiceDynamicObject.getBigDecimal("invoiceamount").setScale(2, 4));
            invoiceJson.put("salertaxno", (Object)invoiceDynamicObject.getString("salertaxno"));
            invoiceJson.put("jqbh", (Object)invoiceDynamicObject.getString("jqbh"));
            invoiceJson.put("invalider", (Object)canceler);
            res = UnitTestHelper.isUnitTest() ? ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u4f5c\u5e9f\u53d1\u7968\u6210\u529f", (String)"LyServerInvoiceHelper_0", (String)"imc-sim-common", (Object[])new Object[0]) : HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"LyServerOpenInvoice", (String)"invoice_abolish");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u53d1\u7968\u53f7\u7801\uff1a%s,\u5df2\u5f00\u4f5c\u5e9f\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), invoiceJson.getString("invoiceno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleAbolishResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse redInfoUpload(DynamicObject redInfo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            DynamicObjectUtil.dynamicObject2JsonContainItems((DynamicObject)redInfo, (JSONObject)invoiceJson);
            QFilter allFilter = new QFilter("invoiceno", "=", (Object)redInfo.getString("originalinvoiceno")).and(new QFilter("invoicecode", "=", (Object)redInfo.getString("originalinvoicecode")));
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])allFilter.toArray());
            if (invoice != null) {
                invoiceJson.put("taxedtype", (Object)invoice.getString("taxedtype"));
                invoiceJson.put("issuetime", (Object)invoice.getString("issuetime"));
            }
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u8bf7\u6c42\u53c2\u6570:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), SerializationUtils.toJsonString((Object)invoiceJson)));
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"LyServerOpenInvoice", (String)"redinfo_upload");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleRedInfoSubmitResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse redInfoDownload(JSONObject redInfo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            res = HTXXUtil.callIsmcInvoice((JSONObject)redInfo, (String)"LyServerOpenInvoice", (String)"redinfo_download");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c:%s", redInfo.getString("jqbh"), redInfo.getString("salertaxno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleRedInfoDownloadResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse blankInvoiceAbolish(String taxNo, String invoiceCode, String invoiceType, String invoiceNo, String equipmentNo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("salertaxno", (Object)taxNo);
            invoiceJson.put("jqbh", (Object)equipmentNo);
            invoiceJson.put("invoicecode", (Object)invoiceCode);
            invoiceJson.put("invoicetype", (Object)invoiceType);
            invoiceJson.put("invoiceno", (Object)invoiceNo);
            invoiceJson.put("invalider", (Object)RequestContext.get().getUserName());
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"LyServerOpenInvoice", (String)"blank_invoice_abolish");
            logger.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a%s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%s,\u7ec8\u7aef\u53f7\uff1a%s,\u7a7a\u767d\u4f5c\u5e9f\u8fd4\u56de\u7ed3\u679c:%s", invoiceCode, invoiceNo, equipmentNo, res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7a7a\u767d\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleBlankAbolishResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse getInvoiceStock(String equipmentNo, String terminalNo, String invoiceType, String devNo, String taxNo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("terminalno", (Object)terminalNo);
            invoiceJson.put("jqbh", (Object)equipmentNo);
            invoiceJson.put("invoicetype", (Object)invoiceType);
            invoiceJson.put("salertaxno", (Object)taxNo);
            RequestContext requestContext = RequestContext.get();
            res = UnitTestHelper.isUnitTest() ? "{\"remainder\" : \"99999\", \"invoice_code\" : \"1111111111\", \"invoice_num\" : \"11111111\"}" : HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"LyServerOpenInvoice", (String)"stock");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7ec8\u7aef\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u8bf7\u6c42\u53d1\u7968\u9886\u8d2d\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c:%s", devNo, terminalNo, taxNo, res));
            ThreadPools.executeOnceIncludeRequestContext((String)"saveDeviceStockData", () -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                LyServerInvoiceHelper.asyncQueryInvoiceCount(invoiceJson);
            });
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleInvoiceStockResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse getInvoice(JSONObject invoiceJson) {
        MsgResponse msgResponse = new MsgResponse();
        String response = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"LyServerOpenInvoice", (String)"query_invoice");
        BwServerInvoiceHelper.handleInvoiceStockResponse(response, msgResponse);
        return msgResponse;
    }

    public static JSONObject getInvoiceByOrderNo(DynamicObject invoice) {
        String response;
        JSONObject requestJson = new JSONObject();
        requestJson.put("jqbh", (Object)invoice.getString("jqbh"));
        requestJson.put("invoicetype", (Object)invoice.getString("invoicetype"));
        String orderNo = invoice.getString("thirdserialno");
        if (StringUtils.isBlank((String)orderNo)) {
            orderNo = invoice.getString("orderno");
        }
        requestJson.put("thirdserialno", (Object)orderNo);
        try {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u53d1\u7968\u6d41\u6c34\u53f7\uff1a[%s]\u8bf7\u6c42\u8054\u4e91\u67e5\u8be2\u662f\u5426\u6210\u529f\u5f00\u7968", orderNo));
            }
            response = HTXXUtil.callIsmcInvoice((JSONObject)requestJson, (String)"LyServerOpenInvoice", (String)"query_invoice_detail");
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u53d1\u7968\u6d41\u6c34\u53f7\uff1a[%s]\u8bf7\u6c42\u8054\u4e91\u67e5\u8be2\u662f\u5426\u6210\u529f\u5f00\u7968\u8fd4\u56de\u7ed3\u679c\uff1a[%s]", orderNo, response));
            }
        }
        catch (MsgException msg) {
            logger.error(msg.getErrorMsg(), (Throwable)msg);
            throw new KDBizException(msg.getErrorMsg());
        }
        if (StringUtils.isBlank((String)response)) {
            return new JSONObject();
        }
        JSONObject invoiceJson = JSONObject.parseObject((String)response);
        JSONObject responseJson = new JSONObject();
        responseJson.put("fplsh", (Object)invoice.getString("orderno"));
        responseJson.put("fpdm", (Object)invoiceJson.getString("invoicecode"));
        responseJson.put("fphm", (Object)invoiceJson.getString("invoiceno"));
        return responseJson;
    }

    public static void revokeRedInfo(List<DynamicObject> successObjs, DynamicObject redInfo, OperationResult operationResult) {
        JSONObject queryParams = new JSONObject();
        try {
            queryParams.put("infocode", (Object)redInfo.getString("infocode"));
            queryParams.put("jqbh", (Object)redInfo.getString("jqbh"));
            queryParams.put("invoicetype", (Object)redInfo.getString("invoicetype"));
            HTXXUtil.callIsmcInvoice((JSONObject)queryParams, (String)"LyServerOpenInvoice", (String)"redinfo_revocation");
            RedInfoHelper.revokeRedInfo(redInfo);
            successObjs.add(redInfo);
        }
        catch (MsgException e) {
            logger.error("\u7a0e\u5c40\u64a4\u9500\u5931\u8d25", (Throwable)e);
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u7a0e\u5c40\u64a4\u9500\u5931\u8d25\uff0c%2$s", (String)"LyServerInvoiceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), e.getErrorMsg())));
        }
        catch (Exception e) {
            logger.error("\u7a0e\u5c40\u64a4\u9500\u5931\u8d25", (Throwable)e);
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u7a0e\u5c40\u64a4\u9500\u5931\u8d25\uff0c%2$s", (String)"LyServerInvoiceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), e.getMessage())));
        }
    }
}

