/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.sim.common.constant.table.MatchBillConstant;

public class NegativeBillMatchHelper {
    public DynamicObject[] getMatchBillByTBillId(List<Object> pks) {
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter(pks, (String)"tbillid").toArray());
        return BusinessDataServiceHelper.load((Object[])Arrays.stream(relations).map(relation -> relation.get("sbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
    }

    public DynamicObject[] writeInfoCode2MatchBill(List<DynamicObject> redInfoOrRedConfirms) {
        if (null == redInfoOrRedConfirms || redInfoOrRedConfirms.size() == 0) {
            return new DynamicObject[0];
        }
        boolean isRedconfirm = "sim_red_confirm_bill".equals(redInfoOrRedConfirms.get(0).getDataEntityType().getName());
        List redInfoOrRedConfirmList = redInfoOrRedConfirms.stream().filter(redInfoOrRedConfirm -> {
            if (isRedconfirm) {
                return "10".equals(redInfoOrRedConfirm.getString("source")) || "5".equals(redInfoOrRedConfirm.getString("source"));
            }
            return "10".equals(redInfoOrRedConfirm.getString("infosource"));
        }).collect(Collectors.toList());
        if (redInfoOrRedConfirms.size() == 0) {
            return new DynamicObject[0];
        }
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid", "ssubdetailid"), (QFilter[])OrgHelper.getIdFilter((Collection)redInfoOrRedConfirmList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()), (String)"tbillid").toArray());
        HashMap<Object, Set> tBillId2SBillIdMap = new HashMap<Object, Set>(relations.length);
        HashMap<Object, Set> tBillId2SSubDetailIdMap = new HashMap<Object, Set>(relations.length);
        for (DynamicObject relation2 : relations) {
            Set sBillIdSet = tBillId2SBillIdMap.computeIfAbsent(relation2.get("tbillid"), k -> new HashSet());
            sBillIdSet.add(relation2.get("sbillid"));
            Set sSubDetailIdSet = tBillId2SSubDetailIdMap.computeIfAbsent(relation2.get("tbillid"), k -> new HashSet());
            sSubDetailIdSet.add(relation2.get("ssubdetailid"));
        }
        Map matchBillMap = BusinessDataServiceHelper.loadFromCache((Object[])Arrays.stream(relations).map(relation -> relation.get("sbillid")).toArray(), (String)"sim_match_bill");
        for (DynamicObject redInfoOrRedConfirm2 : redInfoOrRedConfirmList) {
            Set sBillIds = (Set)tBillId2SBillIdMap.get(redInfoOrRedConfirm2.getPkValue());
            if (sBillIds == null) continue;
            HashSet sSubDetailIdSet = (HashSet)tBillId2SSubDetailIdMap.get(redInfoOrRedConfirm2.getPkValue());
            if (sSubDetailIdSet == null) {
                sSubDetailIdSet = new HashSet(1);
            }
            for (Object sBillId : sBillIds) {
                DynamicObject matchBill = (DynamicObject)matchBillMap.get(sBillId);
                if (matchBill == null) continue;
                boolean isManually = "3".equals(matchBill.getString("matchtarget")) || "2".equals(matchBill.getString("matchtarget"));
                DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items2) {
                    DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject oriItem : oriItems) {
                        if (isManually) {
                            oriItem.set("infocode", redInfoOrRedConfirm2.get(isRedconfirm ? "number" : "infocode"));
                            continue;
                        }
                        if (!sSubDetailIdSet.contains(oriItem.getPkValue())) continue;
                        oriItem.set("infocode", redInfoOrRedConfirm2.get(isRedconfirm ? "number" : "infocode"));
                    }
                }
            }
        }
        ImcSaveServiceHelper.save((DynamicObject[])matchBillMap.values().toArray(new DynamicObject[0]));
        return matchBillMap.values().toArray(new DynamicObject[0]);
    }

    public static void changePushStatus(DynamicObject matchBill) {
        BigDecimal pushAmount = BigDecimal.ZERO;
        BigDecimal pushTax = BigDecimal.ZERO;
        BigDecimal matchAmount = BigDecimal.ZERO;
        BigDecimal matchTax = BigDecimal.ZERO;
        HashSet<String> pushInvoiceNum = new HashSet<String>(16);
        HashSet<String> matchInvoiceNum = new HashSet<String>(16);
        HashSet<String> statusSet = new HashSet<String>(2);
        boolean isConfirm = "1".equals(matchBill.getString("matchtarget")) || "2".equals(matchBill.getString("matchtarget"));
        DynamicObjectCollection items2 = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items2) {
            if (!MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(item.getString("itemmatchstatus")) && !MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(item.getString("itemmatchstatus"))) continue;
            if (isConfirm) {
                DynamicObjectCollection confirmEntities = item.getDynamicObjectCollection("confirmsubentryentity");
                for (DynamicObject confirmEntity : confirmEntities) {
                    pushTax = pushTax.add(confirmEntity.getBigDecimal("confirmoriitemtax").abs());
                    pushAmount = pushAmount.add(confirmEntity.getBigDecimal("confirmoriitemamount").abs());
                    pushInvoiceNum.add(confirmEntity.getString("confirminfocode"));
                }
                continue;
            }
            DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
            for (DynamicObject oriItem : oriItems) {
                statusSet.add(oriItem.getString("pushstatus"));
                if ("1".equals(oriItem.getString("pushstatus"))) {
                    pushTax = pushTax.add(oriItem.getBigDecimal("oriitemtax"));
                    pushAmount = pushAmount.add(oriItem.getBigDecimal("oriitemamount"));
                    pushInvoiceNum.add(oriItem.getString("oriinvoiceid"));
                }
                matchAmount = matchAmount.add(oriItem.getBigDecimal("oriitemamount"));
                matchTax = matchTax.add(oriItem.getBigDecimal("oriitemtax"));
                matchInvoiceNum.add(oriItem.getString("oriinvoiceid"));
            }
        }
        if (isConfirm) {
            matchBill.set("pushdownstatus", null);
            matchBill.set("pushdowninvoicenum", (Object)BigDecimal.ZERO);
            matchBill.set("pushdownamount", (Object)BigDecimal.ZERO);
            matchBill.set("pushdowntax", (Object)BigDecimal.ZERO);
            matchBill.set("pushdownstatus", null);
        } else {
            matchBill.set("pushdowninvoicenum", (Object)pushInvoiceNum.size());
            matchBill.set("pushdownamount", (Object)pushAmount.negate());
            matchBill.set("pushdowntax", (Object)pushTax.negate());
            matchBill.set("matchamount", (Object)matchAmount.negate());
            matchBill.set("matchtax", (Object)matchTax.negate());
            matchBill.set("matchtotalamount", (Object)matchAmount.negate().add(matchTax.negate()));
            matchBill.set("matchinvoicenum", (Object)matchInvoiceNum.size());
            if (statusSet.isEmpty()) {
                matchBill.set("pushdownstatus", (Object)"0");
            } else if (statusSet.size() != 1) {
                matchBill.set("pushdownstatus", (Object)"1");
            } else {
                String status = (String)statusSet.toArray()[0];
                status = "1".equals(status) ? "2" : "0";
                matchBill.set("pushdownstatus", (Object)status);
            }
        }
    }
}

