/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.CallbackRequestVo;
import kd.imc.bdm.common.helper.EasBusinessHelper;
import kd.imc.bdm.common.helper.FiInvoiceCallbackHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.SimCommonConstant;
import kd.imc.sim.common.helper.BillRollbackHelper;
import kd.imc.sim.common.vo.openapi.BillWithDrawVo;

public class OriginalBillWithdrawHelper {
    private static final Log LOGGER = LogFactory.getLog(OriginalBillWithdrawHelper.class);

    public static void notice2BusSys(AbstractListPlugin listPlugin) {
        ListSelectedRowCollection rows = ((IListView)listPlugin.getView()).getSelectedRows();
        DynamicObject[] selOriBillList = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "confirmstate", "billsource", "systemsource", "salertaxno", "id", "billno", "orgid"), (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray());
        selOriBillList = Arrays.stream(selOriBillList).filter(l -> "0".equals(l.getString("confirmstate")) && ("2".equals(l.getString("billsource")) || "3".equals(l.getString("billsource")) || "8".equals(l.getString("billsource")))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5355\u636e\u56de\u64a4\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7684\u6570\u636e\u662f\uff1a%s", SerializationUtils.toJsonString((Object)selOriBillList)));
        }
        if (selOriBillList.length == 0) {
            return;
        }
        Map<String, List<DynamicObject>> groupMap = Arrays.stream(selOriBillList).collect(Collectors.groupingBy(bill -> bill.getString("systemsource")));
        try (TXHandle tx = TX.required();){
            try {
                Set<Map.Entry<String, List<DynamicObject>>> entries = groupMap.entrySet();
                for (Map.Entry<String, List<DynamicObject>> entry : entries) {
                    String systemSource = entry.getKey();
                    if (StringUtils.isBlank((CharSequence)systemSource)) continue;
                    List<DynamicObject> bills = entry.getValue();
                    for (DynamicObject bill2 : bills) {
                        String issueCacheKey = CacheHelper.get((String)(DynamicObjectUtil.getDynamicObjectLongValue((Object)bill2.get("orgid")) + "!!!" + bill2.getString("billno")));
                        String processCacheKey = CacheHelper.get((String)(bill2.getPkValue() + "workbench"));
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)issueCacheKey) && !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)processCacheKey)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f00\u7968\u7533\u8bf7\u5355\u6b63\u5728\u5f00\u7968\u5904\u7406\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\uff01", (String)"OriginalBillWithdrawHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
                    }
                    if (CallbackHelperUtil.isFromArIssueBill((String)systemSource)) {
                        OriginalBillWithdrawHelper.notice2Fi(bills);
                        continue;
                    }
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(bills.size());
                    ArrayList<DynamicObject> botpList = new ArrayList<DynamicObject>(bills.size());
                    for (DynamicObject bill3 : bills) {
                        if ("3".equals(bill3.getString("billsource")) || "8".equals(bill3.getString("billsource"))) {
                            botpList.add(bill3);
                            continue;
                        }
                        list.add(bill3);
                    }
                    if (!CollectionUtils.isEmpty(botpList)) {
                        OriginalBillWithdrawHelper.dealBillWriteToBillCenter(botpList);
                        OriginalBillWithdrawHelper.deleteBotpBill(botpList);
                    }
                    if (CollectionUtils.isEmpty(list)) continue;
                    OriginalBillWithdrawHelper.notice2Sys(list, systemSource);
                }
                BillRollbackHelper.saveAppLog((AbstractFormPlugin)listPlugin, Arrays.asList(selOriBillList), "sim_original_bill");
                listPlugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u56de\u64a4\u6210\u529f", (String)"OriginalBillWithdrawHelper_0", (String)"imc-sim-common", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error(String.format("\u5f00\u7968\u7533\u8bf7\u5355\u56de\u64a4\u5f02\u5e38\uff1a%s", e.getMessage()), (Throwable)e);
                listPlugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u56de\u64a4\u5f02\u5e38\uff1a%s", (String)"OriginalBillWithdrawHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), e.getMessage()), SimCommonConstant.SHOW_TIME);
            }
        }
        BillList list = (BillList)listPlugin.getView().getControl("billlistap");
        list.clearSelection();
        list.refresh();
    }

    private static void dealBillWriteToBillCenter(List<DynamicObject> botpList) {
        ArrayList<Long> originalIdList = new ArrayList<Long>(botpList.size());
        for (DynamicObject originalBill : botpList) {
            String systemSource = originalBill.getString("systemsource");
            if (!"BILL_CENTER".equals(systemSource)) continue;
            originalIdList.add(originalBill.getLong("id"));
        }
        if (!originalIdList.isEmpty()) {
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"dealUnLockBillMethod", (Object[])new Object[]{originalIdList});
            LOGGER.info("dealBillWriteToBillCenter\u6267\u884c\u6210\u529f\uff01");
        }
    }

    private static void notice2Fi(List<DynamicObject> objList) throws IOException {
        JSONObject rObj;
        String resultStr;
        ArrayList<JSONObject> noticeBillNos = new ArrayList<JSONObject>(objList.size());
        Object[] ids = new Object[objList.size()];
        for (int i = 0; i < objList.size(); ++i) {
            ids[i] = objList.get(i).getLong("id");
            JSONObject jObj = new JSONObject();
            jObj.put("billNo", (Object)objList.get(i).getString("billno"));
            jObj.put("interfaceCode", (Object)"BILL_WITH_DRAW");
            noticeBillNos.add(jObj);
        }
        if (FiInvoiceCallbackHelper.arBizServiceExist()) {
            String noticeBillNoStr = JSONObject.toJSONString(noticeBillNos);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u8c03\u7528\u5e94\u6536\u5fae\u670d\u52a1\u8bf7\u6c42\u53c2\u6570 : [%s]", noticeBillNoStr));
            }
            resultStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"IssueInvoiceService", (String)"issueInvoice", (Object[])new Object[]{noticeBillNoStr});
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u8c03\u7528\u5e94\u6536\u5fae\u670d\u52a1\u8fd4\u56de : [%s]", resultStr));
            }
        } else {
            String taxNo = objList.get(0).getString("salertaxno");
            taxNo = StringUtils.isBlank((CharSequence)taxNo) ? "" : taxNo;
            DynamicObject invsmCallbackObj = FiInvoiceCallbackHelper.getFiCallbackConfig((String)taxNo);
            if (null == invsmCallbackObj) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5e94\u6536\u4e1a\u52a1\u7cfb\u7edf\u539f\u59cb\u5355\u636e\u56de\u64a4\u901a\u77e5\u5730\u5740", (String)"OriginalBillWithdrawHelper_2", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            Map rMap = FiInvoiceCallbackHelper.getAccessToken((DynamicObject)invsmCallbackObj);
            if (StringUtils.isNotBlank(rMap.get("msg"))) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u5355\u636e\u56de\u64a4\u8c03\u7528\u5e94\u6536\u4e1a\u52a1\u7cfb\u7edf\u83b7\u53d6AccessToken\u53d1\u751f\u5f02\u5e38\uff1a%s", rMap.get("msg")));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u56de\u64a4\u8c03\u7528\u5e94\u6536\u4e1a\u52a1\u7cfb\u7edf\u83b7\u53d6AccessToken\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"OriginalBillWithdrawHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), rMap.get("msg")));
            }
            String noticeUrl = invsmCallbackObj.getString("issue").concat("?access_token=").concat(String.valueOf(rMap.get("accessToken")));
            JSONObject noticeData = new JSONObject();
            noticeData.put("datas", noticeBillNos);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5355\u636e\u56de\u64a4\u901a\u77e5\u5e94\u6536\u4e1a\u52a1\u7cfb\u7edf\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s", noticeData.toJSONString()));
            }
            resultStr = HttpUtil.doPostJson((String)noticeUrl, null, null, (String)noticeData.toJSONString());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5355\u636e\u56de\u64a4\u901a\u77e5\u5e94\u6536\u4e1a\u52a1\u7cfb\u7edf\u8fd4\u56de\u62a5\u6587\u662f\uff1a%s", resultStr));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)resultStr) && (rObj = JSON.parseObject((String)resultStr)).containsKey((Object)"success") && Boolean.TRUE.equals(rObj.get((Object)"success"))) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"sim_original_bill", (Object[])ids, null);
        }
    }

    private static void notice2Sys(List<DynamicObject> bills, String systemSource) {
        CallbackRequestVo request = OriginalBillWithdrawHelper.buildWithdrawRequest(bills, systemSource);
        try {
            String result = "";
            DynamicObject easCallBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_callback_config"), (QFilter[])new QFilter("business_system_code", "=", (Object)systemSource).toArray());
            if (easCallBackConfig != null) {
                result = OriginalBillWithdrawHelper.getPostResult(easCallBackConfig, request, systemSource);
            } else {
                DynamicObject busSystemObj = CallbackHelperUtil.getBusinessSystemByCode((String)systemSource);
                if (null == busSystemObj) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7cfb\u7edf\u56de\u8c03\u914d\u7f6e", (String)"OriginalBillWithdrawHelper_4", (String)"imc-sim-common", (Object[])new Object[0]));
                }
                String billNo = bills.get(0).getString("billno");
                String callbackUrl = busSystemObj.getString("callback_url");
                if (StringUtils.isBlank((CharSequence)callbackUrl)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u3010%s\u3011\u56de\u63a8\u4e1a\u52a1\u7cfb\u7edf\u5730\u5740\u4e0d\u5b58\u5728", (String)"OriginalBillWithdrawHelper_5", (String)"imc-sim-common", (Object[])new Object[0]), billNo));
                }
                LOGGER.info("\u5355\u636e\u56de\u64a4Api request url  " + callbackUrl);
                if (!callbackUrl.startsWith("https:") && !callbackUrl.startsWith("http:")) {
                    String[] configs = callbackUrl.split(",");
                    if (configs.length >= 4) {
                        HashMap<String, String> requestDataMap = new HashMap<String, String>(4);
                        requestDataMap.put("interfaceCode", request.getInterfaceCode());
                        requestDataMap.put("data", request.getData());
                        Object resultObj = DispatchServiceHelper.invokeService((String)configs[0], (String)configs[1], (String)configs[2], (String)configs[3], (Object[])new Object[]{requestDataMap});
                        result = resultObj instanceof String ? (String)resultObj : SerializationUtils.toJsonString((Object)resultObj);
                    }
                } else {
                    result = HttpUtil.doPostJson((String)callbackUrl, null, null, (String)JSON.toJSONString((Object)request));
                }
                LOGGER.info("\u5355\u636e\u56de\u64a4Api response " + result);
            }
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u56de\u9000\u4e0a\u6e38\u5355\u636e\u5931\u8d25 : \u8bf7\u6c42\u56de\u64a4\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"OriginalBillWithdrawHelper_6", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (easCallBackConfig != null) {
                if (!ApiErrCodeEnum.OK.getCode().equals(jsonObject.getString("errCode"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u4e0a\u6e38\u5355\u636e\u5931\u8d25 %s", (String)"OriginalBillWithdrawHelper_7", (String)"imc-sim-common", (Object[])new Object[0]), jsonObject.getString("description")));
                }
                EasBusinessHelper.handleEasResponse((JSONObject)jsonObject);
            }
            if (!jsonObject.containsKey((Object)"code") && !jsonObject.containsKey((Object)"errorCode")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u56de\u9000\u4e0a\u6e38\u5355\u636e\u5931\u8d25 : \u5bf9\u63a5\u65b9\u672a\u6309\u56de\u8c03\u63a5\u53e3\u6587\u6863\u8fd4\u56de\u6570\u636e", (String)"OriginalBillWithdrawHelper_8", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!ApiErrCodeEnum.OK.getCode().equals(jsonObject.getString("code")) && !"0".equals(jsonObject.getString("errorCode"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u4e0a\u6e38\u5355\u636e\u5931\u8d25 %s", (String)"OriginalBillWithdrawHelper_7", (String)"imc-sim-common", (Object[])new Object[0]), jsonObject.getString("message")));
            }
            OperationServiceHelper.executeOperate((String)"delete", (String)"sim_original_bill", (Object[])bills.stream().map(bill -> bill.getLong("id")).toArray(), null);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u901a\u77e5\u5355\u636e\u56de\u64a4\u53d1\u751f\u5f02\u5e38\uff1a%s", e));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u9000\u4e0a\u6e38\u5355\u636e\u5931\u8d25 %s", (String)"OriginalBillWithdrawHelper_7", (String)"imc-sim-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static CallbackRequestVo buildWithdrawRequest(List<DynamicObject> bills, String systemSource) {
        ArrayList<String> billNos = new ArrayList<String>(bills.size());
        ArrayList<String> sellerTaxpayerId = new ArrayList<String>(bills.size());
        bills.forEach(bill -> {
            billNos.add(bill.getString("billno"));
            sellerTaxpayerId.add(bill.getString("salertaxno"));
        });
        BillWithDrawVo vo = new BillWithDrawVo();
        vo.setBackPerson(RequestContext.get().getUserName());
        vo.setBackTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        vo.setBusinessSystemCode(systemSource);
        vo.setBillNo(billNos);
        vo.setSellerTaxpayerId(sellerTaxpayerId);
        CallbackRequestVo request = new CallbackRequestVo();
        request.setData(JSON.toJSONString((Object)vo));
        request.setInterfaceCode(OpenApiInterfaceCodeEnum.BILL_WITHDRAW.getCode());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5355\u636e\u56de\u64a4Api request data  " + JSON.toJSONString((Object)request));
        }
        return request;
    }

    private static String getPostResult(DynamicObject callBackConfig, CallbackRequestVo requestVo, String systemSource) {
        CallbackHelperUtil.checkInvsmCallBackConfig((DynamicObject)callBackConfig);
        return CallbackHelperUtil.postEas((DynamicObject)callBackConfig, (String)EasBusinessHelper.getEasRequestData((String)requestVo.getData(), (String)requestVo.getInterfaceCode()), (String)systemSource);
    }

    private static void deleteBotpBill(List<DynamicObject> bills) {
        OperationResult status;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5355\u636e\u56de\u64a4\u5220\u9664BOTP\u4e0b\u63a8\u7684\u5355\u636e\u7f16\u53f7\u662f\uff1a%s", bills.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))));
        }
        if ((status = OperationServiceHelper.executeOperate((String)"delete", (String)"sim_original_bill", (Object[])bills.stream().map(DataEntityBase::getPkValue).toArray(), null)) != null) {
            if (!status.isSuccess()) {
                throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)status));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u64a4\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff01", (String)"OriginalBillWithdrawHelper_9", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }
}

