/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.MoudleDataDTO;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.vo.openapi.InvoiceStockVo;

public class QueryStockHelper {
    private static Log LOGGER = LogFactory.getLog(QueryStockHelper.class);

    public static void refreshStock(DynamicObject stock) throws Exception {
        block13: {
            String equipType = stock.getString("equipmenttype");
            String equipNo = stock.getString("equipmentno");
            String taxNo = stock.getString("taxno");
            String lockKey = "QueryStockHelperRefreshStock" + equipNo;
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock(1000L)) {
                    DynamicObject equipment = QueryStockHelper.getEquipment(stock);
                    QueryStockHelper.refreshStock(stock, equipType, equipNo, taxNo, equipment);
                    break block13;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52ff\u9891\u7e41\u5237\u65b0", (String)"QueryStockHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
    }

    private static void refreshStock(DynamicObject stock, String equipType, String equipNo, String taxNo, DynamicObject equipment) throws Exception {
        int paperSpecialCount = 0;
        int eleNormalCount = 0;
        int eleSpecialCount = 0;
        int paperNomalCount = 0;
        switch (equipType) {
            case "10": 
            case "9": 
            case "11": {
                JSONObject json = new JSONObject();
                json.put("terminalno", (Object)equipment.getString("terminalno"));
                json.put("jqbh", (Object)equipNo);
                json.put("salertaxno", (Object)equipment.getDynamicObject("epinfo").getString("number"));
                LyServerInvoiceHelper.syncQueryInvoiceCount(json);
                break;
            }
            case "2": 
            case "1": 
            case "0": {
                String remoteUrl = ComponentServiceHelper.getComponentUrl((String)equipNo);
                boolean isSuccess = EquipmentHelper.saveDeviceStockDataWithoutCache((String)remoteUrl, (String)equipNo);
                if (isSuccess) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5e93\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"QueryStockHelper_1", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            case "8": {
                String terminalNo = equipment.getString("terminalno");
                String invoiceType = InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
                paperNomalCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, invoiceType, equipNo, taxNo);
                paperSpecialCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), equipNo, taxNo);
                eleNormalCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), equipNo, taxNo);
                eleSpecialCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), equipNo, taxNo);
                QueryStockHelper.updateStock(stock, paperSpecialCount, eleNormalCount, eleSpecialCount, paperNomalCount);
                break;
            }
            case "4": 
            case "6": 
            case "7": {
                try {
                    paperNomalCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), equipNo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    paperSpecialCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), equipNo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    eleNormalCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), equipNo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    eleSpecialCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), equipNo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QueryStockHelper.updateStock(stock, paperSpecialCount, eleNormalCount, eleSpecialCount, paperNomalCount);
            }
        }
    }

    public static InvoiceStockVo queryStock(String equipType, String equipNo, String taxNo, String terminalNo) {
        InvoiceStockVo stock = null;
        try {
            switch (equipType) {
                case "10": 
                case "9": 
                case "11": {
                    JSONObject json = new JSONObject();
                    json.put("jqbh", (Object)equipNo);
                    json.put("salertaxno", (Object)taxNo);
                    String result = LyServerInvoiceHelper.queryStock(json);
                    if (!StringUtils.isNotBlank((CharSequence)result)) break;
                    stock = new InvoiceStockVo();
                    stock.setSuccess(Boolean.TRUE);
                    MoudleDataDTO moudleDataDTO = (MoudleDataDTO)JSONObject.parseObject((String)result, MoudleDataDTO.class);
                    stock.setInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getPtfpsyfs()));
                    stock.setSpecialInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getZyfpsyfs()));
                    stock.seteInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getDjdpfpsyfs()));
                    stock.seteSpecialInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getDjdpzyfpsyfs()));
                    break;
                }
                case "2": 
                case "1": 
                case "0": {
                    String remoteUrl = ComponentServiceHelper.getComponentUrl((String)equipNo);
                    MoudleDataDTO moudleDataDTO = EquipmentHelper.queryEquipemntDataWithoutCache((String)remoteUrl);
                    stock = new InvoiceStockVo();
                    if (ErrorType.FAIL.getCode().equals(moudleDataDTO.getErrcode())) {
                        stock.setSuccess(Boolean.FALSE);
                        stock.setErrorMsg(moudleDataDTO.getDescription());
                        break;
                    }
                    stock.setSuccess(Boolean.TRUE);
                    stock.setInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getPtfpsyfs()));
                    stock.setSpecialInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getZyfpsyfs()));
                    stock.seteInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getDjdpfpsyfs()));
                    stock.seteSpecialInvoiceStock(QueryStockHelper.getStrIntValue(moudleDataDTO.getDjdpzyfpsyfs()));
                    break;
                }
                case "8": {
                    String invoiceType = InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
                    int paperNomalCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, invoiceType, equipNo, taxNo);
                    int paperSpecialCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), equipNo, taxNo);
                    int eleNormalCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), equipNo, taxNo);
                    int eleSpecialCount = BwServerInvoiceHelper.getStockIntValue(equipNo, terminalNo, InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), equipNo, taxNo);
                    stock = new InvoiceStockVo();
                    stock.setSuccess(Boolean.TRUE);
                    stock.setInvoiceStock(paperNomalCount);
                    stock.seteInvoiceStock(eleNormalCount);
                    stock.seteSpecialInvoiceStock(eleSpecialCount);
                    stock.setSpecialInvoiceStock(paperSpecialCount);
                    break;
                }
                case "4": 
                case "6": 
                case "7": {
                    int paperNomalCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), equipNo);
                    int paperSpecialCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), equipNo);
                    int eleNormalCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), equipNo);
                    int eleSpecialCount = HostModeInvoiceHelper.getStockIntValue(taxNo, InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), equipNo);
                    stock = new InvoiceStockVo();
                    stock.setSuccess(Boolean.TRUE);
                    stock.setInvoiceStock(paperNomalCount);
                    stock.seteInvoiceStock(eleNormalCount);
                    stock.seteSpecialInvoiceStock(eleSpecialCount);
                    stock.setSpecialInvoiceStock(paperSpecialCount);
                }
            }
        }
        catch (MsgException e) {
            if (null == stock) {
                stock = new InvoiceStockVo();
                stock.setSuccess(Boolean.FALSE);
                stock.setErrorMsg(e.getErrorMsg());
            }
        }
        catch (Exception e) {
            LOGGER.error("QueryStockHelperQueryStock" + e.getMessage(), (Throwable)e);
        }
        if (null == stock) {
            stock = new InvoiceStockVo();
            stock.setSuccess(Boolean.FALSE);
            stock.setErrorMsg(ErrorType.QUERY_STOCK_FAIL.getName());
        }
        return stock;
    }

    private static int getStrIntValue(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return 0;
        }
        return Integer.parseInt(num);
    }

    private static void updateStock(DynamicObject stock, int paperSpecialCount, int eleNormalCount, int eleSpecialCount, int paperNomalCount) {
        stock.set("invoicestock", (Object)paperNomalCount);
        stock.set("specialinvoicestock", (Object)paperSpecialCount);
        stock.set("einvoicestock", (Object)eleNormalCount);
        stock.set("especialinvoicestock", (Object)eleSpecialCount);
        stock.set("modifytime", (Object)new Date());
        stock.set("modifier", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{stock});
    }

    private static DynamicObject getEquipment(DynamicObject stock) {
        String equipNo = stock.getString("equipmentno");
        String taxNo = stock.getString("taxno");
        String equipType = stock.getString("equipmenttype");
        QFilter filter = new QFilter("equipmentno", "=", (Object)equipNo).and("equipmenttype", "=", (Object)equipType).and("epinfo.number", "=", (Object)taxNo);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_tax_equipment", (boolean)true), (QFilter[])filter.toArray());
        if (array.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\uff1a%s\u5728\u8bbe\u5907\u5217\u8868\u4e0d\u5b58\u5728", (String)"QueryStockHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), equipNo));
        }
        return array[0];
    }
}

