/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.goodsinfo;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.InvItemConfigHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class GoodsInfoEditHelp {
    private static final Log LOGGER = LogFactory.getLog(GoodsInfoEditHelp.class);

    public static void saveGoodsInfoBySetting(DynamicObject invObj) {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invObj.get("orgid"));
        DynamicObjectCollection items2 = invObj.getDynamicObjectCollection("items");
        for (DynamicObject item : items2) {
            if ("1".equals(item.getString("rowtype"))) continue;
            String goodsCode = item.getString("goodscode");
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)goodsCode);
            if (taxClassCode == null) {
                LOGGER.info("\u7a0e\u63a7\u670d\u52a1\u4e91\u4e0d\u5b58\u5728\u8be5\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
                continue;
            }
            String goodsName = item.getString("goodsname");
            goodsName = goodsName.replaceAll("^\\*[A-Za-z0-9\u3001\\u4E00-\\u9FA5]+\\*", "");
            String unit = item.getString("unit");
            String specification = item.getString("specification");
            String taxRate = item.getString("taxrate");
            QFilter filter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId).and("name", "=", (Object)goodsName).and("taxrate", "=", (Object)taxRate).and("specifications", "=", (Object)specification).and("unit", "=", (Object)unit).and("taxcode", "=", taxClassCode.getPkValue());
            if (QueryServiceHelper.exists((String)"bdm_goods_info", (QFilter[])filter.toArray())) continue;
            DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            org.set("id", (Object)orgId);
            DynamicObject goodsInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_goods_info");
            goodsInfo.set("taxcode", (Object)taxClassCode);
            goodsInfo.set("unit", (Object)unit);
            goodsInfo.set("specifications", (Object)specification);
            goodsInfo.set("taxrate", (Object)taxRate);
            goodsInfo.set("org", (Object)org);
            goodsInfo.set("useorg", (Object)org);
            goodsInfo.set("number", (Object)("ATS" + GoodsInfoConstant.getID()));
            goodsInfo.set("privilegeflag", (Object)item.getString("taxpremark"));
            goodsInfo.set("privilegetype", (Object)item.getString("zzstsgl"));
            goodsInfo.set("priority", (Object)"1");
            goodsInfo.set("isinclusive", (Object)"1");
            goodsInfo.set("enable", (Object)"1");
            goodsInfo.set("name", (Object)goodsName);
            goodsInfo.set("creator", (Object)RequestContext.get().getUserId());
            goodsInfo.set("createorg", (Object)org);
            goodsInfo.set("ctrlstrategy", (Object)"7");
            goodsInfo.set("status", (Object)"C");
            goodsInfo.set("group", (Object)1);
            goodsInfo.set("share", (Object)"2");
            OperationServiceHelper.executeOperate((String)"save", (String)"bdm_goods_info", (DynamicObject[])new DynamicObject[]{goodsInfo}, null);
        }
    }

    public static void dealGoodsInfoBySetting(DynamicObject invObj) {
        String invDataSource;
        long org = DynamicObjectUtil.getDynamicObjectLongValue((Object)invObj.get("orgid"));
        Map invItemConfig = InvItemConfigHelper.getInvItemConfig((Long)org);
        if (null != invItemConfig && Boolean.parseBoolean(String.valueOf(invItemConfig.get("savefrombill"))) && "4".equals(invDataSource = invObj.getString("buyertype"))) {
            GoodsInfoEditHelp.saveGoodsInfoBySetting(invObj);
        }
    }
}

