/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MqPublishUtils;
import kd.imc.sim.common.dto.RedConfirmBillHandleRequest;

public class IssueInvoiceMqHelper {
    private static final Log LOGGER = LogFactory.getLog(IssueInvoiceMqHelper.class);
    public static final String submitMqField = String.join((CharSequence)",", "salertaxno", "jqbh", "orderno", "issuestatus", "result", "issuesource", "id", "invoiceamount", "orgid", "invoicetype");

    public static String getIssueInvoiceLockKey(String saleTaxNo, String devno) {
        return saleTaxNo + "_" + devno;
    }

    public static void submitInvoice2MQ(DynamicObject[] vatInvoiceList) {
        HashMap<String, List> batchDynamicObjectMap = new HashMap<String, List>(16);
        for (DynamicObject invoice : vatInvoiceList) {
            invoice.set("issuestatus", (Object)IssueStatusEnum.submit.getCode());
            invoice.set("result", (Object)"");
            String lockKey2 = IssueInvoiceMqHelper.getIssueInvoiceLockKey(invoice.getString("salertaxno"), invoice.getString("jqbh"));
            List list2 = batchDynamicObjectMap.computeIfAbsent(lockKey2, k -> new ArrayList());
            list2.add(invoice);
            if (!"4".equals(invoice.getString("issuesource"))) continue;
            CacheHelper.put((String)("choose_terminalno" + invoice.getString("orderno")), (String)RequestContext.get().getUserId(), (int)86400);
        }
        ImcSaveServiceHelper.update((DynamicObject[])vatInvoiceList);
        LOGGER.info("submitInvoice2MQ_length" + vatInvoiceList.length);
        batchDynamicObjectMap.forEach((lockKey, list) -> MqPublishUtils.publish((String)"imc", (String)"imc.sim.sim_queue", list.stream().map(obj -> obj.getString("orderno")).collect(Collectors.toList())));
    }

    public static void submitVehicleInvoice2MQ(DynamicObject[] vehicleInvoice) {
        Map<String, List<DynamicObject>> batchDynamicObjectMap = InvoiceUtils.isAllEVehicleInv((String)vehicleInvoice[0].getString("invoicetype")) ? Stream.of(vehicleInvoice).collect(Collectors.groupingBy(k -> IssueInvoiceMqHelper.getIssueInvoiceLockKey(k.getString("salertaxno"), k.getString("account")))) : Stream.of(vehicleInvoice).collect(Collectors.groupingBy(k -> IssueInvoiceMqHelper.getIssueInvoiceLockKey(k.getString("salertaxno"), k.getString("jqbh"))));
        batchDynamicObjectMap.forEach((lockKey, list) -> MqPublishUtils.publish((String)"imc", (String)"imc.sim.sim_queue", list.stream().map(obj -> obj.getString("orderno")).collect(Collectors.toList())));
    }

    public static void submitRedConfirm2MQ(RedConfirmBillHandleRequest request) {
        Object[] pks;
        for (Object pk : pks = request.getPks()) {
            if (!StringUtils.isBlank((CharSequence)CacheHelper.get((String)(pk + request.getOpKey() + "submitCache")))) continue;
            request.setPks(new Object[]{pk});
            MqPublishUtils.publish((String)"imc", (String)"imc.sim.sync_aws_queue", (Object)SerializationUtils.toJsonString((Object)request));
            CacheHelper.put((String)(pk + request.getOpKey() + "submitCache"), (String)"1", (int)3600);
        }
    }
}

