/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.RedInfoAndConfirmBillWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.SourceBillWriteBackHelper;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractIssueInvoiceWriteBackHelper {
    protected static final String writeback_fields = String.join((CharSequence)",", "orgid", "validstate", "confirmstate", "invoicetype", "closestatus", "billproperties", "billno", "hsbz", "systemsource", "billstatus", "billsourcetype", "fromcurr", "infocode", "invoicecode", "invoiceno", "issuetime", "invoicestatus", "invoicedamount", "invoicedtax", "invoicedtotalamount", "totaltax", "totalamount", "invoiceamount", "confirmamount", "maintaxdeviation", "foreignissuedamount", "foreignissuedtax", "foreignissuedtotalamount", "mainissuedamount", "mainissuedtax", "surplusamount", "surplustax", "sim_original_bill_item.seq", "remainvalidamount", "remainvalidtax", "remainvalidnum", "goodsname", "taxamount", "amount", "tax", "num", "issuedamount", "issuedtax", "issuedtotaltaxamount", "issuednum", "oriissuednum", "orinum", "modelnumrate", "rowtype", "taxdeviation", "amountdeviation", "numdeviation", "gift", "zeropushflag", "fromissuedamount", "fromissuedtax", "fromissuedtaxamount", "fromamount", "fromtax", "fromtaxamount", "fromtaxdeviation", "combinelocalamount", "combineamount", "combinenum", "iselepaper", "comprehensivestatus");
    private static final Log LOG = LogFactory.getLog(AbstractIssueInvoiceWriteBackHelper.class);

    static boolean isNoWriteBack(boolean isCancel, boolean isRedPush, DynamicObject invoice) {
        return isCancel && AbstractIssueInvoiceWriteBackHelper.getNoWriteBackSourceList(true).contains(invoice.getString("systemsource")) || isRedPush && AbstractIssueInvoiceWriteBackHelper.getNoWriteBackSourceList(false).contains(invoice.getString("systemsource"));
    }

    private static List<String> getNoWriteBackSourceList(boolean isCancel) {
        String value = ImcConfigUtil.getValue((CacheKeyEnum)(isCancel ? CacheKeyEnum.SIM_WRITEBACK_CONFIG_CANCEL : CacheKeyEnum.SIM_WRITEBACK_CONFIG_REDPUSH));
        ArrayList<String> sourceList = new ArrayList<String>(10);
        sourceList.add("YNZY_TOBACCO");
        sourceList.add("KINGDEE_FI");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            sourceList.addAll(Arrays.asList(value.split(",")));
        }
        return sourceList;
    }

    static boolean isNegativeSpecialInvoice(DynamicObject invoice) {
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) {
            return false;
        }
        String invoiceType = invoice.getString("invoicetype");
        return InvoiceUtils.isSpecialInvoice((String)invoiceType) || InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"));
    }

    static DynamicObject getInvalidBill(DynamicObject invoice) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode")).and("invoiceno", "=", (Object)invoice.getString("invoiceno")).and("billsourcetype", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)String.join((CharSequence)",", "validstate", "confirmstate", "billstatus", "billsourcetype"), (QFilter[])qFilter.toArray());
    }

    static DynamicObject[] loadOriginalBill(Object[] pkList, String selectFields) {
        ArrayList<Long> list = new ArrayList<Long>(pkList.length);
        for (Object obj : pkList) {
            list.add(BigDecimalUtil.transDecimal((Object)obj).longValue());
        }
        return AbstractIssueInvoiceWriteBackHelper.loadOriginalBill(list, selectFields);
    }

    public static DynamicObject[] loadOriginalBill(List<Long> pkList, String selectFields) {
        String tEntityKey;
        DynamicObject[] collect = AbstractIssueInvoiceWriteBackHelper.loadBill(pkList, selectFields);
        HashSet<Long> set = new HashSet<Long>(pkList);
        if ((collect == null || collect.length < set.size()) && StringUtils.isNotEmpty((CharSequence)(tEntityKey = BillArchiveHelper.getArchiveEnetity((String)"sim_original_bill")))) {
            DynamicObject[] collect2;
            int count;
            ArrayList<Long> copyList = new ArrayList<Long>(pkList);
            if (collect != null) {
                for (DynamicObject obj : collect) {
                    copyList.remove(obj.getLong("id"));
                }
            }
            if (!copyList.isEmpty() && (count = BillArchiveHelper.revoke((String)"sim_original_bill", (String)tEntityKey, copyList)) > 0 && (collect2 = AbstractIssueInvoiceWriteBackHelper.loadBill(pkList, selectFields)).length > 0) {
                if (collect == null || collect.length == 0) {
                    return collect2;
                }
                DynamicObject[] mergedArray = new DynamicObject[collect.length + collect2.length];
                System.arraycopy(collect, 0, mergedArray, 0, collect.length);
                System.arraycopy(collect2, 0, mergedArray, collect.length, collect2.length);
                return mergedArray;
            }
        }
        return collect;
    }

    private static DynamicObject[] loadBill(List<Long> pkList, String selectFields) {
        DynamicObject[] collect = StringUtils.isEmpty((CharSequence)selectFields) ? BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill")) : BusinessDataServiceHelper.load((String)"sim_original_bill", (String)selectFields, (QFilter[])OrgHelper.getIdFilter(pkList).toArray());
        return collect;
    }

    static void writeBillIssued(DynamicObject bill, BigDecimal amount, BigDecimal tax) {
        bill.set("mainissuedamount", (Object)bill.getBigDecimal("mainissuedamount").add(amount));
        bill.set("mainissuedtax", (Object)bill.getBigDecimal("mainissuedtax").add(tax));
        bill.set("surplusamount", (Object)bill.getBigDecimal("surplusamount").subtract(amount));
        bill.set("surplustax", (Object)bill.getBigDecimal("surplustax").subtract(tax));
    }

    static void updateBillState(DynamicObject[] bills, DynamicObject invoice, boolean isValid, boolean redPush, Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap) {
        for (DynamicObject bill : bills) {
            AbstractIssueInvoiceWriteBackHelper.writeInfoCode2OriginalBill(bill, invoice);
            if (!isValid && !redPush) {
                AbstractIssueInvoiceWriteBackHelper.issueInvoiceWriteInvoiceCode(bill, invoice);
            }
            AbstractIssueInvoiceWriteBackHelper.updateValidAndConfirmState(bill, invoice, isValid, redPush);
            AbstractIssueInvoiceWriteBackHelper.updateCombineDataIfBillClosed(bills);
            AbstractIssueInvoiceWriteBackHelper.foreignCurrencyWriteBack(bill, arIssuedRelationMap);
        }
        AbstractIssueInvoiceWriteBackHelper.writeInvoiceCodeAndNo2OriginalBill(invoice, isValid, redPush);
        if (BotpHelper.isFromAr((Object)bills[0].getString("systemsource")) || "no".equals(ImcConfigUtil.getValue((String)"sim_writeback_config", (String)"use_save_operate"))) {
            AbstractIssueInvoiceWriteBackHelper.saveRelation(arIssuedRelationMap, invoice, isValid);
            AbstractIssueInvoiceWriteBackHelper.updateIssueWriteBackStatus(invoice, "1", "");
            ImcSaveServiceHelper.save((DynamicObject[])bills);
            SourceBillWriteBackHelper.writeBack(bills, invoice);
            return;
        }
        try {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"writebacksave", (String)"sim_original_bill", (DynamicObject[])bills, null);
            if (operationResult.isSuccess()) {
                AbstractIssueInvoiceWriteBackHelper.updateIssueWriteBackStatus(invoice, "1", "");
                SourceBillWriteBackHelper.writeBack(bills, invoice);
            } else {
                AbstractIssueInvoiceWriteBackHelper.updateOriginalBill(bills, invoice, OperationConstant.getErrorMsg((OperationResult)operationResult));
            }
        }
        catch (Exception e) {
            LOG.error(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u53cd\u5199\u8c03\u7528\u82cd\u7a79\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38", invoice.getString("invoicecode"), invoice.getString("invoiceno")), (Throwable)e);
            AbstractIssueInvoiceWriteBackHelper.updateOriginalBill(bills, invoice, "\u8c03\u7528\u82cd\u7a79\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    private static void saveRelation(Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap, DynamicObject invoice, boolean isValid) {
        if (null == arIssuedRelationMap || arIssuedRelationMap.size() == 0) {
            return;
        }
        Collection<ArBillRelationExtensionDTO> relations = arIssuedRelationMap.values();
        String mergeKey = BotpHelper.getMergeKey((DynamicObject)invoice, (boolean)isValid);
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
        log.set("createtime", (Object)new Date());
        log.set("business", (Object)"2");
        log.set("param_tag", (Object)JSONObject.toJSONString(relations));
        log.set("invoiceno", (Object)mergeKey);
        ImcSaveServiceHelper.save((DynamicObject)log);
    }

    private static void issueInvoiceWriteInvoiceCode(DynamicObject bill, DynamicObject invoice) {
        bill.set("invoicecode", invoice.get("invoicecode"));
        bill.set("invoiceno", invoice.get("invoiceno"));
        bill.set("issuetime", invoice.get("issuetime"));
        bill.set("invoicestatus", invoice.get("invoicestatus"));
        bill.set("invoicedtotalamount", invoice.get("totalamount"));
        bill.set("invoicedtax", invoice.get("totaltax"));
        bill.set("invoicedamount", invoice.get("invoiceamount"));
    }

    static void writeInfoCode2OriginalBill(DynamicObject bill, DynamicObject invoice) {
        if (BillHelper.isRedInfo(bill)) {
            String oriInfoCode = bill.getString("infocode");
            String currentInfoCode = invoice.getString("infocode");
            if (StringUtils.isBlank((CharSequence)oriInfoCode)) {
                oriInfoCode = currentInfoCode;
            } else if (!oriInfoCode.contains(currentInfoCode)) {
                oriInfoCode = oriInfoCode + "," + currentInfoCode;
            }
            bill.set("infocode", (Object)oriInfoCode);
        }
    }

    static void writeInvoiceCodeAndNo2OriginalBill(DynamicObject invoice, boolean isValid, boolean redPush) {
        try {
            DynamicObject[] originalBills;
            if (!isValid && !redPush) {
                AbstractIssueInvoiceWriteBackHelper.setOriginalInvoiceStatus(invoice, false);
                return;
            }
            QFilter qFilter = isValid ? new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode")).and("invoiceno", "=", (Object)invoice.getString("invoiceno")) : new QFilter("invoicecode", "=", (Object)invoice.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoice.getString("originalinvoiceno"));
            for (DynamicObject originalBill : originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"invoicestatus", (QFilter[])qFilter.toArray())) {
                if (isValid) {
                    originalBill.set("invoicestatus", (Object)"6");
                    continue;
                }
                originalBill.set("invoicestatus", (Object)"3");
            }
            ImcSaveServiceHelper.save((DynamicObject[])originalBills);
            if (isValid) {
                AbstractIssueInvoiceWriteBackHelper.setOriginalInvoiceStatus(invoice, true);
            }
        }
        catch (Exception e) {
            LOG.error("\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
        }
    }

    static void setOriginalInvoiceStatus(DynamicObject invoice, boolean isValid) {
        DynamicObject[] originalBills;
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        String originalInvoiceCode = invoice.getString("originalinvoicecode");
        String originalInvoiceNo = invoice.getString("originalinvoiceno");
        if (StringUtils.isBlank((CharSequence)originalInvoiceCode) && StringUtils.isBlank((CharSequence)originalInvoiceNo)) {
            return;
        }
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)originalInvoiceCode).and("invoiceno", "=", (Object)originalInvoiceNo);
        for (DynamicObject originalBill : originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"invoicestatus", (QFilter[])qFilter.toArray())) {
            originalBill.set("invoicestatus", (Object)(isValid ? "0" : "3"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])originalBills);
    }

    private static void updateValidAndConfirmState(DynamicObject bill, DynamicObject invoice, boolean isValid, boolean redPush) {
        if (AbstractIssueInvoiceWriteBackHelper.isNoWriteBack(isValid, redPush, invoice)) {
            return;
        }
        BigDecimal surplusAmount = bill.getBigDecimal("surplusamount");
        if (surplusAmount.compareTo(BigDecimal.ZERO) == 0 || surplusAmount.add(bill.getBigDecimal("surplustax")).compareTo(BigDecimal.ZERO) == 0) {
            AbstractIssueInvoiceWriteBackHelper.changeBillStatusBySurplusAmountZero(bill);
        } else {
            AbstractIssueInvoiceWriteBackHelper.changeBillStatusBySurplusAmountNotZero(bill, invoice, isValid, redPush);
        }
        if (!isValid && !redPush) {
            return;
        }
        BigDecimal confirmAmount = bill.getBigDecimal("confirmamount");
        if (confirmAmount.compareTo(BigDecimal.ZERO) == 0) {
            bill.set("confirmstate", (Object)"0");
        } else {
            boolean isTax = "1".equals(bill.getString("hsbz"));
            if (isTax && bill.getBigDecimal("totalamount").compareTo(confirmAmount) == 0 || !isTax && bill.getBigDecimal("invoiceamount").compareTo(confirmAmount) == 0) {
                bill.set("confirmstate", (Object)"2");
            } else {
                bill.set("confirmstate", (Object)"1");
            }
        }
    }

    private static void changeBillStatusBySurplusAmountNotZero(DynamicObject bill, DynamicObject invoice, boolean isValid, boolean redPush) {
        bill.set("validstate", (Object)"0");
        if (isValid || redPush) {
            bill.set("comprehensivestatus", (Object)"21");
            if (bill.getBigDecimal("mainissuedamount").compareTo(BigDecimal.ZERO) == 0 && bill.getBigDecimal("confirmamount").compareTo(BigDecimal.ZERO) == 0) {
                bill.set("comprehensivestatus", (Object)"22");
            }
            return;
        }
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            bill.set("comprehensivestatus", (Object)"08");
            if ("10".equals(invoice.getString("contraststatus"))) {
                DynamicObject relation;
                DynamicObject redConfirm;
                boolean isMatchRedConfirm = false;
                if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) && (redConfirm = RedInfoAndConfirmBillWriteBackHelper.getRedConfirmBillByInfoCode(invoice)) != null && (relation = QueryServiceHelper.queryOne((String)"sim_match_inv_relation", (String)"matchtarget", (QFilter[])new QFilter("tbillid", "=", redConfirm.getPkValue()).toArray())) != null) {
                    boolean bl = isMatchRedConfirm = "2".equals(relation.getString("matchtarget")) || "1".equals(relation.getString("matchtarget"));
                }
                if (isMatchRedConfirm) {
                    bill.set("comprehensivestatus", (Object)"42");
                } else {
                    bill.set("comprehensivestatus", (Object)"39");
                }
            }
            return;
        }
        Pair<Boolean, BigDecimal> reversePair = AbstractIssueInvoiceWriteBackHelper.calcInvoiceReverseAndTotalAmount(bill);
        if (((Boolean)reversePair.getKey()).booleanValue()) {
            bill.set("comprehensivestatus", (Object)"21");
        } else {
            bill.set("comprehensivestatus", (Object)"08");
        }
    }

    private static void changeBillStatusBySurplusAmountZero(DynamicObject bill) {
        Pair<Boolean, BigDecimal> reversePair = AbstractIssueInvoiceWriteBackHelper.calcInvoiceReverseAndTotalAmount(bill);
        if (((Boolean)reversePair.getLeft()).booleanValue()) {
            bill.set("comprehensivestatus", (Object)(((BigDecimal)reversePair.getValue()).compareTo(bill.getBigDecimal("totalamount")) >= 0 ? "24" : "23"));
        } else {
            bill.set("comprehensivestatus", (Object)"09");
        }
        bill.set("validstate", (Object)"2");
    }

    private static Pair<Boolean, BigDecimal> calcInvoiceReverseAndTotalAmount(DynamicObject bill) {
        DynamicObjectCollection invoices = AbstractIssueInvoiceWriteBackHelper.queryRelationInvoice(bill);
        BigDecimal totalAmount = BigDecimal.ZERO;
        boolean hasReverseInv = invoices.stream().anyMatch(inv -> {
            String invoiceStatus = inv.getString("invoicestatus");
            return "2".equals(invoiceStatus) || "3".equals(invoiceStatus) || "6".equals(invoiceStatus);
        });
        if (hasReverseInv) {
            for (DynamicObject invoice : invoices) {
                String invoiceStatus = invoice.getString("invoicestatus");
                if (!"2".equals(invoiceStatus) && !"3".equals(invoiceStatus) && !"6".equals(invoiceStatus)) continue;
                totalAmount = totalAmount.add(invoice.getBigDecimal("totalamount"));
            }
        }
        return Pair.of((Object)hasReverseInv, (Object)totalAmount);
    }

    private static DynamicObjectCollection queryRelationInvoice(DynamicObject bill) {
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", bill.getPkValue()).toArray());
        if (CollectionUtils.isEmpty((Collection)relations)) {
            return new DynamicObjectCollection();
        }
        Object[] invIds = relations.stream().map(relation -> relation.getLong("tbillid")).distinct().toArray();
        return QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicestatus", "invoiceamount", "totalamount"), (QFilter[])new QFilter("id", "in", (Object)invIds).toArray());
    }

    private static void updateCombineDataIfBillClosed(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            String closeStatus = bill.getString("closestatus");
            if (!"1".equals(closeStatus)) continue;
            BotpHelper.calBillCombineData((DynamicObject)bill);
        }
    }

    public static void foreignCurrencyWriteBack(DynamicObject bill, Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap) {
        if (null == arIssuedRelationMap || arIssuedRelationMap.size() == 0) {
            return;
        }
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        if (!CurrencyHelper.isFrom((Object)fromCurr)) {
            AbstractIssueInvoiceWriteBackHelper.copyForeignIssueAmount(arIssuedRelationMap);
            return;
        }
        DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal sumFromAmount = BigDecimal.ZERO;
        BigDecimal sumFromTax = BigDecimal.ZERO;
        for (int i = 0; i < items2.size(); ++i) {
            BigDecimal issuedFromTaxAmount;
            BigDecimal issuedFromTax;
            BigDecimal issuedFromAmount;
            DynamicObject item = (DynamicObject)items2.get(i);
            long itemPk = item.getLong("id");
            String rowType = item.getString("rowtype");
            ArBillRelationExtensionDTO relation = arIssuedRelationMap.get(itemPk);
            if ("1".equals(rowType) && i != 0) {
                DynamicObject lastRow = (DynamicObject)items2.get(i - 1);
                relation = arIssuedRelationMap.get(lastRow.getLong("id"));
            }
            BigDecimal issuedAmount = item.getBigDecimal("issuedamount");
            BigDecimal issuedTax = item.getBigDecimal("issuedtax");
            BigDecimal amount = item.getBigDecimal("amount");
            BigDecimal tax = item.getBigDecimal("tax");
            if (issuedAmount.compareTo(amount) == 0) {
                issuedFromAmount = item.getBigDecimal("fromamount").subtract(item.getBigDecimal("fromissuedamount"));
                issuedFromTax = item.getBigDecimal("fromtax").subtract(item.getBigDecimal("fromissuedtax"));
                issuedFromTaxAmount = item.getBigDecimal("fromtaxamount").subtract(item.getBigDecimal("fromissuedtaxamount"));
                item.set("fromissuedamount", item.get("fromamount"));
                item.set("fromissuedtax", item.get("fromtax"));
                item.set("fromissuedtaxamount", item.get("fromtaxamount"));
            } else {
                BigDecimal fromIssueTax;
                BigDecimal fromAmount = item.getBigDecimal("fromamount");
                BigDecimal fromIssueAmount = fromAmount.multiply(issuedAmount.divide(amount, 100, 4)).setScale(fromCurr.getInt("amtprecision"), 4);
                issuedFromAmount = fromIssueAmount.subtract(item.getBigDecimal("fromissuedamount"));
                item.set("fromissuedamount", (Object)fromIssueAmount);
                if (MathUtils.isNullOrZero(tax)) {
                    fromIssueTax = BigDecimal.ZERO;
                } else {
                    BigDecimal fromTax = item.getBigDecimal("fromtax");
                    fromIssueTax = fromTax.multiply(issuedTax.divide(tax, 100, 4)).setScale(fromCurr.getInt("amtprecision"), 4);
                }
                issuedFromTax = fromIssueTax.subtract(item.getBigDecimal("fromissuedtax"));
                item.set("fromissuedtax", (Object)fromIssueTax);
                BigDecimal itemIssueTaxAmount = item.getBigDecimal("fromissuedamount").add(item.getBigDecimal("fromissuedtax"));
                issuedFromTaxAmount = itemIssueTaxAmount.subtract(item.getBigDecimal("fromissuedtaxamount"));
                item.set("fromissuedtaxamount", (Object)itemIssueTaxAmount);
            }
            sumFromAmount = sumFromAmount.add(item.getBigDecimal("fromissuedamount"));
            sumFromTax = sumFromTax.add(item.getBigDecimal("fromissuedtax"));
            if (!BotpHelper.isFromAr((Object)bill.getString("systemsource")) || null == relation) continue;
            relation.setFromTax(relation.getFromTax().add(issuedFromTax));
            relation.setFromAmount(relation.getFromAmount().add(issuedFromAmount));
            relation.setFromTaxAmount(relation.getFromTaxAmount().add(issuedFromTaxAmount));
        }
        bill.set("foreignissuedamount", (Object)sumFromAmount);
        bill.set("foreignissuedtax", (Object)sumFromTax);
        bill.set("foreignissuedtotalamount", (Object)sumFromAmount.add(sumFromTax));
    }

    private static void copyForeignIssueAmount(Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap) {
        for (Map.Entry<Long, ArBillRelationExtensionDTO> entry : arIssuedRelationMap.entrySet()) {
            ArBillRelationExtensionDTO dto = entry.getValue();
            dto.setFromAmount(dto.getAmount());
            dto.setFromTax(dto.getTax());
        }
    }

    static void updateIssueWriteBackStatus(DynamicObject invoice, String writebackStatus, String writebackReason) {
        invoice.set("issuewritebackstatus", (Object)writebackStatus);
        invoice.set("issuewritebackreason", (Object)writebackReason);
        ImcSaveServiceHelper.update((DynamicObject)invoice);
    }

    static void updateOriginalBill(DynamicObject[] bills, DynamicObject invoice, String errMsg) {
        ImcSaveServiceHelper.save((DynamicObject[])bills);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u8fdb\u884c\u53cd\u5199\uff0c\u8c03\u7528\u82cd\u7a79\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f[%s]", invoice.getString("invoicecode"), invoice.getString("invoiceno"), errMsg));
        }
        SourceBillWriteBackHelper.writeBack(bills, invoice);
        AbstractIssueInvoiceWriteBackHelper.updateIssueWriteBackStatus(invoice, "1", GBKUtils.cutGBKString((String)errMsg, (int)60));
    }

    static DynamicObject[] getRedInfoRelation(DynamicObject red) {
        DynamicObject blueInvoice = AbstractIssueInvoiceWriteBackHelper.getBlueInvoiceByRed(red);
        if (blueInvoice == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u5bf9\u5e94\u84dd\u7968\u4fe1\u606f\uff0c\u7ea2\u51b2\u64cd\u4f5c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", red.getString("invoiceno")));
            }
            return new DynamicObject[0];
        }
        if (red.getBigDecimal("invoiceamount").abs().compareTo(blueInvoice.getBigDecimal("invoiceamount")) < 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801\uff1a[%s]\u90e8\u5206\u7ea2\u51b2\u4f5c\u5e9f\uff0c\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", red.getString("invoiceno")));
            }
            return new DynamicObject[0];
        }
        return AbstractIssueInvoiceWriteBackHelper.getRelationsByTBillId(blueInvoice.getPkValue());
    }

    static DynamicObject getBlueInvoiceByRed(DynamicObject invoiceOrRedInfo) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoiceOrRedInfo.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invoiceOrRedInfo.getString("originalinvoiceno"));
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoiceamount"), (QFilter[])qFilter.toArray());
    }

    static DynamicObject[] getRelationsByTBillId(Object invoiceId) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceId).and("isdelete", "!=", (Object)"Y").toArray());
    }

    static DLock lockOriginalBillWriteBack(DynamicObject invoice) {
        String lockKey = "writebackOriginal_" + DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
        DLock lock = DLock.create((String)lockKey, (String)("writebackOriginal_" + lockKey));
        lock.lock();
        return lock;
    }

    protected static DynamicObject createWriteBackLog(DynamicObject bill, DynamicObject invoiceOrRedInfo) {
        DynamicObject writeBackLog = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_process_log");
        writeBackLog.set("billno", (Object)bill.getString("billno"));
        writeBackLog.set("logtype", (Object)"issuewriteback");
        writeBackLog.set("traceid", (Object)RequestContext.get().getTraceId());
        writeBackLog.set("invoicekey", (Object)invoiceOrRedInfo.getString("invoiceno"));
        return writeBackLog;
    }

    protected static void updateBefore(JSONObject writeJson, DynamicObject billItem) {
        writeJson.put("seq", billItem.get("seq"));
        writeJson.put("goodsName", billItem.get("goodsname"));
        writeJson.put("beforeAmount", (Object)billItem.getBigDecimal("issuedamount").setScale(2, 4));
        writeJson.put("beforeTax", (Object)billItem.getBigDecimal("issuedtax").setScale(2, 4));
        writeJson.put("beforeNum", (Object)billItem.getBigDecimal("issuednum").stripTrailingZeros());
    }

    protected static void updateAfter(JSONObject writeJson, DynamicObject billItem) {
        writeJson.put("afterAmount", (Object)billItem.getBigDecimal("issuedamount").setScale(2, 4));
        writeJson.put("afterTax", (Object)billItem.getBigDecimal("issuedtax").setScale(2, 4));
        writeJson.put("afterNum", (Object)billItem.getBigDecimal("issuednum").stripTrailingZeros());
    }

    protected static void updateNegativeBillDiff(DynamicObject[] bills, DynamicObject redConfirm) {
        try {
            DynamicObject bill;
            BigDecimal redConfirmTax = redConfirm.getBigDecimal("totaltax");
            BigDecimal redConfirmAmount = redConfirm.getBigDecimal("invoiceamount");
            BigDecimal billTotalTax = BigDecimal.ZERO;
            BigDecimal billTotalAmount = BigDecimal.ZERO;
            HashMap<Integer, BigDecimal> hashMap = new HashMap<Integer, BigDecimal>();
            ArrayList<Object> billPks = new ArrayList<Object>();
            for (int i = 0; i < bills.length; ++i) {
                bill = bills[i];
                billTotalTax = billTotalTax.add(bill.getBigDecimal("totaltax"));
                billTotalAmount = billTotalAmount.add(bill.getBigDecimal("invoiceamount"));
                hashMap.put(i, bill.getBigDecimal("invoiceamount").abs());
                billPks.add(bill.getPkValue());
            }
            DynamicObjectCollection mergeRelations = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_matchbill_relation"), (QFilter[])new QFilter("sbillid", "in", billPks).toArray());
            if (mergeRelations.size() > 1) {
                Object[] objects = mergeRelations.stream().map(obj -> obj.get("tbillid")).toArray();
                DynamicObjectCollection redRelations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_match_inv_relation"), (QFilter[])new QFilter("sbillid", "in", (Object)objects).toArray());
                if (redRelations.size() > 1) {
                    Object[] redPks = redRelations.stream().map(obj -> obj.get("tbillid")).toArray();
                    DynamicObject[] redList = BusinessDataServiceHelper.load((Object[])redPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill"));
                    redConfirmTax = BigDecimal.ZERO;
                    redConfirmAmount = BigDecimal.ZERO;
                    for (DynamicObject red : redList) {
                        redConfirmTax = redConfirmTax.add(red.getBigDecimal("totaltax"));
                        redConfirmAmount = redConfirmAmount.add(red.getBigDecimal("invoiceamount"));
                    }
                }
            }
            if (redConfirmTax.compareTo(billTotalTax) != 0) {
                Optional maxEntry;
                Optional maxEntry2;
                LOG.info("\u8d1f\u6570\u5f00\u7968\u7533\u8bf7\u5355\u5b58\u5728\u7a0e\u989d\u5bb9\u5dee: " + redConfirmTax.subtract(billTotalTax));
                bill = bills[0];
                if (hashMap.size() > 1 && (maxEntry2 = hashMap.entrySet().stream().max(Map.Entry.comparingByValue())).isPresent()) {
                    bill = bills[(Integer)maxEntry2.get().getKey()];
                }
                BigDecimal taxDiff = redConfirmTax.subtract(billTotalTax);
                BigDecimal amountDiff = redConfirmAmount.subtract(billTotalAmount);
                bill.set("maintaxdeviation", (Object)taxDiff);
                DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
                HashMap<Integer, BigDecimal> itemMap = new HashMap<Integer, BigDecimal>();
                for (int i = 0; i < items2.size(); ++i) {
                    itemMap.put(i, ((DynamicObject)items2.get(i)).getBigDecimal("amount").abs());
                }
                DynamicObject billItem = (DynamicObject)items2.get(0);
                if (itemMap.size() > 1 && (maxEntry = itemMap.entrySet().stream().max(Map.Entry.comparingByValue())).isPresent()) {
                    billItem = (DynamicObject)items2.get(((Integer)maxEntry.get().getKey()).intValue());
                }
                billItem.set("taxdeviation", (Object)taxDiff);
                billItem.set("amountdeviation", (Object)amountDiff);
            }
        }
        catch (Exception e) {
            LOG.error("updateNegativeBillDiff", (Throwable)e);
        }
    }
}

