/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SourceBillWriteBackHelper {
    private static final String BGD_COLLECT = "BGD_COLLECT";
    private static final String SIM_DECLARATION_BILL = "sim_declaration_bill";
    private static final String BILL_CENTER = "BILL_CENTER";
    private static final String SIM_ISOMERISM_BILL_DATA = "sim_isomerism_bill_data";
    private static final Map<String, Pair<String, String>> WRITEBACK_MAP = new ImmutableMap.Builder().put((Object)"BGD_COLLECT", (Object)Pair.of((Object)"sim_declaration_bill", (Object)"invoice")).put((Object)"BILL_CENTER", (Object)Pair.of((Object)"sim_isomerism_bill_data", (Object)"invoice")).build();

    public static void writeBack(DynamicObject[] bills, DynamicObject invoice) {
        DynamicObject[] sourceBillArr;
        Pair<String, String> table = WRITEBACK_MAP.get(invoice.getString("systemsource"));
        if (table == null) {
            return;
        }
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"sim_original_bill", (Long[])((Long[])Arrays.stream(bills).map(bill -> bill.getLong("id")).toArray(Long[]::new)));
        HashSet sourceBillids = (HashSet)sourceBills.get(table.getKey());
        if (CollectionUtils.isEmpty((Collection)sourceBillids)) {
            return;
        }
        for (DynamicObject sourceBill : sourceBillArr = BusinessDataServiceHelper.load((Object[])sourceBillids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((String)table.getKey())))) {
            DynamicObjectCollection billInvoices = sourceBill.getDynamicObjectCollection((String)table.getValue());
            for (DynamicObject billInvoice : billInvoices) {
                if (!invoice.getString("invoicecode").equals(billInvoice.getString("invoicecode")) || !invoice.getString("invoiceno").equals(billInvoice.getString("invoiceno"))) continue;
                return;
            }
            DynamicObject billInvoice = billInvoices.addNew();
            billInvoice.set("invoicecode", (Object)invoice.getString("invoicecode"));
            billInvoice.set("invoiceno", (Object)invoice.getString("invoiceno"));
            billInvoice.set("issuetime", (Object)invoice.getDate("issuetime"));
            billInvoice.set("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount"));
            billInvoice.set("totaltax", (Object)invoice.getBigDecimal("totaltax"));
            if (!sourceBill.getDynamicObjectType().getName().equals(SIM_ISOMERISM_BILL_DATA)) continue;
            billInvoice.set("totalamount", (Object)invoice.getBigDecimal("totalamount"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])sourceBillArr);
    }
}

