/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;

public class TaxOrgFilterListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("taxorg")) {
            args.addCustomParam("orgFuncId", (Object)(TaxOrgFilterListPlugin.useNewTaxOrg() ? "40" : "10"));
            HasPermOrgResult result = PermissionHelper.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            QFilter idsFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
            args.addCustomQFilter(idsFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listCommonFilterColumns = args.getCommonFilterColumns();
        if (!CollectionUtils.isEmpty((Collection)listCommonFilterColumns)) {
            for (FilterColumn filterColumn : listCommonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!fieldName.startsWith("taxorg") || !(filterColumn instanceof CommonFilterColumn)) continue;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                List<ComboItem> combos = this.getOrgComboItem();
                if (combos == null) continue;
                commonFilterColumn.setComboItems(combos);
                if (!combos.isEmpty()) continue;
                commonFilterColumn.setDefaultValue("");
            }
        }
    }

    protected List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache + "taxorg");
        if ("hasAllOrgPerm".equals(orgListCacheString)) {
            return null;
        }
        List orgList = new ArrayList();
        if (orgListCacheString == null) {
            HasPermOrgResult hasPermOrgResult = PermissionHelper.getAllPermOrgs((IFormView)this.getView());
            if (hasPermOrgResult.hasAllOrgPerm()) {
                this.getPageCache().put(orgListCache, "hasAllOrgPerm");
                return null;
            }
            ORM orm = ORM.create();
            orgList = new ArrayList();
            QFilter idQFilter = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()).and("view.number", "=", (Object)(TaxOrgFilterListPlugin.useNewTaxOrg() ? "40" : "10"));
            DynamicObjectCollection col = orm.query("bos_org_structure", "org.id as id,org.name as name, parent.id", idQFilter.toArray());
            for (DynamicObject dynamicObject : col) {
                if (dynamicObject == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", String.valueOf(dynamicObject.getPkValue()));
                map.put("name", dynamicObject.getString("name"));
                orgList.add(map);
            }
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString((String)map.get("name")));
            item.setValue((String)map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }

    public static boolean useNewTaxOrg() {
        Map orgBizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"", (QFilter[])new QFilter("fnumber", "=", (Object)"40").toArray());
        return !CollectionUtils.isEmpty((Map)orgBizMap);
    }
}

