/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.dto.BillFreightItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillCoBuyerItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillTravlerInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillVehicheVesselShipVo;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.BaseInvoiceItem;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.enums.SeatClassTypeEnum;
import kd.imc.sim.common.enums.TransportTypeEnum;
import kd.imc.sim.common.enums.TravelerCardTypeEnum;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

public class InvoiceAllESpecialCheckService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceAllESpecialCheckService.class);
    public static final Set<String> transportTypeSet = new ImmutableSet.Builder().add((Object[])new String[]{"\u94c1\u8def\u8fd0\u8f93", "\u516c\u8def\u8fd0\u8f93", "\u6c34\u8def\u8fd0\u8f93", "\u822a\u7a7a\u8fd0\u8f93", "\u7ba1\u9053\u8fd0\u8f93", "\u5176\u5b83\u8fd0\u8f93\u5de5\u5177"}).build();
    private static final Set<String> detailAddressSet = new ImmutableSet.Builder().add((Object[])new String[]{"\u8857", "\u8def", "\u6751", "\u4e61", "\u9547", "\u9053", "\u5df7", "\u53f7"}).build();

    public void allEBuildCheck(BaseInvoice invoice) {
        InvoiceCheckService.checkNull(invoice.getSimpleaddress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_0", (String)"imc-sim-common", (Object[])new Object[0])));
        this.checkAddressLength(invoice);
        InvoiceCheckService.checkNull(invoice.getCrosscitysign(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_1", (String)"imc-sim-common", (Object[])new Object[0])));
        if (!"0".equals(invoice.getCrosscitysign()) && !"1".equals(invoice.getCrosscitysign())) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u8de8\u5730\u5e02\u6807\u5fd7\u53ea\u80fd\u662f0\u62161", (String)"InvoiceAllESpecialCheckService_2", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        InvoiceCheckService.checkNull(invoice.getBuildingname(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u5efa\u7b51\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_3", (String)"imc-sim-common", (Object[])new Object[0])));
        InvoiceCheckService.checkStrLength(invoice.getBuildingname(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u5efa\u7b51\u9879\u76ee\u540d\u79f0", (String)"InvoiceAllESpecialCheckService_4", (String)"imc-sim-common", (Object[])new Object[0])), 80);
        InvoiceCheckService.checkStrLength(invoice.getLandtaxno(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u7f16\u53f7", (String)"InvoiceAllESpecialCheckService_5", (String)"imc-sim-common", (Object[])new Object[0])), 20);
        InvoiceCheckService.checkStrLength(invoice.getCrossCityTaxVerifyNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u8de8\u533a\u57df\u6d89\u7a0e\u4e8b\u9879\u62a5\u9a8c\u7ba1\u7406\u7f16\u53f7", (String)"InvoiceAllESpecialCheckService_120", (String)"imc-sim-common", (Object[])new Object[0])), 100);
    }

    @SdkDeprecated
    public static boolean checkDetailAddress(String detailAddress) {
        if (StringUtils.isBlank((CharSequence)detailAddress)) {
            return false;
        }
        for (String s : detailAddressSet) {
            if (!detailAddress.contains(s)) continue;
            return true;
        }
        return false;
    }

    public void allEEstateCheck(BaseInvoice invoice) {
        InvoiceCheckService.checkNull(invoice.getSimpleaddress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_6", (String)"imc-sim-common", (Object[])new Object[0])));
        InvoiceCheckService.checkNull(invoice.getDetailaddress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_7", (String)"imc-sim-common", (Object[])new Object[0])));
        String detailAddress = this.checkAddressLength(invoice);
        if (!InvoiceAllESpecialCheckService.checkDetailAddress(detailAddress)) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u5fc5\u987b\u5305\u542b\u201c\u8857\u3001\u8def\u3001\u6751\u3001\u4e61\u3001\u9547\u3001\u9053\u3001\u5df7\u3001\u53f7\u201d\u7b49\u5173\u952e\u8bcd\u4e4b\u4e00", (String)"InvoiceAllESpecialCheckService_14", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        InvoiceCheckService.checkStrLength(invoice.getEstateid(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u623f\u5c4b\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7", (String)"InvoiceAllESpecialCheckService_15", (String)"imc-sim-common", (Object[])new Object[0])), 40);
        InvoiceCheckService.checkNull(invoice.getCrosscitysign(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_1", (String)"imc-sim-common", (Object[])new Object[0])));
        if (!"0".equals(invoice.getCrosscitysign()) && !"1".equals(invoice.getCrosscitysign())) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u8de8\u5730\u5e02\u6807\u5fd7\u53ea\u80fd\u662f0\u62161", (String)"InvoiceAllESpecialCheckService_2", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        InvoiceCheckService.checkNull(invoice.getAreaunit(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u9762\u79ef\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_16", (String)"imc-sim-common", (Object[])new Object[0])));
        if (!InvoiceCheckService.areaUnitSet.contains(invoice.getAreaunit())) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u9762\u79ef\u5355\u4f4d\u5e94\u8be5\u5305\u542b\u5e73\u65b9\u7c73\u3001\u4ea9\u3001\u33a1\u3001\u5e73\u65b9\u5343\u7c73\u3001\u516c\u9877\u3001h\u33a1\u3001k\u33a1\u5173\u952e\u8bcd", (String)"InvoiceAllESpecialCheckService_17", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        if ("E06".equals(invoice.getSpecialtype())) {
            InvoiceCheckService.checkNull(invoice.getEstateid(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u623f\u5c4b\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_18", (String)"imc-sim-common", (Object[])new Object[0])));
            if (StringUtils.isBlank((CharSequence)invoice.getEndleasedate()) || StringUtils.isBlank((CharSequence)invoice.getStartleasedate())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u79df\u8d41\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_19", (String)"imc-sim-common", (Object[])new Object[0])));
            }
        } else {
            InvoiceCheckService.checkStrLength(invoice.getEstatecode(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5355\u5143\u4ee3\u7801/\u7f51\u7b7e\u5408\u540c\u5907\u6848\u7f16\u53f7", (String)"InvoiceAllESpecialCheckService_20", (String)"imc-sim-common", (Object[])new Object[0])), 28);
            InvoiceCheckService.checkStrLength(invoice.getLandtaxno(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u7f16\u53f7", (String)"InvoiceAllESpecialCheckService_5", (String)"imc-sim-common", (Object[])new Object[0])), 20);
            if (invoice.getApprovedprice().compareTo(BigDecimal.ZERO) < 0) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u6838\u5b9a\u8ba1\u7a0e\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceAllESpecialCheckService_21", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if (invoice.getActualturnover().compareTo(BigDecimal.ZERO) < 0) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceAllESpecialCheckService_22", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            this.checkAmountLength(invoice.getApprovedprice(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u6838\u5b9a\u8ba1\u7a0e\u4ef7", (String)"InvoiceAllESpecialCheckService_23", (String)"imc-sim-common", (Object[])new Object[0])));
            this.checkAmountLength(invoice.getActualturnover(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d", (String)"InvoiceAllESpecialCheckService_24", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        this.checkItemNumAndPriceRequired(invoice);
    }

    public void allEFreightCheck(BaseInvoice invoice) {
        List freightItems = invoice.getFreightItems();
        if (CollectionUtils.isEmpty((Collection)freightItems)) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u7279\u79cd\u7968\u79cd\u4e3a\u8d27\u7269\u8fd0\u8f93\u65f6\uff0c\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u5fc5\u586b", (String)"InvoiceAllESpecialCheckService_27", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        for (int i = 0; i < freightItems.size(); ++i) {
            BillFreightItemVo freightItem = (BillFreightItemVo)freightItems.get(i);
            int seq = i + 1;
            InvoiceCheckService.checkNull(freightItem.getStartPlace(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8d77\u8fd0\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_28", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkLen(freightItem.getStartPlace(), 80, String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8d77\u8fd0\u5730\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_29", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkNull(freightItem.getEndPlace(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5230\u8fbe\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_30", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkLen(freightItem.getEndPlace(), 80, String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5230\u8fbe\u5730\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_31", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkNull(freightItem.getTransportType(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8fd0\u8f93\u5de5\u5177\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_32", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            if (StringUtils.isNotBlank((CharSequence)freightItem.getTransportType()) && !transportTypeSet.contains(freightItem.getTransportType())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8fd0\u8f93\u5de5\u5177\u79cd\u7c7b\u5e94\u8be5\u662f\u94c1\u8def\u8fd0\u8f93\u3001\u516c\u8def\u8fd0\u8f93\u3001\u6c34\u8def\u8fd0\u8f93\u3001\u822a\u7a7a\u8fd0\u8f93\u3001\u7ba1\u9053\u8fd0\u8f93\u3001\u5176\u5b83\u8fd0\u8f93\u5de5\u5177\u4e2d\u7684\u4e00\u79cd", (String)"InvoiceAllESpecialCheckService_33", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            InvoiceCheckService.checkNull(freightItem.getLicensePlate(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8fd0\u8f93\u5de5\u5177\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_34", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkLen(freightItem.getLicensePlate(), 40, String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8fd0\u8f93\u5de5\u5177\u724c\u53f7\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_35", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkNull(freightItem.getTransportGoods(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8fd0\u8f93\u8d27\u7269\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_36", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            InvoiceCheckService.checkLen(freightItem.getTransportGoods(), 80, String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8fd0\u8f93\u8d27\u7269\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_37", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
        }
    }

    public void allEEstateListCheck(BaseInvoice invoice) {
        int i;
        if (BigDecimal.ZERO.compareTo(invoice.getInvoiceamount()) > 0) {
            return;
        }
        int itemSize = 0;
        String specialtype = invoice.getSpecialtype();
        for (int i2 = 0; i2 < invoice.getInvoiceItemList().size(); ++i2) {
            if ("1".equals(((BaseInvoiceItem)invoice.getInvoiceItemList().get(i2)).getRowtype())) continue;
            ++itemSize;
        }
        List esateItems = invoice.getEstateSaleItems();
        String specialDescription = InvoiceSpecialType.InvoiceSpecialTypeEnum.getDescriptionByCode(specialtype);
        if (CollectionUtils.isEmpty((Collection)esateItems)) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u7279\u79cd\u7968\u79cd\u4e3a%1$s\u65f6\uff0c%1$s\u660e\u7ec6\u5fc5\u586b", (String)"InvoiceAllESpecialCheckService_91", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription)));
        }
        if (itemSize != esateItems.size()) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u53d1\u7968\uff1a\u5546\u54c1\u660e\u7ec6\u884c\u6570\u4e0d\u7b49\u4e8e%1$s\u660e\u7ec6\u884c\u6570", (String)"InvoiceAllESpecialCheckService_90", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription)));
        }
        for (i = 0; i < esateItems.size(); ++i) {
            DynamicObject adminDivision;
            String error;
            BillEstateSaleItemVo estateItem = (BillEstateSaleItemVo)esateItems.get(i);
            InvoiceCheckService.checkNull(estateItem.getProvinceAdress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u7701\uff09\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_66", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            InvoiceCheckService.checkStrLength(estateItem.getProvinceAdress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u7701\uff09", (String)"InvoiceAllESpecialCheckService_92", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)), 20);
            if (!estateItem.getProvinceAdress().matches(".*?\u7701|.*?\u81ea\u6cbb\u533a|.*?\u7279\u522b\u884c\u653f\u533a|\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u4e0a\u6d77\u5e02|\u91cd\u5e86\u5e02")) {
                error = String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u7701\uff09\u5fc5\u987b\u4ee5\u7701\u3001\u81ea\u6cbb\u533a\u3001\u7279\u522b\u884c\u653f\u533a\u3001\u5317\u4eac\u5e02\u3001\u5929\u6d25\u5e02\u3001\u4e0a\u6d77\u5e02\u3001\u91cd\u5e86\u5e02\u4efb\u610f\u4e00\u4e2a\u5173\u952e\u8bcd\u7ed3\u5c3e", (String)"InvoiceAllESpecialCheckService_96", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1);
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), error));
            }
            InvoiceCheckService.checkStrLength(estateItem.getCityAdreess(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u5e02\uff09", (String)"InvoiceAllESpecialCheckService_93", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)), 20);
            if (!estateItem.getProvinceAdress().matches("\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a|\u53f0\u6e7e\u7701") && StringUtils.isEmpty((CharSequence)estateItem.getCityAdreess())) {
                error = String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5f53\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u7701\uff09\u4e3a\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a\u3001\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a\u3001\u53f0\u6e7e\u7701\u65f6\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u5e02\uff09\u53ef\u4e3a\u7a7a\uff0c\u5176\u4ed6\u60c5\u51b5\u5fc5\u586b", (String)"InvoiceAllESpecialCheckService_124", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1);
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), error));
            }
            if (StringUtils.isNotEmpty((CharSequence)estateItem.getCityAdreess())) {
                if ("\u6d77\u5357\u7701".equals(estateItem.getProvinceAdress()) || "\u91cd\u5e86\u5e02".equals(estateItem.getProvinceAdress())) {
                    if (!estateItem.getCityAdreess().matches(".*?\u5e02\u533a|.*?\u5e02|.*?\u76df|.*?\u81ea\u6cbb\u5dde|.*?\u533a|.*?\u53bf|")) {
                        error = String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u5e02\uff09\u5fc5\u987b\u4ee5\u5e02\u3001\u76df\u3001\u81ea\u6cbb\u5dde\u3001\u5730\u533a\u3001\u533a\u3001\u53bf\u4efb\u610f\u4e00\u4e2a\u5173\u952e\u8bcd\u7ed3\u5c3e", (String)"InvoiceAllESpecialCheckService_125", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1);
                        throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), error));
                    }
                } else if (!estateItem.getCityAdreess().matches(".*?\u5e02\u533a|.*?\u5e02|.*?\u76df|.*?\u81ea\u6cbb\u5dde|.*?\u533a|")) {
                    error = String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5750\u843d\u5730\u5740\uff08\u5e02\uff09\u5fc5\u987b\u4ee5\u5e02\u3001\u76df\u3001\u81ea\u6cbb\u5dde\u3001\u5730\u533a\u3001\u533a\u4efb\u610f\u4e00\u4e2a\u5173\u952e\u8bcd\u7ed3\u5c3e", (String)"InvoiceAllESpecialCheckService_97", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1);
                    throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), error));
                }
            }
            InvoiceCheckService.checkNull(estateItem.getDetailAddress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_67", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            InvoiceCheckService.checkStrLength(estateItem.getDetailAddress(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740", (String)"InvoiceAllESpecialCheckService_94", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)), 80);
            if (!estateItem.getDetailAddress().matches("(?i).*(?:\u8857|\u8def|\u6751|\u4e61|\u9547|\u9053|\u5df7|\u53f7).*")) {
                error = String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740\u5fc5\u987b\u5305\u542b\u8857\u3001\u8def\u3001\u6751\u3001 \u4e61\u3001\u9547\u3001\u9053\u3001\u5df7\u3001\u53f7\u7b49\u4efb\u610f\u4e00\u4e2a\u5173\u952e\u8bcd", (String)"InvoiceAllESpecialCheckService_98", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1);
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), error));
            }
            String simpleAddress = estateItem.getProvinceAdress() + (StringUtils.isEmpty((CharSequence)estateItem.getCityAdreess()) ? "" : estateItem.getCityAdreess());
            if (StringUtils.isNotEmpty((CharSequence)estateItem.getProvinceAdress()) && StringUtils.isNotEmpty((CharSequence)estateItem.getCityAdreess()) && (adminDivision = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_admindivision", (QFilter[])new QFilter("name", "like", (Object)(simpleAddress + "%")).toArray())) == null) {
                String error2 = String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u3010\u7701\u5e02\u533a\u53bf\u3011\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"InvoiceAllESpecialCheckService_95", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1);
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), error2));
            }
            int totalLength = (simpleAddress + estateItem.getDetailAddress()).length();
            if (totalLength > 120) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u7701\u5e02\u533a\u53bf+\u5177\u4f53\u5730\u5740\u957f\u5ea6\u9650\u5236\u4e3a120\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_68", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            }
            InvoiceCheckService.checkStrLength(estateItem.getEstateId(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u623f\u5c4b\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7", (String)"InvoiceAllESpecialCheckService_69", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)), 40);
            InvoiceCheckService.checkNull(estateItem.getCrossCitySign(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u8de8\u5730\u5e02\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_70", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            if (!"0".equals(estateItem.getCrossCitySign()) && !"1".equals(estateItem.getCrossCitySign())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u8de8\u5730\u5e02\u6807\u5fd7\u53ea\u80fd\u662f0\u62161", (String)"InvoiceAllESpecialCheckService_71", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            }
            InvoiceCheckService.checkNull(estateItem.getAreaunit(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u9762\u79ef\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_72", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            if (!InvoiceCheckService.areaUnitSet.contains(estateItem.getAreaunit())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u9762\u79ef\u5355\u4f4d\u5e94\u8be5\u5305\u542b\u5e73\u65b9\u7c73\u3001\u4ea9\u3001\u33a1\u3001\u5e73\u65b9\u5343\u7c73\u3001\u516c\u9877\u3001h\u33a1\u3001k\u33a1\u5173\u952e\u8bcd", (String)"InvoiceAllESpecialCheckService_73", (String)"imc-sim-common", (Object[])new Object[0]), specialDescription, i + 1)));
            }
            if ("E05".equals(specialtype)) {
                InvoiceCheckService.checkStrLength(estateItem.getEstateCode(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0d\u52a8\u4ea7\u5355\u5143\u4ee3\u7801", (String)"InvoiceAllESpecialCheckService_74", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)), 28);
                InvoiceCheckService.checkStrLength(estateItem.getOnLineContracteNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7f51\u7b7e\u5408\u540c\u5907\u6848\u7f16\u53f7", (String)"InvoiceAllESpecialCheckService_75", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)), 28);
                InvoiceCheckService.checkStrLength(estateItem.getLandTaxNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u7f16\u53f7", (String)"InvoiceAllESpecialCheckService_76", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)), 20);
                if (null != estateItem.getApprovedPrice() && estateItem.getApprovedPrice().compareTo(BigDecimal.ZERO) < 0) {
                    throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6838\u5b9a\u8ba1\u7a0e\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceAllESpecialCheckService_77", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)));
                }
                if (null != estateItem.getActualTurnover() && estateItem.getActualTurnover().compareTo(BigDecimal.ZERO) < 0) {
                    throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceAllESpecialCheckService_78", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)));
                }
                this.checkAmountLength(estateItem.getApprovedPrice(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6838\u5b9a\u8ba1\u7a0e\u4ef7", (String)"InvoiceAllESpecialCheckService_79", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)));
                this.checkAmountLength(estateItem.getActualTurnover(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d", (String)"InvoiceAllESpecialCheckService_80", (String)"imc-sim-common", (Object[])new Object[0]), i + 1)));
            }
            if (!"E06".equals(specialtype)) continue;
            InvoiceCheckService.checkNull(estateItem.getEstateId(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u623f\u5c4b\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_18", (String)"imc-sim-common", (Object[])new Object[0])));
            if (!StringUtils.isBlank((CharSequence)estateItem.getEndLeaseDate()) && !StringUtils.isBlank((CharSequence)estateItem.getStartLeaseDate())) continue;
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u79df\u8d41\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_19", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        if (StringUtils.isNotBlank((CharSequence)invoice.getCoBuyerFlag()) && "E05".equals(invoice.getSpecialtype())) {
            if (!"0".equals(invoice.getCoBuyerFlag()) && !"1".equals(invoice.getCoBuyerFlag())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u6807\u5fd7\u53ea\u80fd\u662f0\u62161", (String)"InvoiceAllESpecialCheckService_81", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if ("1".equals(invoice.getCoBuyerFlag()) && CollectionUtils.isEmpty((Collection)invoice.getCoBuyerItems())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u6807\u5fd7\u4e3a1\u65f6\u5171\u540c\u8d2d\u4e70\u65b9\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_82", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if ("1".equals(invoice.getCoBuyerFlag())) {
                for (i = 0; i < invoice.getCoBuyerItems().size(); ++i) {
                    InvoiceCheckService.checkNull(((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCoBuyer(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5171\u540c\u8d2d\u4e70\u65b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_86", (String)"imc-sim-common", (Object[])new Object[]{i + 1})));
                    if (!((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCoBuyer().matches("[\\u4e00-\\u9fa5a-zA-Z]+")) {
                        throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5171\u540c\u8d2d\u4e70\u65b9\u53ea\u80fd\u586b\u5199\u6c49\u5b57\u3001\u82f1\u6587\u5927\u5c0f\u5199", (String)"InvoiceAllESpecialCheckService_89", (String)"imc-sim-common", (Object[])new Object[]{i + 1})));
                    }
                    InvoiceCheckService.checkNull(((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCardType(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_87", (String)"imc-sim-common", (Object[])new Object[]{i + 1})));
                    InvoiceCheckService.checkNull(((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCardNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_88", (String)"imc-sim-common", (Object[])new Object[]{i + 1})));
                    InvoiceCheckService.checkStrLength(((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCoBuyer(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5171\u540c\u8d2d\u4e70\u65b9", (String)"InvoiceAllESpecialCheckService_83", (String)"imc-sim-common", (Object[])new Object[]{i + 1})), 100);
                    InvoiceCheckService.checkStrLength(((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCardType(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bc1\u4ef6\u7c7b\u578b", (String)"InvoiceAllESpecialCheckService_84", (String)"imc-sim-common", (Object[])new Object[]{i + 1})), 3);
                    InvoiceCheckService.checkStrLength(((BillCoBuyerItemVo)invoice.getCoBuyerItems().get(i)).getCardNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u9500\u552e\u591a\u65b9\u5171\u540c\u8d2d\u4e70\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bc1\u4ef6\u53f7\u7801", (String)"InvoiceAllESpecialCheckService_85", (String)"imc-sim-common", (Object[])new Object[]{i + 1})), 20);
                }
            }
        }
        this.checkItemNumAndPriceRequired(invoice);
    }

    private void checkItemNumAndPriceRequired(BaseInvoice invoice) {
        List items2 = invoice.getInvoiceItemList();
        int index = 0;
        for (BaseInvoiceItem item : items2) {
            ++index;
            if ("1".equals(item.getRowtype())) continue;
            BigDecimal unitprice = item.getUnitprice();
            if (BigDecimalUtil.compareZero((BigDecimal)unitprice)) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u5355\u4ef7\u5fc5\u586b", (String)"InvoiceAllESpecialCheckService_25", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            BigDecimal num = item.getNum();
            if (!BigDecimalUtil.compareZero((BigDecimal)num)) continue;
            throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u6570\u91cf\u5fc5\u586b", (String)"InvoiceAllESpecialCheckService_26", (String)"imc-sim-common", (Object[])new Object[0])));
        }
    }

    private String checkAddressLength(BaseInvoice invoice) {
        int totalLength = (invoice.getSimpleaddress() + invoice.getDetailaddress()).length();
        if (totalLength > 120) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u7701\u5e02\u533a\u53bf+\u5177\u4f53\u5730\u5740\u957f\u5ea6\u9650\u5236\u4e3a120\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_38", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        return invoice.getDetailaddress();
    }

    private void checkAmountLength(BigDecimal amount, String name) {
        if (null == amount) {
            return;
        }
        String inputValueStr = amount.toPlainString();
        String replacedStr = inputValueStr.replace("-", "");
        if (!inputValueStr.contains(".") && replacedStr.length() > 13) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a13\u4f4d", (String)"InvoiceAllESpecialCheckService_39", (String)"imc-sim-common", (Object[])new Object[0]), name, amount));
        }
        String[] array = replacedStr.split("\\.");
        if (array[0].length() > 13) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a13\u4f4d", (String)"InvoiceAllESpecialCheckService_39", (String)"imc-sim-common", (Object[])new Object[0]), name, amount));
        }
    }

    private void checkAmountLength(BigDecimal amount, String msg, int num) {
        if (amount == null) {
            throw new MsgException(msg);
        }
        String inputValueStr = amount.stripTrailingZeros().toPlainString();
        if ((inputValueStr = inputValueStr.replace(".", "")).length() > num) {
            throw new MsgException(msg);
        }
    }

    private void checkAmountRule(BigDecimal amount, String msg) {
        if (amount == null) {
            throw new MsgException(msg);
        }
        try {
            Double.parseDouble(amount.toString());
        }
        catch (Exception e) {
            throw new MsgException(msg);
        }
    }

    public void allEOilCheck(BaseInvoice invoice) {
        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && !TaxUtils.isOilEnterpriseByTaxNo((String)invoice.getSalertaxno()) && "E01".equals(invoice.getSpecialtype())) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e0d\u662f\u6210\u54c1\u6cb9\u4f01\u4e1a\uff0c\u4e0d\u80fd\u5f00\u5177\u6210\u54c1\u6cb9\u7c7b\u660e\u7ec6\u53d1\u7968\u3002\u8bf7\u5728\u53d1\u7968\u4e91\u2192\u57fa\u7840\u8d44\u6599\u2192\u4f01\u4e1a\u7ba1\u7406\u4e2d\uff0c\u914d\u7f6e\u76f8\u5173\u8d44\u8d28", (String)"InvoiceAllESpecialCheckService_40", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        List invoiceItems = invoice.getInvoiceItemList();
        int index = 0;
        for (BaseInvoiceItem item : invoiceItems) {
            ++index;
            if (StringUtils.equals((CharSequence)item.getRowtype(), (CharSequence)"1") || !"E01".equals(invoice.getSpecialtype())) continue;
            String xmdw = item.getUnit();
            BigDecimal xmsl = item.getNum();
            if (StringUtils.isEmpty((CharSequence)xmdw) || !Arrays.asList(GoodsInfoConstant.getOilUnit()).contains(xmdw)) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u5355\u4f4d\"\u3002\u6210\u54c1\u6cb9\u53ea\u80fd\u4f7f\u7528\u201c\u5428\u201d\u6216\u201c\u5347\u201d\u4e3a\u5355\u4f4d\uff01", (String)"InvoiceAllESpecialCheckService_41", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if (null != xmsl && 0 != BigDecimal.valueOf(0L).compareTo(xmsl)) continue;
            throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u6570\u91cf\"\u3002\u6210\u54c1\u6cb9\u660e\u7ec6\u7684\"\u6570\u91cf\"\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\"0\"", (String)"InvoiceAllESpecialCheckService_42", (String)"imc-sim-common", (Object[])new Object[0])));
        }
    }

    public void allETobaccoCheck(BaseInvoice invoice) {
        boolean isTobaccoEnterprise = TaxUtils.isTobaccoEnterprise((String)invoice.getSalertaxno());
        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && !isTobaccoEnterprise) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), ResManager.loadKDString((String)"\u5f53\u524d\u4f01\u4e1a\u4e0d\u5177\u5907\u5377\u70df\u8d44\u8d28\uff0c\u8bf7\u5728\u53d1\u7968\u4e91\u2192\u57fa\u7840\u8d44\u6599\u2192\u4f01\u4e1a\u7ba1\u7406\u4e2d\uff0c\u914d\u7f6e\u76f8\u5173\u8d44\u8d28", (String)"InvoiceAllESpecialCheckService_43", (String)"imc-sim-common", (Object[])new Object[0])));
        }
    }

    public void dealCheckTravelerIsMatchMethod(List<BillTravlerInfoVo> travlerInfoList) {
        int row = 0;
        for (BillTravlerInfoVo billTravlerInfoVo : travlerInfoList) {
            String errorMsg;
            String cardType = billTravlerInfoVo.getCardType();
            String transportType = billTravlerInfoVo.getTransportType();
            String seatClass = billTravlerInfoVo.getSeatClass();
            ++row;
            TravelerCardTypeEnum travelerCardTypeEnum = TravelerCardTypeEnum.getByCode(cardType);
            if (travelerCardTypeEnum == null) {
                String errorMsg2 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%s\u884c\u7684\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (String)"InvoiceOriginalFormPlugin_51", (String)"imc-sim-formplugin", (Object[])new Object[0]), row);
                throw new MsgException(errorMsg2);
            }
            TransportTypeEnum transportTypeEnum = TransportTypeEnum.getByCode(transportType);
            if (transportTypeEnum == null) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%s\u884c\u7684\u4ea4\u901a\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (String)"InvoiceOriginalFormPlugin_52", (String)"imc-sim-formplugin", (Object[])new Object[0]), row);
                throw new MsgException(errorMsg);
            }
            if (!TransportTypeEnum.FLIGHT.getCode().equals(transportType) && !TransportTypeEnum.TRAIN.getCode().equals(transportType) && !TransportTypeEnum.SHIP.getCode().equals(transportType)) continue;
            if (StringUtils.isBlank((CharSequence)seatClass)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%s\u884c\u7684\u5ea7\u4f4d\u7b49\u7ea7\u4e3a\u7a7a\uff01", (String)"InvoiceOriginalFormPlugin_49", (String)"imc-sim-formplugin", (Object[])new Object[0]), row);
                throw new MsgException(errorMsg);
            }
            List<String> list = SeatClassTypeEnum.getSeatClassNameByCode(transportType);
            if (list.contains(seatClass)) continue;
            String errorMsg3 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%s\u884c\u7684\u4ea4\u901a\u5de5\u5177\u7c7b\u4e0e\u5ea7\u4f4d\u7b49\u7ea7\u4e24\u8005\u4e0d\u5339\u914d\uff01", (String)"InvoiceOriginalFormPlugin_50", (String)"imc-sim-formplugin", (Object[])new Object[0]), row);
            throw new MsgException(errorMsg3);
        }
    }

    public void allEVesselVehicheCheck(BaseInvoice baseInvoice) {
        String invoiceType = baseInvoice.getInvoicetype();
        if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u7279\u6b8a\u7968\u79cd\u53ea\u5141\u8bb8\u5f00\u5177\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", (String)"BillValidaterHelper_131", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        this.dealCheckInvoiceItemMethod(baseInvoice.getBillno(), baseInvoice.getInvoiceItemList());
        this.dealCheckVesselVehicheItemMethod(baseInvoice.getBillno(), baseInvoice.getVehicheVesselShipList());
    }

    private void dealCheckInvoiceItemMethod(String billNo, List<BaseInvoiceItem> invoiceItemList) {
        if (invoiceItemList == null || invoiceItemList.size() == 0) {
            return;
        }
        for (BaseInvoiceItem baseInvoiceItem : invoiceItemList) {
            String unit = baseInvoiceItem.getUnit();
            String rowtype = baseInvoiceItem.getRowtype();
            if (!"0".equals(rowtype) && !"2".equals(rowtype) || "\u8f86".equals(unit)) continue;
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"InvoiceAllESpecialCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), billNo));
        }
    }

    public void dealCheckVesselVehicheItemMethod(String billNo, List<BillVehicheVesselShipVo> vehicheVesselShipList) {
        if (vehicheVesselShipList == null || vehicheVesselShipList.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u7c7b\u578b\u4e3a\uff1a\u4ee3\u6536\u8f66\u8239\u7a0e\u65f6\uff0c\u660e\u7ec6\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!", (String)"BillValidaterHelper_134", (String)"imc-sim-service", (Object[])new Object[0]), billNo));
        }
        if (vehicheVesselShipList.size() > 1) {
            throw new MsgException(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u5206\u5f55\u6570\u636e\u53ea\u9650\u4e00\u884c", (String)"BillValidaterHelper_130", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        String templateErrorType = InvoiceCheckService.BILL_ERROR_TEMPLATE();
        for (int i = 0; i < vehicheVesselShipList.size(); ++i) {
            BillVehicheVesselShipVo billVehicheVesselShipVo = vehicheVesselShipList.get(i);
            int seq = i + 1;
            String policyNoError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4fdd\u9669\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_99", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billVehicheVesselShipVo.getPolicyNo(), String.format(templateErrorType, billNo, policyNoError));
            String policyNoLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4fdd\u9669\u5355\u53f7\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_100", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billVehicheVesselShipVo.getPolicyNo(), 40, String.format(templateErrorType, billNo, policyNoLenError));
            String shipsNoError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_101", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billVehicheVesselShipVo.getShipsNo(), String.format(templateErrorType, billNo, shipsNoError));
            String shipsNoLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_102", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billVehicheVesselShipVo.getShipsNo(), 40, String.format(templateErrorType, billNo, shipsNoLenError));
            String periodStartDateError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_118", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            if (billVehicheVesselShipVo.getPeriodStartDate() == null) {
                throw new MsgException(String.format(templateErrorType, billNo, periodStartDateError));
            }
            String periodEndDateError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_119", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            if (billVehicheVesselShipVo.getPeriodEndDate() == null) {
                throw new MsgException(String.format(templateErrorType, billNo, periodEndDateError));
            }
            String periodDate = DateUtils.format((Date)billVehicheVesselShipVo.getPeriodStartDate(), (String)"yyyy-MM") + " " + DateUtils.format((Date)billVehicheVesselShipVo.getPeriodEndDate(), (String)"yyyy-MM");
            String periodDateError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_103", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(periodDate, String.format(templateErrorType, billNo, periodDateError));
            String periodDateLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662f\uff1ayyyy-MM+\u7a7a\u683c+yyyy-MM", (String)"InvoiceAllESpecialCheckService_104", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkFormat(periodDate, String.format(templateErrorType, billNo, periodDateLenError));
            String periodDateComparedError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u591f\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"InvoiceAllESpecialCheckService_113", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkComparedDate(periodDate, String.format(templateErrorType, billNo, periodDateComparedError));
            String vehicelCodeError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8f66\u8f86\u8bc6\u522b\u4ee3\u7801/\u8f66\u67b6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_105", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billVehicheVesselShipVo.getVehicleCode(), String.format(templateErrorType, billNo, vehicelCodeError));
            String vehicelCodeLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8f66\u8f86\u8bc6\u522b\u4ee3\u7801/\u8f66\u67b6\u53f7\u7801\u4e0d\u80fd\u8d85\u8fc717\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_106", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billVehicheVesselShipVo.getVehicleCode(), 17, String.format(templateErrorType, billNo, vehicelCodeLenError));
            String vehicleVesselAmountError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_107", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkAmountNull(billVehicheVesselShipVo.getVehicleVesselAmount(), String.format(templateErrorType, billNo, vehicleVesselAmountError));
            String amountError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceAllESpecialCheckService_115", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            this.checkAmountRule(billVehicheVesselShipVo.getVehicleVesselAmount(), String.format(templateErrorType, billNo, amountError));
            String vehicleVesselAmountLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d\u4e0d\u80fd\u591f\u8d85\u8fc713\u4f4d", (String)"InvoiceAllESpecialCheckService_108", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            this.checkAmountLength(billVehicheVesselShipVo.getVehicleVesselAmount(), String.format(templateErrorType, billNo, vehicleVesselAmountLenError), 13);
            String vehicleLateAmountError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6ede\u7eb3\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_109", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkAmountNull(billVehicheVesselShipVo.getVehicleLateAmount(), String.format(templateErrorType, billNo, vehicleLateAmountError));
            String amountError2 = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6ede\u7eb3\u91d1\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceAllESpecialCheckService_116", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            this.checkAmountRule(billVehicheVesselShipVo.getVehicleVesselAmount(), String.format(templateErrorType, billNo, amountError2));
            String vehicleLateAmountLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6ede\u7eb3\u91d1\u91d1\u989d\u4e0d\u80fd\u591f\u8d85\u8fc713\u4f4d", (String)"InvoiceAllESpecialCheckService_110", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            this.checkAmountLength(billVehicheVesselShipVo.getVehicleLateAmount(), String.format(templateErrorType, billNo, vehicleLateAmountLenError), 13);
            String totalAmountError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_111", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkAmountNull(billVehicheVesselShipVo.getVehicleTotalAmount(), String.format(templateErrorType, billNo, totalAmountError));
            String amountError3 = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5408\u8ba1\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", (String)"InvoiceAllESpecialCheckService_117", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            this.checkAmountRule(billVehicheVesselShipVo.getVehicleVesselAmount(), String.format(templateErrorType, billNo, amountError3));
            String totalAmountLenError = String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u8f66\u8239\u7a0e\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u591f\u8d85\u8fc713\u4f4d", (String)"InvoiceAllESpecialCheckService_112", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            this.checkAmountLength(billVehicheVesselShipVo.getVehicleTotalAmount(), String.format(templateErrorType, billNo, totalAmountLenError), 13);
        }
    }

    public void allETravlerCheck(BaseInvoice invoice) {
        List invoiceItemList = invoice.getInvoiceItemList();
        if (invoiceItemList != null && invoiceItemList.stream().filter(invoiceItem -> "0".equals(invoiceItem.getRowtype())).count() > 1L) {
            throw new MsgException(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"BillValidaterHelper_129", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        this.dealCheckTravelerItemMethod(invoice.getBillno(), invoice.getTravelerList());
    }

    public void dealCheckTravelerItemMethod(String billNo, List<BillTravlerInfoVo> travlerInfoList) {
        if (travlerInfoList == null || travlerInfoList.size() == 0) {
            return;
        }
        int num = 0;
        for (BillTravlerInfoVo billTravlerInfoVo : travlerInfoList) {
            String traveler = billTravlerInfoVo.getTraveler();
            String startPlace = billTravlerInfoVo.getStartPlace();
            String endPlace = billTravlerInfoVo.getEndPlace();
            String transportType = billTravlerInfoVo.getTransportType();
            String cardNo = billTravlerInfoVo.getCardNo();
            String cardType = billTravlerInfoVo.getCardType();
            String seatClass = billTravlerInfoVo.getSeatClass();
            String travelDate = billTravlerInfoVo.getTravelDate();
            String[] array = new String[]{traveler, cardType, cardNo, travelDate, startPlace, endPlace, transportType, seatClass};
            int count = 0;
            for (String element : array) {
                if (!StringUtils.isBlank((CharSequence)element)) continue;
                ++count;
            }
            if (array.length != count) continue;
            ++num;
        }
        if (travlerInfoList.size() == num && num > 0) {
            return;
        }
        String templateErrorType = InvoiceCheckService.BILL_ERROR_TEMPLATE();
        for (int i = 0; i < travlerInfoList.size(); ++i) {
            BillTravlerInfoVo billTravlerInfoVo = travlerInfoList.get(i);
            int seq = i + 1;
            String travlerError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_44", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getTraveler(), String.format(templateErrorType, billNo, travlerError));
            String travlerLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_45", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getTraveler(), 20, String.format(templateErrorType, billNo, travlerLenError));
            String cardTypeError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_46", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getCardType(), String.format(templateErrorType, billNo, cardTypeError));
            String cardTypeLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_47", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getCardType(), 20, String.format(templateErrorType, billNo, cardTypeLenError));
            String cardNoError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_48", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getCardNo(), String.format(templateErrorType, billNo, cardNoError));
            String cardNoLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_49", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getCardNo(), 20, String.format(templateErrorType, billNo, cardNoLenError));
            String travelDateError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_50", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getTravelDate(), String.format(templateErrorType, billNo, travelDateError));
            String travelDateLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_51", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getTravelDate(), 40, String.format(templateErrorType, billNo, travelDateLenError));
            String startPlaceError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u53d1\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_52", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getStartPlace(), String.format(templateErrorType, billNo, startPlaceError));
            String startPlaceLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u53d1\u5730\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_53", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getStartPlace(), 80, String.format(templateErrorType, billNo, startPlaceLenError));
            String endPlaceError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5230\u8fbe\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_54", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getEndPlace(), String.format(templateErrorType, billNo, endPlaceError));
            String endPlaceLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5230\u8fbe\u5730\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_55", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getEndPlace(), 80, String.format(templateErrorType, billNo, endPlaceLenError));
            String transportTypeError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ea4\u901a\u5de5\u5177\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_56", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getTransportType(), String.format(templateErrorType, billNo, transportTypeError));
            String transportTypeLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ea4\u901a\u5de5\u5177\u7c7b\u578b\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_57", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getTransportType(), 80, String.format(templateErrorType, billNo, transportTypeLenError));
            String transportType = billTravlerInfoVo.getTransportType();
            if (!TransportTypeEnum.FLIGHT.getCode().equals(transportType) && !TransportTypeEnum.TRAIN.getCode().equals(transportType) && !TransportTypeEnum.SHIP.getCode().equals(transportType)) continue;
            String seatClassError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_58", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull(billTravlerInfoVo.getSeatClass(), String.format(templateErrorType, billNo, seatClassError));
            String seatClassLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7b49\u7ea7\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_59", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen(billTravlerInfoVo.getSeatClass(), 20, String.format(templateErrorType, billNo, seatClassLenError));
        }
        this.dealCheckTravelerIsMatchMethod(travlerInfoList);
    }

    public void allEVehicleCheck(BaseInvoice invoice) {
        if (!InvoiceUtils.isAllESpecialInvoice((String)invoice.getInvoicetype())) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u53ea\u53ef\u5f00\u5177\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"InvoiceAllESpecialCheckService_65", (String)"imc-sim-common", (Object[])new Object[0]), invoice.getBillno()));
        }
        List invoiceItems = invoice.getInvoiceItemList();
        int index = 0;
        for (BaseInvoiceItem item : invoiceItems) {
            ++index;
            if (StringUtils.equals((CharSequence)item.getRowtype(), (CharSequence)"1") || !"E14".equals(invoice.getSpecialtype())) continue;
            String xmdw = item.getUnit();
            BigDecimal xmsl = item.getNum();
            BigDecimal xmdj = item.getUnitprice();
            if (StringUtils.isEmpty((CharSequence)xmdw) || !Arrays.asList(GoodsInfoConstant.getVehicleUnit()).contains(xmdw)) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u5355\u4f4d\"\u3002\u673a\u52a8\u8f66\u53ea\u80fd\u4f7f\u7528\u201c\u8f86\u201d\uff01", (String)"InvoiceAllESpecialCheckService_61", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if (null == xmsl || 0 == BigDecimal.valueOf(0L).compareTo(xmsl)) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u6570\u91cf\"\u3002\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\"0\"", (String)"InvoiceAllESpecialCheckService_62", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if (xmsl.stripTrailingZeros().scale() > 0) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u6570\u91cf\"\u3002\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570", (String)"InvoiceAllESpecialCheckService_63", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if (null != xmdj && 0 > BigDecimal.valueOf(0L).compareTo(xmdj)) continue;
            throw new MsgException(String.format(InvoiceCheckService.BILL_ITEM_ERROR_TEMPLATE(), invoice.getBillno(), index, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u5355\u4ef7\"\u3002\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u5355\u4ef7\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"InvoiceAllESpecialCheckService_64", (String)"imc-sim-common", (Object[])new Object[0])));
        }
    }
}

