/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.service.IssueInvoiceService;

public class VehicleInvoiceAddService {
    private static final Log LOGGER = LogFactory.getLog(VehicleInvoiceAddService.class);

    public static MsgResponse VehicleInvoiceAddService(JSONObject insertJSON) {
        long start = System.currentTimeMillis();
        MsgResponse response = new MsgResponse();
        LOGGER.info("VehicleInvoiceAddServiceVehicleInvoiceAddServiceJSON:" + insertJSON);
        try {
            DynamicObject vehicleDy = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_vehicles");
            VehicleInvoiceAddService.dealWithVehicleDynamic(vehicleDy, insertJSON);
            VehicleInvoiceAddService.checkExistAndUpdateOrInsert(vehicleDy);
            response.setErrorCode(ErrorType.SUCCESS.getCode());
            response.setErrorMsg(ErrorType.SUCCESS.getName());
            response.setMsgId(vehicleDy.getString("billno"));
        }
        catch (Exception e) {
            LOGGER.error("VehicleInvoiceAddServiceAddInvoiceFail:", (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(String.valueOf(e.getMessage()));
            return response;
        }
        long end = System.currentTimeMillis();
        LOGGER.info("VehicleInvoiceAddServiceTime:" + (end - start));
        return response;
    }

    private static void checkExistAndUpdateOrInsert(DynamicObject vehicle) {
        QFilter filter = new QFilter("invoicecode", "=", (Object)vehicle.getString("invoicecode")).and("invoiceno", "=", (Object)vehicle.getString("invoiceno"));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)"id", (QFilter[])filter.toArray());
        if (ids.length > 0) {
            DeleteServiceHelper.delete((String)"sim_vatinvoice_vehicles", (QFilter[])filter.toArray());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{vehicle});
    }

    private static void dealWithVehicleDynamic(DynamicObject vehicle, JSONObject insertJSON) {
        vehicle.set("vehicleidcode", (Object)insertJSON.getString("vehicleIdentificationCode"));
        vehicle.set("salername", (Object)insertJSON.getString("salerName"));
        vehicle.set("salerphone", (Object)insertJSON.getString("salerPhone"));
        vehicle.set("limitepeople", (Object)insertJSON.getString("limitePeople"));
        vehicle.set("proxymark", (Object)insertJSON.getString("proxyMark"));
        vehicle.set("brandmodel", (Object)insertJSON.getString("brandModel"));
        vehicle.set("invoiceamount", (Object)insertJSON.getBigDecimal("invoiceAmount"));
        vehicle.set("issuetype", (Object)insertJSON.getString("type"));
        vehicle.set("overtaxcode", (Object)insertJSON.getString("overTaxCode"));
        vehicle.set("buyercardno", (Object)insertJSON.getString("buyerCardno"));
        vehicle.set("salertaxno", (Object)insertJSON.getString("salerTaxNo"));
        vehicle.set("salerbankname", (Object)insertJSON.getString("salerBankName"));
        vehicle.set("invoicetype", (Object)InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
        vehicle.set("producingarea", (Object)insertJSON.getString("producingArea"));
        vehicle.set("invoiceno", (Object)insertJSON.getString("invoiceNo"));
        vehicle.set("vehicletype", (Object)insertJSON.getString("vehicleType"));
        vehicle.set("taxauthoritycode", (Object)insertJSON.getString("taxAuthorityCode"));
        vehicle.set("saleraccount", (Object)insertJSON.getString("salerAccount"));
        vehicle.set("importcertificate", (Object)insertJSON.getString("importCertificate"));
        vehicle.set("buyertaxno", (Object)insertJSON.getString("buyerTaxNo"));
        vehicle.set("commodityinspectionnum", (Object)insertJSON.getString("commodityInspectionNum"));
        vehicle.set("enginenum", (Object)insertJSON.getString("engineNum"));
        vehicle.set("buyername", (Object)insertJSON.getString("buyerName"));
        vehicle.set("invoicecode", (Object)insertJSON.getString("invoiceCode"));
        vehicle.set("orgid", (Object)insertJSON.getString("orgid"));
        vehicle.set("saleraddress", (Object)insertJSON.getString("salerAddress"));
        vehicle.set("totalamount", (Object)insertJSON.getBigDecimal("totalAmount"));
        vehicle.set("taxrate", (Object)insertJSON.getString("taxRate"));
        vehicle.set("totalton", (Object)insertJSON.getString("totalTon"));
        vehicle.set("invoicestatus", (Object)insertJSON.getString("invoiceStatus"));
        vehicle.set("totaltax", (Object)insertJSON.getBigDecimal("totalTaxAmount"));
        vehicle.set("taxauthorityname", (Object)insertJSON.getString("taxAuthorityName"));
        vehicle.set("checkcode", (Object)insertJSON.getString("checkCode"));
        vehicle.set("remark", (Object)insertJSON.getString("remark"));
        vehicle.set("drawer", (Object)insertJSON.getString("drawer"));
        vehicle.set("jqbh", (Object)insertJSON.getString("machineNo"));
        vehicle.set("originalinvoicecode", (Object)insertJSON.getString("originalInvoiceCode"));
        vehicle.set("originalinvoiceno", (Object)insertJSON.getString("originalInvoiceNo"));
        vehicle.set("billno", (Object)("600_" + UUID.getBatchNumber() + "_0001"));
        vehicle.set("certificatenum", (Object)insertJSON.getString("certificateNum"));
        vehicle.set("producingname", (Object)insertJSON.getString("producingName"));
        vehicle.set("goodscode", (Object)insertJSON.getString("goodsCode"));
        vehicle.set("zerotaxmark", (Object)insertJSON.getString("zeroTaxRateFlag"));
        vehicle.set("taxpremark", (Object)insertJSON.getString("preferentialPolicy"));
        vehicle.set("zzstsgl", (Object)insertJSON.getString("vatException"));
        vehicle.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        vehicle.set("billsource", (Object)"1");
        IssueInvoiceService.updateTaxOrg(vehicle);
        if (StringUtils.isNotBlank((CharSequence)insertJSON.getString("invoiceDate"))) {
            vehicle.set("issuetime", (Object)insertJSON.getDate("invoiceDate"));
        }
        if (StringUtils.isNotBlank((CharSequence)insertJSON.getString("invalidDate"))) {
            Date invalidDate = DateUtils.stringToDate((String)insertJSON.getString("invalidDate"), (String)"yyyy-MM-dd");
            vehicle.set("invaliddate", (Object)invalidDate);
        }
        vehicle.set("createtime", (Object)new Date());
    }
}

