/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WideInvoiceSevice {
    private static Log logger = LogFactory.getLog(WideInvoiceSevice.class);
    public static String WIDE_INVOICE = "sim_wide_invoice";
    public static String WIDE_CONFIG = "sim_wide_config";
    private static String STOP_FLAG = "InvoiceWideTableSeviceStop";

    public static boolean isWideTable(String taxNo) {
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return false;
        }
        return QueryServiceHelper.exists((String)WIDE_CONFIG, (QFilter[])new QFilter("salertaxno", "=", (Object)taxNo).and("status", "=", (Object)"1").toArray());
    }

    public static void addInvoiceToWide(DynamicObject invoice) {
        try {
            if (!WideInvoiceSevice.isWideTable(invoice.getString("salertaxno"))) {
                return;
            }
            if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype")) || !IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                return;
            }
            if ("3".equals(invoice.getString("invoicestatus")) || "3".equals(invoice.getString("invoicestatus"))) {
                WideInvoiceSevice.delete(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
                return;
            }
            ArrayList<Long> invoiceIdList = new ArrayList<Long>(1);
            invoiceIdList.add(BigDecimalUtil.transDecimal((Object)invoice.get("id")).longValue());
            WideInvoiceSevice.insertToWide(invoiceIdList);
        }
        catch (Exception e) {
            logger.error("\u53d1\u7968\u63d2\u5165\u5bbd\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    private static void delete(String invoiceCode, String invoiceNo) {
        String longNumber = WideInvoiceSevice.getInvoiceLontNumber(invoiceCode, invoiceNo);
        QFilter deleteQfilter = new QFilter("longnumber", "=", (Object)longNumber);
        DeleteServiceHelper.delete((String)WIDE_INVOICE, (QFilter[])deleteQfilter.toArray());
    }

    public static Long insertToWide(List<Long> idList) {
        Set<String> wideSet = WideInvoiceSevice.getWideFieldSet();
        DynamicObjectCollection invoiceCollect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)WideInvoiceSevice.getWideTableAddFields(wideSet), (QFilter[])new QFilter("id", "in", idList).toArray());
        if (CollectionUtils.isEmpty((Collection)invoiceCollect)) {
            return 0L;
        }
        HashMap<String, String> valFieldMap = new HashMap<String, String>(1);
        DataEntityPropertyCollection properties = invoiceCollect.getDynamicObjectType().getProperties();
        for (IDataEntityProperty subproperty : properties) {
            valFieldMap.put(subproperty.getName(), "1");
        }
        ArrayList<DynamicObject> wideInvoiceList = new ArrayList<DynamicObject>(invoiceCollect.size());
        HashSet<String> longNumberSet = new HashSet<String>(8);
        long maxInvoiceId = 0L;
        for (DynamicObject invoice : invoiceCollect) {
            if ("1".equals(invoice.getString("rowtype")) || invoice.getInt("itemseq") != 0 && invoice.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) <= 0) continue;
            long invoiceId = invoice.getLong("invoiceid");
            if (invoiceId > maxInvoiceId) {
                maxInvoiceId = invoiceId;
            }
            DynamicObject wideInvoice = BusinessDataServiceHelper.newDynamicObject((String)WIDE_INVOICE);
            for (String field : wideSet) {
                if (valFieldMap.get(field) == null) continue;
                wideInvoice.set(field, invoice.get(field));
            }
            String longNumber = WideInvoiceSevice.getInvoiceLontNumber(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
            wideInvoice.set("longnumber", (Object)longNumber);
            longNumberSet.add(longNumber);
            wideInvoiceList.add(wideInvoice);
        }
        QFilter deleteQfilter = new QFilter("longnumber", "in", longNumberSet);
        DeleteServiceHelper.delete((String)WIDE_INVOICE, (QFilter[])deleteQfilter.toArray());
        SaveServiceHelper.save((DynamicObject[])wideInvoiceList.toArray(new DynamicObject[0]));
        return maxInvoiceId;
    }

    private static String getInvoiceLontNumber(String invoiceCode, String invoiceNo) {
        return StringUtils.trimToEmpty((String)invoiceCode) + StringUtils.trimToEmpty((String)invoiceNo);
    }

    public static void dealOneWideInvoiceOccupyStatus(DynamicObject invoice) {
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
        invoiceList.add(invoice);
        WideInvoiceSevice.dealWideInvoiceOccupyStatus(invoiceList);
    }

    public static void dealWideInvoiceOccupyStatus(List<DynamicObject> invoices) {
        if (invoices.size() == 0) {
            return;
        }
        boolean isInvoice = "sim_vatinvoice".equals(invoices.get(0).getDataEntityType().getName());
        if (!isInvoice) {
            return;
        }
        HashMap<Long, DynamicObject> invoiceIdInvoiceMap = new HashMap<Long, DynamicObject>();
        ArrayList itemIdList = new ArrayList();
        ArrayList<Long> currentIdList = new ArrayList<Long>();
        Set invoiceIdSet = invoices.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] dbInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"salertaxno,items.id", (QFilter[])new QFilter("id", "in", invoiceIdSet).toArray());
        for (DynamicObject dynamicObject : invoices) {
            invoiceIdInvoiceMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (DynamicObject invoice : dbInvoices) {
            DynamicObjectCollection items2 = invoice.getDynamicObjectCollection("items");
            for (DynamicObject item : items2) {
                currentIdList.add(item.getLong("id"));
            }
            if (currentIdList.size() <= 200000) continue;
            itemIdList.add(currentIdList);
            currentIdList = new ArrayList();
        }
        if (currentIdList.size() > 0) {
            itemIdList.add(currentIdList);
        }
        if (dbInvoices.length > 0 && WideInvoiceSevice.isWideTable(dbInvoices[0].getString("salertaxno"))) {
            for (List list : itemIdList) {
                DynamicObject[] wides;
                for (DynamicObject wide : wides = BusinessDataServiceHelper.load((String)WIDE_INVOICE, (String)"invoiceid,occupystatus", (QFilter[])new QFilter("id", "in", (Object)list).toArray())) {
                    DynamicObject invoice = (DynamicObject)invoiceIdInvoiceMap.get(wide.getLong("invoiceid"));
                    if (null == invoice) continue;
                    wide.set("occupystatus", (Object)invoice.getString("occupystatus"));
                }
                if (wides.length <= 0) continue;
                ImcSaveServiceHelper.save((DynamicObject[])wides);
            }
        }
    }

    private static Set<String> getWideFieldSet() {
        HashSet<String> wideSet = new HashSet<String>();
        MainEntityType mainEntityType1 = EntityMetadataCache.getDataEntityType((String)WIDE_INVOICE);
        DataEntityPropertyCollection collect = mainEntityType1.getProperties();
        for (IDataEntityProperty property : collect) {
            wideSet.add(property.getName());
        }
        return wideSet;
    }

    private static String getWideTableAddFields(Set<String> wideSet) {
        MainEntityType invoiceMainEntityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        DataEntityPropertyCollection invoicepropertys = invoiceMainEntityType.getProperties();
        HashMap<String, String> allMap = new HashMap<String, String>(16);
        for (IDataEntityProperty property : invoicepropertys) {
            if (property instanceof EntryProp) {
                if (!"items".equals(property.getName())) continue;
                EntryProp items2 = (EntryProp)property;
                DynamicObjectType dynamicObjectType = items2.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                for (IDataEntityProperty subproperty : properties) {
                    allMap.put(subproperty.getName(), "items");
                }
                continue;
            }
            allMap.put(property.getName(), "main");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("id as invoiceid,items.id as id,items.seq as itemseq");
        for (String field : wideSet) {
            if ("id".equals(field)) continue;
            String type = (String)allMap.get(field);
            if ("items".equals(type)) {
                sb.append(",items.").append(field).append(" as ").append(field);
                continue;
            }
            if (!"main".equals(type)) continue;
            sb.append(',').append(field);
        }
        return sb.toString();
    }

    public static void stopMigrate() {
        CacheHelper.put((String)STOP_FLAG, (String)"1", (int)180);
    }

    public static void invoiceMigrate(String taxNo) {
        QFilter filter = new QFilter("salertaxno", "=", (Object)taxNo);
        DynamicObject obj = QueryServiceHelper.queryOne((String)WIDE_CONFIG, (String)"id,datadate,salertaxno,pagesize,invoiceid", (QFilter[])filter.toArray());
        if (obj != null) {
            CacheHelper.remove((String)STOP_FLAG);
            Date dataDate = obj.getDate("datadate");
            if (dataDate == null || dataDate.compareTo(new Date()) > 0) {
                logger.info("\u65f6\u95f4\u8303\u56f4\u9519\u8bef");
                return;
            }
            Date startDate = DateUtils.trunc((Date)dataDate);
            Date maxDate = DateUtils.addDay((Date)DateUtils.trunc((Date)new Date()), (int)1);
            Long maxId = obj.getLong("invoiceid");
            int pageSize = obj.getInt("pagesize");
            DynamicObject configUpdate = BusinessDataServiceHelper.newDynamicObject((String)WIDE_CONFIG);
            configUpdate.set("id", obj.get("id"));
            while (startDate.compareTo(maxDate) < 0) {
                List<Long> list;
                Date endDate = DateUtils.addDay((Date)startDate, (int)1);
                int times = 0;
                do {
                    if (CacheHelper.get((String)STOP_FLAG) != null) {
                        return;
                    }
                    list = WideInvoiceSevice.queryInoiceId(taxNo, startDate, endDate, maxId, pageSize);
                    if (list.size() > 0) {
                        maxId = WideInvoiceSevice.insertToWide(list);
                        logger.info("\u5bbd\u8868\u6570\u636e\u8fc1\u79fb{},{},{},{}", new Object[]{taxNo, maxId, DateUtils.format((Date)startDate), times++});
                    }
                    configUpdate.set("invoiceid", (Object)maxId);
                    if (list.size() < pageSize) {
                        configUpdate.set("datadate", (Object)endDate);
                        configUpdate.set("invoiceid", (Object)0L);
                    }
                    SaveServiceHelper.update((DynamicObject)configUpdate);
                } while (list.size() >= pageSize);
                maxId = 0L;
                startDate = endDate;
            }
        }
    }

    private static List<Long> queryInoiceId(String taxNo, Date startDate, Date endDate, Long maxId, int pageSize) {
        QFilter filter1 = new QFilter("salertaxno", "=", (Object)taxNo);
        QFilter filter2 = new QFilter("issuetime", ">=", (Object)startDate);
        QFilter filter3 = new QFilter("issuetime", "<", (Object)endDate);
        QFilter filter4 = new QFilter("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        QFilter filter5 = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
        QFilter filter6 = new QFilter("invoicestatus", "not in", (Object)new String[]{"6", "3"});
        QFilter filter7 = new QFilter("id", ">", (Object)maxId);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4, filter5, filter6, filter7}, (String)"id", (int)pageSize);
        ArrayList<Long> list = new ArrayList<Long>(pageSize);
        for (DynamicObject obj : collect) {
            list.add(obj.getLong("id"));
        }
        return list;
    }
}

