/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.dto.FillInInvoiceDTO;
import kd.imc.sim.common.dto.FillInInvoiceRequestDTO;
import kd.imc.sim.common.dto.FillInInvoiceResponseDTO;
import kd.imc.sim.common.model.bill.FillInBIllItemVo;
import kd.imc.sim.common.model.bill.FillInBillVo;
import kd.imc.sim.common.service.FillInInvoiceService;

public class InvoiceFillinServiceImpl
implements FillInInvoiceService {
    @Override
    public boolean support(FillInInvoiceRequestDTO request) {
        return true;
    }

    @Override
    public FillInInvoiceResponseDTO fillInInvoice2Original(FillInInvoiceRequestDTO request) {
        FillInBIllItemVo item;
        List<FillInInvoiceDTO> invs = request.getInvs();
        List<DynamicObject> bills = request.getBills();
        ArrayList<FillInBillVo> listFillVos = new ArrayList<FillInBillVo>(bills.size());
        BigDecimal totalInvInvoiceAmount = BigDecimal.ZERO;
        BigDecimal totalInvTax = BigDecimal.ZERO;
        for (FillInInvoiceDTO inv : invs) {
            totalInvInvoiceAmount = totalInvInvoiceAmount.add(inv.getInvoiceAmount());
            totalInvTax = totalInvTax.add(inv.getTotalTax());
        }
        boolean isBlueFillIn = BigDecimalUtil.greaterZero((BigDecimal)totalInvInvoiceAmount);
        BigDecimal billTotalAmountAll = BigDecimal.ZERO;
        BigDecimal billTotalAmountAllExcludeDiscount = BigDecimal.ZERO;
        BigDecimal billTotalAmount = BigDecimal.ZERO;
        BigDecimal billTotalTaxAll = BigDecimal.ZERO;
        BigDecimal billTotalTaxAllExcludeDiscount = BigDecimal.ZERO;
        BigDecimal billTotalTax = BigDecimal.ZERO;
        for (DynamicObject bill : bills) {
            FillInBillVo billVo = (FillInBillVo)DynamicObjectUtil.dynamicObject2Bean(FillInBillVo.class, (DynamicObject)bill);
            DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
            boolean isFrom = CurrencyHelper.isFrom((Object)fromCurr);
            billVo.setFrom(isFrom);
            listFillVos.add(billVo);
            billTotalAmount = billTotalAmount.add(bill.getBigDecimal("totalamount"));
            billTotalTax = billTotalTax.add(bill.getBigDecimal("totaltax"));
            DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < items2.size(); ++i) {
                item = (DynamicObject)items2.get(i);
                BigDecimal amount = item.getBigDecimal("amount");
                String rowType = item.getString("rowtype");
                boolean isDiscountRow = "1".equalsIgnoreCase(rowType);
                boolean isDiscountedRow = false;
                if (i + 1 < items2.size()) {
                    DynamicObject nextRow = (DynamicObject)items2.get(i + 1);
                    String nextRowType = nextRow.getString("rowtype");
                    isDiscountedRow = "1".equalsIgnoreCase(nextRowType);
                }
                if (isBlueFillIn && BigDecimalUtil.lessZero((BigDecimal)amount) && !isDiscountRow) {
                    totalInvInvoiceAmount = totalInvInvoiceAmount.subtract(item.getBigDecimal("amount"));
                    totalInvTax = totalInvTax.subtract(item.getBigDecimal("tax"));
                    billTotalAmountAll = billTotalAmountAll.subtract(item.getBigDecimal("amount"));
                    billTotalTaxAll = billTotalTaxAll.subtract(item.getBigDecimal("tax"));
                    continue;
                }
                if (!isBlueFillIn && BigDecimalUtil.greaterZero((BigDecimal)amount) && !isDiscountedRow) {
                    totalInvInvoiceAmount = totalInvInvoiceAmount.subtract(item.getBigDecimal("amount"));
                    totalInvTax = totalInvTax.subtract(item.getBigDecimal("tax"));
                    billTotalAmountAll = billTotalAmountAll.subtract(item.getBigDecimal("amount"));
                    billTotalTaxAll = billTotalTaxAll.subtract(item.getBigDecimal("tax"));
                    continue;
                }
                billTotalAmountAll = billTotalAmountAll.add(item.getBigDecimal("amount"));
                billTotalTaxAll = billTotalTaxAll.add(item.getBigDecimal("tax"));
                billTotalAmountAllExcludeDiscount = billTotalAmountAllExcludeDiscount.add(item.getBigDecimal("amount"));
                billTotalTaxAllExcludeDiscount = billTotalTaxAllExcludeDiscount.add(item.getBigDecimal("tax"));
            }
        }
        boolean isEqualsAmountTax = totalInvInvoiceAmount.compareTo(billTotalAmount) == 0 && totalInvTax.compareTo(billTotalTax) == 0;
        BigDecimal allocatedAmount = BigDecimal.ZERO;
        BigDecimal allocatedTax = BigDecimal.ZERO;
        if (!isEqualsAmountTax) {
            int i;
            FillInBIllItemVo lastNotRedRow = new FillInBIllItemVo();
            FillInBillVo fillInBillVo = (FillInBillVo)listFillVos.get(listFillVos.size() - 1);
            for (i = fillInBillVo.getItems().size() - 1; i >= 0; --i) {
                List<FillInBIllItemVo> items3 = fillInBillVo.getItems();
                item = items3.get(i);
                String rowType = item.getRowType();
                boolean isDiscountRow = "1".equalsIgnoreCase(rowType);
                BigDecimal amount = item.getAmount();
                if (isBlueFillIn && BigDecimalUtil.greaterZero((BigDecimal)amount) || isDiscountRow) {
                    lastNotRedRow = item;
                    break;
                }
                if (isBlueFillIn || !BigDecimalUtil.lessZero((BigDecimal)amount)) continue;
                lastNotRedRow = item;
                break;
            }
            for (i = 0; i < listFillVos.size(); ++i) {
                FillInBillVo fillVo = (FillInBillVo)listFillVos.get(i);
                List<FillInBIllItemVo> items4 = fillVo.getItems();
                for (int j = 0; j < items4.size(); ++j) {
                    BigDecimal allocateTax;
                    BigDecimal allocateAmount;
                    FillInBIllItemVo item2 = items4.get(j);
                    BigDecimal amount = item2.getAmount();
                    BigDecimal tax = item2.getTax();
                    String rowType = item2.getRowType();
                    boolean isDiscountedRow = false;
                    if (j + 1 < items4.size()) {
                        FillInBIllItemVo nextRow = items4.get(j + 1);
                        String nextRowType = nextRow.getRowType();
                        isDiscountedRow = "1".equalsIgnoreCase(nextRowType);
                    }
                    boolean isDiscountRow = "1".equalsIgnoreCase(rowType);
                    if (Objects.equals(lastNotRedRow.getItemPk(), item2.getItemPk())) {
                        allocateAmount = totalInvInvoiceAmount.subtract(allocatedAmount);
                        allocateTax = totalInvTax.subtract(allocatedTax);
                        item2.setAllocateAmount(allocateAmount);
                        item2.setAllocateTax(allocateTax);
                        item2.setAllocateTaxAmount(allocateAmount.add(allocateTax));
                        continue;
                    }
                    if (isBlueFillIn && BigDecimalUtil.greaterZero((BigDecimal)amount) || isDiscountRow) {
                        allocateAmount = amount.divide(billTotalAmountAllExcludeDiscount, 40, RoundingMode.HALF_UP).multiply(totalInvInvoiceAmount).setScale(2, RoundingMode.HALF_UP);
                        allocateTax = BigDecimal.ZERO;
                        if (!BigDecimalUtil.compareZero((BigDecimal)totalInvTax) && !BigDecimalUtil.compareZero((BigDecimal)billTotalTaxAllExcludeDiscount)) {
                            allocateTax = tax.divide(billTotalTaxAllExcludeDiscount, 40, RoundingMode.HALF_UP).multiply(totalInvTax).setScale(2, RoundingMode.HALF_UP);
                        }
                        item2.setAllocateAmount(allocateAmount);
                        item2.setAllocateTax(allocateTax);
                        item2.setAllocateTaxAmount(allocateAmount.add(allocateTax));
                        allocatedAmount = allocatedAmount.add(allocateAmount);
                        allocatedTax = allocatedTax.add(allocateTax);
                        continue;
                    }
                    if ((isBlueFillIn || !BigDecimalUtil.lessZero((BigDecimal)amount)) && !isDiscountedRow) continue;
                    allocateAmount = amount.divide(billTotalAmountAllExcludeDiscount, 40, RoundingMode.HALF_UP).multiply(totalInvInvoiceAmount).setScale(2, RoundingMode.HALF_UP);
                    allocateTax = BigDecimal.ZERO;
                    if (!BigDecimalUtil.compareZero((BigDecimal)totalInvTax) && !BigDecimalUtil.compareZero((BigDecimal)billTotalTaxAllExcludeDiscount)) {
                        allocateTax = tax.divide(billTotalTaxAllExcludeDiscount, 40, RoundingMode.HALF_UP).multiply(totalInvTax).setScale(2, RoundingMode.HALF_UP);
                    }
                    item2.setAllocateAmount(allocateAmount);
                    item2.setAllocateTax(allocateTax);
                    item2.setAllocateTaxAmount(allocateAmount.add(allocateTax));
                    allocatedAmount = allocatedAmount.add(allocateAmount);
                    allocatedTax = allocatedTax.add(allocateTax);
                }
            }
        }
        Map<String, List<ArBillRelationExtensionDTO>> map = this.allocateInvAmount(listFillVos, invs);
        FillInInvoiceResponseDTO response = new FillInInvoiceResponseDTO();
        response.setRelationMap(map);
        return response;
    }

    private Map<String, List<ArBillRelationExtensionDTO>> allocateInvAmount(List<FillInBillVo> listFillVos, List<FillInInvoiceDTO> invs) {
        BigDecimal invTotalAmount = BigDecimal.ZERO;
        BigDecimal invTotalTax = BigDecimal.ZERO;
        for (FillInInvoiceDTO inv : invs) {
            invTotalAmount = invTotalAmount.add(inv.getInvoiceAmount());
            invTotalTax = invTotalTax.add(inv.getTotalTax());
        }
        HashMap<String, List<ArBillRelationExtensionDTO>> relationMap = new HashMap<String, List<ArBillRelationExtensionDTO>>();
        for (FillInBillVo fillVo : listFillVos) {
            List<FillInBIllItemVo> items2 = fillVo.getItems();
            for (FillInBIllItemVo item : items2) {
                BigDecimal amount = item.getAllocateAmount();
                BigDecimal remainAmount = item.getAllocateAmount();
                BigDecimal tax = item.getAllocateTax();
                BigDecimal remainTax = item.getAllocateTax();
                for (int i = 0; i < invs.size(); ++i) {
                    FillInInvoiceDTO fillInInvoiceDTO = invs.get(i);
                    BigDecimal FillAmount = fillInInvoiceDTO.getInvoiceAmount();
                    BigDecimal FillTax = fillInInvoiceDTO.getTotalTax();
                    ArBillRelationExtensionDTO relation = new ArBillRelationExtensionDTO();
                    relation.setsBillId(fillVo.getPk());
                    relation.setsDetailId(item.getItemPk());
                    relation.setNum(item.getNum());
                    relation.setMergeLabel("1");
                    relation.setFrom(Boolean.valueOf(fillVo.isFrom()));
                    if (i == invs.size() - 1) {
                        relation.setAmount(remainAmount);
                        relation.setTax(remainTax);
                    } else {
                        BigDecimal allocateAmount = FillAmount.divide(invTotalAmount, 20, RoundingMode.HALF_UP).multiply(amount).setScale(2, RoundingMode.HALF_UP);
                        remainAmount = remainAmount.subtract(allocateAmount);
                        relation.setAmount(allocateAmount);
                        BigDecimal allocateTax = BigDecimalUtil.compareZero((BigDecimal)invTotalTax) ? BigDecimal.ZERO : FillTax.divide(invTotalTax, 20, RoundingMode.HALF_UP).multiply(tax).setScale(2, 4);
                        remainTax = remainTax.subtract(allocateTax);
                        relation.setTax(allocateTax);
                    }
                    String invoiceCode = fillInInvoiceDTO.getInvoiceCode();
                    String invoiceNo = fillInInvoiceDTO.getInvoiceNo();
                    String key = StringUtils.isBlank((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + invoiceNo;
                    ArrayList<ArBillRelationExtensionDTO> list = (ArrayList<ArBillRelationExtensionDTO>)relationMap.get(key);
                    if (null == list) {
                        list = new ArrayList<ArBillRelationExtensionDTO>();
                        relationMap.put(key, list);
                    }
                    list.add(relation);
                }
            }
        }
        return relationMap;
    }
}

