/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.service.issueinvoice.IIssueInvoice;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.BlockChainIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.BwServerIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.ComponentIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.HostModeIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.LyServerIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.VirtualUkeyIssueInvoiceImpl;

public class IssueInvoiceFactory {
    private static final Log LOG = LogFactory.getLog(IssueInvoiceFactory.class);
    private static LinkedHashMap<String, IIssueInvoice> issueInvoiceServiceMap = new LinkedHashMap();

    private static Map<String, String> getSimIssueInvoiceServiceMap() {
        HashMap<String, String> issueServiceMap = new HashMap(4);
        try {
            issueServiceMap = ImcConfigUtil.getValue((String)"imc_sim_issue_invoice_service");
            if (CollectionUtils.isEmpty(issueServiceMap)) {
                CacheHelper.put((String)"imc_sim_issue_invoice_service", (String)SerializationUtils.toJsonString(issueServiceMap), (int)86400);
            }
            issueServiceMap.entrySet().removeIf(config -> !((String)config.getKey()).startsWith("imc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return issueServiceMap;
    }

    public static IIssueInvoice getIssueInvoice(DynamicObject invoice) {
        try {
            Map<String, String> issueServiceClassNameMap = IssueInvoiceFactory.getSimIssueInvoiceServiceMap();
            if (CollectionUtils.isEmpty(issueServiceClassNameMap)) {
                issueInvoiceServiceMap.entrySet().removeIf(next -> ((String)next.getKey()).startsWith("imc"));
            }
            Set<Map.Entry<String, String>> entries = issueServiceClassNameMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (issueInvoiceServiceMap.containsKey(entry.getKey())) continue;
                Class<?> clazz = Class.forName(entry.getValue());
                issueInvoiceServiceMap.put(entry.getKey(), (IIssueInvoice)clazz.newInstance());
            }
        }
        catch (Exception e) {
            LOG.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5f00\u7968\u5b9e\u73b0\u7c7b");
        }
        try {
            IIssueInvoice[] serviceArr = issueInvoiceServiceMap.values().toArray(new IIssueInvoice[0]);
            for (int i = serviceArr.length - 1; i >= 0; --i) {
                IIssueInvoice iIssueInvoice = serviceArr[i];
                if (!iIssueInvoice.support(invoice)) continue;
                return iIssueInvoice;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MsgException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u5f00\u7968\u65b9\u5f0f", (String)"IssueInvoiceFactory_0", (String)"imc-sim-common", (Object[])new Object[0]));
    }

    static {
        issueInvoiceServiceMap.put("component", new ComponentIssueInvoiceImpl());
        issueInvoiceServiceMap.put("blockChain", new BlockChainIssueInvoiceImpl());
        issueInvoiceServiceMap.put("bwServer", new BwServerIssueInvoiceImpl());
        issueInvoiceServiceMap.put("hostMode", new HostModeIssueInvoiceImpl());
        issueInvoiceServiceMap.put("lyServer", new LyServerIssueInvoiceImpl());
        issueInvoiceServiceMap.put("virtualUkey", new VirtualUkeyIssueInvoiceImpl());
        issueInvoiceServiceMap.put("allEle", new AllEleIssueInvoiceImpl());
    }
}

