/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.message.exception.MsgException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpUtil.class);
    private static int connectTimeout = 20000;
    private static int socketTimeout = 60000;

    public static CloseableHttpClient getConnection(String proxy, boolean redirectsEnabled) {
        return HttpUtil.getConnection(proxy, redirectsEnabled, connectTimeout, socketTimeout);
    }

    public static CloseableHttpClient getConnection(String proxy) {
        return HttpUtil.getConnection(proxy, true, connectTimeout, socketTimeout);
    }

    public static CloseableHttpClient getConnection(String proxy, boolean redirectsEnabled, int connectTime, int readTime) {
        int connectionRequestTimeout = 1200000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTime).setSocketTimeout(readTime).setRedirectsEnabled(redirectsEnabled).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (StringUtils.isNotEmpty((CharSequence)proxy)) {
            String[] values = proxy.trim().split(":");
            if (values.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"HttpUtil_01", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            HttpHost httpHost = new HttpHost(values[0], Integer.parseInt(values[1]));
            httpClientBuilder.setProxy(httpHost);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String proxy) {
        HttpGet httpGet = HttpUtil.getHttpGet(url);
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy);
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity resEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)resEntity);
                EntityUtils.consume((HttpEntity)resEntity);
                String string = result;
                return string;
            }
            logger.info("doGet:{},{}", (Object)url, (Object)statusCode);
        }
        catch (IOException e) {
            logger.error("Failed to post get.", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            try {
                httpGet.abort();
                httpGet.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String proxy, Map<String, String> headers, HttpEntity httpEntity) throws IOException {
        long start = System.currentTimeMillis();
        CloseableHttpClient client = HttpUtil.getConnection(proxy);
        HttpPost post = new HttpPost(url);
        post.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        CloseableHttpResponse response = null;
        String rs = "";
        BufferedReader in = null;
        try {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    post.setHeader(k, v);
                }
            } else {
                post.setHeader("Connection", "close");
            }
            RequestContext request = RequestContext.get();
            if (request != null) {
                post.setHeader("tenantId", request.getTenantId());
                post.setHeader("traceId", request.getTraceId());
            }
            post.setEntity(httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                in = new BufferedReader(new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8.name()));
                StringBuilder sb = new StringBuilder();
                String line = "";
                String NL = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    sb.append(line).append(NL);
                }
                rs = sb.toString();
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error("doPost-Exception", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            if (in != null) {
                in.close();
            }
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        logger.info("HttpUtil-doPost:" + url + " proxy:" + proxy + " \u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return rs;
    }

    public static String doPostJson(String url, String proxy, Map<String, String> headers, String body) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        logger.info("url:{}", (Object)url);
        logger.info("body:{}", (Object)body);
        String response = HttpUtil.doPost(url, proxy, headers, (HttpEntity)new StringEntity(body, StandardCharsets.UTF_8.name()));
        logger.info("response:{}", (Object)response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, String proxy, Map<String, String> headers, InputStream inputStream, String fileName, Map<String, String> bodyMap, int connectionTimeout, int readTimeout) {
        logger.info("HttpUtil-postFormData:" + url + " proxy:" + proxy);
        Boolean redirectsEnabled = Boolean.TRUE;
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy, redirectsEnabled, connectionTimeout, readTimeout);
        HttpPost httppost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            RequestContext request;
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((request = RequestContext.get()) != null) {
                httppost.setHeader("tenantId", request.getTenantId());
                httppost.setHeader("traceId", request.getTraceId());
            }
            try {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                if (inputStream != null) {
                    builder.addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA, fileName);
                }
                if (bodyMap != null) {
                    for (Map.Entry<String, String> entry : bodyMap.entrySet()) {
                        if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                        builder.addTextBody(entry.getKey(), entry.getValue());
                    }
                }
                HttpEntity entity = builder.build();
                httppost.setEntity(entity);
                response = (CloseableHttpResponse)httpclient.execute((HttpUriRequest)httppost);
                int statusCode = response.getStatusLine().getStatusCode();
                logger.info("HttpUtil-statusCode:" + statusCode);
                if (statusCode == 200) {
                    HttpEntity resEntity = response.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (IOException e) {
                logger.error("Failed to post formdata.", (Throwable)e);
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            try {
                httppost.abort();
                httppost.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static HttpGet getHttpGet(String url) {
        URIBuilder uriBuilder = null;
        HttpGet httpGet = null;
        try {
            uriBuilder = new URIBuilder(url);
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new MsgException((Throwable)e, "0009", String.format(ResManager.loadKDString((String)"url\u9519\u8bef:%1$s", (String)"HttpUtil_02", (String)"imc-sim-common", (Object[])new Object[0]), url));
        }
        return httpGet;
    }

    public static String getResult(String urlStr, String content, String encoding) throws IOException {
        URL url = null;
        HttpURLConnection connection = null;
        System.out.println("\u8f6c\u7801\uff1a" + urlStr + "?" + content);
        try {
            url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(600000);
            connection.setReadTimeout(600000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.connect();
            StringBuilder buffer = new StringBuilder();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("I/O\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u901a\u7545\uff01");
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

