/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import kd.imc.sim.common.utils.Base64Utils;

public class RSAUtil {
    private static final String RSA_ALGORITHM = "RSA";

    public static byte[] encryptWithPublicKey(byte[] data, RSAPublicKey publicKey) {
        return RSAUtil.doRSA(publicKey, 1, data);
    }

    public static byte[] decryptByPublicKey(byte[] data, RSAPublicKey publicKey) {
        return RSAUtil.doRSA(publicKey, 2, data);
    }

    public static byte[] decryptWithPrivateKey(byte[] data, RSAPrivateKey privateKey) {
        return RSAUtil.doRSA(privateKey, 2, data);
    }

    public static byte[] encryptWithPrivateKey(byte[] data, RSAPrivateKey privateKey) {
        return RSAUtil.doRSA(privateKey, 1, data);
    }

    private static byte[] doRSA(RSAKey key, int mode, byte[] data) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doRSA(Cipher cipher, int mode, byte[] data, int keySize) throws IOException, BadPaddingException, IllegalBlockSizeException {
        int maxBlock = mode == 2 ? keySize / 8 : keySize / 8 - 11;
        int length = data.length;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (length - offset > 0) {
                byte[] buf = length - offset > maxBlock ? cipher.doFinal(data, offset, maxBlock) : cipher.doFinal(data, offset, length - offset);
                baos.write(buf, 0, buf.length);
                offset = ++i * maxBlock;
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static RSAPublicKey generatePublicKey(String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64Utils.decode(publicKey, "UTF-8"));
            RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
            return key;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("generate publicKey caught error", e);
        }
    }

    public static RSAPrivateKey generatePrivateKey(String privateKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64Utils.decode(privateKey, "UTF-8"));
            RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
            return key;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("generate privateKey caught error", e);
        }
    }

    public static String getPublicKey(PublicKey publicKey) {
        return Base64Utils.encodeString(publicKey.getEncoded());
    }

    public static String getPrivateKey(PrivateKey privateKey) {
        return Base64Utils.encodeString(privateKey.getEncoded());
    }

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }
}

