/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SimpleGoodsNameUtil {
    private static final Log LOGGER = LogFactory.getLog(SimpleGoodsNameUtil.class);
    public static final String REGEX_SIMPLE_GOODSNAME = "^\\*[A-Za-z0-9\u3001\\u4E00-\\u9FA5]+\\*";
    public static final Pattern REGEX_GOODS_NAME = Pattern.compile("^\\*[A-Za-z0-9\u3001\\u4E00-\\u9FA5]+\\*");

    public static void handlerSimpleGoodsName(DynamicObject item) {
        boolean isBill = item.getDynamicObjectType().getProperties().containsKey((Object)"goodssimplename");
        String goodsSimpleName = item.getString(isBill ? "goodssimplename" : "simplegoodsname");
        String goodsName = item.getString("goodsname");
        if (StringUtils.isNotBlank((CharSequence)goodsSimpleName) && StringUtils.isNotBlank((CharSequence)goodsName) && !REGEX_GOODS_NAME.matcher(goodsName).find()) {
            goodsSimpleName = goodsSimpleName.startsWith("*") ? goodsSimpleName : '*' + goodsSimpleName + '*';
            item.set(isBill ? "goodssimplename" : "simplegoodsname", (Object)goodsSimpleName);
            item.set("goodsname", (Object)(goodsSimpleName + goodsName));
        }
    }

    public static String[] getInvoiceItemGoodsNameByCondition(DynamicObject goodsObject) {
        String[] array = new String[2];
        Long goodsId = goodsObject.getLong("id");
        goodsObject = BusinessDataServiceHelper.loadSingle((Object)goodsId, (String)"bdm_goods_info");
        String goodsName = goodsObject.getString("name");
        DynamicObject taxCodeObject = goodsObject.getDynamicObject("taxcode");
        if (taxCodeObject != null) {
            String goodsSimpleName = taxCodeObject.getString("simplename");
            array[0] = goodsSimpleName.startsWith("*") ? goodsSimpleName : '*' + goodsSimpleName + '*';
            array[1] = array[0] + goodsName;
            LOGGER.info("getInvoiceItemGoodsNameByCondition, array[0]:{}, array[1]:{}", (Object)array[0], (Object)array[1]);
        }
        return array;
    }
}

