/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.billsplit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.bill.HSAmountSplitHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillProcessTabCustomEvent;

public class AbstractHSAmountSplitPlugin
extends AbstractFormPlugin {
    protected static final String BTN_CANCEL = "cancel";
    protected static final String BTN_CONFIRM = "confirm";
    protected static final String BTN_ADD_ROW = "addrow";
    protected static final String BTN_DEL_ROW = "delrow";
    protected static final String DEV_LIMIT_AMOUNT = "limitamount";
    protected static final String LIMIT_HS_AMOUNT = "limithsamount";
    protected static final String ORIGIN_JSHJ = "originamount";
    protected static final String KEY_ENTRY_ENTITY = "entryentity";
    protected static final String TITLE_JSHJ = "totaltaxamount";
    protected static final String TITLE_LENGTH = "rowsizetitle";
    protected static final String TITLE_LAST_TITLE = "lasttitle";
    protected static final String ROW_NAME = "rowname";
    protected static final String ROW_JSHJ = "jshj";
    protected static final String ROW_BSHJE = "bshje";
    protected static final String ROW_TAX = "taxamount";
    protected static final String TIPS = "tips";
    protected static final String PAGE_CACHE_ADD_ROW = "addrow";
    protected static final String PAGE_CACHE_BILL_STR = "cacheBill";
    protected static final String PAGE_CACHE_REQUEST_JSON = "requestJson";
    public static final String PAGE_CUSTOM_AMOUNT_SPLIT = "sim_bill_split_by_amount";
    public static final String PAGE_AUTO_AMOUNT_SPLIT = "sim_split_amount_auto";

    protected static BigDecimal setLimitAmountToView(AbstractFormPlugin formPlugin, String cacheBill, BigDecimal equipmentLimitAmount) {
        JSONObject billJson = JSON.parseObject((String)cacheBill);
        BigDecimal hsLimitBigDecimal = AbstractHSAmountSplitPlugin.getHSAmountLimit(billJson);
        if (MathUtils.isZero((BigDecimal)hsLimitBigDecimal)) {
            hsLimitBigDecimal = BigDecimal.ZERO;
        }
        if (MathUtils.isZero((BigDecimal)equipmentLimitAmount)) {
            equipmentLimitAmount = new BigDecimal("99999999999.99");
        }
        ViewUtil.setLabelViewData((IFormView)formPlugin.getView(), (String)DEV_LIMIT_AMOUNT, (String)equipmentLimitAmount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        formPlugin.getPageCache().put(DEV_LIMIT_AMOUNT, equipmentLimitAmount.toString());
        ViewUtil.setLabelViewData((IFormView)formPlugin.getView(), (String)LIMIT_HS_AMOUNT, (String)hsLimitBigDecimal.setScale(2, RoundingMode.HALF_UP).toPlainString());
        formPlugin.getPageCache().put(LIMIT_HS_AMOUNT, hsLimitBigDecimal.toString());
        return hsLimitBigDecimal;
    }

    protected BigDecimal getEquipmentLimit(JSONObject cacheBillJsonObject) {
        BigDecimal equipmentLimitAmount;
        if (InvoiceUtils.isAllEInvoice((Object)cacheBillJsonObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)cacheBillJsonObject.getString("iselepaper"))) {
            equipmentLimitAmount = BigDecimal.ZERO;
        } else {
            equipmentLimitAmount = EquipmentHelper.getDevLimitAmountByInvoiceType((String)cacheBillJsonObject.getString("invoicetype"), (String)cacheBillJsonObject.getString("jqbh")).setScale(2, RoundingMode.HALF_UP);
            if (MathUtils.isZero((BigDecimal)equipmentLimitAmount)) {
                throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u8bbe\u5907\u672a\u540c\u6b65\u9650\u989d\uff0c\u8bf7\u5148\u914d\u7f6e\u8bbe\u5907\u9650\u989d", (String)"AbstractHSAmountSplitPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
        return equipmentLimitAmount;
    }

    protected static BigDecimal getHSAmountLimit(JSONObject billJson) {
        DynamicObject hsAmountSplitConfigDynamicObject = HSAmountSplitHelper.getHSAmountSplitConfigDynamicObject((long)BillProcessTabCustomEvent.getCacheBillOrgId((JSONObject)billJson));
        return HSAmountSplitHelper.getUserSetHSAmountLimitByInvoiceType((DynamicObject)hsAmountSplitConfigDynamicObject, (String)billJson.getString("invoicetype"));
    }

    protected SplitRequestDTO buildSplitRequestDTO(String billStr, JSONObject requestJson, DynamicObject originBill, List<BigDecimal> splitAmountList) {
        SplitRequestDTO splitRequestDTO = new SplitRequestDTO();
        splitRequestDTO.setAmounts(splitAmountList);
        Map billMap = (Map)SerializationUtils.fromJsonString((String)billStr, Map.class);
        DynamicObjectUtil.map2DynamicObject((Map)billMap, (DynamicObject)originBill);
        originBill.set("splitrule", (Object)"imc_split_by_amount");
        splitRequestDTO.setBill(originBill);
        JSONObject billNoMapJson = (JSONObject)requestJson.get((Object)"billNoMap");
        HashMap<String, String> billNoMap = new HashMap<String, String>(2);
        String key = originBill.getString("billno");
        billNoMap.put(key, billNoMapJson.getString(key));
        splitRequestDTO.setBillNoMap(billNoMap);
        splitRequestDTO.setRuleCode("imc_split_by_amount");
        return splitRequestDTO;
    }

    protected void sendSplitDataToCustomView(JSONObject requestJson, DynamicObject originBill, SplitResponseDTO splitResponseDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        List invoiceList = DynamicObjectUtil.dynamicObjectslist2ListMap((List)splitResponseDTO.getInvoices());
        AbstractBillWorkbenchCustomEvent.allEleSpecialData((DynamicObject)originBill, (List)invoiceList);
        for (Map billMap : invoiceList) {
            StringBuilder extraRemarkBuilder = new StringBuilder(" ");
            List extra = (List)billMap.get("extra");
            if (null == extra || extra.size() <= 0) continue;
            for (Map extraItem : extra) {
                extraRemarkBuilder.append(extraItem.get("extrainfoname")).append(":").append(extraItem.get("extrainfovalue")).append(" ");
            }
            billMap.put("extraRemark", extraRemarkBuilder.toString());
        }
        HashMap<String, List> invoiceMap = new HashMap<String, List>(2);
        invoiceMap.put(String.valueOf(originBill.getLong("id")), invoiceList);
        map.put("invoiceList", invoiceMap);
        map.put("billNoMap", requestJson.get((Object)"billNoMap"));
        HashMap<String, List> invoiceRelationMap = new HashMap<String, List>(2);
        invoiceRelationMap.put(String.valueOf(originBill.getLong("id")), AbstractBillWorkbenchCustomEvent.relations2ListMap((List)splitResponseDTO.getRelations()));
        map.put("invoiceRelationMap", invoiceRelationMap);
        map.put("ruleCode", requestJson.getString("ruleCode"));
        map.put("taxDeviationBillMap", AbstractBillWorkbenchCustomEvent.queryMergeDeviation((DynamicObject)originBill));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

