/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.billsplit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.billsplit.AbstractHSAmountSplitPlugin;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;

public class CustomAmountSplitDialogPlugin
extends AbstractHSAmountSplitPlugin {
    private static final Log LOG = LogFactory.getLog(CustomAmountSplitDialogPlugin.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.get("tips") != null) {
            this.getView().showTipNotification((String)customParams.get("tips"));
        }
        String args = (String)customParams.get("requestJson");
        LOG.info("\u81ea\u5b9a\u4e49\u91d1\u989d\u62c6\u5206 requestJson" + args);
        this.getPageCache().put("requestJson", args);
        String cacheBillStr = (String)customParams.get("cacheBill");
        LOG.info("\u81ea\u5b9a\u4e49\u91d1\u989d\u62c6\u5206 cacheBill" + cacheBillStr);
        this.getPageCache().put("cacheBill", cacheBillStr);
        try {
            JSONObject cacheBillJsonObject = JSON.parseObject((String)cacheBillStr);
            CustomAmountSplitDialogPlugin.setLimitAmountToView(this, cacheBillStr, this.getEquipmentLimit(cacheBillJsonObject));
            BigDecimal originAmount = cacheBillJsonObject.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP);
            this.getPageCache().put("originamount", originAmount.toString());
            this.getModel().setValue("totaltaxamount", (Object)originAmount);
            this.initRow(originAmount);
        }
        catch (MsgException m) {
            this.getView().showErrorNotification(m.getErrorMsg());
        }
        catch (Exception ex) {
            LOG.error("\u6309\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u5f02\u5e38", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6309\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u5f02\u5e38", (String)"CustomAmountSplitDialogPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void initRow(BigDecimal originAmount) {
        this.getModel().deleteEntryData("entryentity");
        this.addNewRow(0);
        this.addLastRow(originAmount, 1);
        this.updateTipRowSize(2);
    }

    private void addLastRow(BigDecimal originAmount, int index) {
        this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("rowname", (Object)String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d1\u7968%1$s:", (String)"CustomAmountSplitDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), index + 1), index);
        ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"jshj", (boolean)false, (int)index);
        this.getModel().setValue("jshj", (Object)originAmount, index);
    }

    private void addNewRow(int index) {
        this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("rowname", (Object)String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d1\u7968%1$s:", (String)"CustomAmountSplitDialogPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), index + 1), index);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"cancel", "confirm", "addrow", "delrow"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("addrow".equals(key)) {
            this.addRow();
        } else if ("delrow".equals(key)) {
            this.delRow();
        }
    }

    private void delRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 1 || entryEntity.size() == 2) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u5220\u884c", (String)"CustomAmountSplitDialogPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows[0] == entryEntity.size() - 1) {
            return;
        }
        this.getModel().deleteEntryRow("entryentity", rows[0]);
        if (!MathUtils.isZero((BigDecimal)((DynamicObject)entryEntity.get(rows[0])).getBigDecimal("jshj"))) {
            BigDecimal add = ((DynamicObject)entryEntity.get(entryEntity.size() - 1)).getBigDecimal("jshj").add(((DynamicObject)entryEntity.get(rows[0])).getBigDecimal("jshj"));
            this.getPageCache().put("addrow", "addrow");
            this.getModel().setValue("jshj", (Object)add, entryEntity.size() - 2);
            this.getPageCache().remove("addrow");
        }
        this.getView().addClientCallBack("split", Integer.valueOf(200));
        this.updateTipRowSize(entryEntity.size() - 1);
        for (int i = 0; i < entryEntity.size() - 1; ++i) {
            this.getModel().setValue("rowname", (Object)String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d1\u7968%d:", (String)"CustomAmountSplitDialogPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1), i);
        }
    }

    private void addRow() {
        EntryGrid entryGrid;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            BigDecimal bigDecimal = dynamicObject.getBigDecimal("jshj");
            if (!MathUtils.isZero((BigDecimal)bigDecimal)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a0", (String)"CustomAmountSplitDialogPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), dynamicObject.getString("rowname")));
            return;
        }
        int rowSize = entryEntity.size();
        int lastIndex = rowSize - 1;
        BigDecimal lastJSHJ = (BigDecimal)this.getModel().getValue("jshj", lastIndex);
        if (rowSize > 1) {
            entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            BigDecimal copyJSHJ = rows.length == 0 || rows[0] == lastIndex ? (BigDecimal)this.getModel().getValue("jshj", rowSize - 2) : (BigDecimal)this.getModel().getValue("jshj", rows[0]);
            rowSize = this.addRowEmpty(rowSize, lastJSHJ);
            if (copyJSHJ.compareTo(lastJSHJ) < 0) {
                this.getPageCache().put("addrow", "addrow");
                this.getModel().setValue("jshj", (Object)copyJSHJ, rowSize - 2);
                this.getModel().setValue("jshj", (Object)lastJSHJ.subtract(copyJSHJ), rowSize - 1);
                this.getPageCache().remove("addrow");
                this.getView().addClientCallBack("split", Integer.valueOf(200));
            }
        } else {
            rowSize = this.addRowEmpty(rowSize, lastJSHJ);
        }
        entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(rowSize - 2);
        this.updateTipRowSize(entryEntity.size() + 1);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        this.executeSplit();
    }

    private int addRowEmpty(int rowSize, BigDecimal lastJSHJ) {
        this.getModel().deleteEntryRow("entryentity", rowSize - 1);
        this.getPageCache().put("addrow", "addrow");
        this.addNewRow(--rowSize);
        this.addLastRow(lastJSHJ, ++rowSize);
        this.getPageCache().remove("addrow");
        return rowSize + 1;
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("confirm".equals(source.getKey())) {
            DynamicObject originBill;
            String args;
            JSONObject requestJson;
            String billStr = this.getPageCache().get("cacheBill");
            SplitRequestDTO splitRequestDTO = this.buildSplitRequestDTOData(billStr, requestJson = JSON.parseObject((String)(args = this.getPageCache().get("requestJson"))), originBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
            if (splitRequestDTO != null) {
                SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill((SplitRequestDTO)splitRequestDTO);
                if (!InvoiceUtils.isAllEInvoice((Object)originBill.getString("invoicetype"))) {
                    BigDecimal limitAmount = new BigDecimal(this.getPageCache().get("limitamount"));
                    for (int i = 0; i < splitResponseDTO.getInvoices().size(); ++i) {
                        if (((DynamicObject)splitResponseDTO.getInvoices().get(i)).getBigDecimal("invoiceamount").compareTo(limitAmount) <= 0) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u542b\u7a0e\u91d1\u989d\u8d85\u8fc7\u8bbe\u5907\u9650\u989d\uff0c\u8bf7\u8c03\u6574\u4ef7\u7a0e\u5408\u8ba1", (String)"CustomAmountSplitDialogPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getModel().getValue("rowname", i)));
                        return;
                    }
                }
                this.sendSplitDataToCustomView(requestJson, originBill, splitResponseDTO);
            }
        } else if ("cancel".equals(source.getKey())) {
            this.getView().close();
        }
    }

    private SplitRequestDTO buildSplitRequestDTOData(String billStr, JSONObject requestJson, DynamicObject originBill) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u91d1\u989d\u62c6\u5206\u81f3\u5c11\u9700\u8981\u4e00\u5f20\u81ea\u5b9a\u4e49\u53d1\u7968", (String)"CustomAmountSplitDialogPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<BigDecimal> amounts = new ArrayList<BigDecimal>();
        for (DynamicObject dynamicObject : entryEntity) {
            BigDecimal bigDecimal = dynamicObject.getBigDecimal("jshj");
            if (MathUtils.isZero((BigDecimal)bigDecimal)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a0", (String)"CustomAmountSplitDialogPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), dynamicObject.getString("rowname")));
                return null;
            }
            amounts.add(bigDecimal);
        }
        return this.buildSplitRequestDTO(billStr, requestJson, originBill, amounts);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            return;
        }
        int editIndex = rows[0];
        if (!StringUtils.isEmpty((String)this.getPageCache().get("addrow"))) {
            return;
        }
        if ("jshj".equals(e.getProperty().getName())) {
            BigDecimal editRowJSHJ = (BigDecimal)this.getModel().getValue("jshj", editIndex);
            if (MathUtils.isZero((BigDecimal)editRowJSHJ)) {
                this.getModel().setValue("bshje", (Object)0, editIndex);
                return;
            }
            BigDecimal originJSHJ = new BigDecimal(this.getPageCache().get("originamount"));
            BigDecimal addBigDecimal = BigDecimal.ZERO;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size() - 1; ++i) {
                if (i == editIndex) continue;
                addBigDecimal = addBigDecimal.add(((DynamicObject)entryEntity.get(i)).getBigDecimal("jshj"));
            }
            if (addBigDecimal.add(editRowJSHJ).compareTo(originJSHJ) > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4ef7\u7a0e\u5408\u8ba1\u8d85\u989d", (String)"CustomAmountSplitDialogPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getModel().getValue("rowname", editIndex)));
                this.updateRowJSHJZero(editIndex);
                this.getPageCache().put("addrow", "addrow");
                this.getModel().setValue("jshj", (Object)originJSHJ.subtract(addBigDecimal), entryEntity.size() - 1);
                this.getPageCache().remove("addrow");
                return;
            }
            if (editRowJSHJ.add(addBigDecimal).compareTo(originJSHJ) == 0) {
                if (entryEntity.size() == 2) {
                    if (editRowJSHJ.compareTo(originJSHJ) == 0) {
                        this.getPageCache().put("addrow", "addrow");
                        this.getModel().setValue("jshj", (Object)editRowJSHJ, entryEntity.size() - 1);
                        this.getPageCache().remove("addrow");
                    }
                    this.updateRowJSHJZero(editIndex);
                } else {
                    int lastRowIndex = entryEntity.size() - 1;
                    this.getModel().deleteEntryRow("entryentity", lastRowIndex);
                    ViewUtil.setEntryRowEnable((IFormView)this.getView(), (String)"jshj", (boolean)false, (int)(lastRowIndex - 1));
                }
                this.updateTipRowSize(entryEntity.size());
                this.getView().addClientCallBack("split", Integer.valueOf(200));
                return;
            }
            this.getPageCache().put("addrow", "addrow");
            BigDecimal subtract = originJSHJ.subtract(addBigDecimal.add(editRowJSHJ));
            this.getModel().setValue("jshj", (Object)subtract, entryEntity.size() - 1);
            this.getPageCache().remove("addrow");
            this.getView().addClientCallBack("split", Integer.valueOf(200));
        }
    }

    private void executeSplit() {
        DynamicObject originBill;
        String args;
        JSONObject requestJson;
        String billStr = this.getPageCache().get("cacheBill");
        SplitRequestDTO splitRequestDTO = this.buildSplitRequestDTOData(billStr, requestJson = JSON.parseObject((String)(args = this.getPageCache().get("requestJson"))), originBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
        if (splitRequestDTO != null) {
            SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill((SplitRequestDTO)splitRequestDTO);
            List invoices = splitResponseDTO.getInvoices();
            for (int i = 0; i < invoices.size(); ++i) {
                this.getModel().setValue("bshje", (Object)((DynamicObject)invoices.get(i)).getBigDecimal("invoiceamount"), i);
            }
        }
    }

    private void updateRowJSHJZero(int editIndex) {
        this.getPageCache().put("addrow", "addrow");
        this.getModel().setValue("jshj", (Object)0, editIndex);
        this.getModel().setValue("bshje", (Object)0, editIndex);
        this.getPageCache().remove("addrow");
    }

    private void updateTipRowSize(int size) {
        this.getModel().setValue("rowsizetitle", (Object)String.format(ResManager.loadKDString((String)"\u5171\u62c6\u5206\u4e3a%d\u5f20\u53d1\u7968", (String)"CustomAmountSplitDialogPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), size));
        this.getModel().setValue("lasttitle", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%d\u5f20\u53d1\u7968\u91d1\u989d\u81ea\u52a8\u8ba1\u7b97", (String)"CustomAmountSplitDialogPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), size));
    }
}

