/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.botp.wb;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.FinishWriteBackEventArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class BusArRelateAmtWriteBack
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(BusArRelateAmtWriteBack.class);
    private Set<Long> arBusBillIds = new HashSet<Long>(2);
    private Set<String> errorBillNo = new HashSet<String>(2);
    private Date dataUpgrade;
    private Map<Long, Boolean> arBusBillToleranceControl = new HashMap<Long, Boolean>(8);
    private Map<Long, BigDecimal> arBusBillToleranceAmt = new HashMap<Long, BigDecimal>(8);

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add("createtime");
        lst.add("unrelateinvamt");
        lst.add("uninvoicedamt");
        lst.add("recamount");
        lst.add("org");
        lst.add("billno");
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        DynamicObject srcActiveRow;
        DynamicObject parent;
        Date createTime;
        super.afterExcessCheck(e);
        String srcBillType = e.getSrcSubMainType().getName();
        if (!"ar_busbill".equals(srcBillType)) {
            return;
        }
        boolean isLogPushDetail = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.LOG_BOTP_DETAIL));
        if (this.dataUpgrade == null) {
            this.dataUpgrade = this.getDataUpgrade("BIZ_V5.0.018_DataUpgrade", isLogPushDetail);
            if (isLogPushDetail) {
                logger.info("BusArRelateAmtWriteBack.afterExcessCheck.dataUpgrade : " + this.dataUpgrade);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(createTime = (parent = (DynamicObject)(srcActiveRow = e.getSrcActiveRow()).getParent()).getDate("createtime"))) && this.isHistoryBill(this.dataUpgrade, createTime)) {
            this.arBusBillIds.add(parent.getLong("id"));
            return;
        }
        Long orgId = parent.getLong("org.id");
        Boolean toleranceControl = this.arBusBillToleranceControl.get(orgId);
        BigDecimal toleranceAmt = this.arBusBillToleranceAmt.get(orgId);
        if (toleranceControl == null && toleranceAmt == null) {
            Map<String, Object> parameters = this.batchGetAppParameters(orgId, "ar_035", "ar_036");
            this.arBusBillToleranceControl.put(orgId, parameters.get("ar_035") == null ? Boolean.FALSE : (Boolean)parameters.get("ar_035"));
            this.arBusBillToleranceAmt.put(orgId, parameters.get("ar_036") == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(parameters.get("ar_036"))));
        }
        if (this.arBusBillToleranceControl.get(orgId) == null || !this.arBusBillToleranceControl.get(orgId).booleanValue()) {
            return;
        }
        toleranceAmt = this.arBusBillToleranceAmt.get(orgId);
        BigDecimal unrelateinvamt = parent.getBigDecimal("unrelateinvamt");
        int signum = parent.getBigDecimal("recamount").signum();
        String billNo = parent.getString("billno");
        if (this.errorBillNo.contains(billNo)) {
            return;
        }
        if (signum > 0) {
            if (toleranceAmt.compareTo(unrelateinvamt.negate()) < 0) {
                this.errorBillNo.add(billNo);
                e.setExcess(true);
                e.setMessage(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\uff0c\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusArRelateAmtWriteBack_0", (String)"imc-sim-formplugin", (Object[])new Object[]{billNo}));
            }
        } else if (signum < 0) {
            if (toleranceAmt.compareTo(unrelateinvamt) < 0) {
                this.errorBillNo.add(billNo);
                e.setExcess(true);
                e.setMessage(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\uff0c\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusArRelateAmtWriteBack_0", (String)"imc-sim-formplugin", (Object[])new Object[]{billNo}));
            }
        } else if (toleranceAmt.compareTo(unrelateinvamt.abs()) < 0) {
            this.errorBillNo.add(billNo);
            e.setExcess(true);
            e.setMessage(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\uff0c\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusArRelateAmtWriteBack_0", (String)"imc-sim-formplugin", (Object[])new Object[]{billNo}));
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        String srcBillType = e.getSrcSubMainType().getName();
        if (!"ar_busbill".equals(srcBillType)) {
            return;
        }
        DynamicObject[] srcDataEntities = e.getSrcDataEntities();
        boolean isLogPushDetail = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.LOG_BOTP_DETAIL));
        if (this.dataUpgrade == null) {
            this.dataUpgrade = this.getDataUpgrade("BIZ_V5.0.018_DataUpgrade", isLogPushDetail);
            if (isLogPushDetail) {
                logger.info("BusArRelateAmtWriteBack.afterSaveSourceBill.dataUpgrade : " + this.dataUpgrade);
            }
        }
        for (DynamicObject srcDataEntity : srcDataEntities) {
            Date createtime = srcDataEntity.getDate("createtime");
            if (ObjectUtils.isEmpty((Object)createtime) || !this.isHistoryBill(this.dataUpgrade, createtime)) continue;
            this.arBusBillIds.add(srcDataEntity.getLong("id"));
        }
    }

    public void finishWriteBack(FinishWriteBackEventArgs e) {
        super.finishWriteBack(e);
        if (this.arBusBillIds.size() > 0) {
            try (TXHandle tx = TX.requiresNew();){
                CommonParam param = new CommonParam();
                long uniqueKey = DB.genGlobalLongId();
                param.put((Object)"uniquekey", (Object)uniqueKey);
                param.put((Object)"methodName", (Object)"BusArRelateAmtQtyRepair");
                param.put((Object)"arBusBillIds", this.arBusBillIds);
                this.beginAndRegister("arap_dataupgrade_repair", "ar_busar_repairrelatefield", "fi", "ar", "DataUpgradeRepairService", (Param)param, "");
            }
        }
    }

    private Date getDataUpgrade(String key, boolean isLogDetail) {
        if (isLogDetail) {
            logger.info("BusArRelateAmtWriteBack.getDataUpgrade.key:" + key);
        }
        Date upgradeDate = null;
        String upgradeDateStr = null;
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"ap_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)key)});
        if (ObjectUtils.isEmpty((Object)queryOne)) {
            return upgradeDate;
        }
        String value = queryOne.getString("value");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            upgradeDateStr = value;
        }
        if (StringUtils.isEmpty((CharSequence)upgradeDateStr)) {
            return upgradeDate;
        }
        if (isLogDetail) {
            logger.info("BusArRelateAmtWriteBack.getDataUpgrade.upgradeDateStr:" + upgradeDateStr);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            upgradeDate = sdf.parse(upgradeDateStr);
        }
        catch (ParseException parseException) {
            logger.error("BusArRelateAmtWriteBack.getDataUpgrade.context", (Object)parseException.getMessage());
        }
        return upgradeDate;
    }

    private boolean isHistoryBill(Date upgradeDate, Date createtime) {
        boolean flag = false;
        if (upgradeDate == null) {
            return flag;
        }
        if (createtime != null && createtime.before(upgradeDate)) {
            flag = true;
        }
        return flag;
    }

    private void begin(String scenesCode) {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null) {
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"fi"), (boolean)true);
            ECGlobalSession.setAsync((boolean)true);
        }
    }

    private void beginAndRegister(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, Param param, String bizId) {
        this.begin(scenesCode);
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
    }

    private Map<String, Object> batchGetAppParameters(Long orgId, String ... paramKey) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(orgId);
        appParam.setAppId("/BBRH+122=39");
        appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        Map systemParams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        HashMap<String, Object> params = new HashMap<String, Object>(paramKey.length);
        if (!ObjectUtils.isEmpty((Object)systemParams)) {
            for (String keyItem : paramKey) {
                params.put(keyItem, systemParams.get(keyItem));
            }
        }
        return params;
    }
}

