/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;

public class BillMatchDetailChooseBlueItemDialogPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Object blueInvoiceFid = this.getView().getFormShowParameter().getCustomParam("blueInvoiceFid");
        String taxRate = (String)this.getView().getFormShowParameter().getCustomParam("taxRate");
        DynamicObject invoiceDO = BusinessDataServiceHelper.loadSingle((Object)blueInvoiceFid, (String)"sim_vatinvoice");
        DynamicObjectCollection items = invoiceDO.getDynamicObjectCollection("items");
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        boolean startZero = items.stream().anyMatch(item -> item.getInt("seq") == 0);
        for (DynamicObject blueItem : items) {
            if ("1".equals(blueItem.getString("rowtype")) || !taxRate.equals(blueItem.getString("taxrate")) || MathUtils.isZero((BigDecimal)blueItem.getBigDecimal("itemremainredamount"))) continue;
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            model.setValue("invoicecode", invoiceDO.get("invoicecode"), rowIndex);
            model.setValue("invoiceno", invoiceDO.get("invoiceno"), rowIndex);
            model.setValue("occupystatus", invoiceDO.get("occupystatus"), rowIndex);
            model.setValue("blueitemseq", (Object)(startZero ? blueItem.getLong("seq") + 1L : blueItem.getLong("seq")), rowIndex);
            model.setValue("goodsname", blueItem.get("goodsname"), rowIndex);
            model.setValue("goodscode", blueItem.get("goodscode"), rowIndex);
            model.setValue("specification", blueItem.get("specification"), rowIndex);
            model.setValue("unit", blueItem.get("unit"), rowIndex);
            model.setValue("unitprice", blueItem.get("unitprice"), rowIndex);
            model.setValue("taxunitprice", blueItem.get("taxunitprice"), rowIndex);
            model.setValue("num", blueItem.get("num"), rowIndex);
            model.setValue("amount", blueItem.get("amount"), rowIndex);
            model.setValue("tax", blueItem.get("tax"), rowIndex);
            model.setValue("taxrate", blueItem.get("taxrate"), rowIndex);
            model.setValue("itemremainredamount", blueItem.get("itemremainredamount"), rowIndex);
            model.setValue("remaindiscountamount", blueItem.get("remaindiscountamount"), rowIndex);
            model.setValue("itemremainredtax", blueItem.get("itemremainredtax"), rowIndex);
            model.setValue("itemremainrednum", blueItem.get("itemremainrednum"), rowIndex);
            model.setValue("rowtype", blueItem.get("rowtype"), rowIndex);
            model.setValue("itemfid", blueItem.getPkValue(), rowIndex);
            model.setValue("fid", invoiceDO.getPkValue(), rowIndex);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int selectRow = 0;
            if (grid.getSelectRows().length > 0) {
                selectRow = grid.getSelectRows()[0];
            }
            IDataModel model = this.getModel();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("oriitemid", model.getValue("itemFid", selectRow));
            jsonObject.put("oriinvoiceid", model.getValue("fid", selectRow));
            jsonObject.put("oriitemseq", model.getValue("blueitemseq", selectRow));
            jsonObject.put("invoicecode", model.getValue("invoicecode", selectRow));
            jsonObject.put("invoiceno", model.getValue("invoiceno", selectRow));
            jsonObject.put("occupystatus", model.getValue("occupystatus", selectRow));
            jsonObject.put("amount", model.getValue("amount", selectRow));
            jsonObject.put("tax", model.getValue("tax", selectRow));
            jsonObject.put("taxrate", model.getValue("taxrate", selectRow));
            jsonObject.put("num", model.getValue("num", selectRow));
            BigDecimal itemRemainAmount = (BigDecimal)model.getValue("itemremainredamount", selectRow);
            jsonObject.put("itemremainredamount", (Object)itemRemainAmount);
            BigDecimal itemRemainTax = (BigDecimal)model.getValue("itemremainredtax", selectRow);
            jsonObject.put("itemremainredtax", (Object)itemRemainTax);
            BigDecimal itemRemainNum = (BigDecimal)model.getValue("itemremainrednum", selectRow);
            jsonObject.put("itemremainrednum", (Object)itemRemainNum);
            jsonObject.put("goodsname", model.getValue("goodsname", selectRow));
            jsonObject.put("specification", model.getValue("specification", selectRow));
            jsonObject.put("unit", model.getValue("unit", selectRow));
            BigDecimal unitPrice = (BigDecimal)model.getValue("unitprice", selectRow);
            if (!MathUtils.isNullOrZero((BigDecimal)itemRemainNum)) {
                BigDecimal canRedPrice = (BigDecimal)model.getValue("redprice", selectRow);
                if (!MathUtils.isNullOrZero((BigDecimal)canRedPrice)) {
                    unitPrice = canRedPrice;
                } else {
                    String rowType = (String)model.getValue("rowtype", selectRow);
                    if ("2".equals(rowType)) {
                        unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemRemainAmount, (BigDecimal)itemRemainNum, (boolean)true);
                    } else if (itemRemainAmount.setScale(2, 4).compareTo(((BigDecimal)model.getValue("amount", selectRow)).setScale(2, 4)) == 0) {
                        unitPrice = (BigDecimal)model.getValue("unitprice", selectRow);
                    } else {
                        BigDecimal calcAmount = itemRemainNum.multiply(unitPrice);
                        if (BigDecimalUtil.compare((BigDecimal)calcAmount, (BigDecimal)itemRemainAmount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                            unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemRemainAmount, (BigDecimal)itemRemainNum, (boolean)true);
                        }
                    }
                }
            }
            jsonObject.put("remaindiscountamount", model.getValue("remaindiscountamount", selectRow));
            jsonObject.put("unitprice", (Object)unitPrice);
            jsonObject.put("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)itemRemainAmount.add(itemRemainTax), (BigDecimal)itemRemainNum, (boolean)true));
            this.getView().returnDataToParent((Object)jsonObject);
            this.getView().close();
        }
    }
}

