/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.formplugin.bill.matchbill.control.NegativeBillMatchControl;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import kd.imc.sim.schedule.AbstractJobTask;
import kd.imc.sim.schedule.bill.NegativeBillMatchTask;
import org.apache.commons.lang3.StringUtils;

public class NegativeBillMatchListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("billproperties", "=", (Object)"-1");
        QFilter confirmFilter = new QFilter("confirmstate", "=", (Object)"0").or(new QFilter("confirmstate", "=", (Object)"2").and("matchstatus", "in", (Object)new String[]{"-1", "1", "5"}));
        e.getCustomQFilters().add(qFilter);
        e.getCustomQFilters().add(confirmFilter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        String callBackId = StringUtils.defaultString((String)messageBoxClosedEvent.getCallBackId());
        if ("red".equals(callBackId)) {
            new NegativeBillMatchControl().redConfirmCallBack((AbstractFormPlugin)this, messageBoxClosedEvent, ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues());
        } else if (callBackId.startsWith("risk_control_check_")) {
            String key = callBackId.substring(callBackId.indexOf("risk_control_check_") + "risk_control_check_".length());
            BillRiskControlService.unlockRiskRecord((AbstractFormPlugin)this);
            this.getView().invokeOperation(key);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        String operateKey = oprate.getOperateKey();
        if ("match".equals(operateKey) || "trackdownmatch".equals(operateKey)) {
            DynamicObject[] bills = this.getSelectBill();
            long count = Arrays.stream(bills).map(bill -> DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid"))).distinct().count();
            if (count != 1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6570\u636e\u64cd\u4f5c", (String)"NegativeBillMatchListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("red".equals(operateKey)) {
            DynamicObject[] bills = this.getSelectBill();
            new NegativeBillMatchControl().red((AbstractFormPlugin)this, args, bills);
        }
    }

    private DynamicObject[] getSelectBill() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "orgid", "invoicetype", "billno"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(rows.getPrimaryKeyValues()).collect(Collectors.toSet())).toArray());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "match": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                HashMap params = Maps.newHashMap();
                params.put("pks", rows.getPrimaryKeyValues());
                ViewUtil.openDialog((AbstractFormPlugin)this, (Map)params, (String)"sim_match_bill_process", (String)"sim_match_bill_process");
                break;
            }
            case "cancel_match": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "trackdown": {
                BillHelper.nextQuery((AbstractFormPlugin)this, (Object[])this.getSelectedRows().getPrimaryKeyValues());
                break;
            }
            case "trackdownmatch": {
                DynamicObject[] matchBills;
                Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues == null || primaryKeyValues.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"NegativeBillMatchListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Object> matchInvIds = new HashSet<Object>(primaryKeyValues.length);
                for (DynamicObject matchBill : matchBills = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_matchbill_relation"), (QFilter[])new QFilter("sbillid", "in", (Object)primaryKeyValues).toArray())) {
                    matchInvIds.add(matchBill.get("tbillid"));
                }
                if (matchInvIds.size() == 0) break;
                ViewUtil.openTrackListPage((AbstractFormPlugin)this, (String)"sim_match_bill", matchInvIds);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "sim_match_bill_process": {
                new NegativeBillMatchTask().dispatchTask(this, closedCallBackEvent.getReturnData(), ResManager.loadKDString((String)"\u5339\u914d\u84dd\u7968", (String)"NegativeBillMatchListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "dispatchTask": {
                AbstractJobTask.dispatchTaskCloseCallback(this, closedCallBackEvent.getReturnData());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject targetBill;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        if ("billno".equals(args.getFieldName()) && (targetBill = BusinessDataServiceHelper.loadSingle((String)"sim_matchbill_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "=", row.getPrimaryKeyValue()).toArray())) != null) {
            args.setCancel(true);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("sim_match_bill");
            parameter.setPkId(targetBill.get("tbillid"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("red".equals(itemKey)) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            Object[] idArr = rows.getPrimaryKeyValues();
            boolean antiReplayControlFlag = BillRiskControlService.riskControl((Object[])idArr, (String)"sim_original_bill", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_REVERSAL, (AbstractFormPlugin)this, (String)("risk_control_check_" + itemKey));
            evt.setCancel(antiReplayControlFlag);
        }
    }
}

