/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.matchbill.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.formplugin.bill.matchbill.op.MatchBillRevokeOpPlugin;
import kd.imc.sim.formplugin.match.BillComprehensiveStatusHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import org.apache.commons.collections.CollectionUtils;

public class BillMatchDetailSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        try {
            for (DynamicObject matchBill : dataEntities) {
                NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] matchBills = e.getDataEntities();
        ArrayList<Long> matchRedConfirmPks = new ArrayList<Long>(matchBills.length);
        for (DynamicObject matchBill : matchBills) {
            String matchTarget = matchBill.getString("matchtarget");
            if (!"1".equals(matchTarget) && !"2".equals(matchTarget)) continue;
            matchRedConfirmPks.add(matchBill.getLong("id"));
        }
        DynamicObject[] dbMatchBills = BusinessDataServiceHelper.load((Object[])matchRedConfirmPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        ArrayList<Long> dbRedConfirmPks = new ArrayList<Long>(dbMatchBills.length);
        for (DynamicObject dynamicObject : dbMatchBills) {
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                DynamicObjectCollection redConfirms = item.getDynamicObjectCollection("confirmsubentryentity");
                for (DynamicObject redConfirm : redConfirms) {
                    dbRedConfirmPks.add(redConfirm.getLong("redconfirmpk"));
                }
            }
        }
        matchRedConfirmPks.stream().filter(o -> !dbRedConfirmPks.contains(o)).collect(Collectors.toSet());
        String salerTaxNo = matchBills[0].getString("salertaxno");
        String lockKey = salerTaxNo + "RedConfirmMatchHelperMatch";
        if (matchRedConfirmPks.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)lockKey))) {
                e.setCancelOperation(true);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u6709\u5176\u4ed6\u5339\u914d\u5355\u5728\u4fdd\u5b58\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BillMatchDetailSaveOpPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), salerTaxNo));
            }
            Throwable throwable = null;
            try (DLock lock = DLock.create((String)lockKey);){
                if (!lock.tryLock(500L)) {
                    e.setCancelOperation(true);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u6709\u5176\u4ed6\u5339\u914d\u5355\u5728\u4fdd\u5b58\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BillMatchDetailSaveOpPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), salerTaxNo));
                }
                DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"occupystatus,number", (QFilter[])new QFilter("id", "in", matchRedConfirmPks).and("occupystatus", "=", (Object)"1").toArray());
                if (redConfirms.length > 0) {
                    e.setCancelOperation(true);
                    StringBuilder builder = new StringBuilder();
                    Arrays.stream(redConfirms).forEach(o -> builder.append('[').append(o.getString("number")).append(']'));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5355:%s\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u786e\u8ba4\u5355", (String)"BillMatchDetailSaveOpPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), builder.toString()));
                }
                CacheHelper.put((String)lockKey, (String)lockKey, (int)60);
            }
            catch (Throwable redConfirms) {
                Throwable throwable2 = redConfirms;
                throw redConfirms;
            }
        }
        try {
            Long oriInvoiceId;
            DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(matchBills).map(DataEntityBase::getPkValue).collect(Collectors.toSet()), (String)"tbillid").toArray());
            HashMap<Object, Set> hashMap = new HashMap<Object, Set>(billRelations.length);
            for (DynamicObject billRelation : billRelations) {
                Set sBillIdSet = hashMap.computeIfAbsent(billRelation.get("tbillid"), k -> new HashSet());
                sBillIdSet.add(billRelation.get("sbillid"));
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "matchstatus", "comprehensivestatus"), (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(billRelations).map(relation -> relation.getLong("sbillid")).collect(Collectors.toSet())).toArray());
            HashMap<Object, DynamicObject> billMap = new HashMap<Object, DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                billMap.put(bill.getPkValue(), bill);
            }
            BillComprehensiveStatusHelper billComprehensiveStatusHelper = new BillComprehensiveStatusHelper();
            for (DynamicObject matchBill : matchBills) {
                Set relations = (Set)hashMap.get(matchBill.getPkValue());
                ArrayList<DynamicObject> groupBills = new ArrayList<DynamicObject>(relations.size());
                for (Object e2 : relations) {
                    DynamicObject bill = (DynamicObject)billMap.get(e2);
                    if (bill == null) continue;
                    bill.set("matchstatus", matchBill.get("matchstatus"));
                    groupBills.add(bill);
                }
                if (!CollectionUtils.isNotEmpty(groupBills)) continue;
                billComprehensiveStatusHelper.setBillsComprehensiveStatusByMatchBill(matchBill, groupBills.toArray(new DynamicObject[0]));
            }
            ImcSaveServiceHelper.update((DynamicObject[])bills);
            DynamicObjectCollection beforeMatchBills = QueryServiceHelper.query((String)"sim_match_bill", (String)"matchtarget,sim_original_bill_item.subentryentity.id,sim_original_bill_item.subentryentity.oriinvoiceid,sim_original_bill_item.confirmsubentryentity.redconfirmpk", (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(matchBills).map(DataEntityBase::getPkValue).toArray()).toArray());
            HashMap<Long, Long> beforeSubEntryId2OriInvoiceIdMap = new HashMap<Long, Long>(beforeMatchBills.size());
            HashSet<Long> beforeRedConfirmIdSet = new HashSet<Long>(beforeMatchBills.size());
            for (DynamicObject beforeMatchBill : beforeMatchBills) {
                String matchTarget = beforeMatchBill.getString("matchtarget");
                if ("1".equals(matchTarget) || "2".equals(matchTarget)) {
                    beforeRedConfirmIdSet.add(beforeMatchBill.getLong("sim_original_bill_item.confirmsubentryentity.redconfirmpk"));
                    continue;
                }
                long subEntryId = beforeMatchBill.getLong("sim_original_bill_item.subentryentity.id");
                if (subEntryId == 0L) continue;
                beforeSubEntryId2OriInvoiceIdMap.put(subEntryId, beforeMatchBill.getLong("sim_original_bill_item.subentryentity.oriinvoiceid"));
            }
            HashMap<Long, Long> afterSubEntryId2OriInvoiceIdMap = new HashMap<Long, Long>(beforeMatchBills.size());
            HashSet<Long> afterRedConfirmIdSet = new HashSet<Long>(beforeMatchBills.size());
            HashMap<Long, Set> oriInvoiceId2RedConfirmMap = new HashMap<Long, Set>(beforeMatchBills.size());
            MatchBillRevokeOpPlugin matchBillRevokeOpPlugin = new MatchBillRevokeOpPlugin();
            for (DynamicObject dynamicObject : matchBills) {
                String matchTarget = dynamicObject.getString("matchtarget");
                if ("1".equals(matchTarget) || "2".equals(matchTarget)) {
                    matchBillRevokeOpPlugin.setInvoiceIdSetFormMatchBill(dynamicObject, afterRedConfirmIdSet);
                    continue;
                }
                DynamicObjectCollection matchItems = dynamicObject.getDynamicObjectCollection("sim_original_bill_item");
                Iterator iterator = matchItems.iterator();
                while (iterator.hasNext()) {
                    DynamicObject matchItem = (DynamicObject)iterator.next();
                    DynamicObjectCollection subItems = matchItem.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subItem : subItems) {
                        afterSubEntryId2OriInvoiceIdMap.put(subItem.getLong("id"), subItem.getLong("oriinvoiceid"));
                        Set redConfirms = oriInvoiceId2RedConfirmMap.computeIfAbsent(subItem.getLong("oriinvoiceid"), k -> new HashSet());
                        redConfirms.add(subItem.getString("infocode"));
                    }
                }
            }
            HashSet hashSet = new HashSet(beforeSubEntryId2OriInvoiceIdMap.keySet());
            HashSet afterSubEntryIdSet = new HashSet(afterSubEntryId2OriInvoiceIdMap.keySet());
            Set intersectionSubEntryIdSet = afterSubEntryIdSet.stream().filter(hashSet::contains).collect(Collectors.toSet());
            hashSet.removeAll(intersectionSubEntryIdSet);
            afterSubEntryIdSet.removeAll(intersectionSubEntryIdSet);
            MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
            if (CollectionUtils.isNotEmpty(hashSet)) {
                HashSet<Long> removeOriInvoiceIdSet = new HashSet<Long>(hashSet.size());
                for (Long beforeOriInvoiceId : hashSet) {
                    oriInvoiceId = (Long)beforeSubEntryId2OriInvoiceIdMap.get(beforeOriInvoiceId);
                    removeOriInvoiceIdSet.add(oriInvoiceId);
                }
                Iterator iterator = removeOriInvoiceIdSet.iterator();
                while (iterator.hasNext()) {
                    Long removeOriInvoiceId = (Long)iterator.next();
                    Set redConfirms = (Set)oriInvoiceId2RedConfirmMap.get(removeOriInvoiceId);
                    if (redConfirms == null) continue;
                    if (redConfirms.remove("")) {
                        iterator.remove();
                        continue;
                    }
                    if (redConfirms.size() == 0 || !QueryServiceHelper.exists((String)"sim_red_confirm_bill", (QFilter[])new QFilter("number", "in", (Object)redConfirms).and("issuestatus", "!=", (Object)"0").toArray())) continue;
                    iterator.remove();
                }
                minusBillMatchHelper.updateInvoiceOccupyStatus(removeOriInvoiceIdSet, "0", "sim_vatinvoice");
            }
            if (CollectionUtils.isNotEmpty(afterSubEntryIdSet)) {
                HashSet<Long> oriInvoiceIdSet = new HashSet<Long>(afterSubEntryIdSet.size());
                for (Long afterSubEntryId : afterSubEntryIdSet) {
                    oriInvoiceId = (Long)afterSubEntryId2OriInvoiceIdMap.get(afterSubEntryId);
                    oriInvoiceIdSet.add(oriInvoiceId);
                }
                minusBillMatchHelper.updateInvoiceOccupyStatus(oriInvoiceIdSet, "1", "sim_vatinvoice");
            }
            Set intersectionRedConfirmSet = afterRedConfirmIdSet.stream().filter(beforeRedConfirmIdSet::contains).collect(Collectors.toSet());
            afterRedConfirmIdSet.removeAll(intersectionRedConfirmSet);
            beforeRedConfirmIdSet.removeAll(intersectionRedConfirmSet);
            if (CollectionUtils.isNotEmpty(beforeRedConfirmIdSet)) {
                minusBillMatchHelper.updateInvoiceOccupyStatus(beforeRedConfirmIdSet, "0", "sim_red_confirm_bill");
            }
            if (CollectionUtils.isNotEmpty(afterRedConfirmIdSet)) {
                minusBillMatchHelper.updateInvoiceOccupyStatus(afterRedConfirmIdSet, "1", "sim_red_confirm_bill");
            }
        }
        finally {
            CacheHelper.remove((String)lockKey);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("matchtarget");
    }
}

